/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.utils;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.core.dto.ReportMethodReq;
import com.ebaiyihui.his.core.enums.CheckAppointMethodEnum;
import com.ebaiyihui.his.core.enums.ReportMethodEnum;
import com.ebaiyihui.his.core.vo.medicaladvice.MadParamReq;
import com.ebaiyihui.his.pojo.vo.checkAppoint.CheckAppointReq;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CxfClientUtil {
    private static final Logger log = LoggerFactory.getLogger(CxfClientUtil.class);

    public String send(String wsdlUrl, String method, String methodStr, String xml) {
        log.info("\u5165\u53c2URL:" + wsdlUrl + " method:" + method + " methodStr:" + methodStr);
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(wsdlUrl);
        try {
            log.info("\u8c03\u7528his\u2014\u2014webservice\u8bf7\u6c42\u53c2\u6570:{},methodStr:{} ", (Object)xml, (Object)methodStr);
            Object[] objects = client.invoke(method, new Object[]{methodStr, xml});
            log.info("\u8c03\u7528his\u2014\u2014webservice\u8fd4\u56de\u53c2\u6570" + JSON.toJSONString((Object)objects));
            return objects[0].toString();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528his\u5f02\u5e38\u2014\u2014>{}", (Throwable)e);
            return "\u901a\u8bafhis\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5";
        }
    }

    public String sendToHis(String url, String methodStr, String xml) {
        String method = "Process";
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(url);
        try {
            log.info("\u8c03\u7528his\u2014\u2014webservice\u8bf7\u6c42\u53c2\u6570:{},methodStr:{} ", (Object)xml, (Object)methodStr);
            Object[] objects = client.invoke(method, new Object[]{methodStr, xml});
            log.info("\u8c03\u7528his\u2014\u2014webservice\u8fd4\u56de\u53c2\u6570" + JSON.toJSONString((Object)objects));
            return objects[0].toString();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528his\u5f02\u5e38\u2014\u2014>{}", (Throwable)e);
            return "\u901a\u8bafhis\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5";
        }
    }

    public String send(String method, CheckAppointReq checkAppointReq) {
        String wsdlUrl = "http://oa.asch.net.cn:8089/BYHLService.asmx?WSDL";
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(wsdlUrl);
        try {
            log.info("\u3010\u68c0\u67e5\u9884\u7ea6\u3011\u8c03\u7528his\u2014\u2014webservice\u8bf7\u6c42\u53c2\u6570:{},methodStr:{} ", (Object)JSON.toJSONString((Object)checkAppointReq), (Object)method);
            Object[] objects = null;
            if (CheckAppointMethodEnum.LIST_OUT.getValue().equals(method)) {
                objects = client.invoke(method, new Object[]{checkAppointReq.getCardNo()});
            } else if (CheckAppointMethodEnum.GET_APPOINTMENT_PLAN_COPY.getValue().equals(method)) {
                objects = client.invoke(method, new Object[]{checkAppointReq.getReqId(), checkAppointReq.getAppointDate()});
            } else if (CheckAppointMethodEnum.APPOINT_OUT_COPY.getValue().equals(method)) {
                objects = client.invoke(method, new Object[]{checkAppointReq.getReqId(), Long.valueOf(checkAppointReq.getScheduleId()), checkAppointReq.getCardNo(), checkAppointReq.getPatientName()});
            } else if (CheckAppointMethodEnum.APPINTED_LIST.getValue().equals(method)) {
                objects = client.invoke(method, new Object[]{checkAppointReq.getCardNo()});
            } else if (CheckAppointMethodEnum.CANCEL_BY_PHONE.getValue().equals(method)) {
                objects = client.invoke(method, new Object[]{checkAppointReq.getReqId(), checkAppointReq.getType()});
            } else {
                return "\u4e1a\u52a1\u4e0d\u5b58\u5728\uff01";
            }
            log.info("\u3010\u68c0\u67e5\u9884\u7ea6\u3011\u8c03\u7528his\u2014\u2014webservice\u8fd4\u56de\u53c2\u6570" + JSON.toJSONString((Object)objects));
            return JSON.toJSONString((Object)objects);
        }
        catch (Exception e) {
            log.error("\u3010\u68c0\u67e5\u9884\u7ea6\u3011\u8c03\u7528his\u5f02\u5e38\u2014\u2014>{}", (Throwable)e);
            return "\u3010\u68c0\u67e5\u9884\u7ea6\u3011\u901a\u8bafhis\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5";
        }
    }

    public String reportSend(String wsdlUrl, String method, ReportMethodReq reportReq) {
        wsdlUrl = "http://oa.asch.net.cn:8089/BYHLService.asmx?WSDL";
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(wsdlUrl);
        try {
            log.info("\u3010\u4f53\u68c0\u62a5\u544a\u3011\u8c03\u7528his\u2014\u2014webservice\u8bf7\u6c42\u53c2\u6570:{},methodStr:{} ", (Object)JSON.toJSONString((Object)reportReq), (Object)method);
            Object[] objects = null;
            if (ReportMethodEnum.QUERY_CHECK_INFO.getValue().equals(method)) {
                String xml = "<ROOT>\n  <METHODNAME>QueryCheckInfoBy</METHODNAME>\n  <PATIENTINFOS>\n    <PATIENTINFO>\n      <IDENNO>" + reportReq.getIdNo() + "</IDENNO>\n      </PATIENTINFO>\n  </PATIENTINFOS>\n</ROOT>";
                objects = client.invoke("Execute", new Object[]{xml, ""});
            } else if (ReportMethodEnum.QUERY_REPORT.getValue().equals(method)) {
                String xml = "<ROOT><METHODNAME>QueryReportBy</METHODNAME><REGISTERS><REGISTER><CLINICCODE>" + reportReq.getClinicCode() + "</CLINICCODE></REGISTER></REGISTERS></ROOT>";
                objects = client.invoke("Execute", new Object[]{xml, ""});
            } else {
                return "\u4e1a\u52a1\u4e0d\u5b58\u5728\uff01";
            }
            log.info("\u3010\u4f53\u68c0\u62a5\u544a\u3011\u8c03\u7528his\u2014\u2014webservice\u8fd4\u56de\u53c2\u6570" + JSON.toJSONString((Object)objects));
            return objects[0].toString();
        }
        catch (Exception e) {
            log.error("\u3010\u4f53\u68c0\u62a5\u544a\u3011\u8c03\u7528his\u5f02\u5e38\u2014\u2014>{}", (Throwable)e);
            return "\u3010\u4f53\u68c0\u62a5\u544a\u3011\u901a\u8bafhis\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5";
        }
    }

    public String madSend(String wsdlUrl, String method, MadParamReq madParamReq) {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        Client client = dcf.createClient(wsdlUrl);
        try {
            log.info("\u3010\u4e00\u4f53\u5316\u533b\u5631\u3011\u8c03\u7528his\u2014\u2014webservice\u8bf7\u6c42\u53c2\u6570:{},methodStr:{} ", (Object)JSON.toJSONString((Object)madParamReq), (Object)method);
            Object[] objects = null;
            switch (method) {
                case "MedicalOrderlist": {
                    objects = client.invoke(method, new Object[]{"", "", "", "", madParamReq.getUseScene(), madParamReq.getTermClassId()});
                    break;
                }
                case "Constant": {
                    objects = client.invoke(method, new Object[]{madParamReq.getConsTypeId(), madParamReq.getConsCode()});
                    break;
                }
                case "Drug": {
                    objects = client.invoke(method, new Object[]{madParamReq.getUndrugId()});
                    break;
                }
                case "ExecuteSave": 
                case "Executedelete": 
                case "DiagnoseeSave": 
                case "Diagdelete": {
                    objects = client.invoke(method, new Object[]{madParamReq.getJsonString()});
                    break;
                }
                case "PharmacyListID": 
                case "Conversion": 
                case "Drugdetails": {
                    objects = client.invoke(method, new Object[]{madParamReq.getDrugId()});
                    break;
                }
                case "Frequency": {
                    objects = client.invoke(method, new Object[]{madParamReq.getFreqCode()});
                    break;
                }
                case "Usage": {
                    objects = client.invoke(method, new Object[]{"", "", "", "", madParamReq.getValidState(), madParamReq.getUsageCode()});
                    break;
                }
                case "Medications": {
                    objects = client.invoke(method, new Object[]{madParamReq.getTermClassId(), ""});
                    break;
                }
                case "Ensemble": {
                    objects = client.invoke(method, new Object[]{madParamReq.getPatientId(), "", "", madParamReq.getClinicNo(), madParamReq.getRecipeNo(), madParamReq.getComboNo(), madParamReq.getOrderId(), madParamReq.getBeginDate(), madParamReq.getEndDate()});
                    break;
                }
                case "Nodruglist": {
                    objects = client.invoke(method, new Object[]{"", "", "", "", madParamReq.getUndrugId(), madParamReq.getTermClassId(), ""});
                    break;
                }
                case "Nodrugdetails": {
                    objects = client.invoke(method, new Object[]{madParamReq.getUndrugId()});
                    break;
                }
                case "Sequence": {
                    objects = client.invoke(method, new Object[0]);
                    break;
                }
                case "Westdiaquery": {
                    objects = client.invoke(method, new Object[]{madParamReq.getKeyWord(), "", "", "", ""});
                    break;
                }
                case "OpListquery": {
                    objects = client.invoke(method, new Object[]{"", "", "", "", madParamReq.getPatientId(), madParamReq.getClinicNo(), "", ""});
                    break;
                }
                case "Deptquery": {
                    objects = client.invoke(method, new Object[]{madParamReq.getDeptCode(), madParamReq.getKeyWord(), "", "", "", ""});
                    break;
                }
                case "Docquery": {
                    objects = client.invoke(method, new Object[]{madParamReq.getDoctCode(), madParamReq.getKeyWord(), "", "", "", ""});
                    break;
                }
                default: {
                    return "\u4e1a\u52a1\u4e0d\u5b58\u5728\uff01";
                }
            }
            log.info("\u3010\u4e00\u4f53\u5316\u533b\u5631\u3011\u8c03\u7528his\u2014\u2014webservice\u8fd4\u56de\u53c2\u6570" + JSON.toJSONString((Object)objects[0]));
            return objects[0].toString();
        }
        catch (Exception e) {
            log.error("\u3010\u4e00\u4f53\u5316\u533b\u5631\u3011\u8c03\u7528his\u5f02\u5e38\u2014\u2014>{}", (Throwable)e);
            return "\u3010\u4e00\u4f53\u5316\u533b\u5631\u3011\u901a\u8bafhis\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5";
        }
    }
}

