/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.core.config.NodeConfig;
import com.ebaiyihui.his.core.dto.pres.AccessTokenDTO;
import com.ebaiyihui.his.core.dto.pres.CommonPresDTO;
import com.ebaiyihui.his.core.dto.pres.PresCheckDTO;
import com.ebaiyihui.his.core.enums.ReturnCodeEnum;
import com.ebaiyihui.his.core.service.PresService;
import com.ebaiyihui.his.core.utils.HttpUtils;
import com.ebaiyihui.his.core.vo.pres.AccessTokenVO;
import com.ebaiyihui.his.core.vo.pres.CommonPresVO;
import com.ebaiyihui.his.core.vo.pres.DeletePresVO;
import com.ebaiyihui.his.core.vo.pres.PresCheckVO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import java.util.HashMap;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PresServiceImpl
implements PresService {
    private static final Logger log = LoggerFactory.getLogger(PresServiceImpl.class);
    @Autowired
    private NodeConfig nodeConfig;

    public FrontResponse<AccessTokenDTO> getToken(FrontRequest<AccessTokenVO> frontRequest) {
        log.info("\u533b\u836f\u4e91\u4e1a\u52a1\u7cfb\u7edf\u4f20\u5165\u7684\u53c2\u6570======>\uff1a{}", (Object)JSONObject.toJSONString(frontRequest));
        AccessTokenDTO accessTokenDTO = null;
        FrontResponse frontResponse = new FrontResponse();
        try {
            String url = new StringBuffer(this.nodeConfig.getAddress()).append("api/gettoken").toString();
            HashMap<String, String> parm = new HashMap<String, String>();
            parm.put("appid", ((AccessTokenVO)frontRequest.getBody()).getAppid());
            parm.put("appsecret", ((AccessTokenVO)frontRequest.getBody()).getAppsecret());
            log.info("===>\u8c03\u7528his\u83b7\u53d6token\u8bf7\u6c42url\u662f:{}=====\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString(parm));
            String result = HttpUtils.get((String)url, parm);
            log.info("========hisaccess_token\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)result));
            String code = JSON.parseObject((String)result).getString("errcode");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code)) {
                accessTokenDTO = (AccessTokenDTO)JSONObject.parseObject((String)result, AccessTokenDTO.class);
                log.info("========hisaccess_token\u63a5\u53e3\u8fd4\u56de\u7684\u8f6c\u5316\u4e4b\u540e\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)accessTokenDTO));
            }
            frontResponse.setBody(accessTokenDTO);
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528his\u83b7\u53d6access_token\u63a5\u53e3\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return frontResponse;
    }

    public FrontResponse<PresCheckDTO> presCheck(FrontRequest<PresCheckVO> frontRequest) {
        log.info("\u533b\u836f\u4e91\u4e1a\u52a1\u7cfb\u7edf\u5904\u65b9\u5408\u683c\u6821\u9a8c\u4f20\u5165\u7684\u53c2\u6570======>\uff1a{}", (Object)JSONObject.toJSONString(frontRequest));
        PresCheckDTO presCheckDTO = null;
        FrontResponse frontResponse = new FrontResponse();
        try {
            StringBuffer urlBuff = new StringBuffer(this.nodeConfig.getAddress()).append("api/hegui/menzhen");
            urlBuff.append("?access_token=" + ((PresCheckVO)frontRequest.getBody()).getAccess_token());
            log.info("===>\u8c03\u7528his\u5904\u65b9\u5408\u683c\u6821\u9a8c\u63a5\u53e3\u8bf7\u6c42url\u662f:{}=====\u53c2\u6570\u662f:{}", (Object)urlBuff, (Object)JSON.toJSONString((Object)frontRequest.getBody()));
            String result = HttpUtils.doPost((String)urlBuff.toString(), (String)JSON.toJSONString((Object)frontRequest.getBody()), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("========his\u5904\u65b9\u5408\u683c\u6821\u9a8c\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)result));
            String code = JSON.parseObject((String)result).getString("errcode");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code)) {
                presCheckDTO = (PresCheckDTO)JSONObject.parseObject((String)result, PresCheckDTO.class);
                log.info("========his\u5904\u65b9\u5408\u683c\u6821\u9a8c\u63a5\u53e3\u8fd4\u56de\u7684\u8f6c\u5316\u4e4b\u540e\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)presCheckDTO));
            }
            frontResponse.setBody(presCheckDTO);
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528his\u83b7\u53d6\u5904\u65b9\u5408\u683c\u63a5\u53e3\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return frontResponse;
    }

    public FrontResponse<CommonPresDTO> savePres(FrontRequest<CommonPresVO> frontRequest) {
        log.info("\u533b\u836f\u4e91\u4e1a\u52a1\u7cfb\u7edf\u4fdd\u5b58\u5904\u65b9\u4f20\u5165\u7684\u53c2\u6570======>\uff1a{}", (Object)JSONObject.toJSONString(frontRequest));
        CommonPresDTO commonPresDTO = null;
        FrontResponse frontResponse = new FrontResponse();
        try {
            StringBuffer urlBuff = new StringBuffer(this.nodeConfig.getAddress()).append("api/hegui/menzhen");
            urlBuff.append("?access_token=" + ((CommonPresVO)frontRequest.getBody()).getAccess_token());
            log.info("===>\u8c03\u7528his\u4fdd\u5b58\u5904\u65b9\u4fe1\u606f\u8bf7\u6c42url\u662f:{}=====\u53c2\u6570\u662f:{}", (Object)urlBuff, (Object)JSON.toJSONString((Object)frontRequest.getBody()));
            String result = HttpUtils.doPost((String)urlBuff.toString(), (String)JSON.toJSONString((Object)frontRequest.getBody()), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("========his\u4fdd\u5b58\u5904\u65b9\u4fe1\u606f\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)result));
            String code = JSON.parseObject((String)result).getString("errcode");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code)) {
                commonPresDTO = (CommonPresDTO)JSONObject.parseObject((String)result, CommonPresDTO.class);
                log.info("========his\u4fdd\u5b58\u5904\u65b9\u4fe1\u606f\u8fd4\u56de\u7684\u8f6c\u5316\u4e4b\u540e\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)commonPresDTO));
            }
            frontResponse.setBody(commonPresDTO);
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528his\u4fdd\u5b58\u5904\u65b9\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return frontResponse;
    }

    public FrontResponse<CommonPresDTO> deletePres(FrontRequest<DeletePresVO> frontRequest) {
        log.info("\u533b\u836f\u4e91\u4e1a\u52a1\u7cfb\u7edf\u5220\u9664\u6216\u4f5c\u5e9f\u4f20\u5165\u7684\u53c2\u6570======>\uff1a{}", (Object)JSONObject.toJSONString(frontRequest));
        CommonPresDTO commonPresDTO = null;
        FrontResponse frontResponse = new FrontResponse();
        try {
            StringBuffer urlBuff = new StringBuffer(this.nodeConfig.getAddress()).append("api/hegui/menzhen");
            urlBuff.append("?access_token=" + ((DeletePresVO)frontRequest.getBody()).getAccess_token());
            log.info("===>\u8c03\u7528his\u5220\u9664\u6216\u4f5c\u5e9f\u8bf7\u6c42url\u662f:{}=====\u53c2\u6570\u662f:{}", (Object)urlBuff, (Object)JSON.toJSONString((Object)frontRequest.getBody()));
            String result = HttpUtils.doPost((String)urlBuff.toString(), (String)JSON.toJSONString((Object)frontRequest.getBody()), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("========his\u5220\u9664\u6216\u4f5c\u5e9f\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)result));
            String code = JSON.parseObject((String)result).getString("errcode");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code)) {
                commonPresDTO = (CommonPresDTO)JSONObject.parseObject((String)result, CommonPresDTO.class);
                log.info("========his\u5220\u9664\u6216\u4f5c\u5e9f\u8fd4\u56de\u7684\u8f6c\u5316\u4e4b\u540e\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)commonPresDTO));
            }
            frontResponse.setBody(commonPresDTO);
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528his\u5220\u9664\u6216\u4f5c\u5e9f\u63a5\u53e3\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return frontResponse;
    }

    public FrontResponse queryCheckPres(FrontRequest<CommonPresVO> frontRequest) {
        log.info("\u533b\u836f\u4e91\u4e1a\u52a1\u7cfb\u7edf\u67e5\u770b\u5408\u89c4\u4fe1\u606f\u4f20\u5165\u7684\u53c2\u6570======>\uff1a{}", (Object)JSONObject.toJSONString(frontRequest));
        Object commonPresDTO = null;
        FrontResponse frontResponse = new FrontResponse();
        try {
            StringBuffer urlBuff = new StringBuffer(this.nodeConfig.getAddress()).append("api/hegui/menzhen");
            urlBuff.append(((CommonPresVO)frontRequest.getBody()).getCzxh()).append("?access_token=" + ((CommonPresVO)frontRequest.getBody()).getAccess_token());
            log.info("===>\u8c03\u7528his\u67e5\u770b\u5408\u89c4\u4fe1\u606f\u8bf7\u6c42url\u662f:{}=====\u53c2\u6570\u662f:{}", (Object)urlBuff, (Object)JSON.toJSONString((Object)frontRequest.getBody()));
            String result = HttpUtils.doPost((String)urlBuff.toString(), (String)JSON.toJSONString((Object)frontRequest.getBody()), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("========his\u67e5\u770b\u5408\u89c4\u4fe1\u606f\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)result));
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528his\u83b7\u53d6\u67e5\u770b\u5408\u89c4\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return frontResponse;
    }
}

