/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XmlTemplateKit {
    private static final Logger log = LoggerFactory.getLogger(XmlTemplateKit.class);
    private static final transient Configuration CONFIG = new Configuration(Configuration.getVersion());

    public static void init() {
        try {
            String path = XmlTemplateKit.class.getClassLoader().getResource("").getPath();
            log.info("----------------------path->{}", (Object)path);
            CONFIG.setClassForTemplateLoading(XmlTemplateKit.class, "/template_send/");
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u6a21\u677f\u5931\u8d25->{}", (Throwable)e);
        }
        CONFIG.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        CONFIG.setDefaultEncoding("UTF-8");
        CONFIG.setOutputEncoding("UTF-8");
        CONFIG.setLocale(Locale.CHINA);
        CONFIG.setLocalizedLookup(false);
        CONFIG.setNumberFormat("#0.#####");
        CONFIG.setClassicCompatible(true);
    }

    public static String process(String method, Map rootMap) {
        Writer out = null;
        try {
            String string;
            Template temp = CONFIG.getTemplate(method + ".ftl");
            out = new StringWriter();
            temp.process((Object)rootMap, out);
            String string2 = string = out.toString();
            return string2;
        }
        catch (TemplateNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String processDebug(String method) {
        Writer out = null;
        try {
            String string;
            Template temp = CONFIG.getTemplate("/template_receive/" + method + ".ftl");
            out = new StringWriter();
            temp.process(null, out);
            String string2 = string = out.toString();
            return string2;
        }
        catch (TemplateNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

