/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctoruser.api.DoctorWorkApi;
import com.doctoruser.api.pojo.base.dto.DocServiceInfoDTO;
import com.doctoruser.api.pojo.base.vo.WorkInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorPositionInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.WorkServiceInfoVo;
import com.doctoruser.doctor.pojo.entity.DoctorWorkEntity;
import com.doctoruser.doctor.service.DoctorWorkService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533b\u751f\u6267\u4e1a\u70b9\u7ba1\u7406"})
public class DoctorWorkController
implements DoctorWorkApi {
    private static final Logger log = LoggerFactory.getLogger(DoctorWorkController.class);
    @Resource
    private DoctorWorkService doctorWorkService;

    public BaseResponse<WorkInfoVo> getDoctorAuthInfo(Long doctorId) {
        return this.doctorWorkService.getDoctorAuthInfo(doctorId);
    }

    public BaseResponse<DoctorPositionInfoVo> getDoctorPositionInfo(Long doctorId) {
        return this.doctorWorkService.getDoctorPositionInfo(doctorId);
    }

    public BaseResponse<WorkServiceInfoVo> checkDoctorService(Long doctorId, String serviceType) {
        String serviceCode;
        switch (serviceType) {
            case "2": {
                serviceCode = "zxmz";
                break;
            }
            case "11": {
                serviceCode = "hzgl";
                break;
            }
            case "5": {
                serviceCode = "ypcf";
                break;
            }
            case "13": {
                serviceCode = "51110";
                break;
            }
            case "14": {
                serviceCode = "51120";
                break;
            }
            case "15": {
                serviceCode = "52110";
                break;
            }
            case "16": {
                serviceCode = "52120";
                break;
            }
            case "17": {
                serviceCode = "wlmz";
                break;
            }
            case "46": {
                serviceCode = "51140";
                break;
            }
            case "47": {
                serviceCode = "ycjx";
                break;
            }
            case "48": {
                serviceCode = "dxkhz";
                break;
            }
            case "49": {
                serviceCode = "sxzz";
                break;
            }
            case "4": {
                serviceCode = "cfgl";
                break;
            }
            case "53": {
                serviceCode = "ycyx";
                break;
            }
            default: {
                serviceCode = "";
            }
        }
        BaseResponse workServiceInfoVoBaseResponse = this.doctorWorkService.checkDoctorServiceByCode(doctorId, serviceCode);
        WorkServiceInfoVo data = (WorkServiceInfoVo)workServiceInfoVoBaseResponse.getData();
        if (Objects.nonNull(data)) {
            data.setServiceType(Integer.valueOf(serviceType));
        }
        return workServiceInfoVoBaseResponse;
    }

    public BaseResponse<WorkServiceInfoVo> checkDoctorServiceByCode(Long doctorId, String serviceCode) {
        return this.doctorWorkService.checkDoctorServiceByCode(doctorId, serviceCode);
    }

    public BaseResponse<DocServiceInfoDTO> getDocServiceInfo(Long organId, Long doctorId, String serviceCode) {
        return this.doctorWorkService.getDocServiceInfo(organId, doctorId, serviceCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u804c\u4e1a\u70b9")
    @GetMapping(value={"/getDoctorWork"})
    public BaseResponse<DoctorWorkEntity> getDoctorWork(@RequestParam(value="organId") Long organId, @RequestParam(value="doctorId") Long doctorId) {
        DoctorWorkEntity doctorWork = this.doctorWorkService.getDoctorWork(organId, doctorId);
        return BaseResponse.success((Object)doctorWork);
    }
}

