/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.doctor.basedata.api.vo.BusinessDoctorTeamDetailinfoVo;
import com.doctor.basedata.api.vo.DoctorLabelVO;
import com.doctor.basedata.api.vo.DoctorTeamInfoDTO;
import com.doctor.basedata.api.vo.DoctorTeamInfoDetailVO;
import com.doctor.basedata.api.vo.DoctorTeamListNewReqVO;
import com.doctor.basedata.api.vo.DoctorTeamMemberInfoVO;
import com.doctoruser.api.pojo.base.query.BusinessDoctorPageQuery;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorTeamBasicInfoVO;
import com.doctoruser.api.pojo.base.vo.doctor.WorkServiceInfoVo;
import com.doctoruser.api.pojo.vo.basedata.doctor.BusinessDoctorTeamDetailVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorProfessionListReqVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorTeamInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorTeamListReqVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorTeamListResVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorTeamMemberDelVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorTeamMemberVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorTeamServiceInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.TeamEvaluationVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.TeamLeaderInfoVO;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesMapper;
import com.doctoruser.doctor.mapper.DoctorTeamInfoMapper;
import com.doctoruser.doctor.mapper.DoctorTeamLabelMapper;
import com.doctoruser.doctor.mapper.DoctorTeamMemberMapper;
import com.doctoruser.doctor.mapper.DoctorTeamServiceInfoMapper;
import com.doctoruser.doctor.pojo.entity.DoctorTeamInfoEntity;
import com.doctoruser.doctor.pojo.entity.DoctorTeamMemberEntity;
import com.doctoruser.doctor.pojo.entity.DoctorTeamServiceInfoEntity;
import com.doctoruser.doctor.pojo.vo.DoctorProfessionListVO;
import com.doctoruser.doctor.pojo.vo.PersonTeamInfoVO;
import com.doctoruser.doctor.service.DoctorTeamService;
import com.doctoruser.doctor.utils.PagingUtils;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;

@Service
public class DoctorTeamServiceImpl
implements DoctorTeamService {
    private static final Logger log = LoggerFactory.getLogger(DoctorTeamServiceImpl.class);
    @Resource
    private DoctorTeamInfoMapper doctorTeamInfoMapper;
    @Resource
    private DoctorTeamMemberMapper doctorTeamMemberMapper;
    @Resource
    private DoctorTeamServiceInfoMapper doctorTeamServiceInfoMapper;
    @Resource
    private DocDoctorWorkplacesMapper docDoctorWorkplacesMapper;
    @Autowired
    private DoctorTeamLabelMapper doctorTeamLabelMapper;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse saveOrUpdate(DoctorTeamInfoVO param) {
        try {
            DoctorTeamInfoEntity doctorTeamInfoEntity = new DoctorTeamInfoEntity();
            BeanUtils.copyProperties((Object)param, (Object)doctorTeamInfoEntity);
            List memberVOList = param.getDoctorTeamMemberVOList();
            List serviceInfoVOList = param.getDoctorTeamServiceInfoVOList();
            ArrayList<DoctorTeamMemberEntity> memberEntityList = new ArrayList<DoctorTeamMemberEntity>();
            ArrayList serviceInfoEntityList = new ArrayList();
            Long teamId = 0L;
            if (param.getTeamId() != null) {
                teamId = param.getTeamId();
                this.doctorTeamInfoMapper.updateOne(doctorTeamInfoEntity);
            } else {
                this.doctorTeamInfoMapper.insertOne(doctorTeamInfoEntity);
                teamId = Long.parseLong(doctorTeamInfoEntity.getId());
            }
            for (DoctorTeamMemberVO memberVO : memberVOList) {
                DoctorTeamMemberEntity memberEntity = new DoctorTeamMemberEntity();
                memberEntity.setTeamId(teamId);
                memberEntity.setStatus(1);
                memberEntity.setDoctorId(memberVO.getDoctorId());
                memberEntity.setDoctorName(memberVO.getDoctorName());
                memberEntityList.add(memberEntity);
            }
            this.doctorTeamMemberMapper.insertListOrUpdateList(memberEntityList);
        }
        catch (Exception e) {
            log.error("save doctorTeamInfo error,e=", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseResponse.error((String)"save doctorTeamInfo error!");
        }
        return BaseResponse.success();
    }

    private void initParam(Long teamId, List<DoctorTeamMemberInfoVO> memberVOList, List<DoctorTeamServiceInfoVO> serviceInfoVOList, List<DoctorTeamMemberEntity> memberEntityList, List<DoctorTeamServiceInfoEntity> serviceInfoEntityList) {
        for (DoctorTeamMemberInfoVO memberVO : memberVOList) {
            DoctorTeamMemberEntity memberEntity = new DoctorTeamMemberEntity();
            memberEntity.setTeamId(teamId);
            memberEntity.setStatus(1);
            memberEntity.setDoctorId(memberVO.getDoctorId());
            memberEntity.setDoctorName(memberVO.getDoctorName());
            memberEntity.setLabelId(memberVO.getLabelId());
            memberEntityList.add(memberEntity);
        }
    }

    public BaseResponse<PageResult<DoctorTeamListResVO>> getList(DoctorTeamListReqVO param) {
        PageResult result = new PageResult();
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        try {
            Page resultData = this.doctorTeamInfoMapper.selectTeamList(param);
            if (resultData.isEmpty()) {
                return BaseResponse.success((Object)result);
            }
            result.setContent(resultData.getResult());
            result.setPageNum(resultData.getPageNum());
            result.setPageSize(resultData.getPageSize());
            result.setTotalPages(resultData.getPages());
            result.setTotal((int)resultData.getTotal());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            log.error("get team list error,e=", (Throwable)e);
            return BaseResponse.error((String)"get team list error");
        }
    }

    public BaseResponse<DoctorTeamInfoVO> getDetail(Long teamId) {
        DoctorTeamInfoVO doctorTeamInfoVO = null;
        try {
            DoctorTeamInfoEntity doctorTeamInfoEntity = new DoctorTeamInfoEntity();
            doctorTeamInfoEntity.setId(String.valueOf(teamId));
            doctorTeamInfoVO = this.doctorTeamInfoMapper.selectOne(doctorTeamInfoEntity);
            DoctorTeamMemberEntity doctorTeamMemberEntity = new DoctorTeamMemberEntity();
            doctorTeamMemberEntity.setTeamId(teamId);
            List doctorTeamMemberVOS = this.doctorTeamMemberMapper.selectList(doctorTeamMemberEntity);
            List doctorTeamServiceInfoVOS = this.doctorTeamServiceInfoMapper.selectList(teamId);
            doctorTeamInfoVO.setDoctorTeamMemberVOList(doctorTeamMemberVOS);
            doctorTeamInfoVO.setDoctorTeamServiceInfoVOList(doctorTeamServiceInfoVOS);
        }
        catch (Exception e) {
            log.error("get doctor team error,e=", (Throwable)e);
            return BaseResponse.error((String)"get doctor team error");
        }
        return BaseResponse.success((Object)doctorTeamInfoVO);
    }

    public BaseResponse deleteMember(DoctorTeamMemberDelVO param) {
        try {
            this.doctorTeamMemberMapper.updateOne(param);
        }
        catch (Exception e) {
            log.error("delete team member error,e=", (Throwable)e);
            return BaseResponse.error((String)"delete team member error");
        }
        return BaseResponse.success();
    }

    public BaseResponse isTeamLeader(Long doctorId, Long teamId) {
        DoctorTeamInfoEntity doctorTeamInfoEntity = new DoctorTeamInfoEntity();
        doctorTeamInfoEntity.setLeaderId(doctorId);
        DoctorTeamMemberEntity doctorTeamMemberEntity = new DoctorTeamMemberEntity();
        doctorTeamMemberEntity.setDoctorId(doctorId);
        try {
            DoctorTeamInfoVO doctorTeamInfoVO = this.doctorTeamInfoMapper.selectOne(doctorTeamInfoEntity);
            if (doctorTeamInfoVO != null) {
                if (teamId == null) {
                    return BaseResponse.success((Object)"teamLeader");
                }
                if (!teamId.equals(doctorTeamInfoVO.getTeamId())) {
                    return BaseResponse.success((Object)"teamLeader");
                }
                return BaseResponse.success((Object)Boolean.TRUE);
            }
            List doctorTeamMemberVOS = this.doctorTeamMemberMapper.selectList(doctorTeamMemberEntity);
            if (!CollectionUtils.isEmpty((Collection)doctorTeamMemberVOS)) {
                return BaseResponse.success((Object)"teamMember");
            }
            return BaseResponse.success((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("is team leader error,e=", (Throwable)e);
            return BaseResponse.error((String)"is team leader error");
        }
    }

    public BaseResponse doctorProfessionList(DoctorProfessionListReqVO param) {
        try {
            List doctorProfessionListVOS = this.doctorTeamInfoMapper.selectProfessionList(param);
            if ("all".equals(param.getDoctorName())) {
                return BaseResponse.success((Object)doctorProfessionListVOS);
            }
            JSONArray jsonArray = this.getProfessionList(doctorProfessionListVOS);
            return BaseResponse.success((Object)jsonArray);
        }
        catch (Exception e) {
            log.error("get doctorProfessionList error,e=", (Throwable)e);
            return BaseResponse.error((String)"get doctorProfessionList error");
        }
    }

    private JSONArray getProfessionList(List<DoctorProfessionListVO> doctorProfessionListVOS) {
        Map<String, List<DoctorProfessionListVO>> map = doctorProfessionListVOS.stream().collect(Collectors.groupingBy(DoctorProfessionListVO::getProfession));
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<String, List<DoctorProfessionListVO>> entry : map.entrySet()) {
            String mapKey = entry.getKey();
            List<DoctorProfessionListVO> mapValue = entry.getValue();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("professionName", (Object)mapKey);
            jsonObject.put("doctorList", (Object)JSONArray.parseArray((String)JSON.toJSONString(mapValue)));
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public BaseResponse leaderProfessionList(DoctorProfessionListReqVO param) {
        try {
            List doctorProfessionListVOS = this.doctorTeamInfoMapper.selectProfessionList(param);
            if (param.getTeamId() != null) {
                DoctorProfessionListVO doctorProfessionListVO = this.doctorTeamInfoMapper.selectProfession(param.getTeamId());
                doctorProfessionListVOS.add(doctorProfessionListVO);
            }
            if ("all".equals(param.getDoctorName())) {
                return BaseResponse.success((Object)doctorProfessionListVOS);
            }
            JSONArray jsonArray = this.getProfessionList(doctorProfessionListVOS);
            return BaseResponse.success((Object)jsonArray);
        }
        catch (Exception e) {
            log.error("get leaderProfessionList error,e=", (Throwable)e);
            return BaseResponse.error((String)"get leaderProfessionList error");
        }
    }

    public BaseResponse getPersonTeam(Long doctorId) {
        try {
            List personTeamInfoVOS = this.doctorTeamInfoMapper.selectPersonTeamByDoctorId(doctorId, false);
            Map<String, List<PersonTeamInfoVO>> collect = personTeamInfoVOS.stream().collect(Collectors.groupingBy(PersonTeamInfoVO::getTeamName));
            JSONArray jsonArray = new JSONArray();
            for (Map.Entry<String, List<PersonTeamInfoVO>> entry : collect.entrySet()) {
                String mapKey = entry.getKey();
                List<PersonTeamInfoVO> mapValue = entry.getValue();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("teamName", (Object)mapKey);
                jsonObject.put("teamList", (Object)JSONArray.parseArray((String)JSON.toJSONString(mapValue)));
                jsonArray.add((Object)jsonObject);
            }
            return BaseResponse.success((Object)jsonArray);
        }
        catch (Exception e) {
            log.error("getPersonTeam error,e=", (Throwable)e);
            return BaseResponse.error((String)"getPersonTeam error");
        }
    }

    public BaseResponse isTeamReceiver(Long doctorId, Long teamId) {
        try {
            Long teamIdTemp = this.doctorTeamServiceInfoMapper.selectOneByDoctorId(doctorId);
            if (teamIdTemp == null || teamId != null && teamId.equals(teamIdTemp)) {
                return BaseResponse.success((Object)Boolean.FALSE);
            }
            return BaseResponse.success((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("get isTeamReceiver error,e=", (Throwable)e);
            return BaseResponse.error((String)"get isTeamReceiver error");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse editTeamScore(Long doctorId, Long teamId) {
        try {
            this.doctorTeamMemberMapper.initScore(doctorId);
            this.doctorTeamMemberMapper.updateScore(doctorId, teamId);
        }
        catch (Exception e) {
            log.error("editTeamScore error,e=", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseResponse.error((String)"editTeamScorer error");
        }
        return BaseResponse.success();
    }

    public BaseResponse getBusinessDoctorTeamPage(BusinessDoctorPageQuery param) {
        this.initDoctorTeamParam(param);
        PageResult result = new PageResult();
        param.setStatus(1);
        try {
            ArrayList resultDoctorTeamData = this.doctorTeamInfoMapper.selectDoctorTeamBaseInfoPage(param);
            List resultDoctorData = this.doctorTeamInfoMapper.selectDoctorBaseInfoPage(param);
            if (Objects.isNull(resultDoctorTeamData) && Objects.isNull(resultDoctorData)) {
                return BaseResponse.success((Object)result);
            }
            if (Objects.isNull(resultDoctorTeamData)) {
                resultDoctorTeamData = new ArrayList();
            }
            if (Objects.nonNull(resultDoctorData)) {
                resultDoctorTeamData.addAll(resultDoctorData);
            }
            this.sortList(resultDoctorTeamData);
            log.info(JSONObject.toJSONString(resultDoctorTeamData));
            result = PagingUtils.paging((Integer)param.getPageNum(), resultDoctorTeamData, (Integer)param.getPageSize());
        }
        catch (Exception e) {
            log.error("getBusinessDoctorTeamPage error,e=", (Throwable)e);
            return BaseResponse.error((String)"getBusinessDoctorTeamPage error!");
        }
        return BaseResponse.success((Object)result);
    }

    public BaseResponse getBusinessDoctorTeamDetail(Long teamId) {
        try {
            BusinessDoctorTeamDetailVO detailVO = this.doctorTeamInfoMapper.selectTeamBaseInfo(teamId);
            if (detailVO != null) {
                Long doctorId = detailVO.getLeaderId();
                TeamLeaderInfoVO teamLeaderInfoVO = this.doctorTeamInfoMapper.selectLeaderInfo(doctorId);
                DoctorTeamServiceInfoVO doctorTeamServiceInfoVO = this.doctorTeamInfoMapper.selectTeamServiceInfo(teamId, "zxmz");
                List teamEvaluationVOS = this.doctorTeamInfoMapper.selectTeamLastEvaluation(doctorId);
                detailVO.setTeamLeaderInfoVO(teamLeaderInfoVO);
                detailVO.setDoctorTeamServiceInfoVO(doctorTeamServiceInfoVO);
                if (teamEvaluationVOS != null && !teamEvaluationVOS.isEmpty()) {
                    detailVO.setEvaluationCount(Integer.valueOf(teamEvaluationVOS.size()));
                    detailVO.setTeamEvaluationVO((TeamEvaluationVO)teamEvaluationVOS.get(0));
                } else {
                    detailVO.setEvaluationCount(Integer.valueOf(0));
                }
                return BaseResponse.success((Object)detailVO);
            }
        }
        catch (Exception e) {
            log.error("getBusinessDoctorTeamDetail error,e=", (Throwable)e);
            return BaseResponse.error((String)"getBusinessDoctorTeamDetail error!");
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<TeamLeaderInfoVO>> getBusinessDoctorTeamList(Long teamId) {
        List teamLeaderInfoVOS = new ArrayList();
        try {
            teamLeaderInfoVOS = this.doctorTeamInfoMapper.selectMemberByTeamId(teamId);
        }
        catch (Exception e) {
            log.error("getBusinessDoctorTeamList error,e=", (Throwable)e);
            return BaseResponse.error((String)"getBusinessDoctorTeamList error!");
        }
        return BaseResponse.success(teamLeaderInfoVOS);
    }

    public BaseResponse<Map<String, Object>> getListNew(DoctorTeamListNewReqVO param) {
        PageResult result = new PageResult();
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> teamIdList = new ArrayList<String>();
        try {
            Page resultData = this.doctorTeamInfoMapper.selectTeamListNew(param);
            if (resultData.isEmpty()) {
                map.put("data", "\u6ca1\u6709\u56e2\u961f\u4fe1\u606f");
                return BaseResponse.success(map);
            }
            for (DoctorTeamListResVO doctorTeamListResVO : resultData) {
                doctorTeamListResVO.setDoctorAmount(this.doctorTeamMemberMapper.getDocTeamMemberCountByTeamId(doctorTeamListResVO.getTeamId()));
                teamIdList.add(doctorTeamListResVO.getTeamId().toString());
            }
            result.setContent(resultData.getResult());
            result.setPageNum(resultData.getPageNum());
            result.setPageSize(resultData.getPageSize());
            result.setTotalPages(resultData.getPages());
            result.setTotal((int)resultData.getTotal());
            map.put("teamMember", this.doctorTeamMemberMapper.selectAllMember(teamIdList));
            map.put("data", result);
            return BaseResponse.success(map);
        }
        catch (Exception e) {
            log.error("get team list error,e=", (Throwable)e);
            return BaseResponse.error((String)"get team list error");
        }
    }

    public BaseResponse getBusinessDoctorTeamDetailinfo(Long teamId) {
        try {
            BusinessDoctorTeamDetailVO detailVO = this.doctorTeamInfoMapper.selectTeamBaseInfo(teamId);
            BusinessDoctorTeamDetailinfoVo detailinfoVo = new BusinessDoctorTeamDetailinfoVo();
            if (detailVO != null) {
                Long doctorId = detailVO.getLeaderId();
                TeamLeaderInfoVO teamLeaderInfoVO = this.doctorTeamInfoMapper.selectLeaderInfo(doctorId);
                DoctorTeamServiceInfoVO doctorTeamServiceInfoVO = this.doctorTeamInfoMapper.selectTeamServiceInfo(teamId, "zxmz");
                List teamEvaluationVOS = this.doctorTeamInfoMapper.selectTeamLastEvaluation(doctorId);
                detailVO.setTeamLeaderInfoVO(teamLeaderInfoVO);
                detailVO.setDoctorTeamServiceInfoVO(doctorTeamServiceInfoVO);
                BeanUtils.copyProperties((Object)detailVO, (Object)detailinfoVo);
                if (teamEvaluationVOS != null && !teamEvaluationVOS.isEmpty()) {
                    detailinfoVo.setEvaluationCount(Integer.valueOf(teamEvaluationVOS.size()));
                    detailinfoVo.setTeamEvaluationVOS(teamEvaluationVOS);
                } else {
                    detailinfoVo.setEvaluationCount(Integer.valueOf(0));
                }
                return BaseResponse.success((Object)detailinfoVo);
            }
        }
        catch (Exception e) {
            log.error("getBusinessDoctorTeamDetail error,e=", (Throwable)e);
            return BaseResponse.error((String)"getBusinessDoctorTeamDetail error!");
        }
        return BaseResponse.success();
    }

    public BaseResponse<DoctorTeamInfoDetailVO> getDetailInfo(Long teamId, String serviceCode) {
        DoctorTeamInfoDetailVO doctorTeamInfoVO = null;
        try {
            DoctorTeamInfoEntity doctorTeamInfoEntity = new DoctorTeamInfoEntity();
            doctorTeamInfoEntity.setId(String.valueOf(teamId));
            doctorTeamInfoVO = this.doctorTeamInfoMapper.selectDoctorTeamInfoDetailVOOne(doctorTeamInfoEntity);
            if (StringUtils.isNotEmpty((String)serviceCode)) {
                WorkServiceInfoVo workServiceInfoVo = this.docDoctorWorkplacesMapper.checkDoctorServiceByCode(doctorTeamInfoVO.getLeaderId(), serviceCode, Integer.valueOf(1));
                doctorTeamInfoVO.setIsPermissions(Boolean.valueOf(workServiceInfoVo == null));
            }
            DoctorTeamMemberEntity doctorTeamMemberEntity = new DoctorTeamMemberEntity();
            doctorTeamMemberEntity.setTeamId(teamId);
            List doctorTeamMemberVOS = this.doctorTeamMemberMapper.selectDoctorTeamMemberInfoVOList(doctorTeamMemberEntity);
            Iterator iterator = doctorTeamMemberVOS.iterator();
            while (iterator.hasNext()) {
                DoctorTeamMemberInfoVO doctorTeamMemberVO;
                WorkServiceInfoVo workServiceInfoVo = this.docDoctorWorkplacesMapper.checkDoctorServiceByCode((doctorTeamMemberVO = (DoctorTeamMemberInfoVO)iterator.next()).getDoctorId(), serviceCode, Integer.valueOf(1));
                doctorTeamMemberVO.setIsPermissions(Boolean.valueOf(workServiceInfoVo == null));
            }
            DoctorTeamInfoDetailVO finalDoctorTeamInfoVO = doctorTeamInfoVO;
            List doctorTeamMemberInfoVOList = doctorTeamMemberVOS.stream().filter(d -> d.getDoctorId().longValue() != finalDoctorTeamInfoVO.getLeaderId().longValue()).collect(Collectors.toList());
            List doctorTeamServiceInfoVOS = this.doctorTeamServiceInfoMapper.selectList(teamId);
            doctorTeamInfoVO.setDoctorTeamMemberVOList(doctorTeamMemberInfoVOList);
            doctorTeamInfoVO.setDoctorTeamServiceInfoVOList(doctorTeamServiceInfoVOS);
        }
        catch (Exception e) {
            log.error("get doctor team error,e=", (Throwable)e);
            return BaseResponse.error((String)"get doctor team error");
        }
        return BaseResponse.success((Object)doctorTeamInfoVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse saveOrUpdatenew(DoctorTeamInfoDTO param) {
        ArrayList ids = new ArrayList();
        Long teamId = 0L;
        try {
            DoctorTeamInfoEntity doctorTeamInfoEntity = new DoctorTeamInfoEntity();
            BeanUtils.copyProperties((Object)param, (Object)doctorTeamInfoEntity);
            List memberVOList = param.getDoctorTeamMemberVOList();
            List serviceInfoVOList = param.getDoctorTeamServiceInfoVOList();
            ArrayList memberEntityList = new ArrayList();
            ArrayList serviceInfoEntityList = new ArrayList();
            ArrayList<Long> doctorIds = new ArrayList<Long>();
            DoctorTeamMemberInfoVO doctorTeamMemberVO = new DoctorTeamMemberInfoVO();
            doctorTeamMemberVO.setDoctorId(param.getLeaderId());
            doctorTeamMemberVO.setDoctorName(param.getLeaderName());
            doctorTeamMemberVO.setLabelId(param.getLabelId());
            memberVOList.add(doctorTeamMemberVO);
            doctorIds.add(param.getLeaderId());
            if (param.getTeamId() != null) {
                teamId = param.getTeamId();
                DoctorTeamInfoVO doctorTeamInfoVO = this.doctorTeamInfoMapper.selectByTeamName(param.getTeamName(), teamId);
                if (doctorTeamInfoVO != null) {
                    log.info("\u7f16\u8f91\u65f6\u5df2\u5b58\u5728\u540c\u540d\u56e2\u961f:{}", (Object)JSONObject.toJSONString((Object)doctorTeamInfoVO));
                    return BaseResponse.error((String)"\u56e2\u961f\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165!!!");
                }
                List doctorTeamInfoVOS = this.doctorTeamInfoMapper.selectListByDoctorIdsCheckId(doctorIds, teamId);
                if (doctorTeamInfoVOS.size() > 0) {
                    return new BaseResponse("0", "\u8be5\u533b\u751f\u5df2\u5728\u5176\u4ed6\u56e2\u961f,\u8bf7\u91cd\u65b0\u9009\u62e9", (Object)doctorTeamInfoVOS);
                }
                this.doctorTeamInfoMapper.updateOne(doctorTeamInfoEntity);
            } else {
                DoctorTeamInfoVO doctorTeamInfoVO = this.doctorTeamInfoMapper.selectByTeamName(param.getTeamName(), Long.valueOf(0L));
                if (doctorTeamInfoVO != null) {
                    log.info("\u65b0\u589e\u65f6\u5df2\u5b58\u5728\u540c\u540d\u56e2\u961f:{}", (Object)JSONObject.toJSONString((Object)doctorTeamInfoVO));
                    return BaseResponse.error((String)"\u56e2\u961f\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165!!!");
                }
                List doctorTeamInfoVOS = this.doctorTeamInfoMapper.selectListByDoctorIdsCheckId(doctorIds, teamId);
                if (doctorTeamInfoVOS.size() > 0) {
                    return new BaseResponse("0", "\u8be5\u533b\u751f\u5df2\u5728\u5176\u4ed6\u56e2\u961f,\u8bf7\u91cd\u65b0\u9009\u62e9", (Object)doctorTeamInfoVOS);
                }
                this.doctorTeamInfoMapper.insertOne(doctorTeamInfoEntity);
                teamId = Long.parseLong(doctorTeamInfoEntity.getId());
            }
            this.initParam(teamId, memberVOList, serviceInfoVOList, memberEntityList, serviceInfoEntityList);
            this.doctorTeamMemberMapper.deleteByTeamId(teamId);
            this.doctorTeamMemberMapper.insertList(memberEntityList);
        }
        catch (Exception e) {
            log.error("save doctorTeamInfo error,e=", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseResponse.error((String)"save doctorTeamInfo error!");
        }
        return BaseResponse.success((Object)teamId);
    }

    public BaseResponse getPersonTeamNew(Long doctorId) {
        try {
            List personTeamInfoVOS = this.doctorTeamInfoMapper.selectPersonTeamByDoctorId(doctorId, true);
            Map<String, List<PersonTeamInfoVO>> collect = personTeamInfoVOS.stream().collect(Collectors.groupingBy(PersonTeamInfoVO::getTeamName));
            JSONArray jsonArray = new JSONArray();
            for (Map.Entry<String, List<PersonTeamInfoVO>> entry : collect.entrySet()) {
                String mapKey = entry.getKey();
                List<PersonTeamInfoVO> mapValue = entry.getValue();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("teamId", (Object)mapValue.get(0).getTeamId());
                jsonObject.put("teamName", (Object)mapKey);
                jsonObject.put("headPortrait", (Object)mapValue.get(0).getHeadPortrait());
                jsonObject.put("teamList", (Object)JSONArray.parseArray((String)JSON.toJSONString(mapValue)));
                jsonArray.add((Object)jsonObject);
            }
            return BaseResponse.success((Object)jsonArray);
        }
        catch (Exception e) {
            log.error("getPersonTeam error,e=", (Throwable)e);
            return BaseResponse.error((String)"getPersonTeam error");
        }
    }

    public BaseResponse delete(Long teamId) {
        log.info("\u8981\u5220\u9664\u7684\u56e2\u961fid:{}", (Object)teamId);
        this.doctorTeamInfoMapper.delete(teamId);
        return BaseResponse.success();
    }

    public BaseResponse changeUsable(Long teamId, Integer usable) {
        log.info("\u8981\u53d8\u66f4\u72b6\u6001\u7684\u56e2\u961fid:{},\u72b6\u6001\u53d8\u4e3a:{}", (Object)teamId, (Object)usable);
        this.doctorTeamInfoMapper.changeUsable(teamId, usable);
        return BaseResponse.success();
    }

    public BaseResponse<List<DoctorLabelVO>> listLabel() {
        return BaseResponse.success((Object)this.doctorTeamLabelMapper.listDoctorLabel());
    }

    private void sortList(List<DoctorTeamBasicInfoVO> resultDoctorTeamData) {
        Collections.sort(resultDoctorTeamData, (o1, o2) -> {
            if (o1.getCreateTime() == null || o2.getCreateTime() == null) {
                int flag = 1;
                return flag;
            }
            int flag = o1.getCreateTime().compareTo(o2.getCreateTime());
            if (flag == -1) {
                flag = 1;
            } else if (flag == 1) {
                flag = -1;
            }
            return flag;
        });
    }

    private void initDoctorTeamParam(BusinessDoctorPageQuery businessDoctorPageQuery) {
        if (StringUtils.isNotBlank((String)businessDoctorPageQuery.getServiceCodes())) {
            String[] split = businessDoctorPageQuery.getServiceCodes().split(",");
            List<String> serviceCodeList = Arrays.asList(split);
            if (!serviceCodeList.isEmpty()) {
                String serviceCodes = serviceCodeList.stream().collect(Collectors.joining("','", "'", "'"));
                businessDoctorPageQuery.setServiceCodes(serviceCodes);
            } else {
                businessDoctorPageQuery.setServiceCodes("");
            }
        }
    }
}

