/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.doctor.basedata.api.vo.AddSittingDeptConfigReqVO;
import com.doctor.basedata.api.vo.BatchAddSittingDeptConfigReqVO;
import com.doctor.basedata.api.vo.DeptInfoReqVO;
import com.doctor.basedata.api.vo.SittingDeptConfigReqVO;
import com.doctor.basedata.api.vo.SittingDeptConfigRespVO;
import com.doctor.basedata.api.vo.WorkplacesInfoIdVO;
import com.doctoruser.doctor.exception.BusinessException;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesInfoMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesInfo;
import com.doctoruser.doctor.service.SittingDeptConfigService;
import com.ebaiyihui.framework.page.PageResult;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SittingDeptConfigServiceImpl
implements SittingDeptConfigService {
    @Autowired
    private DoctorMapper doctorMapper;
    @Autowired
    private DocDoctorWorkplacesMapper docDoctorWorkplacesMapper;
    @Autowired
    private DocDoctorWorkplacesInfoMapper docDoctorWorkplacesInfoMapper;

    public PageResult<SittingDeptConfigRespVO> findSittingDeptConfigPage(SittingDeptConfigReqVO sittingDeptConfigReqVO) {
        PageHelper.startPage((int)sittingDeptConfigReqVO.getPageNum(), (int)sittingDeptConfigReqVO.getPageSize());
        Long organId = Long.valueOf(sittingDeptConfigReqVO.getOrganId());
        List sittingDeptConfigRespVOList = this.doctorMapper.findSittingDeptConfigList(sittingDeptConfigReqVO);
        if (sittingDeptConfigRespVOList.size() > 0) {
            for (SittingDeptConfigRespVO sittingDeptConfigRespVO : sittingDeptConfigRespVOList) {
                Long doctorId = Long.valueOf(sittingDeptConfigRespVO.getDoctorId());
                DocDoctorWorkplacesEntity dbDoctorWorkplacesEntity = this.docDoctorWorkplacesMapper.getDoctorWorkInfo(doctorId, organId, 1);
                if (dbDoctorWorkplacesEntity == null) continue;
                List doctorWorkplacesInfoList = this.docDoctorWorkplacesInfoMapper.findByWorkInfoId(dbDoctorWorkplacesEntity.getxId());
                if ((doctorWorkplacesInfoList = doctorWorkplacesInfoList.stream().distinct().collect(Collectors.toList())).size() <= 0) continue;
                ArrayList<WorkplacesInfoIdVO> workplacesInfoIdVOList = new ArrayList<WorkplacesInfoIdVO>();
                for (DocDoctorWorkplacesInfo doctorWorkplacesInfo : doctorWorkplacesInfoList) {
                    WorkplacesInfoIdVO workplacesInfoIdVO = new WorkplacesInfoIdVO();
                    workplacesInfoIdVO.setWorkplacesInfoId(doctorWorkplacesInfo.getXId().toString());
                    workplacesInfoIdVO.setDeptId(doctorWorkplacesInfo.getDeptId().toString());
                    workplacesInfoIdVO.setDeptName(doctorWorkplacesInfo.getDeptName());
                    workplacesInfoIdVO.setIsDefault(doctorWorkplacesInfo.getIsDefault());
                    workplacesInfoIdVOList.add(workplacesInfoIdVO);
                }
                sittingDeptConfigRespVO.setWorkplacesInfoIdVOList(workplacesInfoIdVOList);
            }
        }
        PageInfo pageInfo = new PageInfo(sittingDeptConfigRespVOList);
        PageResult pageResult = new PageResult();
        pageResult.setPageNum(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        Long total = pageInfo.getTotal();
        pageResult.setTotal(total.intValue());
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(pageInfo.getList());
        return pageResult;
    }

    @Transactional
    public void addSittingDeptConfig(AddSittingDeptConfigReqVO addSittingDeptConfigReqVO) {
        block4: {
            List deptInfoReqVOList;
            Long organId;
            Long doctorId;
            block3: {
                doctorId = addSittingDeptConfigReqVO.getDoctorId();
                organId = addSittingDeptConfigReqVO.getOrganId();
                deptInfoReqVOList = addSittingDeptConfigReqVO.getDeptInfoReqVOList();
                DocDoctorWorkplacesEntity dbDoctorWorkplacesEntity = this.docDoctorWorkplacesMapper.getDoctorWorkInfo(doctorId, organId, 1);
                if (dbDoctorWorkplacesEntity == null) break block3;
                if (deptInfoReqVOList == null || deptInfoReqVOList.size() <= 0) break block4;
                for (DeptInfoReqVO deptInfoReqVO : deptInfoReqVOList) {
                    DocDoctorWorkplacesInfo dbDocDoctorWorkplacesInfo = this.docDoctorWorkplacesInfoMapper.getByWorkPlacesIdAndDeptId(dbDoctorWorkplacesEntity.getxId(), deptInfoReqVO.getDeptId());
                    if (dbDocDoctorWorkplacesInfo != null) continue;
                    DocDoctorWorkplacesInfo doctorWorkplacesInfo = new DocDoctorWorkplacesInfo();
                    doctorWorkplacesInfo.setDoctorWorkplaces(dbDoctorWorkplacesEntity.getxId());
                    doctorWorkplacesInfo.setDeptId(deptInfoReqVO.getDeptId());
                    doctorWorkplacesInfo.setDeptName(deptInfoReqVO.getDeptName());
                    this.docDoctorWorkplacesInfoMapper.insert(doctorWorkplacesInfo);
                }
                break block4;
            }
            DocDoctorWorkplacesEntity docDoctorWorkplacesEntity = new DocDoctorWorkplacesEntity();
            docDoctorWorkplacesEntity.setDoctorId(doctorId);
            docDoctorWorkplacesEntity.setOrganId(organId);
            docDoctorWorkplacesEntity.setStatus(Byte.valueOf((byte)1));
            this.docDoctorWorkplacesMapper.insert(docDoctorWorkplacesEntity);
            if (deptInfoReqVOList != null && deptInfoReqVOList.size() > 0) {
                for (DeptInfoReqVO deptInfoReqVO : deptInfoReqVOList) {
                    DocDoctorWorkplacesInfo dbDocDoctorWorkplacesInfo = this.docDoctorWorkplacesInfoMapper.getByWorkPlacesIdAndDeptId(docDoctorWorkplacesEntity.getxId(), deptInfoReqVO.getDeptId());
                    if (dbDocDoctorWorkplacesInfo != null) continue;
                    DocDoctorWorkplacesInfo doctorWorkplacesInfo = new DocDoctorWorkplacesInfo();
                    doctorWorkplacesInfo.setDoctorWorkplaces(docDoctorWorkplacesEntity.getxId());
                    doctorWorkplacesInfo.setDeptId(deptInfoReqVO.getDeptId());
                    doctorWorkplacesInfo.setDeptName(deptInfoReqVO.getDeptName());
                    this.docDoctorWorkplacesInfoMapper.insert(doctorWorkplacesInfo);
                }
            }
        }
    }

    public void deleteByWorkplacesInfoId(Long workplacesInfoId) {
        DocDoctorWorkplacesInfo docDoctorWorkplacesInfo = this.docDoctorWorkplacesInfoMapper.selectByPrimaryKey(workplacesInfoId);
        if (Objects.nonNull(docDoctorWorkplacesInfo) && 1 == docDoctorWorkplacesInfo.getIsDefault()) {
            throw new BusinessException("\u533b\u751f\u884c\u653f\u79d1\u5ba4\u65e0\u6cd5\u88ab\u5220\u9664");
        }
        this.docDoctorWorkplacesInfoMapper.deleteByPrimaryKey(workplacesInfoId);
    }

    @Transactional
    public void batchAddSittingDeptConfig(BatchAddSittingDeptConfigReqVO batchAddSittingDeptConfigReqVO) {
        List doctorIdList = batchAddSittingDeptConfigReqVO.getDoctorIdList();
        Long organId = batchAddSittingDeptConfigReqVO.getOrganId();
        List deptInfoReqVOList = batchAddSittingDeptConfigReqVO.getDeptInfoReqVOList();
        for (Long doctorId : doctorIdList) {
            DocDoctorWorkplacesInfo doctorWorkplacesInfo;
            DocDoctorWorkplacesInfo dbDoctorWorkplacesInfo;
            Long deptId;
            DocDoctorWorkplacesEntity dbDoctorWorkplacesEntity = this.docDoctorWorkplacesMapper.getDoctorWorkInfo(doctorId, organId, 1);
            if (dbDoctorWorkplacesEntity != null) {
                Long workPlacesId = dbDoctorWorkplacesEntity.getxId();
                if (deptInfoReqVOList == null || deptInfoReqVOList.size() <= 0) continue;
                for (DeptInfoReqVO deptInfoReqVO : deptInfoReqVOList) {
                    deptId = deptInfoReqVO.getDeptId();
                    dbDoctorWorkplacesInfo = this.docDoctorWorkplacesInfoMapper.getByWorkPlacesIdAndDeptId(workPlacesId, deptId);
                    if (dbDoctorWorkplacesInfo != null) continue;
                    doctorWorkplacesInfo = new DocDoctorWorkplacesInfo();
                    doctorWorkplacesInfo.setDoctorWorkplaces(workPlacesId);
                    doctorWorkplacesInfo.setDeptId(deptId);
                    doctorWorkplacesInfo.setDeptName(deptInfoReqVO.getDeptName());
                    this.docDoctorWorkplacesInfoMapper.insert(doctorWorkplacesInfo);
                }
                continue;
            }
            DocDoctorWorkplacesEntity docDoctorWorkplacesEntity = new DocDoctorWorkplacesEntity();
            docDoctorWorkplacesEntity.setDoctorId(doctorId);
            docDoctorWorkplacesEntity.setOrganId(organId);
            docDoctorWorkplacesEntity.setStatus(Byte.valueOf("1"));
            this.docDoctorWorkplacesMapper.insert(docDoctorWorkplacesEntity);
            if (deptInfoReqVOList == null || deptInfoReqVOList.size() <= 0) continue;
            for (DeptInfoReqVO deptInfoReqVO : deptInfoReqVOList) {
                deptId = deptInfoReqVO.getDeptId();
                dbDoctorWorkplacesInfo = this.docDoctorWorkplacesInfoMapper.getByWorkPlacesIdAndDeptId(docDoctorWorkplacesEntity.getxId(), deptId);
                if (dbDoctorWorkplacesInfo != null) continue;
                doctorWorkplacesInfo = new DocDoctorWorkplacesInfo();
                doctorWorkplacesInfo.setDoctorWorkplaces(docDoctorWorkplacesEntity.getxId());
                doctorWorkplacesInfo.setDeptId(deptId);
                doctorWorkplacesInfo.setDeptName(deptInfoReqVO.getDeptName());
                this.docDoctorWorkplacesInfoMapper.insert(doctorWorkplacesInfo);
            }
        }
    }
}

