/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.aop;

import com.doctoruser.doctor.pojo.entity.BaseEntity;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CommonDataInject {
    private static Logger logger = LoggerFactory.getLogger(CommonDataInject.class);

    @Pointcut(value="execution(* com.doctoruser.doctor.mapper.*Mapper.insert*(..))")
    private void insertCutMethod() {
        logger.debug("");
    }

    @Pointcut(value="execution(* com.doctoruser.doctor.mapper.*Mapper.update*(..))")
    private void updateCutMethod() {
        logger.debug("");
    }

    @Around(value="insertCutMethod()")
    public Object doInsertAround(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args;
        for (Object arg : args = pjp.getArgs()) {
            if (arg instanceof BaseEntity) {
                BaseEntity entity = (BaseEntity)arg;
                this.builBaseEntity(entity);
            } else if (arg instanceof Collection) {
                List list = (List)arg;
                for (Object obj : list) {
                    if (!(obj instanceof BaseEntity)) break;
                    BaseEntity entity = (BaseEntity)obj;
                    this.builBaseEntity(entity);
                }
            }
            logger.debug("[insert]" + arg);
        }
        return pjp.proceed();
    }

    @Around(value="updateCutMethod()")
    public Object doUpdateAround(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args;
        for (Object arg : args = pjp.getArgs()) {
            if (arg instanceof BaseEntity) {
                BaseEntity entity = (BaseEntity)arg;
                entity.setUpdateTime(new Date());
            } else if (arg instanceof Collection) {
                List list = (List)arg;
                for (Object obj : list) {
                    if (!(obj instanceof BaseEntity)) break;
                    BaseEntity entity = (BaseEntity)obj;
                    entity.setUpdateTime(new Date());
                }
            }
            logger.debug("[update]" + arg);
        }
        return pjp.proceed();
    }

    private void builBaseEntity(BaseEntity entity) {
        Date now = new Date();
        if (entity.getCreateTime() == null) {
            entity.setCreateTime(now);
        }
        if (entity.getUpdateTime() == null) {
            entity.setUpdateTime(now);
        }
    }
}

