/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.remote;

import com.alibaba.fastjson.JSON;
import com.doctoruser.doctor.pojo.dto.SessionGroupUser;
import com.doctoruser.doctor.pojo.vo.GetFollowupPlanDoctorListReqVo;
import com.doctoruser.doctor.pojo.vo.MedicalRecordsReqVO;
import com.doctoruser.doctor.pojo.vo.MedicalRecordsVO;
import com.doctoruser.doctor.pojo.vo.PatientAttentionVO;
import com.doctoruser.doctor.pojo.vo.PatientDetailReqVO;
import com.doctoruser.doctor.pojo.vo.PatientFollowupPlanVO;
import com.ebaiyihui.common.pojo.vo.GetUserInfoReqVO;
import com.ebaiyihui.common.pojo.vo.UserInfoRespVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class NodeRemoteService {
    private static final Logger log = LoggerFactory.getLogger(NodeRemoteService.class);
    @Value(value="${domainName}")
    private String domainName;
    private static final String USER_URL = "/user/getuserinfo";
    private static final String MEDICAL_RECORD = "/netinquiry/medicalRecord/getPatientMedicalRecords";
    private static final String FOLLOWUP_ORDER = "/health/api/v1/followupPlanOrder/getPatientFollowPlanOrder";
    private static final String CREATE_SESSION = "/health/api/v1/imMessage/patientReport";

    public UserInfoRespVO getUserInfo(String appCode, String userId) {
        String getUserUrl = this.domainName + "/" + appCode + USER_URL;
        try {
            GetUserInfoReqVO reqVo = new GetUserInfoReqVO();
            reqVo.setUserId(userId);
            reqVo.setUserType(new Short("0"));
            reqVo.setAppCode(appCode);
            log.info("\u83b7\u53d6\u8282\u70b9\u7528\u6237\u4fe1\u606f\u5165\u53c2: {}", (Object)reqVo);
            String body = HttpKit.jsonPost((String)getUserUrl, (String)JSON.toJSONString((Object)reqVo));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            log.info("\u83b7\u53d6\u8282\u70b9\u7528\u6237\u4fe1\u606f\u8fd4\u56de\u503c:{}", (Object)baseResponse);
            UserInfoRespVO respVo = (UserInfoRespVO)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), UserInfoRespVO.class);
            return respVo;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u767b\u5f55\u8bbe\u5907\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
            return null;
        }
    }

    public MedicalRecordsVO getDoctorMedicalRecords(PatientDetailReqVO reqVO) {
        String getMedicalUrl = this.domainName + "/" + reqVO.getAppCode() + MEDICAL_RECORD;
        try {
            MedicalRecordsReqVO record = new MedicalRecordsReqVO();
            record.setDoctorId(reqVO.getDoctorId());
            record.setPatientId(reqVO.getPatientId());
            record.setPageNum(Integer.valueOf(1));
            record.setPageSize(Integer.valueOf(10));
            log.info("\u67e5\u8be2\u533b\u751f\u7aef\u5c31\u8bca\u8bb0\u5f55\u5217\u8868-\u7ebf\u4e0a\u5c31\u8bca\u8bb0\u5f55\u5165\u53c2: {}", (Object)record);
            String body = HttpKit.jsonPost((String)getMedicalUrl, (String)JSON.toJSONString((Object)record));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            log.info("\u67e5\u8be2\u533b\u751f\u7aef\u5c31\u8bca\u8bb0\u5f55\u5217\u8868-\u7ebf\u4e0a\u5c31\u8bca\u8bb0\u5f55\u8fd4\u56de\u503c:{}", (Object)baseResponse);
            PageResult pageResult = (PageResult)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), PageResult.class);
            MedicalRecordsVO recordsVo = null;
            if (Objects.nonNull(pageResult) && pageResult.getTotal() > 0) {
                recordsVo = (MedicalRecordsVO)JSON.parseObject((String)JSON.toJSONString(pageResult.getContent().get(0)), MedicalRecordsVO.class);
            }
            return recordsVo;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u533b\u751f\u7aef\u5c31\u8bca\u8bb0\u5f55\u5217\u8868-\u7ebf\u4e0a\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25{}", (Throwable)e);
            return null;
        }
    }

    public PatientFollowupPlanVO getPatientFollowPlanOrder(PatientDetailReqVO reqVO) {
        String getMedicalUrl = this.domainName + "/" + reqVO.getAppCode() + FOLLOWUP_ORDER;
        try {
            GetFollowupPlanDoctorListReqVo record = new GetFollowupPlanDoctorListReqVo();
            record.setDoctorId(reqVO.getDoctorId());
            record.setPatientId(reqVO.getPatientId());
            record.setAppCode(reqVO.getAppCode());
            record.setPageNum(Integer.valueOf(1));
            record.setPageSize(Integer.valueOf(10));
            log.info("\u67e5\u8be2\u60a3\u8005-\u968f\u8bbf\u8ba1\u5212\u8bb0\u5f55\u5165\u53c2: {}", (Object)record);
            String body = HttpKit.jsonPost((String)getMedicalUrl, (String)JSON.toJSONString((Object)record));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            log.info("\u67e5\u8be2\u60a3\u8005-\u968f\u8bbf\u8ba1\u5212\u8bb0\u5f55\u8fd4\u56de\u503c:{}", (Object)baseResponse);
            PageResult pageResult = (PageResult)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), PageResult.class);
            PatientFollowupPlanVO recordsVo = null;
            if (Objects.nonNull(pageResult) && pageResult.getTotal() > 0) {
                recordsVo = (PatientFollowupPlanVO)JSON.parseObject((String)JSON.toJSONString(pageResult.getContent().get(0)), PatientFollowupPlanVO.class);
            }
            return recordsVo;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u60a3\u8005-\u968f\u8bbf\u8ba1\u5212\u8bb0\u5f55\u5931\u8d25{}", (Throwable)e);
            return null;
        }
    }

    public BaseResponse<SessionGroupUser> createSession(PatientAttentionVO reqVO) {
        String createSessionUrl = this.domainName + "/" + reqVO.getAppCode() + CREATE_SESSION;
        SessionGroupUser sessionGroupUser = null;
        try {
            log.info("\u521b\u5efa\u4f1a\u8bdd\u5165\u53c2: {}", (Object)reqVO);
            String body = HttpKit.jsonPost((String)createSessionUrl, (String)JSON.toJSONString((Object)reqVO));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            log.info("\u521b\u5efa\u4f1a\u8bdd\u8fd4\u56de\u503c:{}", (Object)baseResponse);
            if (!baseResponse.isSuccess()) {
                return BaseResponse.error((String)baseResponse.getMsg());
            }
            sessionGroupUser = (SessionGroupUser)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), SessionGroupUser.class);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u4f1a\u8bdd\u5931\u8d25{}", (Throwable)e);
        }
        return BaseResponse.success(sessionGroupUser);
    }
}

