/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctor.basedata.api.bo.doc_service.ZXWZServiceBo;
import com.doctor.basedata.api.vo.OrganServiceIterationVo;
import com.doctor.basedata.api.vo.OrganServicePageReqVO;
import com.doctor.basedata.api.vo.OrganServicePageResqVO;
import com.doctoruser.api.pojo.base.entity.OrganWorkingServiceEntity;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.mapper.DictionaryMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkingServiceMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesMapper;
import com.doctoruser.doctor.mapper.OrganWorkingServiceMapper;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.pojo.entity.DictionaryEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesEntity;
import com.doctoruser.doctor.pojo.entity.OrganizationEntity;
import com.doctoruser.doctor.pojo.vo.DocWorkServiceConfigVo;
import com.doctoruser.doctor.pojo.vo.OrganServiceConfigIterationVo;
import com.doctoruser.doctor.pojo.vo.OrganServiceConfigVo;
import com.doctoruser.doctor.pojo.vo.OrganServiceVo;
import com.doctoruser.doctor.pojo.vo.RequestServiceConfigListVo;
import com.doctoruser.doctor.service.OrganServManageService;
import com.doctoruser.doctor.utils.HttpClientUtil;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class OrganServManageServiceImpl
implements OrganServManageService {
    public static final String SYSTEM_SERVICE_TYPE_CODE = "1800";
    @Value(value="${domainName}")
    private String domainName;
    @Autowired
    private OrganWorkingServiceMapper organWorkingServiceMapper;
    @Autowired
    private DictionaryMapper dictionaryMapper;
    @Autowired
    private DocDoctorWorkingServiceMapper docWorkingServiceMapper;
    @Autowired
    private DocDoctorWorkplacesMapper docDoctorWorkplacesMapper;
    @Autowired
    private OrganizationMapper organizationMapper;

    public BaseResponse<List<OrganServiceVo>> getOrganServiceInfo(Long organId) {
        List systemServiceList = this.dictionaryMapper.findByTypeCode(SYSTEM_SERVICE_TYPE_CODE);
        List organServiceList = this.organWorkingServiceMapper.queryOrganServiceByOrganId(String.valueOf(organId), "1,-1");
        Map organServiceVoMap = organServiceList.stream().collect(Collectors.toMap(OrganWorkingServiceEntity::getServCode, Function.identity(), (first, second) -> second));
        ArrayList<OrganServiceVo> serviceList = new ArrayList<OrganServiceVo>();
        for (DictionaryEntity systemService : systemServiceList) {
            OrganServiceVo organServiceVo = new OrganServiceVo();
            OrganWorkingServiceEntity organWorkingService = (OrganWorkingServiceEntity)organServiceVoMap.get(systemService.getDicCode());
            organServiceVo.setDisplayId(systemService.getId());
            organServiceVo.setServiceCode(systemService.getDicCode());
            organServiceVo.setServiceName(systemService.getDicName());
            organServiceVo.setOrganId(organId);
            organServiceVo.setParentCode(systemService.getParentCode());
            if (Objects.isNull(organWorkingService)) {
                organServiceVo.setStatus(Integer.valueOf(-1));
            } else {
                organServiceVo.setStatus(organWorkingService.getStatus());
                organServiceVo.setServiceId(Long.valueOf(organWorkingService.getxId()));
                String serviceConfig = organWorkingService.getConfig();
                OrganServiceConfigVo organServiceConfig = (OrganServiceConfigVo)JSON.parseObject((String)serviceConfig, OrganServiceConfigVo.class);
                if (Objects.nonNull(organServiceConfig)) {
                    BigDecimal organRatio = organServiceConfig.getOrganRatio();
                    BigDecimal platFormRatio = organServiceConfig.getPlatFormRatio();
                    Integer settlement = organServiceConfig.getSettlement();
                    organServiceVo.setSettlement(settlement);
                    organServiceVo.setPlatFormRatio(platFormRatio);
                    organServiceVo.setOrganRatio(organRatio);
                }
            }
            serviceList.add(organServiceVo);
        }
        List organServiceVoList = this.buildOrganServiceList(serviceList);
        return BaseResponse.success((Object)organServiceVoList);
    }

    public BaseResponse openOrganService(OrganServiceVo organServiceVo) {
        List organServiceList = this.organWorkingServiceMapper.queryOrganServiceByOrganId(String.valueOf(organServiceVo.getOrganId()), "1,-1");
        List validateExistList = organServiceList.stream().filter(item -> item.getServCode().equals(organServiceVo.getServiceCode())).collect(Collectors.toList());
        if (validateExistList.isEmpty()) {
            OrganWorkingServiceEntity organWorkingServiceEntity = new OrganWorkingServiceEntity();
            organWorkingServiceEntity.initInsert();
            organWorkingServiceEntity.setOrganId(String.valueOf(organServiceVo.getOrganId()));
            organWorkingServiceEntity.setServCode(organServiceVo.getServiceCode());
            organWorkingServiceEntity.setServName(organServiceVo.getServiceName());
            organWorkingServiceEntity.setServType(Integer.valueOf(1));
            organWorkingServiceEntity.setStatus(organServiceVo.getStatus());
            OrganServiceConfigVo organServiceConfigVo = new OrganServiceConfigVo();
            organServiceConfigVo.setSettlement(organServiceVo.getSettlement());
            organServiceConfigVo.setOrganRatio(organServiceVo.getOrganRatio());
            organServiceConfigVo.setPlatFormRatio(organServiceVo.getPlatFormRatio());
            String configJson = JSON.toJSONString((Object)organServiceConfigVo);
            organWorkingServiceEntity.setConfig(configJson);
            int insert = this.organWorkingServiceMapper.insertSelective(organWorkingServiceEntity);
            return BaseResponse.success((Object)insert);
        }
        return BaseResponse.error((IError)EHErrorEnum.DATA_HAVE_EXIST);
    }

    public BaseResponse updateOrganService(OrganServiceVo organServiceVo) {
        OrganWorkingServiceEntity organWorkingServiceEntity = new OrganWorkingServiceEntity();
        organWorkingServiceEntity.setxUpdateTime(new Date());
        organWorkingServiceEntity.setOrganId(String.valueOf(organServiceVo.getOrganId()));
        organWorkingServiceEntity.setServCode(organServiceVo.getServiceCode());
        organWorkingServiceEntity.setServName(organServiceVo.getServiceName());
        organWorkingServiceEntity.setServType(Integer.valueOf(1));
        organWorkingServiceEntity.setStatus(organServiceVo.getStatus());
        organWorkingServiceEntity.setxId(String.valueOf(organServiceVo.getServiceId()));
        OrganServiceConfigVo organServiceConfigVo = new OrganServiceConfigVo();
        organServiceConfigVo.setSettlement(organServiceVo.getSettlement());
        organServiceConfigVo.setOrganRatio(organServiceVo.getOrganRatio());
        organServiceConfigVo.setPlatFormRatio(organServiceVo.getPlatFormRatio());
        String configJson = JSON.toJSONString((Object)organServiceConfigVo);
        organWorkingServiceEntity.setConfig(configJson);
        int update = this.organWorkingServiceMapper.updateByPrimaryKeySelective(organWorkingServiceEntity);
        return BaseResponse.success((Object)update);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public BaseResponse setDocWorkServiceDefaultConfig(DocWorkServiceConfigVo docWorkServiceConfigVo) {
        String serviceCode = docWorkServiceConfigVo.getServiceCode();
        String serviceConfig = docWorkServiceConfigVo.getServiceConfig();
        Long organId = docWorkServiceConfigVo.getOrganId();
        OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)organId);
        if (Objects.isNull(organizationEntity)) {
            return BaseResponse.error((IError)EHErrorEnum.ORGAN_DATA_NOT_EXIST);
        }
        OrganWorkingServiceEntity organService = this.organWorkingServiceMapper.getServiceByOrganId(organId, serviceCode, "1,-1");
        if (Objects.isNull(organService)) {
            return BaseResponse.error((IError)EHErrorEnum.ORGAN_SERVICE_INFO_NON_EXISTENT);
        }
        organService.setServName(docWorkServiceConfigVo.getServiceName());
        organService.setServiceConfig(serviceConfig);
        this.organWorkingServiceMapper.updateByPrimaryKeySelective(organService);
        List doctorWorkplaces = this.docDoctorWorkplacesMapper.getOpenServiceDoctorWorkInfo(organId, organService.getxId(), 1);
        ZXWZServiceBo zxwzServiceBo = (ZXWZServiceBo)JSON.parseObject((String)serviceConfig, ZXWZServiceBo.class);
        this.docWorkingServiceMapper.updateByWorkServiceId(organService.getxId(), JSON.toJSONString((Object)zxwzServiceBo));
        List doctorIds = doctorWorkplaces.stream().map(DocDoctorWorkplacesEntity::getDoctorId).map(String::valueOf).collect(Collectors.toList());
        String requestUrl = this.domainName + organizationEntity.getAppCode() + "/netinquiry/serviceconfig/saveconfiginfolist";
        RequestServiceConfigListVo requestServiceConfigListVo = new RequestServiceConfigListVo();
        requestServiceConfigListVo.setDoctorId(doctorIds);
        requestServiceConfigListVo.setAppCode(organizationEntity.getAppCode());
        requestServiceConfigListVo.setDailyLimit(zxwzServiceBo.getNumLimit());
        requestServiceConfigListVo.setHospitalId(String.valueOf(organId));
        requestServiceConfigListVo.setNumLimit(zxwzServiceBo.getReplyLimit());
        requestServiceConfigListVo.setOperationType(Integer.valueOf(2));
        requestServiceConfigListVo.setIsSchedule(zxwzServiceBo.getIsSchedule());
        requestServiceConfigListVo.setPrice(zxwzServiceBo.getServicePrice());
        requestServiceConfigListVo.setOrderTime(zxwzServiceBo.getWaitTimeLimit());
        requestServiceConfigListVo.setServTime(zxwzServiceBo.getEffectiveTime());
        String serviceTimeUnit = zxwzServiceBo.getServiceTimeUnit();
        requestServiceConfigListVo.setTimeUnit(Integer.valueOf(Objects.isNull(serviceTimeUnit) ? 1 : Integer.valueOf(serviceTimeUnit)));
        String waitTimeUnit = zxwzServiceBo.getWaitTimeUnit();
        requestServiceConfigListVo.setOrderTimeUnit(Integer.valueOf(Objects.isNull(waitTimeUnit) ? 1 : Integer.valueOf(waitTimeUnit)));
        BaseResponse baseResponse = HttpClientUtil.doJsonPost((Object)requestServiceConfigListVo, (String)requestUrl);
        if (Objects.isNull(baseResponse) || !baseResponse.isSuccess()) {
            throw new RuntimeException("\u8c03\u7528\u5728\u7ebf\u95ee\u8bca,\u6279\u91cf\u8bbe\u7f6e\u670d\u52a1\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    public BaseResponse<DocWorkServiceConfigVo> getDocWorkServiceDefaultConfig(Long organId, String serviceCode) {
        OrganWorkingServiceEntity organWorkService = this.organWorkingServiceMapper.getServiceByOrganId(organId, serviceCode, "1,-1");
        if (Objects.nonNull(organWorkService)) {
            DocWorkServiceConfigVo docWorkServiceConfigVo = new DocWorkServiceConfigVo();
            docWorkServiceConfigVo.setOrganId(organId);
            docWorkServiceConfigVo.setServiceCode(serviceCode);
            docWorkServiceConfigVo.setServiceName(organWorkService.getServName());
            docWorkServiceConfigVo.setServiceConfig(organWorkService.getServiceConfig());
            return BaseResponse.success((Object)docWorkServiceConfigVo);
        }
        return BaseResponse.error((IError)EHErrorEnum.ORGAN_SERVICE_NOT_EXIST);
    }

    public BaseResponse<List<OrganServiceVo>> getOrganOpenService(Long organId) {
        List organServiceList = this.organWorkingServiceMapper.queryOrganServiceByOrganId(String.valueOf(organId), String.valueOf(1));
        ArrayList<OrganServiceVo> serviceList = new ArrayList<OrganServiceVo>();
        for (OrganWorkingServiceEntity organWorkingService : organServiceList) {
            if (ServiceCodeEnum.HLZD.getServiceCode().equals(organWorkingService.getServCode())) continue;
            OrganServiceVo organServiceVo = new OrganServiceVo();
            organServiceVo.setDisplayId(organWorkingService.getxId());
            organServiceVo.setServiceCode(organWorkingService.getServCode());
            organServiceVo.setServiceName(organWorkingService.getServName());
            organServiceVo.setOrganId(organId);
            organServiceVo.setParentCode(organWorkingService.getParentCode());
            organServiceVo.setStatus(organWorkingService.getStatus());
            String serviceConfig = organWorkingService.getConfig();
            organServiceVo.setServiceId(Long.valueOf(organWorkingService.getxId()));
            OrganServiceConfigVo organServiceConfig = (OrganServiceConfigVo)JSON.parseObject((String)serviceConfig, OrganServiceConfigVo.class);
            if (Objects.nonNull(organServiceConfig)) {
                BigDecimal platFormRatio = organServiceConfig.getPlatFormRatio();
                BigDecimal organRatio = organServiceConfig.getOrganRatio();
                Integer settlement = organServiceConfig.getSettlement();
                organServiceVo.setPlatFormRatio(platFormRatio);
                organServiceVo.setSettlement(settlement);
                organServiceVo.setOrganRatio(organRatio);
            }
            serviceList.add(organServiceVo);
        }
        List organServiceVoList = this.buildOrganServiceList(serviceList);
        return BaseResponse.success((Object)organServiceVoList);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse openOrganServiceIteration(OrganServiceIterationVo organServiceVo) {
        List organServiceList = this.organWorkingServiceMapper.queryOrganServiceByOrganId(String.valueOf(organServiceVo.getOrganId()), "1,-1");
        List validateExistList = organServiceList.stream().filter(item -> item.getServCode().equals(organServiceVo.getServiceCode())).collect(Collectors.toList());
        try {
            if (validateExistList.isEmpty()) {
                DictionaryEntity byDicCodeAndTypeCode = this.dictionaryMapper.findByDicCodeAndTypeCode(organServiceVo.getServiceCode(), SYSTEM_SERVICE_TYPE_CODE);
                List byParentCode = this.dictionaryMapper.findByParentCode(byDicCodeAndTypeCode.getDicCode(), SYSTEM_SERVICE_TYPE_CODE);
                if (!byParentCode.isEmpty()) {
                    List organWorkingServiceList = this.getOrganWorkingServiceList(organServiceVo.getOrganId(), byParentCode);
                    if (organWorkingServiceList.isEmpty()) {
                        List organWorkingServiceEntityList = this.openHaveSubService(organServiceVo, byParentCode);
                        for (OrganWorkingServiceEntity organWorkingServiceEntity : organWorkingServiceEntityList) {
                            this.organWorkingServiceMapper.insertSelective(organWorkingServiceEntity);
                        }
                        return BaseResponse.success();
                    }
                    return BaseResponse.error((IError)EHErrorEnum.DATA_HAVE_EXIST);
                }
                OrganWorkingServiceEntity organWorkingServiceEntity = new OrganWorkingServiceEntity();
                organWorkingServiceEntity.initInsert();
                organWorkingServiceEntity.setOrganId(String.valueOf(organServiceVo.getOrganId()));
                organWorkingServiceEntity.setServCode(organServiceVo.getServiceCode());
                organWorkingServiceEntity.setServName(organServiceVo.getServiceName());
                organWorkingServiceEntity.setServType(Integer.valueOf(1));
                organWorkingServiceEntity.setStatus(organServiceVo.getStatus());
                OrganServiceConfigIterationVo organServiceConfigVo = new OrganServiceConfigIterationVo();
                organServiceConfigVo.setSettlement(organServiceVo.getSettlement());
                organServiceConfigVo.setDeptPrice(organServiceVo.getDeptPrice());
                String configJson = JSON.toJSONString((Object)organServiceConfigVo);
                organWorkingServiceEntity.setConfig(configJson);
                int insert = this.organWorkingServiceMapper.insertSelective(organWorkingServiceEntity);
                return BaseResponse.success((Object)insert);
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return BaseResponse.error((IError)EHErrorEnum.DATA_HAVE_EXIST);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse updateOrganServiceIteration(OrganServiceIterationVo organServiceVo) {
        DictionaryEntity dictionaryEntity = this.dictionaryMapper.findByDicCodeAndTypeCode(organServiceVo.getServiceCode(), SYSTEM_SERVICE_TYPE_CODE);
        List byParentCode = this.dictionaryMapper.findByParentCode(dictionaryEntity.getDicCode(), SYSTEM_SERVICE_TYPE_CODE);
        try {
            if (byParentCode != null && byParentCode.size() > 0) {
                List organWorkingServiceList = this.getOrganWorkingServiceList(organServiceVo.getOrganId(), byParentCode);
                for (OrganWorkingServiceEntity organServiceEntity : organWorkingServiceList) {
                    OrganWorkingServiceEntity organWorkingServiceEntity = new OrganWorkingServiceEntity();
                    organWorkingServiceEntity.setxUpdateTime(new Date());
                    organWorkingServiceEntity.setOrganId(String.valueOf(organServiceVo.getOrganId()));
                    organWorkingServiceEntity.setServCode(organServiceEntity.getServCode());
                    organWorkingServiceEntity.setServName(organServiceEntity.getServName());
                    organWorkingServiceEntity.setServType(Integer.valueOf(1));
                    organWorkingServiceEntity.setStatus(organServiceVo.getStatus());
                    organWorkingServiceEntity.setxId(String.valueOf(organServiceEntity.getxId()));
                    OrganServiceIterationVo organServiceConfigVo = new OrganServiceIterationVo();
                    organServiceConfigVo.setSettlement(organServiceVo.getSettlement());
                    organServiceConfigVo.setDeptPrice(organServiceVo.getDeptPrice());
                    String configJson = JSON.toJSONString((Object)organServiceConfigVo);
                    organWorkingServiceEntity.setConfig(configJson);
                    this.organWorkingServiceMapper.updateByPrimaryKeySelective(organWorkingServiceEntity);
                }
                return BaseResponse.success();
            }
            OrganWorkingServiceEntity organWorkingServiceEntity = new OrganWorkingServiceEntity();
            organWorkingServiceEntity.setxUpdateTime(new Date());
            organWorkingServiceEntity.setOrganId(String.valueOf(organServiceVo.getOrganId()));
            organWorkingServiceEntity.setServCode(organServiceVo.getServiceCode());
            organWorkingServiceEntity.setServName(organServiceVo.getServiceName());
            organWorkingServiceEntity.setServType(Integer.valueOf(1));
            organWorkingServiceEntity.setStatus(organServiceVo.getStatus());
            organWorkingServiceEntity.setxId(String.valueOf(organServiceVo.getServiceId()));
            OrganServiceConfigVo organServiceConfigVo = new OrganServiceConfigVo();
            organServiceConfigVo.setSettlement(organServiceVo.getSettlement());
            organServiceConfigVo.setOrganRatio(organServiceVo.getOrganRatio());
            organServiceConfigVo.setPlatFormRatio(organServiceVo.getPlatFormRatio());
            String configJson = JSON.toJSONString((Object)organServiceConfigVo);
            organWorkingServiceEntity.setConfig(configJson);
            int update = this.organWorkingServiceMapper.updateByPrimaryKeySelective(organWorkingServiceEntity);
            return BaseResponse.success((Object)update);
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseResponse.success();
        }
    }

    public BaseResponse<List<OrganServiceIterationVo>> getOrganServiceInfoIteration(Long organId) {
        List systemServiceList = this.dictionaryMapper.findByTypeCodeAndNotHaveParentId(SYSTEM_SERVICE_TYPE_CODE);
        List organServiceList = this.organWorkingServiceMapper.queryOrganServiceByOrganId(String.valueOf(organId), "1,-1");
        Map organServiceVoMap = organServiceList.stream().collect(Collectors.toMap(OrganWorkingServiceEntity::getServCode, Function.identity(), (first, second) -> second));
        ArrayList<OrganServiceIterationVo> serviceList = new ArrayList<OrganServiceIterationVo>();
        for (DictionaryEntity systemService : systemServiceList) {
            OrganServiceIterationVo organServiceVo = new OrganServiceIterationVo();
            OrganWorkingServiceEntity organWorkingService = (OrganWorkingServiceEntity)organServiceVoMap.get(systemService.getDicCode());
            organServiceVo.setDisplayId(systemService.getId());
            organServiceVo.setServiceCode(systemService.getDicCode());
            organServiceVo.setServiceName(systemService.getDicName());
            organServiceVo.setOrganId(organId);
            organServiceVo.setParentCode(systemService.getParentCode());
            if (Objects.isNull(organWorkingService)) {
                if (systemService.getDicCode().equals(ServiceCodeEnum.YCHZ.getServiceCode())) {
                    DictionaryEntity dictionaryEntity = this.dictionaryMapper.findByDicCodeAndTypeCode(organServiceVo.getServiceCode(), SYSTEM_SERVICE_TYPE_CODE);
                    List byParentCode = this.dictionaryMapper.findByParentCode(dictionaryEntity.getDicCode(), SYSTEM_SERVICE_TYPE_CODE);
                    List organWorkingServiceList = this.getOrganWorkingServiceList(organId, byParentCode);
                    if (organWorkingServiceList == null || organWorkingServiceList.size() <= 0) {
                        organServiceVo.setStatus(Integer.valueOf(-1));
                    } else {
                        organServiceVo.setStatus(((OrganWorkingServiceEntity)organWorkingServiceList.get(0)).getStatus());
                        organServiceVo.setServiceId(Long.valueOf(((OrganWorkingServiceEntity)organWorkingServiceList.get(0)).getxId()));
                        String serviceConfig = ((OrganWorkingServiceEntity)organWorkingServiceList.get(0)).getConfig();
                        OrganServiceIterationVo organServiceIterationVo = (OrganServiceIterationVo)JSON.parseObject((String)serviceConfig, OrganServiceIterationVo.class);
                        if (Objects.nonNull(organServiceIterationVo)) {
                            Integer settlement = organServiceIterationVo.getSettlement();
                            organServiceVo.setSettlement(settlement);
                            organServiceVo.setDeptPrice(organServiceIterationVo.getDeptPrice());
                        }
                    }
                } else {
                    organServiceVo.setStatus(Integer.valueOf(-1));
                }
            } else {
                organServiceVo.setStatus(organWorkingService.getStatus());
                organServiceVo.setServiceId(Long.valueOf(organWorkingService.getxId()));
                String serviceConfig = organWorkingService.getConfig();
                OrganServiceConfigVo organServiceConfig = (OrganServiceConfigVo)JSON.parseObject((String)serviceConfig, OrganServiceConfigVo.class);
                if (Objects.nonNull(organServiceConfig)) {
                    BigDecimal organRatio = organServiceConfig.getOrganRatio();
                    BigDecimal platFormRatio = organServiceConfig.getPlatFormRatio();
                    Integer settlement = organServiceConfig.getSettlement();
                    organServiceVo.setSettlement(settlement);
                    organServiceVo.setPlatFormRatio(platFormRatio);
                    organServiceVo.setOrganRatio(organRatio);
                }
            }
            serviceList.add(organServiceVo);
        }
        List organServiceVoList = this.buildOrganServiceListIteration(serviceList);
        return BaseResponse.success((Object)organServiceVoList);
    }

    public BaseResponse<OrganServicePageResqVO> getOrganServiceInfoPage(OrganServicePageReqVO pageReqVO) {
        BaseResponse baseResponse = this.getOrganServiceInfoIteration(pageReqVO.getOrganId());
        if (!baseResponse.isSuccess()) {
            return BaseResponse.error((String)baseResponse.getMsg());
        }
        List organServiceVoList = (List)baseResponse.getData();
        Integer total = organServiceVoList.size();
        Long openServNum = 0L;
        if (CollectionUtils.isNotEmpty((Collection)organServiceVoList)) {
            openServNum = organServiceVoList.stream().filter(service -> service.getStatus().equals(1)).count();
            organServiceVoList = organServiceVoList.stream().skip((pageReqVO.getPageNum() - 1) * pageReqVO.getPageSize()).limit(pageReqVO.getPageSize().intValue()).collect(Collectors.toList());
        }
        PageResult pageResult = new PageResult();
        pageResult.setPageNum(pageReqVO.getPageNum().intValue());
        pageResult.setPageSize(pageReqVO.getPageSize().intValue());
        pageResult.setContent(organServiceVoList);
        pageResult.setTotal(total.intValue());
        OrganServicePageResqVO resqVO = new OrganServicePageResqVO();
        resqVO.setPageResult(pageResult);
        resqVO.setOpenServNum(openServNum);
        return BaseResponse.success((Object)resqVO);
    }

    private List<OrganServiceVo> buildOrganServiceList(List<OrganServiceVo> sourceList) {
        Map<String, List<OrganServiceVo>> serviceGroupMap = sourceList.stream().collect(Collectors.groupingBy(OrganServiceVo::getParentCode));
        List<OrganServiceVo> organServiceVoList = serviceGroupMap.get("0");
        if (Objects.nonNull(organServiceVoList)) {
            for (OrganServiceVo organServiceVo : organServiceVoList) {
                List<OrganServiceVo> organServiceVos = serviceGroupMap.get(organServiceVo.getServiceCode());
                if (!Objects.nonNull(organServiceVos)) continue;
                organServiceVo.setChildService(organServiceVos);
            }
        }
        return organServiceVoList;
    }

    private List<OrganServiceIterationVo> buildOrganServiceListIteration(List<OrganServiceIterationVo> sourceList) {
        Map<String, List<OrganServiceIterationVo>> serviceGroupMap = sourceList.stream().collect(Collectors.groupingBy(OrganServiceIterationVo::getParentCode));
        List<OrganServiceIterationVo> organServiceVoList = serviceGroupMap.get("0");
        if (Objects.nonNull(organServiceVoList)) {
            for (OrganServiceIterationVo organServiceVo : organServiceVoList) {
                List<OrganServiceIterationVo> organServiceVos = serviceGroupMap.get(organServiceVo.getServiceCode());
                if (!Objects.nonNull(organServiceVos)) continue;
                organServiceVo.setChildService(organServiceVos);
            }
        }
        return organServiceVoList;
    }

    List<OrganWorkingServiceEntity> getOrganWorkingServiceList(Long organId, List<DictionaryEntity> dictionaryEntities) {
        ArrayList<String> serviceCodeList = new ArrayList<String>();
        for (DictionaryEntity dictionaryEntity : dictionaryEntities) {
            serviceCodeList.add(dictionaryEntity.getDicCode());
        }
        if (serviceCodeList.size() == 0) {
            serviceCodeList.add("0");
        }
        return this.organWorkingServiceMapper.selectByServiceCodeListAndOrganId(organId, serviceCodeList);
    }

    List<OrganWorkingServiceEntity> openHaveSubService(OrganServiceIterationVo organServiceVo, List<DictionaryEntity> byParentCode) {
        ArrayList<OrganWorkingServiceEntity> organWorkingServiceEntityArrayList = new ArrayList<OrganWorkingServiceEntity>();
        for (DictionaryEntity dictionaryEntity : byParentCode) {
            OrganWorkingServiceEntity organWorkingServiceEntity = new OrganWorkingServiceEntity();
            organWorkingServiceEntity.initInsert();
            organWorkingServiceEntity.setOrganId(String.valueOf(organServiceVo.getOrganId()));
            organWorkingServiceEntity.setServCode(dictionaryEntity.getDicCode());
            organWorkingServiceEntity.setServName(dictionaryEntity.getDicName());
            organWorkingServiceEntity.setServType(Integer.valueOf(1));
            organWorkingServiceEntity.setStatus(organServiceVo.getStatus());
            OrganServiceConfigIterationVo organServiceConfigVo = new OrganServiceConfigIterationVo();
            organServiceConfigVo.setSettlement(organServiceVo.getSettlement());
            organServiceConfigVo.setDeptPrice(organServiceVo.getDeptPrice());
            String configJson = JSON.toJSONString((Object)organServiceConfigVo);
            organWorkingServiceEntity.setConfig(configJson);
            organWorkingServiceEntityArrayList.add(organWorkingServiceEntity);
        }
        return organWorkingServiceEntityArrayList;
    }
}

