/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.utils;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpClientUtil {
    private static Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final Integer DEFAULT_SOCKET_TIME_OUT = 50000;
    private static final Integer DEFAULT_SOCKET_CONNECTION_TIME_OUT = 50000;
    private static final Integer DEFAULT_SOCKET_CONNECTION_REQUEST_TIME_OUT = 50000;
    private static final String HTTP_ERROR = "Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38";
    private static final String UTF8 = "utf-8";

    public static String post(String url, Map<String, String> params) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        log.debug("create httppost:" + url);
        HttpPost post = HttpClientUtil.postForm((String)url, params);
        String body = HttpClientUtil.invoke((DefaultHttpClient)httpclient, (HttpUriRequest)post);
        httpclient.getConnectionManager().shutdown();
        return body;
    }

    private static String invoke(DefaultHttpClient httpclient, HttpUriRequest httpost) {
        HttpResponse response = HttpClientUtil.sendRequest((DefaultHttpClient)httpclient, (HttpUriRequest)httpost);
        String body = HttpClientUtil.paseResponse((HttpResponse)response);
        return body;
    }

    private static String paseResponse(HttpResponse response) {
        log.debug("get response from http server..");
        HttpEntity entity = response.getEntity();
        log.debug("response status: " + response.getStatusLine());
        String charset = EntityUtils.getContentCharSet((HttpEntity)entity);
        log.debug(charset);
        String body = null;
        try {
            body = EntityUtils.toString((HttpEntity)entity);
            log.debug(body);
        }
        catch (Exception e) {
            log.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return body;
    }

    private static HttpResponse sendRequest(DefaultHttpClient httpclient, HttpUriRequest httpost) {
        log.debug("execute post...");
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute(httpost);
        }
        catch (Exception e) {
            log.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return response;
    }

    private static HttpPost postForm(String url, Map<String, String> params) {
        HttpPost httpost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            nvps.add(new BasicNameValuePair(key, params.get(key)));
        }
        try {
            log.debug("set utf-8 form entity to httppost");
            httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return httpost;
    }

    public static Map<String, String> map2map(Map<String, String[]> parameter) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (parameter == null) {
            return result;
        }
        for (String keyString : parameter.keySet()) {
            String[] value = parameter.get(keyString);
            if (value instanceof String[]) {
                String[] valueAry = value;
                StringBuilder sbBuffer = new StringBuilder();
                if (valueAry.length == 1) {
                    result.put(keyString, valueAry[0]);
                    continue;
                }
                for (int i = 0; i < valueAry.length; ++i) {
                    sbBuffer.append(valueAry[i]).append(",");
                }
                result.put(keyString, sbBuffer.toString());
                continue;
            }
            result.put(keyString, value.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url) {
        CloseableHttpClient httpclient = null;
        HttpGet get = null;
        CloseableHttpResponse response = null;
        HttpEntity resEntity = null;
        try {
            httpclient = HttpClients.createDefault();
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(DEFAULT_SOCKET_TIME_OUT.intValue()).setConnectTimeout(DEFAULT_SOCKET_CONNECTION_TIME_OUT.intValue()).setSocketTimeout(DEFAULT_SOCKET_CONNECTION_REQUEST_TIME_OUT.intValue()).build();
            get = new HttpGet(url);
            get.setConfig(requestConfig);
            response = httpclient.execute((HttpUriRequest)get);
            resEntity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            HttpClientUtil.closeClient((CloseableHttpClient)httpclient, (HttpRequestBase)get, (CloseableHttpResponse)response, (HttpEntity)resEntity);
            return string;
        }
        catch (Exception e) {
            log.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            HttpClientUtil.closeClient((CloseableHttpClient)httpclient, get, response, resEntity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String json) throws IOException, ExecutionException, InterruptedException {
        CloseableHttpClient httpclient = null;
        HttpPost post = null;
        CloseableHttpResponse response = null;
        HttpEntity resEntity = null;
        try {
            httpclient = HttpClients.createDefault();
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(DEFAULT_SOCKET_TIME_OUT.intValue()).setConnectTimeout(DEFAULT_SOCKET_CONNECTION_TIME_OUT.intValue()).setSocketTimeout(DEFAULT_SOCKET_CONNECTION_REQUEST_TIME_OUT.intValue()).build();
            post = new HttpPost(url);
            post.setConfig(requestConfig);
            post.setHeader((Header)new BasicHeader("Content-Type", "application/json; charset=utf-8"));
            post.setEntity((HttpEntity)new StringEntity(json, "utf-8"));
            response = httpclient.execute((HttpUriRequest)post);
            resEntity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            HttpClientUtil.closeClient((CloseableHttpClient)httpclient, (HttpRequestBase)post, (CloseableHttpResponse)response, (HttpEntity)resEntity);
            return string;
        }
        catch (Exception e) {
            log.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            HttpClientUtil.closeClient((CloseableHttpClient)httpclient, post, response, resEntity);
        }
        return null;
    }

    private static void closeClient(CloseableHttpClient httpClient, HttpRequestBase httpRequest, CloseableHttpResponse response, HttpEntity resEntity) {
        try {
            if (resEntity != null) {
                EntityUtils.consume((HttpEntity)resEntity);
            }
        }
        catch (Exception e) {
            log.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (Exception e) {
            log.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        try {
            if (httpRequest != null) {
                httpRequest.releaseConnection();
            }
        }
        catch (Exception e) {
            log.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        try {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        catch (Exception e) {
            log.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }

    public static BaseResponse doJsonPost(Object param, String url) {
        try {
            log.info("\u8fdc\u7a0b\u8c03\u7528\u8def\u5f84:{},\u8c03\u7528\u5165\u53c2[{}]", (Object)url, (Object)JSON.toJSONString((Object)param));
            String response = HttpClientUtil.post((String)url, (String)JSON.toJSONString((Object)param));
            log.info("\u8fdc\u7a0b\u8c03\u7528\u8def\u5f84\u8fd4\u56de[{}]", (Object)response);
            return (BaseResponse)JSON.parseObject((String)response, BaseResponse.class);
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u51fa\u9519", (Throwable)e);
            return BaseResponse.error((String)e.getMessage());
        }
    }
}

