/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctor.basedata.api.DoctorWorkingServiceApi;
import com.doctor.basedata.api.bo.doc_service.JKGLServiceBo;
import com.doctor.basedata.api.vo.BusinessDoctorListReqVo;
import com.doctor.basedata.api.vo.BusinessDoctorPageReqVo;
import com.doctor.basedata.api.vo.DoctorBasicRespVO;
import com.doctor.basedata.api.vo.DoctorBusinessListReqVo;
import com.doctor.basedata.api.vo.ServiceCheckReqVo;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesInfo;
import com.doctoruser.doctor.pojo.vo.BatchSetDocServiceReqVO;
import com.doctoruser.doctor.pojo.vo.BatchSetDoctorServiceInfoReq;
import com.doctoruser.doctor.pojo.vo.DocWorkServiceVo;
import com.doctoruser.doctor.pojo.vo.DoctorServiceReq;
import com.doctoruser.doctor.pojo.vo.DoctorWorkInfoVo;
import com.doctoruser.doctor.pojo.vo.EnterGroupVO;
import com.doctoruser.doctor.pojo.vo.ServiceConfigRes;
import com.doctoruser.doctor.pojo.vo.ServiceSwitchReq;
import com.doctoruser.doctor.service.DoctorWorkInfoService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u533b\u751f\u6267\u4e1a\u70b9\u4fe1\u606f\u7ba1\u7406"})
@RestController
public class DoctorWorkInfoController
implements DoctorWorkingServiceApi {
    @Autowired
    private DoctorWorkInfoService doctorWorkInfoService;

    @ApiOperation(value="\u6839\u636e\u804c\u4e1aid\u67e5\u8be2\u804c\u4e1a\u70b9\u4fe1\u606f")
    @GetMapping(value={"/getDoctorWorkInfoById"})
    public BaseResponse<DoctorWorkInfoVo> getDoctorWorkInfo(@RequestParam(value="doctorWorkId") Long doctorWorkId, @RequestParam(value="deptId") Long deptId) {
        DoctorWorkInfoVo doctorWorkInfo = this.doctorWorkInfoService.getDoctorWorkInfo(doctorWorkId, deptId);
        return BaseResponse.success((Object)doctorWorkInfo);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u804c\u4e1a\u70b9\u4fe1\u606f")
    @GetMapping(value={"/getDoctorWorkInfo"})
    public BaseResponse<DoctorWorkInfoVo> getDoctorWorkInfo(@RequestParam(value="organId") Long organId, @RequestParam(value="doctorId") Long doctorId, @RequestParam(value="deptId") Long deptId) {
        DoctorWorkInfoVo doctorWorkInfo = this.doctorWorkInfoService.getDoctorWorkInfo(organId, doctorId, deptId);
        return BaseResponse.success((Object)doctorWorkInfo);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u5f00\u901a\u533b\u751f\u6743\u9650")
    @PostMapping(value={"/openManageDoctorService"})
    public BaseResponse openManageDoctorService(@RequestBody @Valid ServiceSwitchReq serviceSwitchReq, BindingResult bindingResult) {
        return this.doctorWorkInfoService.openManageDoctorService(serviceSwitchReq);
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u5f00\u901a\u533b\u751f\u6743\u9650")
    @PostMapping(value={"/openDoctorAppService"})
    public BaseResponse openDoctorAppService(@RequestBody @Valid ServiceSwitchReq serviceSwitchReq, BindingResult bindingResult) {
        return this.doctorWorkInfoService.openDoctorAppService(serviceSwitchReq);
    }

    @ApiOperation(value="\u533b\u751f\u670d\u52a1\u5217\u8868\u4fe1\u606f")
    @GetMapping(value={"/getDocWorkInfoService"})
    public BaseResponse<List<ServiceConfigRes>> getDocWorkInfoService(@RequestParam(value="organId") Long organId, @RequestParam(value="doctorId") Long doctorId) {
        return this.doctorWorkInfoService.getDocWorkInfoService(organId, doctorId);
    }

    @ApiOperation(value="\u533b\u751f\u5750\u8bca\u79d1\u5ba4\u96c6\u5408")
    @PostMapping(value={"/getDoctorWorkInfoList"})
    public BaseResponse<List<DocDoctorWorkplacesInfo>> getDoctorWorkInfoList(@RequestBody DoctorServiceReq doctorServiceReq) {
        return this.doctorWorkInfoService.getDoctorWorkInfoList(doctorServiceReq);
    }

    @ApiOperation(value="\u533b\u751f\u5f00\u901a\u670d\u52a1\u79d1\u5ba4\u96c6\u5408")
    @PostMapping(value={"/getDocOpenServiceDeptList"})
    public BaseResponse<List<DocDoctorWorkplacesInfo>> getDocOpenServiceDeptList(@RequestBody DoctorServiceReq doctorServiceReq) {
        return this.doctorWorkInfoService.getDocOpenServiceDeptList(doctorServiceReq);
    }

    public BaseResponse<Boolean> checkDoctorServiceByCode(@RequestBody ServiceCheckReqVo serviceCheckReqVo) {
        return this.doctorWorkInfoService.checkDoctorServiceByCode(serviceCheckReqVo);
    }

    public BaseResponse<PageResult<DoctorBasicRespVO>> getBusinessDoctorPage(@RequestBody BusinessDoctorPageReqVo reqVo) {
        return this.doctorWorkInfoService.getBusinessDoctorPage(reqVo);
    }

    public BaseResponse<List<DoctorBasicRespVO>> getBusinessDoctorList(@RequestBody BusinessDoctorListReqVo reqVo) {
        return this.doctorWorkInfoService.getBusinessDoctorList(reqVo);
    }

    public BaseResponse<PageResult<DoctorBasicRespVO>> getBusinessDoctorBaseInfoPage(@RequestBody BusinessDoctorPageReqVo reqVo) {
        return this.doctorWorkInfoService.getBusinessDoctorBaseInfoPage(reqVo);
    }

    public BaseResponse<List<DoctorBasicRespVO>> getBusinessByDocIdsAndServiceCode(@RequestBody DoctorBusinessListReqVo reqVo) {
        return this.doctorWorkInfoService.getBusinessByDocIdsAndServiceCode(reqVo);
    }

    public BaseResponse<Boolean> checkDoctorService(Long doctorId, String serviceCode) {
        return this.doctorWorkInfoService.checkDoctorService(doctorId, serviceCode);
    }

    @ApiOperation(value="\u6839\u636e\u533b\u751fid\u96c6\u5408\u67e5\u8be2\u533b\u751f\u590d\u8bca\u670d\u52a1\u72b6\u6001", notes="\u590d\u8bca\u670d\u52a1\u903b\u8f91\u4e0e\u5176\u4ed6\u670d\u52a1\u4e0d\u540c,\u5355\u72ec\u5b9e\u73b0")
    @GetMapping(value={"/getDocReExaminationStatusByIds"})
    public BaseResponse<List<DocWorkServiceVo>> getDocReExaminationServiceStatus(@RequestParam(value="doctorIds") List<Long> doctorIds, @RequestParam(value="organId") Long organId) {
        return this.doctorWorkInfoService.getDocReExaminationServiceStatus(doctorIds, organId);
    }

    @ApiOperation(value="\u6839\u636e\u533b\u751fid\u96c6\u5408\u66f4\u65b0\u533b\u751f\u590d\u8bca\u670d\u52a1\u4fe1\u606f", notes="\u590d\u8bca\u670d\u52a1\u903b\u8f91\u4e0e\u5176\u4ed6\u670d\u52a1\u4e0d\u540c,\u5355\u72ec\u5b9e\u73b0")
    @PostMapping(value={"/setDocReExaminationStatusByIds"})
    public BaseResponse setDocReExaminationServiceInfo(@RequestBody BatchSetDocServiceReqVO batchSetDocServiceReqVO) {
        return this.doctorWorkInfoService.setDocReExaminationServiceInfo(batchSetDocServiceReqVO);
    }

    @PostMapping(value={"/batchSetDocService"})
    @ApiOperation(value="\u6279\u91cf\u8bbe\u7f6e\u533b\u751f\u670d\u52a1")
    public BaseResponse batchSetDocService(@RequestBody BatchSetDoctorServiceInfoReq batchSetDoctorServiceInfoReq) {
        if (batchSetDoctorServiceInfoReq.getDoctorWorkIds().isEmpty()) {
            return BaseResponse.error((IError)EHErrorEnum.DATA_NOT_EXIST);
        }
        return this.doctorWorkInfoService.batchSetDocService(batchSetDoctorServiceInfoReq);
    }

    @PostMapping(value={"/getEnterGroup"})
    @ApiOperation(value="\u662f\u5426\u8fdb\u5165\u7fa4\u804a\u8fdb\uff0c1\uff1a\u5f00\u542f\uff1b0\uff1a\u5173\u95ed")
    public BaseResponse<JKGLServiceBo> getEnterGroup(@RequestBody EnterGroupVO enterGroupVO) {
        return this.doctorWorkInfoService.getEnterGroup(enterGroupVO);
    }
}

