/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.doctor.basedata.api.vo.OrganManageDetailVo;
import com.doctor.basedata.api.vo.QueryHisDoctorScheduleVo;
import com.doctor.basedata.api.vo.ScheduleDoctorParamVo;
import com.doctor.basedata.api.vo.ScheduleDoctorResVo;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.doctoruser.api.pojo.base.dto.FeignQueryDocAndTeamInfoDTO;
import com.doctoruser.api.pojo.base.dto.basedata.ListDoctorReq;
import com.doctoruser.api.pojo.base.dto.doctor.DoctorIdBatch;
import com.doctoruser.api.pojo.base.dto.doctor.DoctorNameAndBaseInfo;
import com.doctoruser.api.pojo.base.dto.doctor.ImInfosReq;
import com.doctoruser.api.pojo.base.dto.doctor.QueryCodeInfoReq;
import com.doctoruser.api.pojo.base.dto.doctor.QueryDocBaseInfoDTO;
import com.doctoruser.api.pojo.base.dto.doctor.QueryDocDeviceIdReq;
import com.doctoruser.api.pojo.base.dto.doctor.QueryDoctorAndTeamInfoDTO;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.dto.verify.DocAllInfoDto;
import com.doctoruser.api.pojo.base.entity.DepartmentEntity;
import com.doctoruser.api.pojo.base.entity.DoctorEntity;
import com.doctoruser.api.pojo.base.query.BusinessDoctorPageQuery;
import com.doctoruser.api.pojo.base.query.DoctorInfoQuery;
import com.doctoruser.api.pojo.base.query.ExecutorInformationQuery;
import com.doctoruser.api.pojo.base.query.QueryDoctorImInformInfoReq;
import com.doctoruser.api.pojo.base.query.ZxmzDoctorPageQuery;
import com.doctoruser.api.pojo.base.vo.BaseDoctorInfoVo;
import com.doctoruser.api.pojo.base.vo.DocBaseInfoVo;
import com.doctoruser.api.pojo.base.vo.DoctorAllInfoVo;
import com.doctoruser.api.pojo.base.vo.DoctorIdVo;
import com.doctoruser.api.pojo.base.vo.DoctorImInformInfo;
import com.doctoruser.api.pojo.base.vo.DoctorInfoForBaseVo;
import com.doctoruser.api.pojo.base.vo.DoctorNameAndOrganNameRes;
import com.doctoruser.api.pojo.base.vo.DoctorNameInfoVo;
import com.doctoruser.api.pojo.base.vo.DoctorNameVo;
import com.doctoruser.api.pojo.base.vo.ExecutorInformationVO;
import com.doctoruser.api.pojo.base.vo.FeignQueryDocAndTeamInfoVo;
import com.doctoruser.api.pojo.base.vo.ImInfosRes;
import com.doctoruser.api.pojo.base.vo.QueryCodeInfoRes;
import com.doctoruser.api.pojo.base.vo.QueryDocDeviceIdRes;
import com.doctoruser.api.pojo.base.vo.basedata.DocInfoVO;
import com.doctoruser.api.pojo.base.vo.basedata.GuideBaseResponse;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorBasicInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorDetailsVO;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorQueryParam;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorQueryReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.base.vo.doctor.ShareCodeQueryReqVO;
import com.doctoruser.api.pojo.base.vo.doctor.ShareCodeQueryRespVO;
import com.doctoruser.api.pojo.vo.GuideDoctorInfoVo;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.doctoruser.doctor.mapper.DepartmentMapper;
import com.doctoruser.doctor.mapper.DictionaryMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.NewCommonMapper;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.pojo.dto.DoctorInfoDTO;
import com.doctoruser.doctor.pojo.entity.DictionaryEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesEntity;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.entity.OrganizationEntity;
import com.doctoruser.doctor.pojo.vo.DoctorAccount;
import com.doctoruser.doctor.pojo.vo.DoctorInfoVO;
import com.doctoruser.doctor.pojo.vo.OrganProfessionDoctorReqVo;
import com.doctoruser.doctor.pojo.vo.QueryDoctorParam;
import com.doctoruser.doctor.service.DoctorInfoService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class DoctorInfoServiceImpl
implements DoctorInfoService {
    private static final Logger log = LoggerFactory.getLogger(DoctorInfoServiceImpl.class);
    @Value(value="${domainName}")
    private String domainName;
    @Autowired
    private DoctorMapper doctorMapper;
    @Autowired
    private DocDoctorWorkplacesMapper doctorWorkplacesMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private DepartmentMapper departmentMapper;
    @Autowired
    private DictionaryMapper dictionaryMapper;
    @Value(value="${extranetDomain}")
    private String extranetDomain;
    @Autowired
    private NewCommonMapper newCommonMapper;

    public BaseResponse<DocBaseInfoVo> queryBaseInfoById(QueryDocBaseInfoDTO param) {
        DoctorInfoEntity doctorEntity = this.getByDoctorIdAndOrganId(param.getOrganId(), param.getDoctorId());
        if (Objects.nonNull(doctorEntity)) {
            DocBaseInfoVo docBaseInfoVo = new DocBaseInfoVo();
            docBaseInfoVo.setDepartment(doctorEntity.getHospitalDeptName());
            docBaseInfoVo.setDoctorId(String.valueOf(doctorEntity.getId()));
            docBaseInfoVo.setDoctorName(doctorEntity.getName());
            docBaseInfoVo.setPortrait(doctorEntity.getHeadPortrait());
            docBaseInfoVo.setTelephone(doctorEntity.getRegisterMobile());
            return BaseResponse.success((Object)docBaseInfoVo);
        }
        return BaseResponse.success();
    }

    public BaseResponse<QueryDocDeviceIdRes> queryDocDeviceId(QueryDocDeviceIdReq param) {
        return null;
    }

    public BaseResponse<List<ImInfosRes>> queryDoctorImInfos(ImInfosReq param) {
        List list = this.doctorMapper.queryDoctorImInfo(param);
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<FeignQueryDocAndTeamInfoVo> feignQueryDocAndTeamInfo(FeignQueryDocAndTeamInfoDTO dto) {
        List doctorInfoList = dto.getDoctorDTOs();
        List organIds = doctorInfoList.stream().map(item -> Long.valueOf(item.getOrganId())).distinct().collect(Collectors.toList());
        Map organMap = this.organizationMapper.getOrgansByIds(organIds);
        ArrayList<DoctorAllInfoVo> doctorList = new ArrayList<DoctorAllInfoVo>();
        for (DocAllInfoDto docAllInfoDto : doctorInfoList) {
            DoctorInfoEntity doctorEntity = this.getByDoctorIdAndOrganId(docAllInfoDto.getOrganId(), docAllInfoDto.getDoctorId());
            if (!Objects.nonNull(doctorEntity)) continue;
            DoctorAllInfoVo doctorAllInfoVo = new DoctorAllInfoVo();
            doctorAllInfoVo.setDeptName(doctorEntity.getHospitalDeptName());
            doctorAllInfoVo.setDoctorId(String.valueOf(doctorEntity.getId()));
            doctorAllInfoVo.setDoctorName(doctorEntity.getName());
            doctorAllInfoVo.setHospitalTitle(doctorEntity.getProfession());
            doctorAllInfoVo.setOrganId(String.valueOf(doctorEntity.getOrganId()));
            OrganizationEntity organizationEntity = (OrganizationEntity)organMap.get(doctorEntity.getOrganId());
            doctorAllInfoVo.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            doctorAllInfoVo.setPortrait(doctorEntity.getHeadPortrait());
            doctorAllInfoVo.setAppCode(Objects.isNull(organizationEntity) ? "" : organizationEntity.getAppCode());
            doctorList.add(doctorAllInfoVo);
        }
        FeignQueryDocAndTeamInfoVo feignQueryDocAndTeamInfoVo = new FeignQueryDocAndTeamInfoVo();
        feignQueryDocAndTeamInfoVo.setDoctorInfos(doctorList);
        return BaseResponse.success((Object)feignQueryDocAndTeamInfoVo);
    }

    private DoctorInfoEntity getByDoctorIdAndOrganId(String organId, String doctorId) {
        DocDoctorWorkplacesEntity doctorWorkplacesEntity = this.doctorWorkplacesMapper.getByDoctorIdAndOrganId(Long.valueOf(organId), Long.valueOf(doctorId), Integer.valueOf(1));
        if (Objects.nonNull(doctorWorkplacesEntity)) {
            QueryDoctorParam queryDoctorParam = new QueryDoctorParam();
            queryDoctorParam.setDoctorId(doctorWorkplacesEntity.getDoctorId());
            queryDoctorParam.setOrganId(doctorWorkplacesEntity.getOrganId());
            return this.doctorMapper.querySingleDoctor(queryDoctorParam);
        }
        return null;
    }

    public BaseResponse<List<DoctorNameAndBaseInfo>> queryDoctorNameBatch(DoctorIdBatch req) {
        List doctorIds = req.getDoctorIdList().stream().map(Long::valueOf).distinct().collect(Collectors.toList());
        List doctorList = this.doctorMapper.getDoctorListByIds(doctorIds);
        List batchDoctorInfo = doctorList.stream().map(item -> {
            DoctorNameAndBaseInfo doctorNameAndBaseInfo = new DoctorNameAndBaseInfo();
            doctorNameAndBaseInfo.setDoctorId(String.valueOf(item.getId()));
            doctorNameAndBaseInfo.setDoctorName(item.getName());
            return doctorNameAndBaseInfo;
        }).collect(Collectors.toList());
        return BaseResponse.success(batchDoctorInfo);
    }

    public BaseResponse<List<DoctorInfoForBaseVo>> findDoctorOrTeamInfo(List<QueryDoctorAndTeamInfoDTO> param) {
        HashMap doctorIdsPart = param.stream().collect(Collectors.groupingBy(QueryDoctorAndTeamInfoDTO::getDoctorType, HashMap::new, Collectors.mapping(item -> Long.valueOf(item.getDoctorId()), Collectors.toList())));
        List personalIds = (List)doctorIdsPart.get(DoctorTypeEnum.PERSONAL.getValue());
        List doctorList = this.doctorMapper.getDoctorListByIds(personalIds);
        List organIds = doctorList.stream().map(DoctorInfoEntity::getOrganId).distinct().map(Long::valueOf).collect(Collectors.toList());
        Map organInfoMap = this.organizationMapper.getOrgansByIds(organIds);
        ArrayList<DoctorInfoForBaseVo> resultList = new ArrayList<DoctorInfoForBaseVo>();
        for (DoctorInfoEntity doctorInfoEntity : doctorList) {
            DoctorInfoForBaseVo doctorInfoForBaseVo = new DoctorInfoForBaseVo();
            doctorInfoForBaseVo.setDeptName(doctorInfoEntity.getHospitalDeptName());
            doctorInfoForBaseVo.setDoctorId(String.valueOf(doctorInfoEntity.getId()));
            doctorInfoForBaseVo.setDoctorName(doctorInfoEntity.getName());
            doctorInfoForBaseVo.setDoctorType(doctorInfoEntity.getDoctorType());
            doctorInfoForBaseVo.setHospitalTitle(doctorInfoEntity.getProfession());
            doctorInfoForBaseVo.setOrganId(String.valueOf(doctorInfoEntity.getOrganId()));
            doctorInfoForBaseVo.setPortrait(doctorInfoEntity.getHeadPortrait());
            OrganizationEntity organizationEntity = (OrganizationEntity)organInfoMap.get(doctorInfoEntity.getOrganId());
            doctorInfoForBaseVo.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            resultList.add(doctorInfoForBaseVo);
        }
        return BaseResponse.success(resultList);
    }

    public BaseResponse<DoctorAllInfoVo> findDoctorAllInfo(DocAllInfoDto param) {
        DoctorInfoEntity doctorInfoEntity = this.getByDoctorIdAndOrganId(param.getOrganId(), param.getDoctorId());
        if (Objects.nonNull(doctorInfoEntity)) {
            OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorInfoEntity.getOrganId());
            DoctorAllInfoVo doctorAllInfoVo = new DoctorAllInfoVo();
            doctorAllInfoVo.setDeptName(doctorInfoEntity.getStdSecondDeptName());
            doctorAllInfoVo.setPortrait(doctorInfoEntity.getHeadPortrait());
            doctorAllInfoVo.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            doctorAllInfoVo.setOrganId(String.valueOf(doctorInfoEntity.getOrganId()));
            doctorAllInfoVo.setOrganCode(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganCode());
            doctorAllInfoVo.setHospitalTitle(doctorInfoEntity.getProfession());
            doctorAllInfoVo.setDoctorId(String.valueOf(doctorInfoEntity.getId()));
            doctorAllInfoVo.setDoctorName(doctorInfoEntity.getName());
            return BaseResponse.success((Object)doctorAllInfoVo);
        }
        return BaseResponse.error((IError)IError.DATA_NOT_EXIST);
    }

    public BaseResponse<QueryCodeInfoRes> queryCodeInfo(QueryCodeInfoReq param) {
        DoctorInfoEntity doctorInfoEntity = this.getByDoctorIdAndOrganId(param.getOrganId(), param.getDoctorId());
        if (Objects.nonNull(doctorInfoEntity)) {
            DepartmentEntity docDepartmentEntity = this.departmentMapper.selectById(Long.valueOf(doctorInfoEntity.getHospitalDeptId().intValue()));
            OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorInfoEntity.getOrganId());
            QueryCodeInfoRes queryCodeInfo = new QueryCodeInfoRes();
            queryCodeInfo.setDeptCode(Objects.isNull(docDepartmentEntity) ? null : docDepartmentEntity.getDeptCode());
            queryCodeInfo.setOrganCode(Objects.isNull(organizationEntity) ? null : organizationEntity.getOrganCode());
            queryCodeInfo.setDoctorCode(String.valueOf(doctorInfoEntity.getId()));
            queryCodeInfo.setDoctorName(doctorInfoEntity.getName());
            return BaseResponse.success((Object)queryCodeInfo);
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<DoctorImInformInfo>> queryDoctorImInfo(QueryDoctorImInformInfoReq reqVo) {
        List doctorIds = reqVo.getDoctorIds().stream().map(Long::valueOf).collect(Collectors.toList());
        List doctorAccount = this.doctorMapper.getDoctorAccount(doctorIds);
        List doctorInfoList = this.doctorMapper.getDoctorListByIds(doctorIds);
        Map<Long, String> doctorAccountMap = doctorAccount.stream().collect(Collectors.toMap(DoctorAccount::getDoctorId, DoctorAccount::getAccountNo));
        Map<Long, String> doctorNameMap = doctorInfoList.stream().collect(Collectors.toMap(DoctorInfoEntity::getId, DoctorInfoEntity::getName));
        ArrayList<DoctorImInformInfo> accountInfoList = new ArrayList<DoctorImInformInfo>();
        for (String doctorId : reqVo.getDoctorIds()) {
            DoctorImInformInfo doctorImInformInfo = new DoctorImInformInfo();
            doctorImInformInfo.setDoctorId(doctorId);
            doctorImInformInfo.setAccount(doctorAccountMap.get(Long.valueOf(doctorId)));
            doctorImInformInfo.setName(doctorNameMap.get(Long.valueOf(doctorId)));
            accountInfoList.add(doctorImInformInfo);
        }
        return BaseResponse.success(accountInfoList);
    }

    public BaseResponse<DoctorNameInfoVo> selectDoctorNameByPhone(String phoneNum) {
        DoctorInfoEntity doctorInfoEntity = this.doctorMapper.getDoctorByPhone(phoneNum, Integer.valueOf(1));
        DoctorNameInfoVo doctorNameInfoVo = new DoctorNameInfoVo();
        doctorNameInfoVo.setDoctorName(doctorInfoEntity.getName());
        doctorNameInfoVo.setPortrait(doctorInfoEntity.getHeadPortrait());
        return BaseResponse.success((Object)doctorNameInfoVo);
    }

    public BaseResponse<DoctorNameAndOrganNameRes> queryDoctorInfoForBank(DoctorIdVo param) {
        DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)((Object)param.getDoctorId()));
        if (Objects.nonNull(doctorInfoEntity)) {
            DoctorNameAndOrganNameRes doctorNameAndOrganName = new DoctorNameAndOrganNameRes();
            doctorNameAndOrganName.setDoctorName(doctorInfoEntity.getName());
            OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorInfoEntity.getOrganId());
            doctorNameAndOrganName.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            return BaseResponse.success((Object)doctorNameAndOrganName);
        }
        return BaseResponse.success();
    }

    public BaseResponse<PageResult<DocInfoVO>> listBaseData(ListDoctorReq param) {
        Page page = new Page();
        page.setCurrent((long)param.getPageNum().intValue());
        page.setSize((long)param.getPageSize().intValue());
        param.setStatus(Integer.valueOf(1));
        IPage doctorPage = this.doctorMapper.listBaseData(page, param);
        List records = doctorPage.getRecords();
        List organIds = records.stream().map(DoctorInfoEntity::getOrganId).map(Long::valueOf).collect(Collectors.toList());
        Map organMap = this.organizationMapper.getOrgansByIds(organIds);
        ArrayList<DocInfoVO> result = new ArrayList<DocInfoVO>();
        for (DoctorInfoEntity record : records) {
            DocInfoVO docInfoVO = new DocInfoVO();
            docInfoVO.setCertificateNum(record.getCredNo());
            docInfoVO.setDeptCode(String.valueOf(record.getHospitalDeptId()));
            docInfoVO.setDeptName(record.getHospitalDeptName());
            docInfoVO.setDoctorCode(String.valueOf(record.getId()));
            docInfoVO.setDoctorName(record.getName());
            docInfoVO.setEmail(record.getEmail());
            docInfoVO.setGender(record.getGender().equals(0) ? "\u7537" : "\u5973");
            docInfoVO.setIntroduction(record.getProfile());
            docInfoVO.setOrganCode(String.valueOf(record.getId()));
            OrganizationEntity organizationEntity = (OrganizationEntity)organMap.get(record.getOrganId());
            docInfoVO.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            docInfoVO.setPortrait(record.getHeadPortrait());
            docInfoVO.setProfession(record.getSpeciality());
            docInfoVO.setTelephone(record.getRegisterMobile());
            result.add(docInfoVO);
        }
        PageResult pageResult = new PageResult();
        pageResult.setContent(result);
        pageResult.setPageNum(param.getPageNum().intValue());
        pageResult.setPageSize(param.getPageSize().intValue());
        pageResult.setTotal((int)doctorPage.getTotal());
        pageResult.setTotalPages((int)doctorPage.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<DoctorDetailsVO> queryDocBaseDataInOrgan(String doctorId, String organId) {
        DoctorInfoEntity doctorInfoEntity = this.getByDoctorIdAndOrganId(organId, doctorId);
        if (Objects.nonNull(doctorInfoEntity)) {
            DoctorDetailsVO doctorDetailsVO = new DoctorDetailsVO();
            doctorDetailsVO.setDeptId(doctorInfoEntity.getHospitalDeptId());
            doctorDetailsVO.setDeptName(doctorInfoEntity.getHospitalDeptName());
            doctorDetailsVO.setDoctorCode(String.valueOf(doctorInfoEntity.getId()));
            doctorDetailsVO.setDoctorId(Integer.valueOf(doctorInfoEntity.getId().intValue()));
            doctorDetailsVO.setDoctorName(doctorInfoEntity.getName());
            doctorDetailsVO.setGender(Integer.valueOf(Objects.isNull(doctorInfoEntity.getGender()) ? 0 : doctorInfoEntity.getGender()));
            doctorDetailsVO.setIntroduction(doctorInfoEntity.getProfile());
            doctorDetailsVO.setOrganId(doctorInfoEntity.getOrganId());
            OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorInfoEntity.getOrganId());
            doctorDetailsVO.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            doctorDetailsVO.setPhoneNum(doctorInfoEntity.getRegisterMobile());
            doctorDetailsVO.setPortrait(doctorInfoEntity.getHeadPortrait());
            doctorDetailsVO.setProfession(doctorInfoEntity.getSpeciality());
            doctorDetailsVO.setStdSecondDeptId(Long.valueOf(doctorInfoEntity.getStdSecondDeptId().longValue()));
            doctorDetailsVO.setTitle(doctorInfoEntity.getProfession());
            doctorDetailsVO.setTitleId(Long.valueOf(doctorInfoEntity.getProfessionCode()));
            return BaseResponse.success((Object)doctorDetailsVO);
        }
        return BaseResponse.success();
    }

    public BaseResponse<ShareCodeQueryRespVO> queryShareCode(ShareCodeQueryReqVO reqVO) {
        if (StringUtils.isEmpty((CharSequence)reqVO.getDoctorId())) {
            ShareCodeQueryRespVO shareCodeQueryRespVO = new ShareCodeQueryRespVO();
            shareCodeQueryRespVO.setShareCode("");
            return BaseResponse.success((Object)shareCodeQueryRespVO);
        }
        DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)((Object)reqVO.getDoctorId()));
        if (Objects.isNull(doctorInfoEntity)) {
            log.error("=====\u533b\u751f[{}],\u4fe1\u606f\u4e0d\u5b58\u5728=====", (Object)reqVO.getDoctorId());
            return BaseResponse.error((IError)IError.DATA_ERROR);
        }
        OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorInfoEntity.getOrganId());
        if (Objects.isNull(organizationEntity) || StringUtils.isEmpty((CharSequence)organizationEntity.getAppCode())) {
            log.error("=====\u533b\u751f\u6267\u4e1a\u5e73\u53f0[{}],\u4fe1\u606f\u4e0d\u5b58\u5728=====", (Object)doctorInfoEntity.getOrganId());
            return BaseResponse.error((IError)IError.DATA_ERROR);
        }
        String qrCode = this.extranetDomain + "qrcode/" + organizationEntity.getAppCode() + "?doctorId=" + doctorInfoEntity.getId() + "&appCode=" + organizationEntity.getAppCode() + "&organId=" + organizationEntity.getId() + "&businessCode=attention";
        ShareCodeQueryRespVO shareCodeQueryRespVO = new ShareCodeQueryRespVO();
        shareCodeQueryRespVO.setShareCode(qrCode);
        return BaseResponse.success((Object)shareCodeQueryRespVO);
    }

    public BaseResponse<PersonnelInfo> queryPersonnelInfo(QueryPersonnelInfoReq param) {
        DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)((Object)param.getDoctorId()));
        if (Objects.nonNull(doctorInfoEntity)) {
            PersonnelInfo personnelInfo = new PersonnelInfo();
            personnelInfo.setDoctorId(String.valueOf(doctorInfoEntity.getId()));
            personnelInfo.setDoctorName(doctorInfoEntity.getName());
            personnelInfo.setPortrait(doctorInfoEntity.getHeadPortrait());
            personnelInfo.setTitle(doctorInfoEntity.getProfession());
            personnelInfo.setTitleId(Long.valueOf(doctorInfoEntity.getProfessionCode()));
            DictionaryEntity profession = this.dictionaryMapper.findByDicCodeAndTypeCode(doctorInfoEntity.getProfessionCode(), "100");
            if (Objects.nonNull(profession)) {
                personnelInfo.setTitle(profession.getDicName());
                personnelInfo.setTitleEnglishName(profession.getRemark());
            }
            personnelInfo.setOrganId(doctorInfoEntity.getOrganId());
            personnelInfo.setDeptId(doctorInfoEntity.getHospitalDeptId());
            personnelInfo.setDeptName(doctorInfoEntity.getHospitalDeptName());
            DepartmentEntity department = this.departmentMapper.selectById(Long.valueOf(doctorInfoEntity.getHospitalDeptId().intValue()));
            if (Objects.nonNull(department)) {
                personnelInfo.setDeptName(department.getDeptName());
                personnelInfo.setDeptEnglishName(department.getEnglishName());
            }
            personnelInfo.setStdSecondDeptId(Long.valueOf(doctorInfoEntity.getStdSecondDeptId().intValue()));
            personnelInfo.setPhoneNum(doctorInfoEntity.getContactMobile());
            personnelInfo.setGender(doctorInfoEntity.getGender());
            personnelInfo.setProfession(doctorInfoEntity.getSpeciality());
            personnelInfo.setIntroduction(doctorInfoEntity.getProfile());
            personnelInfo.setEmplCode(doctorInfoEntity.getEmplCode());
            OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorInfoEntity.getOrganId());
            personnelInfo.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            return BaseResponse.success((Object)personnelInfo);
        }
        return BaseResponse.success();
    }

    public BaseResponse<PageResult<DoctorDetailsVO>> queryDocBaseDataList(DoctorQueryParam param) {
        return null;
    }

    public BaseResponse<DoctorBaseInfoDTO> getDoctorInfo(Long doctorId, String organId) {
        DoctorInfoEntity doctorInfoEntity = this.getByDoctorIdAndOrganId(organId, String.valueOf(doctorId));
        if (Objects.nonNull(doctorInfoEntity)) {
            DoctorBaseInfoDTO doctorBaseInfoDTO = new DoctorBaseInfoDTO();
            doctorBaseInfoDTO.setCountry("0");
            doctorBaseInfoDTO.setDeptId(Long.valueOf(doctorInfoEntity.getHospitalDeptId().intValue()));
            doctorBaseInfoDTO.setDeptName(doctorInfoEntity.getHospitalDeptName());
            doctorBaseInfoDTO.setDoctorCode(String.valueOf(doctorInfoEntity.getId()));
            doctorBaseInfoDTO.setDoctorName(doctorInfoEntity.getName());
            doctorBaseInfoDTO.setEmail(doctorInfoEntity.getEmail());
            doctorBaseInfoDTO.setGender(Objects.isNull(doctorInfoEntity.getGender()) ? 0 : doctorInfoEntity.getGender());
            doctorBaseInfoDTO.setFirstWord("");
            doctorBaseInfoDTO.setIntroduction(doctorInfoEntity.getProfile());
            doctorBaseInfoDTO.setOrganId(Long.valueOf(doctorInfoEntity.getOrganId().intValue()));
            OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorInfoEntity.getOrganId());
            doctorBaseInfoDTO.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            doctorBaseInfoDTO.setPortrait(doctorInfoEntity.getHeadPortrait());
            doctorBaseInfoDTO.setProfession(doctorInfoEntity.getSpeciality());
            Integer stdFirstDeptId = doctorInfoEntity.getStdFirstDeptId();
            doctorBaseInfoDTO.setStdFirstDeptId(Objects.isNull(stdFirstDeptId) ? null : Long.valueOf(stdFirstDeptId.intValue()));
            Integer stdSecondDeptId = doctorInfoEntity.getStdSecondDeptId();
            doctorBaseInfoDTO.setStdSecondDeptId(Objects.isNull(stdSecondDeptId) ? null : Long.valueOf(stdSecondDeptId.intValue()));
            doctorBaseInfoDTO.setTelphone(doctorInfoEntity.getRegisterMobile());
            doctorBaseInfoDTO.setTitleName(doctorInfoEntity.getProfession());
            doctorBaseInfoDTO.setXId(doctorInfoEntity.getId());
            doctorBaseInfoDTO.setDoctorType(doctorInfoEntity.getDoctorType());
            return BaseResponse.success((Object)doctorBaseInfoDTO);
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<DoctorBaseInfoDTO>> getDoctorInfoList(List<Long> doctorIdList, String organId) {
        List doctorInfoEntityList = this.doctorMapper.getDoctorInfoList(doctorIdList, organId, Integer.valueOf(1));
        OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)((Object)organId));
        ArrayList<DoctorBaseInfoDTO> resultList = new ArrayList<DoctorBaseInfoDTO>();
        for (DoctorInfoEntity doctorInfoEntity : doctorInfoEntityList) {
            DoctorBaseInfoDTO doctorBaseInfoDTO = new DoctorBaseInfoDTO();
            doctorBaseInfoDTO.setCountry("0");
            doctorBaseInfoDTO.setDeptId(Long.valueOf(doctorInfoEntity.getHospitalDeptId().intValue()));
            doctorBaseInfoDTO.setDeptName(doctorInfoEntity.getHospitalDeptName());
            doctorBaseInfoDTO.setDoctorCode(String.valueOf(doctorInfoEntity.getId()));
            doctorBaseInfoDTO.setDoctorName(doctorInfoEntity.getName());
            doctorBaseInfoDTO.setEmail(doctorInfoEntity.getEmail());
            doctorBaseInfoDTO.setGender(Objects.isNull(doctorInfoEntity.getGender()) ? 0 : doctorInfoEntity.getGender());
            doctorBaseInfoDTO.setFirstWord("");
            doctorBaseInfoDTO.setIntroduction(doctorInfoEntity.getProfile());
            doctorBaseInfoDTO.setOrganId(Long.valueOf(doctorInfoEntity.getOrganId().intValue()));
            doctorBaseInfoDTO.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            doctorBaseInfoDTO.setPortrait(doctorInfoEntity.getHeadPortrait());
            doctorBaseInfoDTO.setProfession(doctorInfoEntity.getSpeciality());
            Integer stdFirstDeptId = doctorInfoEntity.getStdFirstDeptId();
            doctorBaseInfoDTO.setStdFirstDeptId(Objects.isNull(stdFirstDeptId) ? null : Long.valueOf(stdFirstDeptId.intValue()));
            Integer stdSecondDeptId = doctorInfoEntity.getStdSecondDeptId();
            doctorBaseInfoDTO.setStdSecondDeptId(Objects.isNull(stdSecondDeptId) ? null : Long.valueOf(stdSecondDeptId.intValue()));
            doctorBaseInfoDTO.setTelphone(doctorInfoEntity.getRegisterMobile());
            doctorBaseInfoDTO.setTitleName(doctorInfoEntity.getProfession());
            doctorBaseInfoDTO.setXId(doctorInfoEntity.getId());
            resultList.add(doctorBaseInfoDTO);
        }
        return BaseResponse.success(resultList);
    }

    public BaseResponse<PageResult<DoctorDetailsVO>> getDoctorBaseInfoPage(DoctorQueryReq doctorQueryReq) {
        Page page = new Page();
        page.setCurrent((long)doctorQueryReq.getPageNum().intValue());
        page.setSize((long)doctorQueryReq.getPageSize().intValue());
        doctorQueryReq.setStatus(Integer.valueOf(1));
        IPage doctorPage = this.doctorMapper.getDoctorBaseInfoPage(page, doctorQueryReq);
        List records = doctorPage.getRecords();
        List organIds = records.stream().map(DoctorInfoEntity::getOrganId).map(Long::valueOf).collect(Collectors.toList());
        Map organMap = this.organizationMapper.getOrgansByIds(organIds);
        ArrayList<DoctorDetailsVO> list = new ArrayList<DoctorDetailsVO>();
        for (DoctorInfoEntity doctorInfoEntity : records) {
            DoctorDetailsVO doctorDetailsVO = new DoctorDetailsVO();
            doctorDetailsVO.setDeptId(doctorInfoEntity.getHospitalDeptId());
            doctorDetailsVO.setDeptName(doctorInfoEntity.getHospitalDeptName());
            doctorDetailsVO.setDoctorCode(String.valueOf(doctorInfoEntity.getId()));
            doctorDetailsVO.setDoctorId(Integer.valueOf(doctorInfoEntity.getId().intValue()));
            doctorDetailsVO.setDoctorName(doctorInfoEntity.getName());
            doctorDetailsVO.setGender(Integer.valueOf(Objects.isNull(doctorInfoEntity.getGender()) ? 0 : doctorInfoEntity.getGender()));
            doctorDetailsVO.setIntroduction(doctorInfoEntity.getProfile());
            doctorDetailsVO.setOrganId(doctorInfoEntity.getOrganId());
            OrganizationEntity organizationEntity = (OrganizationEntity)organMap.get(doctorInfoEntity.getOrganId());
            doctorDetailsVO.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            doctorDetailsVO.setPhoneNum(doctorInfoEntity.getRegisterMobile());
            doctorDetailsVO.setPortrait(doctorInfoEntity.getHeadPortrait());
            doctorDetailsVO.setProfession(doctorInfoEntity.getSpeciality());
            doctorDetailsVO.setStdSecondDeptId(Long.valueOf(doctorInfoEntity.getStdSecondDeptId().longValue()));
            doctorDetailsVO.setTitle(doctorInfoEntity.getProfession());
            doctorDetailsVO.setTitleId(Long.valueOf(doctorInfoEntity.getProfessionCode()));
            list.add(doctorDetailsVO);
        }
        PageResult pageResult = new PageResult();
        pageResult.setContent(list);
        pageResult.setPageNum(doctorQueryReq.getPageNum().intValue());
        pageResult.setPageSize(doctorQueryReq.getPageSize().intValue());
        pageResult.setTotal((int)doctorPage.getTotal());
        pageResult.setTotalPages((int)doctorPage.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<String> queryDoctorIds(Long organId, String doctorName) {
        List list = this.doctorMapper.queryDoctorIds(organId, doctorName, Integer.valueOf(1));
        String ids = list.stream().map(doctor -> String.valueOf(doctor.getId())).collect(Collectors.joining(","));
        return BaseResponse.success((Object)ids);
    }

    public BaseResponse<List<DoctorEntity>> getDepartmentDoctor(Long organId, Long deptId, String serviceCode) {
        List doctorList = this.doctorMapper.getDepartmentDoctor(organId, deptId, serviceCode, Integer.valueOf(1));
        ArrayList<DoctorEntity> resultList = new ArrayList<DoctorEntity>();
        OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)organId);
        for (DoctorInfoEntity doctorInfoEntity : doctorList) {
            DoctorEntity doctorEntity = new DoctorEntity();
            doctorEntity.setCredentialsNo(doctorInfoEntity.getCredNo());
            doctorEntity.setCredentialsType(doctorInfoEntity.getCredType());
            doctorEntity.setCountry("0");
            doctorEntity.setDeptId(String.valueOf(doctorInfoEntity.getHospitalDeptId()));
            doctorEntity.setDoctorCode(String.valueOf(doctorInfoEntity.getId()));
            doctorEntity.setDoctorName(doctorInfoEntity.getName());
            doctorEntity.setPortrait(doctorInfoEntity.getHeadPortrait());
            doctorEntity.setEmail(doctorInfoEntity.getEmail());
            doctorEntity.setGender(Integer.valueOf(Objects.isNull(doctorInfoEntity.getGender()) ? 0 : doctorInfoEntity.getGender()));
            doctorEntity.setHospitalTitleId(doctorInfoEntity.getProfessionCode());
            doctorEntity.setIntroduction(doctorInfoEntity.getProfile());
            doctorEntity.setProfession(doctorInfoEntity.getSpeciality());
            doctorEntity.setStandardTitleId(doctorInfoEntity.getProfessionCode());
            doctorEntity.setStandardTitle(doctorInfoEntity.getProfession());
            doctorEntity.setTelphone(doctorInfoEntity.getRegisterMobile());
            doctorEntity.setOrganId(String.valueOf(organId));
            doctorEntity.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            doctorEntity.setxId(String.valueOf(doctorInfoEntity.getId()));
            resultList.add(doctorEntity);
        }
        return BaseResponse.success(resultList);
    }

    public BaseResponse<DoctorAllInfoVo> getSingleDoctorInfo(Long doctorId, Long organId) {
        DoctorInfoEntity doctorInfoEntity = this.getByDoctorIdAndOrganId(String.valueOf(organId), String.valueOf(doctorId));
        if (Objects.nonNull(doctorInfoEntity)) {
            DoctorAllInfoVo doctorAllInfoVo = new DoctorAllInfoVo();
            doctorAllInfoVo.setDoctorName(doctorInfoEntity.getName());
            doctorAllInfoVo.setDoctorId(String.valueOf(doctorInfoEntity.getId()));
            doctorAllInfoVo.setHospitalTitle(doctorInfoEntity.getProfession());
            OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorInfoEntity.getOrganId());
            doctorAllInfoVo.setOrganName(organizationEntity.getOrganName());
            doctorAllInfoVo.setOrganCode(organizationEntity.getOrganCode());
            doctorAllInfoVo.setOrganId(String.valueOf(doctorInfoEntity.getOrganId()));
            doctorAllInfoVo.setPortrait(doctorInfoEntity.getHeadPortrait());
            doctorAllInfoVo.setDeptName(doctorInfoEntity.getHospitalDeptName());
            return BaseResponse.success((Object)doctorAllInfoVo);
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<DoctorNameVo>> getOpenServiceDoctor(List<Long> hospitalIds, String serviceCode) {
        ArrayList<DoctorNameVo> list = new ArrayList<DoctorNameVo>();
        if (hospitalIds.isEmpty()) {
            return BaseResponse.success(list);
        }
        String idsStr = hospitalIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        DoctorQueryReq doctorQueryReq = new DoctorQueryReq();
        doctorQueryReq.setOrganId(idsStr);
        if (StringUtils.isNotEmpty((CharSequence)serviceCode)) {
            List<String> serviceCodes = Arrays.asList(serviceCode.split(","));
            String serviceCodeStr = serviceCodes.stream().collect(Collectors.joining("','", "'", "'"));
            doctorQueryReq.setServiceCode(serviceCodeStr);
        }
        doctorQueryReq.setStatus(Integer.valueOf(1));
        List doctorList = this.doctorMapper.getOpenServiceDoctor(doctorQueryReq);
        for (DoctorInfoEntity doctorInfoEntity : doctorList) {
            DoctorNameVo doctorNameVo = new DoctorNameVo();
            doctorNameVo.setDoctorId(doctorInfoEntity.getId());
            doctorNameVo.setDoctorName(doctorInfoEntity.getName());
            doctorNameVo.setOrganId(Long.valueOf(doctorInfoEntity.getOrganId().intValue()));
            doctorNameVo.setStatus(doctorInfoEntity.getStatus());
            list.add(doctorNameVo);
        }
        return BaseResponse.success(list);
    }

    public BaseResponse<List<BaseDoctorInfoVo>> getStdDeptAndServiceOpenDoctor(String appCode, Long stdDeptId, String serviceCode) {
        List doctorList;
        List organIds;
        DoctorQueryReq doctorQueryReq = new DoctorQueryReq();
        doctorQueryReq.setAppCode(appCode);
        doctorQueryReq.setStdDeptId(String.valueOf(stdDeptId));
        doctorQueryReq.setStatus(Integer.valueOf(1));
        if (StringUtils.isNotEmpty((CharSequence)serviceCode)) {
            List<String> serviceCodes = Arrays.asList(serviceCode.split(","));
            String serviceCodeStr = serviceCodes.stream().collect(Collectors.joining("','", "'", "'"));
            doctorQueryReq.setServiceCode(serviceCodeStr);
        }
        if ((organIds = (doctorList = this.doctorMapper.getOpenServiceDoctor(doctorQueryReq)).stream().map(DoctorInfoEntity::getOrganId).map(Long::valueOf).collect(Collectors.toList())).isEmpty()) {
            return BaseResponse.success();
        }
        Map organMap = this.organizationMapper.getOrgansByIds(organIds);
        ArrayList<BaseDoctorInfoVo> resultList = new ArrayList<BaseDoctorInfoVo>();
        for (DoctorInfoEntity doctorInfoEntity : doctorList) {
            BaseDoctorInfoVo baseDoctorInfoVo = new BaseDoctorInfoVo();
            baseDoctorInfoVo.setAccount(doctorInfoEntity.getRegisterMobile());
            baseDoctorInfoVo.setDeptName(doctorInfoEntity.getHospitalDeptName());
            baseDoctorInfoVo.setDoctorId(doctorInfoEntity.getId());
            baseDoctorInfoVo.setDoctorName(doctorInfoEntity.getName());
            OrganizationEntity organizationEntity = (OrganizationEntity)organMap.get(doctorInfoEntity.getOrganId());
            baseDoctorInfoVo.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            baseDoctorInfoVo.setStandardTitle(doctorInfoEntity.getProfession());
            baseDoctorInfoVo.setStatus(doctorInfoEntity.getStatus().intValue());
            resultList.add(baseDoctorInfoVo);
        }
        return BaseResponse.success(resultList);
    }

    public BaseResponse<PageResult<ExecutorInformationVO>> getDoctorAndDepartmentByDoctorName(ExecutorInformationQuery param) {
        Page page = new Page();
        page.setCurrent((long)param.getPageNum().intValue());
        page.setSize((long)param.getPageSize().intValue());
        ArrayList<ExecutorInformationVO> resultList = new ArrayList<ExecutorInformationVO>();
        DoctorInfoQuery doctorInfoQuery = new DoctorInfoQuery();
        doctorInfoQuery.setAppCode(param.getAppCode());
        doctorInfoQuery.setDoctorName(param.getDoctorName());
        doctorInfoQuery.setStatus(1);
        doctorInfoQuery.setOrganDeptId(param.getOrganDeptId());
        doctorInfoQuery.setSearchParam(param.getDoctorName());
        doctorInfoQuery.setStandardTitleId(param.getStandardTitleId());
        doctorInfoQuery.setStdDeptId(param.getStdDeptId());
        IPage doctorPage = this.doctorMapper.getDoctorSelective(page, doctorInfoQuery);
        List records = doctorPage.getRecords();
        List organIds = records.stream().map(DoctorInfoEntity::getOrganId).map(Long::valueOf).collect(Collectors.toList());
        Map organsMap = this.organizationMapper.getOrgansByIds(organIds);
        for (DoctorInfoEntity doctorInfo : records) {
            ExecutorInformationVO executorInformationVO = new ExecutorInformationVO();
            executorInformationVO.setDoctorCode(String.valueOf(doctorInfo.getId()));
            executorInformationVO.setDoctorId(String.valueOf(doctorInfo.getId()));
            executorInformationVO.setDoctorImageUrl(doctorInfo.getHeadPortrait());
            executorInformationVO.setDoctorName(doctorInfo.getName());
            executorInformationVO.setDoctorTitle(doctorInfo.getProfession());
            executorInformationVO.setFirstDeptId(doctorInfo.getStdFirstDeptName());
            executorInformationVO.setHospitalDeptId(String.valueOf(doctorInfo.getHospitalDeptId()));
            executorInformationVO.setHospitalDeptName(doctorInfo.getHospitalDeptName());
            executorInformationVO.setHospitalId(String.valueOf(doctorInfo.getOrganId()));
            executorInformationVO.setSecondDeptId(String.valueOf(doctorInfo.getStdSecondDeptId()));
            OrganizationEntity organizationEntity = (OrganizationEntity)organsMap.get(doctorInfo.getOrganId());
            executorInformationVO.setHospitalName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            resultList.add(executorInformationVO);
        }
        PageResult pageResult = new PageResult();
        pageResult.setContent(resultList);
        pageResult.setPageNum(param.getPageNum().intValue());
        pageResult.setPageSize(param.getPageSize().intValue());
        pageResult.setTotal((int)doctorPage.getTotal());
        pageResult.setTotalPages((int)doctorPage.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<PageResult<DoctorBasicInfoVo>> getOrganDoctorPage(DoctorInfoQuery doctorInfoQuery) {
        Page page = new Page();
        page.setCurrent((long)doctorInfoQuery.getPageNum());
        page.setSize((long)doctorInfoQuery.getPageSize());
        doctorInfoQuery.setStatus(1);
        IPage doctorPage = this.doctorMapper.getDoctorSelective(page, doctorInfoQuery);
        List records = doctorPage.getRecords();
        List organIds = records.stream().map(DoctorInfoEntity::getOrganId).map(Long::valueOf).collect(Collectors.toList());
        Map organsMap = new HashMap();
        if (!organIds.isEmpty()) {
            organsMap = this.organizationMapper.getOrgansByIds(organIds);
        }
        ArrayList<DoctorBasicInfoVo> resultList = new ArrayList<DoctorBasicInfoVo>();
        for (DoctorInfoEntity record : records) {
            DoctorBasicInfoVo doctorBasicInfoVo = new DoctorBasicInfoVo();
            doctorBasicInfoVo.setCountry("0");
            doctorBasicInfoVo.setDeptName(record.getHospitalDeptName());
            doctorBasicInfoVo.setDeptId(Long.valueOf(record.getHospitalDeptId().intValue()));
            doctorBasicInfoVo.setDoctorCode(String.valueOf(record.getId()));
            doctorBasicInfoVo.setDoctorName(record.getName());
            doctorBasicInfoVo.setEmail(record.getEmail());
            doctorBasicInfoVo.setGender(record.getGender());
            doctorBasicInfoVo.setIntroduction(record.getProfile());
            doctorBasicInfoVo.setOrganId(Long.valueOf(record.getOrganId().intValue()));
            OrganizationEntity organizationEntity = (OrganizationEntity)organsMap.get(record.getOrganId());
            doctorBasicInfoVo.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            doctorBasicInfoVo.setPortrait(record.getHeadPortrait());
            doctorBasicInfoVo.setProfession(record.getSpeciality());
            doctorBasicInfoVo.setStandardTitle(record.getProfession());
            doctorBasicInfoVo.setTelephone(record.getRegisterMobile());
            doctorBasicInfoVo.setXId(record.getId());
            resultList.add(doctorBasicInfoVo);
        }
        PageResult pageResult = new PageResult();
        pageResult.setContent(resultList);
        pageResult.setPageNum(doctorInfoQuery.getPageNum());
        pageResult.setPageSize(doctorInfoQuery.getPageSize());
        pageResult.setTotal((int)doctorPage.getTotal());
        pageResult.setTotalPages((int)doctorPage.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<PageResult<DoctorBasicInfoVo>> getBusinessDoctorPage(BusinessDoctorPageQuery businessDoctorPageQuery) {
        Page page = new Page();
        page.setCurrent((long)businessDoctorPageQuery.getPageNum());
        page.setSize((long)businessDoctorPageQuery.getPageSize());
        businessDoctorPageQuery.setStatus(1);
        log.info("\u67e5\u8be2\u670d\u52a1\u533b\u751f\u5217\u8868\u5165\u53c2:[{}]", (Object)JSON.toJSONString((Object)businessDoctorPageQuery));
        IPage info = this.doctorMapper.getBusinessDoctorPage(page, businessDoctorPageQuery);
        List records = info.getRecords();
        log.info("\u67e5\u8be2\u670d\u52a1\u533b\u751f\u5217\u8868\u7ed3\u679c:[{}]", (Object)JSON.toJSONString((Object)records));
        List organIds = records.stream().map(DoctorInfoEntity::getOrganId).map(Long::valueOf).collect(Collectors.toList());
        Map organsMap = new HashMap();
        if (!organIds.isEmpty()) {
            organsMap = this.organizationMapper.getOrgansByIds(organIds);
        }
        ArrayList<DoctorBasicInfoVo> resultList = new ArrayList<DoctorBasicInfoVo>();
        for (DoctorInfoEntity record : records) {
            DepartmentEntity department;
            DoctorBasicInfoVo doctorBasicInfoVo = new DoctorBasicInfoVo();
            doctorBasicInfoVo.setCountry("0");
            doctorBasicInfoVo.setDeptName(record.getHospitalDeptName());
            if (Objects.nonNull(record.getHospitalDeptId()) && Objects.nonNull(department = this.departmentMapper.selectById(Long.valueOf(record.getHospitalDeptId().intValue())))) {
                doctorBasicInfoVo.setDeptId(Long.valueOf(department.getxId()));
                doctorBasicInfoVo.setDeptName(department.getDeptName());
                doctorBasicInfoVo.setDeptEnglishName(department.getEnglishName());
            }
            doctorBasicInfoVo.setDoctorCode(String.valueOf(record.getId()));
            doctorBasicInfoVo.setDoctorName(record.getName());
            doctorBasicInfoVo.setEmail(record.getEmail());
            doctorBasicInfoVo.setGender(record.getGender());
            doctorBasicInfoVo.setIntroduction(record.getProfile());
            doctorBasicInfoVo.setOrganId(Long.valueOf(record.getOrganId().intValue()));
            OrganizationEntity organizationEntity = (OrganizationEntity)organsMap.get(record.getOrganId());
            doctorBasicInfoVo.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            doctorBasicInfoVo.setPortrait(record.getHeadPortrait());
            doctorBasicInfoVo.setStandardTitle(record.getProfession());
            String professionCode = record.getProfessionCode();
            DictionaryEntity profession = this.dictionaryMapper.findByDicCodeAndTypeCode(professionCode, "100");
            if (Objects.nonNull(profession)) {
                doctorBasicInfoVo.setStandardTitle(profession.getDicName());
                doctorBasicInfoVo.setTitleEnglishName(profession.getRemark());
            }
            doctorBasicInfoVo.setProfession(record.getSpeciality());
            doctorBasicInfoVo.setTelephone(record.getRegisterMobile());
            doctorBasicInfoVo.setXId(record.getId());
            resultList.add(doctorBasicInfoVo);
        }
        PageResult pageResult = new PageResult();
        pageResult.setContent(resultList);
        pageResult.setPageNum(businessDoctorPageQuery.getPageNum());
        pageResult.setPageSize(businessDoctorPageQuery.getPageSize());
        pageResult.setTotal((int)info.getTotal());
        pageResult.setTotalPages((int)info.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<List<BaseDoctorInfoVo>> getOrganProfessionDoctor(OrganProfessionDoctorReqVo reqVo) {
        List resultList = new ArrayList();
        if (!reqVo.getOrganIds().isEmpty()) {
            resultList = this.doctorMapper.getOrganProfessionDoctor(reqVo);
        }
        return BaseResponse.success(resultList);
    }

    public BaseResponse<PageResult<DoctorBasicInfoVo>> queryDoctorZxmz(ZxmzDoctorPageQuery zxmzDoctorPageQuery) {
        this.setServiceCode(zxmzDoctorPageQuery);
        Page page = new Page();
        page.setCurrent((long)zxmzDoctorPageQuery.getPageNum());
        page.setSize((long)zxmzDoctorPageQuery.getPageSize());
        zxmzDoctorPageQuery.setStatus(1);
        log.info("\u4e2d\u65e5\u5728\u7ebf\u590d\u8bca\u67e5\u8be2\u670d\u52a1\u533b\u751f\u5217\u8868\u5165\u53c2:[{}]", (Object)JSON.toJSONString((Object)zxmzDoctorPageQuery));
        IPage info = this.doctorMapper.queryDoctorZxmz(page, zxmzDoctorPageQuery);
        List records = info.getRecords();
        log.info("\u4e2d\u65e5\u5728\u7ebf\u590d\u8bca\u67e5\u8be2\u670d\u52a1\u533b\u751f\u5217\u8868\u7ed3\u679c:[{}]", (Object)JSON.toJSONString((Object)records));
        List resultList = this.getDoctorBasicInfoVos(records, zxmzDoctorPageQuery);
        PageResult pageResult = new PageResult();
        pageResult.setContent(resultList);
        pageResult.setPageNum(zxmzDoctorPageQuery.getPageNum());
        pageResult.setPageSize(zxmzDoctorPageQuery.getPageSize());
        pageResult.setTotal((int)info.getTotal());
        pageResult.setTotalPages((int)info.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public GuideBaseResponse<List<GuideDoctorInfoVo>> getDoctorList(String deptId, String hosId, String branchId) {
        ScheduleDoctorParamVo scheduleDoctorParamVo = new ScheduleDoctorParamVo();
        scheduleDoctorParamVo.setOrganId(hosId);
        scheduleDoctorParamVo.setDeptCode(deptId);
        OrganManageDetailVo organManageDetailVO = this.organizationMapper.getOrganDetailById(Integer.valueOf(hosId));
        String queryHisDoctorUrl = this.domainName + organManageDetailVO.getAppCode() + "/appointment/api/v1/doctor/getSchduleDoctor";
        List scheduleDoctorResVoList = null;
        try {
            RestTemplate restTemplate = new RestTemplate();
            String body = (String)restTemplate.postForObject(queryHisDoctorUrl, (Object)scheduleDoctorParamVo, String.class, new Object[0]);
            log.info("\u67e5\u8be2his\u533b\u751f\u4fe1\u606f->{}", (Object)body);
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            scheduleDoctorResVoList = JSON.parseArray((String)JSON.toJSONString((Object)baseResponse.getData()), ScheduleDoctorResVo.class);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2his\u533b\u751f\u4fe1\u606f\u5f02\u5e38->{}", (Throwable)e);
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        if (scheduleDoctorResVoList.isEmpty()) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        Map<Long, ScheduleDoctorResVo> scheduleDoctorResVoMap = scheduleDoctorResVoList.stream().collect(Collectors.toMap(ScheduleDoctorResVo::getDoctorId, scheduleDoctorResVo -> scheduleDoctorResVo));
        List doctorList = scheduleDoctorResVoList.stream().map(ScheduleDoctorResVo::getDoctorId).collect(Collectors.toList());
        List doctorInfoEntityList = this.doctorMapper.getDoctorListByIds(doctorList);
        ArrayList<GuideDoctorInfoVo> guideDoctorInfoVoList = new ArrayList<GuideDoctorInfoVo>();
        for (DoctorInfoEntity record : doctorInfoEntityList) {
            ScheduleDoctorResVo scheduleDoctorResVo2 = scheduleDoctorResVoMap.get(record.getId());
            if (scheduleDoctorResVo2 == null) continue;
            GuideDoctorInfoVo guideDoctorInfoVo = new GuideDoctorInfoVo();
            guideDoctorInfoVo.setDoctorId(scheduleDoctorResVo2.getDoctorCode());
            guideDoctorInfoVo.setDoctorName(scheduleDoctorResVo2.getDoctorName());
            guideDoctorInfoVo.setDoctorSex(record.getGender().intValue());
            guideDoctorInfoVo.setDoctorJobTitle(record.getProfession() == null ? "" : record.getProfession());
            guideDoctorInfoVo.setDoctorImage(record.getHeadPortrait() == null ? "" : record.getHeadPortrait());
            guideDoctorInfoVo.setDoctorGoodat(record.getSpeciality() == null ? "" : record.getSpeciality());
            guideDoctorInfoVo.setExtraData("");
            guideDoctorInfoVo.setIsHTML(Boolean.valueOf(false));
            if (StringUtils.isNotBlank((CharSequence)record.getProfile())) {
                guideDoctorInfoVo.setDoctorIntro(record.getProfile().trim());
            } else {
                guideDoctorInfoVo.setDoctorIntro("");
            }
            String doctorUrl = "/wisdomTreatment/pages/doctorDetail/index?params=";
            QueryHisDoctorScheduleVo queryHisDoctorScheduleVo = new QueryHisDoctorScheduleVo();
            LocalDate startDate = LocalDate.now();
            queryHisDoctorScheduleVo.setStartDate(startDate.toString());
            LocalDate endDate = startDate.plusDays(6L);
            queryHisDoctorScheduleVo.setEndDate(endDate.toString());
            queryHisDoctorScheduleVo.setDeptCode(scheduleDoctorResVo2.getDeptCode());
            queryHisDoctorScheduleVo.setDoctorCode(scheduleDoctorResVo2.getDoctorCode());
            queryHisDoctorScheduleVo.setDocCode(scheduleDoctorResVo2.getDoctorCode());
            try {
                doctorUrl = doctorUrl + URLEncoder.encode(JSON.toJSONString((Object)queryHisDoctorScheduleVo), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("deptUrl\u7f16\u7801\u5f02\u5e38", (Throwable)e);
            }
            guideDoctorInfoVo.setDoctorUrl(doctorUrl);
            guideDoctorInfoVoList.add(guideDoctorInfoVo);
        }
        if (guideDoctorInfoVoList.isEmpty()) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        return GuideBaseResponse.success(guideDoctorInfoVoList, (String)MessageFormat.format("\u67e5\u8be2\u6210\u529f\uff0c\u5171\u67e5\u8be2{0}\u6761\u6570\u636e", guideDoctorInfoVoList.size()));
    }

    public BaseResponse<List<DoctorInfoDTO>> getDoctorUserId(List<String> doctorIds) {
        if (CollectionUtils.isEmpty(doctorIds)) {
            return BaseResponse.success(new ArrayList());
        }
        List doctorIdList = doctorIds.stream().map(Long::valueOf).collect(Collectors.toList());
        List doctorList = this.newCommonMapper.listUserId(doctorIdList);
        return BaseResponse.success((Object)doctorList);
    }

    private List<DoctorBasicInfoVo> getDoctorBasicInfoVos(List<DoctorInfoVO> records, ZxmzDoctorPageQuery zxmzDoctorPageQuery) {
        ArrayList<DoctorBasicInfoVo> resultList = new ArrayList<DoctorBasicInfoVo>();
        for (DoctorInfoVO record : records) {
            DepartmentEntity department;
            DoctorBasicInfoVo doctorBasicInfoVo = new DoctorBasicInfoVo();
            doctorBasicInfoVo.setCountry("0");
            doctorBasicInfoVo.setDoctorCode(String.valueOf(record.getId()));
            doctorBasicInfoVo.setDoctorName(record.getName());
            doctorBasicInfoVo.setEmail(record.getEmail());
            doctorBasicInfoVo.setGender(record.getGender());
            doctorBasicInfoVo.setIntroduction(record.getProfile());
            doctorBasicInfoVo.setOrganId(Long.valueOf(record.getOrganId().intValue()));
            doctorBasicInfoVo.setPortrait(record.getHeadPortrait());
            doctorBasicInfoVo.setStandardTitle(record.getProfession());
            String professionCode = record.getProfessionCode();
            DictionaryEntity profession = this.dictionaryMapper.findByDicCodeAndTypeCode(professionCode, "100");
            if (Objects.nonNull(profession)) {
                doctorBasicInfoVo.setStandardTitle(profession.getDicName());
                doctorBasicInfoVo.setTitleEnglishName(profession.getRemark());
            }
            doctorBasicInfoVo.setProfession(record.getSpeciality());
            doctorBasicInfoVo.setTelephone(record.getRegisterMobile());
            doctorBasicInfoVo.setXId(record.getId());
            if (null != zxmzDoctorPageQuery.getOrganDeptId() && Objects.nonNull(department = this.departmentMapper.selectById(Long.valueOf(record.getServiceDeptId())))) {
                doctorBasicInfoVo.setDeptId(Long.valueOf(department.getxId()));
                doctorBasicInfoVo.setDeptName(department.getDeptName());
                doctorBasicInfoVo.setDeptEnglishName(department.getEnglishName());
            }
            QueryOrganDetailVO queryOrganDetailVO = this.organizationMapper.queryOrganDetailnfo(record.getOrganId());
            doctorBasicInfoVo.setOrganName(queryOrganDetailVO.getOrganName());
            resultList.add(doctorBasicInfoVo);
        }
        return resultList;
    }

    private void setServiceCode(ZxmzDoctorPageQuery zxmzDoctorPageQuery) {
        String[] split;
        if (StringUtils.isNotBlank((CharSequence)zxmzDoctorPageQuery.getServiceCodes())) {
            split = zxmzDoctorPageQuery.getServiceCodes().split(",");
            List<String> serviceCodeList = Arrays.asList(split);
            if (serviceCodeList.isEmpty()) {
                zxmzDoctorPageQuery.setServiceCodes("");
            } else {
                String serviceCodes = serviceCodeList.stream().collect(Collectors.joining("','", "'", "'"));
                zxmzDoctorPageQuery.setServiceCodes(serviceCodes);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)zxmzDoctorPageQuery.getOrganDeptId())) {
            split = zxmzDoctorPageQuery.getOrganDeptId().split(",");
            List<String> deptList = Arrays.asList(split);
            if (deptList.isEmpty()) {
                zxmzDoctorPageQuery.setOrganDeptId("");
            } else {
                String depts = deptList.stream().collect(Collectors.joining("','", "'", "'"));
                zxmzDoctorPageQuery.setOrganDeptId(depts);
            }
        }
    }
}

