/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.doctor.basedata.api.vo.ClassifyReqVO;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctor.basedata.api.vo.DepartmentRespVO;
import com.doctor.basedata.api.vo.DepartmentRespVO2;
import com.doctor.basedata.api.vo.DepartmentStandardVo;
import com.doctor.basedata.api.vo.DeptClassifyParam;
import com.doctor.basedata.api.vo.DeptCustomClassifyVO;
import com.doctor.basedata.api.vo.DeptWebPageBoxReqVO;
import com.doctor.basedata.api.vo.GetStandDeptVo;
import com.doctor.basedata.api.vo.UpdateDeptReqVO;
import com.doctoruser.api.pojo.base.dto.OrganCodeReq;
import com.doctoruser.api.pojo.base.dto.OrganIdReq;
import com.doctoruser.api.pojo.base.dto.QueryDeptIdDTO;
import com.doctoruser.api.pojo.base.dto.dept.FetchAdvisoryDeptReq;
import com.doctoruser.api.pojo.base.dto.dept.SynHisDeptReq;
import com.doctoruser.api.pojo.base.entity.DepartmentEntity;
import com.doctoruser.api.pojo.base.entity.StandardDepartmentEntity;
import com.doctoruser.api.pojo.base.vo.FetchAdvisoryDeptRes;
import com.doctoruser.api.pojo.base.vo.doctor.OrganDeptInfoVO;
import com.doctoruser.api.pojo.base.vo.doctor.StandDeptInfoVO;
import com.doctoruser.api.pojo.base.vo.doctor.StandardDeptResVO;
import com.doctoruser.api.pojo.base.vo.organization.DepartmentVO;
import com.doctoruser.api.pojo.base.vo.standardept.StandardDeptVO;
import com.doctoruser.api.pojo.vo.DeptDeleteReqVO;
import com.doctoruser.api.pojo.vo.StdFirstDeptRespVO;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.exception.BusinessException;
import com.doctoruser.doctor.mapper.ClassifyDeptRelativeMapper;
import com.doctoruser.doctor.mapper.DepartmentMapper;
import com.doctoruser.doctor.mapper.DepartmentStandardMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.DoctorTeamInfoMapper;
import com.doctoruser.doctor.mapper.DoctorWorkInfoMapper;
import com.doctoruser.doctor.pojo.dto.QueryClassifyDeptDTO;
import com.doctoruser.doctor.pojo.entity.ClassifyDeptRelative;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.vo.BaseOrganDeptVo;
import com.doctoruser.doctor.pojo.vo.DepartmentLabelVo;
import com.doctoruser.doctor.pojo.vo.OrganDeptReqVo;
import com.doctoruser.doctor.pojo.vo.OrganDeptSaveReqVo;
import com.doctoruser.doctor.pojo.vo.SortDepartmentVo;
import com.doctoruser.doctor.pojo.vo.StandardDepartmentVo;
import com.doctoruser.doctor.service.DepartmentService;
import com.doctoruser.doctor.service.DeptCustomClassifyService;
import com.doctoruser.doctor.utils.JsonUtil;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DepartmentServiceImpl
implements DepartmentService {
    @Resource
    private DepartmentMapper departmentMapper;
    @Resource
    private DepartmentStandardMapper departmentStandardMapper;
    @Resource
    private DoctorMapper doctorMapper;
    @Autowired
    private ClassifyDeptRelativeMapper classifyDeptRelativeMapper;
    @Autowired
    private DeptCustomClassifyService deptCustomClassifyService;
    @Autowired
    private DoctorTeamInfoMapper doctorTeamInfoMapper;
    @Autowired
    private DoctorWorkInfoMapper doctorWorkInfoMapper;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseResponse<List<DepartmentEntity>> findPopByOrganCode(OrganCodeReq reqVo) {
        String organCode = reqVo.getOrganCode();
        List deptLists = this.departmentMapper.findPopByOrganCode(organCode);
        return BaseResponse.success((Object)deptLists);
    }

    public boolean checkDepartmentById(String deptId) {
        Integer count;
        return Objects.nonNull(deptId) && (count = this.departmentMapper.checkDepartmentById(deptId)) > 0;
    }

    public BaseResponse<List<DepartmentEntity>> listAllDeptByOrganId(String organId, String organCode) {
        List septList = this.departmentMapper.listAllDeptByOrganIdOrOrganCode(organId, organCode);
        return BaseResponse.success((Object)septList);
    }

    @Cacheable(cacheNames={"home_department_list"}, key="'fetchAdvisoryDept:'+#param.toString()", unless="!#result.success")
    public BaseResponse<List<FetchAdvisoryDeptRes>> fetchAdvisoryDept(FetchAdvisoryDeptReq param) {
        this.logger.info("REDIS CACHE REFRESH - name:{},param:{}", (Object)"home_department_list", (Object)JsonUtil.convertObject((Object)param));
        this.logger.info("fetchAdvisoryDept\u7f13\u5b58\u5931\u6548\uff0c\u5c06\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58");
        List departmentInfo = this.departmentMapper.fetchAdvisoryDept(param);
        if (departmentInfo.isEmpty()) {
            return BaseResponse.error((IError)EHErrorEnum.QUERY_DEPT_NULL);
        }
        return BaseResponse.success((Object)departmentInfo);
    }

    public BaseResponse<List<StandardDeptResVO>> queryStandDeptByOrganId(int organId, String standName) {
        List list = this.departmentMapper.querystandDeptByOrgId(organId, standName);
        if (list.isEmpty()) {
            BaseResponse.success(null);
        }
        ArrayList<StandardDeptResVO> listRes = new ArrayList<StandardDeptResVO>();
        for (StandardDeptVO deptVO : list) {
            StandardDeptResVO resVO = new StandardDeptResVO();
            BeanUtils.copyProperties((Object)deptVO, (Object)resVO);
            List listDept = this.departmentMapper.queryDeptByFirstDepId(resVO.getStandDeptId(), organId);
            if (!listDept.isEmpty()) {
                for (DepartmentVO departmentVO : listDept) {
                    StandardDeptVO second;
                    StandardDeptVO fist = this.departmentMapper.queryStandDeptInfoById(departmentVO.getFirstDeptId());
                    if (fist != null) {
                        departmentVO.setFirstDeptName(fist.getDisplayName());
                    }
                    if ((second = this.departmentMapper.queryStandDeptInfoById(departmentVO.getSecondDeptId())) == null) continue;
                    departmentVO.setSecondDeptName(second.getDisplayName());
                }
            }
            resVO.setDeptList(listDept);
            listRes.add(resVO);
        }
        return BaseResponse.success(listRes);
    }

    public BaseResponse<StandDeptInfoVO> queryStandDeptInfoById(int standDeptId) {
        StandardDeptVO standardDeptVO = this.departmentMapper.queryStandDeptInfoById(standDeptId);
        StandDeptInfoVO resVo = new StandDeptInfoVO();
        if (standardDeptVO != null) {
            BeanUtils.copyProperties((Object)standardDeptVO, (Object)resVo);
        }
        return BaseResponse.success((Object)resVo);
    }

    public BaseResponse<List<OrganDeptInfoVO>> listOrganDept(OrganIdReq req) {
        ArrayList<OrganDeptInfoVO> list = new ArrayList<OrganDeptInfoVO>();
        ArrayList departmentStandardVOS = this.departmentStandardMapper.queryAllStandardDept();
        for (DepartmentStandardVo departmentStandardVO : departmentStandardVOS) {
            OrganDeptInfoVO organDeptInfoVO = new OrganDeptInfoVO();
            organDeptInfoVO.setFirstStandDeptId(departmentStandardVO.getStandard() + "");
            organDeptInfoVO.setFirstStandDeptName(departmentStandardVO.getDeptName());
            organDeptInfoVO.setEnglishName(departmentStandardVO.getEnglishName());
            QueryClassifyDeptDTO queryClassifyDeptDTO = new QueryClassifyDeptDTO();
            queryClassifyDeptDTO.setOrganId(Long.valueOf(req.getOrganId()));
            queryClassifyDeptDTO.setDeptType(req.getDeptType());
            queryClassifyDeptDTO.setFirstStdDeptId(Long.valueOf(organDeptInfoVO.getFirstStandDeptId()));
            List departmentEntities = this.departmentMapper.listOrganDept(queryClassifyDeptDTO);
            if (null != departmentEntities && departmentEntities.size() > 0) {
                organDeptInfoVO.setDepartmentEntities(departmentEntities);
            }
            list.add(organDeptInfoVO);
        }
        return BaseResponse.success(list);
    }

    public BaseResponse<Object> synchronizeHisDeptInfo(SynHisDeptReq synHisDeptReq) {
        DepartmentEntity departmentInfo = this.departmentMapper.findByOrganIdAndName(String.valueOf(synHisDeptReq.getOrganId()), synHisDeptReq.getDeptName());
        Optional<DepartmentEntity> departmentOpt = Optional.ofNullable(departmentInfo);
        DepartmentEntity department = departmentOpt.orElseGet(() -> {
            StandardDepartmentEntity standardDepartmentEntity = this.departmentStandardMapper.queryUndividedDept("\u5f85\u5212\u5206", (short)1, (short)2);
            Optional<StandardDepartmentEntity> standardDeptOpt = Optional.ofNullable(standardDepartmentEntity);
            StandardDepartmentEntity secondStandardDept = standardDeptOpt.orElseThrow(() -> new BusinessException(EHErrorEnum.UNDIVIDED_DEPT_NOT_EXIST.getMsg()));
            DepartmentEntity departmentEntity = new DepartmentEntity();
            departmentEntity.setDeptName(synHisDeptReq.getDeptName());
            departmentEntity.setOrganId(String.valueOf(synHisDeptReq.getOrganId()));
            departmentEntity.setStatus(Integer.valueOf(1));
            departmentEntity.setStdFirstDeptId(secondStandardDept.getRel_dept_id());
            departmentEntity.setStdSecondDeptId(Integer.valueOf(secondStandardDept.getxId()));
            departmentEntity.setxCreateTime(new Date());
            departmentEntity.setxUpdateTime(new Date());
            departmentEntity.setxVersion(Long.valueOf(1L));
            departmentEntity.setDoctorCount(Integer.valueOf(0));
            departmentEntity.setIsPopular(Integer.valueOf(0));
            departmentEntity.setDescription("");
            departmentEntity.setxRemark("");
            departmentEntity.setIsInhos(Integer.valueOf(0));
            return departmentEntity;
        });
        department.setDeptCode(synHisDeptReq.getDeptCode());
        this.departmentMapper.save(department);
        return BaseResponse.success();
    }

    public BaseResponse<List<DepartmentEntity>> getHotDepartmentList(Long organId) {
        List list = this.departmentMapper.getHotDepartmentList(organId, (short)1);
        return BaseResponse.success((Object)list);
    }

    public BaseResponse saveOrganDepartment(OrganDeptReqVo organDeptReqVo) {
        DepartmentEntity departmentEntity;
        List baseOrganDept = organDeptReqVo.getBaseOrganDept();
        Map<Boolean, List<BaseOrganDeptVo>> operatePart = baseOrganDept.stream().collect(Collectors.partitioningBy(deptInfo -> Objects.isNull(deptInfo.getOrganDeptId())));
        List deptList = this.departmentMapper.getDeptListByOrganId(organDeptReqVo.getOrganId(), "1,2");
        Map departmentMap = deptList.stream().collect(Collectors.toMap(DepartmentEntity::getDeptName, Function.identity(), (valFirst, valSecond) -> valSecond));
        List<BaseOrganDeptVo> updateOrganDeptReqVos = operatePart.get(false);
        ArrayList<BaseOrganDeptVo> ignoreUpdateDept = new ArrayList<BaseOrganDeptVo>();
        for (BaseOrganDeptVo updateOrganDept : updateOrganDeptReqVos) {
            DepartmentEntity department = (DepartmentEntity)departmentMap.get(updateOrganDept.getOrganDeptName());
            if (!Objects.nonNull(department)) continue;
            if (Long.valueOf(department.getxId()).equals(updateOrganDept.getOrganDeptId()) && department.getDeptCode().equals(updateOrganDept.getDeptCode())) {
                ignoreUpdateDept.add(updateOrganDept);
                continue;
            }
            return BaseResponse.error((IError)EHErrorEnum.DEPARTMENT_HAVE_EXIST);
        }
        ignoreUpdateDept.forEach(updateOrganDeptReqVos::remove);
        List<BaseOrganDeptVo> insertOrganDeptReqVos = operatePart.get(true);
        for (BaseOrganDeptVo insertOrganDept : insertOrganDeptReqVos) {
            DepartmentEntity department = (DepartmentEntity)departmentMap.get(insertOrganDept.getOrganDeptName());
            if (!Objects.nonNull(department)) continue;
            return BaseResponse.error((IError)EHErrorEnum.DEPARTMENT_HAVE_EXIST);
        }
        for (BaseOrganDeptVo updateOrganDept : updateOrganDeptReqVos) {
            departmentEntity = new DepartmentEntity();
            departmentEntity.setxId(String.valueOf(updateOrganDept.getOrganDeptId()));
            departmentEntity.setxUpdateTime(new Date());
            departmentEntity.setDeptCode(updateOrganDept.getDeptCode());
            departmentEntity.setDeptName(updateOrganDept.getOrganDeptName());
            this.departmentMapper.updateByPrimaryKeySelective(departmentEntity);
            try {
                DoctorInfoEntity doctorInfoEntity = new DoctorInfoEntity();
                doctorInfoEntity.setHospitalDeptId(Integer.valueOf(departmentEntity.getxId()));
                doctorInfoEntity.setHospitalDeptName(departmentEntity.getDeptName());
                this.doctorMapper.updateByDeptId(doctorInfoEntity);
            }
            catch (Exception e) {
                this.logger.error("\u540c\u6b65\u4fee\u6539\u62a5\u9519:{}", (Object)e.getMessage());
            }
        }
        for (BaseOrganDeptVo insertOrganDept : insertOrganDeptReqVos) {
            departmentEntity = new DepartmentEntity();
            departmentEntity.initInsert();
            departmentEntity.setDeptName(insertOrganDept.getOrganDeptName());
            departmentEntity.setDeptCode(insertOrganDept.getDeptCode());
            departmentEntity.setOrganId(String.valueOf(organDeptReqVo.getOrganId()));
            departmentEntity.setStdFirstDeptId(Integer.valueOf(organDeptReqVo.getFirstStdDeptId().intValue()));
            departmentEntity.setStdSecondDeptId(Integer.valueOf(organDeptReqVo.getSecondStdDeptId().intValue()));
            this.departmentMapper.insertSelective(departmentEntity);
        }
        return BaseResponse.success();
    }

    public BaseResponse getOrganDeptBySecondStdDeptId(Long organId, Long secondStdDeptId) {
        List deptList = this.departmentMapper.getOrganDeptBySecondStdDeptId(organId, secondStdDeptId, Integer.valueOf(1));
        List organDeptIds = deptList.stream().map(BaseOrganDeptVo::getOrganDeptId).collect(Collectors.toList());
        if (!organDeptIds.isEmpty()) {
            List classifyDeptRelatives = this.classifyDeptRelativeMapper.getByDeptIds(organDeptIds);
            Map deptGroupClassify = classifyDeptRelatives.stream().collect(Collectors.groupingBy(ClassifyDeptRelative::getDeptId, Collectors.mapping(ClassifyDeptRelative::getClassifyId, Collectors.toList())));
            for (BaseOrganDeptVo baseOrganDeptVo : deptList) {
                List classifyIds = deptGroupClassify.get(baseOrganDeptVo.getOrganDeptId());
                if (Objects.nonNull(classifyIds)) {
                    baseOrganDeptVo.setClassifyIds(classifyIds);
                    continue;
                }
                baseOrganDeptVo.setClassifyIds(new ArrayList());
            }
        }
        return BaseResponse.success((Object)deptList);
    }

    public BaseResponse<List<StdFirstDeptRespVO>> getStdFirstDeptByOrganId(Long organId) {
        List firstDeptByOrganId = this.departmentMapper.getStdFirstDeptByOrganId(organId, Integer.valueOf(1));
        return BaseResponse.success((Object)firstDeptByOrganId);
    }

    @Transactional
    public BaseResponse<String> deleteDeptById(DeptDeleteReqVO reqVO) {
        reqVO.setStatus(Integer.valueOf(1));
        int doctorNumber = this.departmentMapper.queryDeptAndDoctorByOrganIdAndDeptId(reqVO);
        if (doctorNumber != 0) {
            return BaseResponse.error((IError)EHErrorEnum.CANNOT_BE_DELETED);
        }
        int teamNumber = this.doctorTeamInfoMapper.selectCountByDeptId(reqVO.getDeptId().toString());
        if (teamNumber != 0) {
            return BaseResponse.error((String)"\u5f53\u524d\u79d1\u5ba4\u4e0b\u5b58\u5728\u533b\u751f\u56e2\u961f,\u65e0\u6cd5\u5220\u9664");
        }
        DepartmentEntity departmentEntity = new DepartmentEntity();
        departmentEntity.setxId(String.valueOf(reqVO.getDeptId()));
        departmentEntity.setStatus(Integer.valueOf(-1));
        this.departmentMapper.updateByPrimaryKeySelective(departmentEntity);
        this.doctorWorkInfoMapper.deleteByDepartmentId(String.valueOf(reqVO.getDeptId()));
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public BaseResponse sortOrganDepartment(SortDepartmentVo sortDepartmentVo) {
        Long stdFirstDeptId = sortDepartmentVo.getStdFirstDeptId();
        List deptIds = sortDepartmentVo.getDeptIds();
        for (int i = 0; i < deptIds.size(); ++i) {
            DepartmentEntity department = new DepartmentEntity();
            department.setxId(String.valueOf(deptIds.get(i)));
            department.setSeq(Long.valueOf(stdFirstDeptId + (long)((deptIds.size() - i) * 10)));
            this.departmentMapper.updateByPrimaryKeySelective(department);
        }
        return BaseResponse.success();
    }

    public BaseResponse saveDepartmentLabel(DepartmentLabelVo departmentLabelVo) {
        DepartmentEntity departmentEntity = new DepartmentEntity();
        departmentEntity.setxId(String.valueOf(departmentLabelVo.getDeptId()));
        departmentEntity.setLabel(departmentLabelVo.getLabel());
        int update = this.departmentMapper.updateByPrimaryKeySelective(departmentEntity);
        if (update == 0) {
            return BaseResponse.error((IError)IError.SYSYTEM_UNKNOW);
        }
        return BaseResponse.success();
    }

    public BaseResponse<DepartmentEntity> getDepartmentById(Long deptId) {
        DepartmentEntity departmentEntity = this.departmentMapper.selectById(deptId);
        return BaseResponse.success((Object)departmentEntity);
    }

    public BaseResponse<StandardDepartmentVo> getDepartmentByName(String deptName) {
        StandardDepartmentVo departmentVo = this.departmentStandardMapper.queryStandardDepartmentVo(deptName);
        return BaseResponse.success((Object)departmentVo);
    }

    public BaseResponse<DepartmentDetailVo> getDepartmentDetail(Long deptId) {
        DepartmentEntity departmentEntity = this.departmentMapper.selectById(deptId);
        DepartmentDetailVo departmentDetailVo = null;
        if (Objects.nonNull(departmentEntity)) {
            StandardDepartmentEntity secondStdDept;
            departmentDetailVo = new DepartmentDetailVo();
            BeanUtils.copyProperties((Object)departmentEntity, (Object)departmentDetailVo);
            ArrayList<Integer> stdDeptIds = new ArrayList<Integer>();
            stdDeptIds.add(departmentEntity.getStdFirstDeptId());
            stdDeptIds.add(departmentEntity.getStdSecondDeptId());
            List stdDeptEntities = this.departmentStandardMapper.selectByIds(stdDeptIds);
            Map stdDeptMap = stdDeptEntities.stream().collect(Collectors.toMap(dept -> Integer.valueOf(dept.getxId()), Function.identity()));
            StandardDepartmentEntity firstStdDept = (StandardDepartmentEntity)stdDeptMap.get(departmentEntity.getStdFirstDeptId());
            if (Objects.nonNull(firstStdDept)) {
                departmentDetailVo.setStdFirstDeptName(firstStdDept.getDisplayName());
            }
            if (Objects.nonNull(secondStdDept = (StandardDepartmentEntity)stdDeptMap.get(departmentEntity.getStdSecondDeptId()))) {
                departmentDetailVo.setStdSecondDeptName(secondStdDept.getDisplayName());
            }
        }
        return BaseResponse.success(departmentDetailVo);
    }

    public PageResult<DepartmentRespVO2> findDeptByClassifyReqVO(ClassifyReqVO classifyReqVO) {
        PageHelper.startPage((int)classifyReqVO.getPageNum(), (int)classifyReqVO.getPageSize());
        String classifyId = classifyReqVO.getClassifyId();
        String organId = classifyReqVO.getOrganId();
        String deptName = classifyReqVO.getDeptName();
        List departmentRespVOList = classifyId == null || "".equals(classifyId) ? this.departmentMapper.findByOrganIdAndDeptName(organId, deptName) : this.departmentMapper.findDeptByClassifyReqVO(classifyReqVO);
        if (departmentRespVOList != null && departmentRespVOList.size() > 0) {
            for (DepartmentRespVO departmentRespVO : departmentRespVOList) {
                List deptCustomClassifyVOList = this.deptCustomClassifyService.findByDeptIdAndOrganId(departmentRespVO.getXId(), Long.valueOf(classifyReqVO.getOrganId()));
                departmentRespVO.setDeptCustomClassifyVOList(deptCustomClassifyVOList);
            }
        }
        PageInfo pageInfo = new PageInfo(departmentRespVOList);
        List pageInfoList = pageInfo.getList();
        ArrayList<DepartmentRespVO2> departmentRespVO2List = new ArrayList<DepartmentRespVO2>();
        if (pageInfoList != null && pageInfoList.size() > 0) {
            for (DepartmentRespVO departmentRespVO : pageInfoList) {
                DepartmentRespVO2 departmentRespVO2 = new DepartmentRespVO2();
                departmentRespVO2.setOrganDeptId(departmentRespVO.getXId());
                departmentRespVO2.setOrganDeptName(departmentRespVO.getDeptName());
                departmentRespVO2.setEnglishName(departmentRespVO.getEnglishName());
                departmentRespVO2.setDeptCode(departmentRespVO.getDeptCode());
                List deptCustomClassifyVOList = departmentRespVO.getDeptCustomClassifyVOList();
                if (deptCustomClassifyVOList != null && deptCustomClassifyVOList.size() > 0) {
                    ArrayList<Long> classifyIds = new ArrayList<Long>();
                    for (DeptCustomClassifyVO deptCustomClassifyVO : deptCustomClassifyVOList) {
                        classifyIds.add(deptCustomClassifyVO.getId());
                    }
                    departmentRespVO2.setClassifyIds(classifyIds);
                }
                departmentRespVO2List.add(departmentRespVO2);
            }
        }
        PageResult pageResult = new PageResult();
        pageResult.setPageNum(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        Long total = pageInfo.getTotal();
        pageResult.setTotal(total.intValue());
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(departmentRespVO2List);
        return pageResult;
    }

    public List<DepartmentRespVO> findDeptWebPageBoxList(DeptWebPageBoxReqVO deptWebPageBoxReqVO) {
        String classifyId = deptWebPageBoxReqVO.getClassifyId();
        String organId = deptWebPageBoxReqVO.getOrganId();
        String deptName = deptWebPageBoxReqVO.getDeptName();
        if (classifyId == null || "".equals(classifyId)) {
            return this.departmentMapper.findByOrganIdAndDeptName(organId, deptName);
        }
        ClassifyReqVO classifyReqVO = new ClassifyReqVO();
        BeanUtils.copyProperties((Object)deptWebPageBoxReqVO, (Object)classifyReqVO);
        List departmentRespVOList = this.departmentMapper.findDeptByClassifyReqVO(classifyReqVO);
        return departmentRespVOList;
    }

    @Transactional
    public BaseResponse updateDept(UpdateDeptReqVO updateDeptReqVO) {
        DepartmentEntity departmentEntityDb = this.departmentMapper.findByOrganIdAndNameAndId(updateDeptReqVO.getOrganId(), updateDeptReqVO.getDeptName(), updateDeptReqVO.getXId());
        if (null != departmentEntityDb) {
            return BaseResponse.error((IError)EHErrorEnum.DEPARTMENT_HAVE_EXIST);
        }
        DepartmentEntity departmentEntity = new DepartmentEntity();
        BeanUtils.copyProperties((Object)updateDeptReqVO, (Object)departmentEntity);
        this.departmentMapper.updateByPrimaryKeySelective(departmentEntity);
        this.updateRedundanceDeptName(departmentEntity.getxId(), departmentEntity.getDeptName());
        this.classifyDeptRelativeMapper.deleteDeptClassify(Long.valueOf(updateDeptReqVO.getXId()));
        List classifyIdList = updateDeptReqVO.getClassifyIdList();
        if (classifyIdList != null && classifyIdList.size() > 0) {
            for (Long classifyId : classifyIdList) {
                ClassifyDeptRelative classifyDeptRelative = new ClassifyDeptRelative();
                classifyDeptRelative.setClassifyId(classifyId);
                classifyDeptRelative.setDeptId(Long.valueOf(updateDeptReqVO.getXId()));
                this.classifyDeptRelativeMapper.insertSelective(classifyDeptRelative);
            }
        }
        return BaseResponse.success();
    }

    private void updateRedundanceDeptName(String deptId, String deptName) {
        this.departmentMapper.updateDoctorAuditDeptName(deptId, deptName);
        this.departmentMapper.updateDoctorInfoDeptName(deptId, deptName);
        this.departmentMapper.updateDoctorUserDeptName(deptId, deptName);
        this.departmentMapper.updateDoctorWorkplacesInfoDeptName(deptId, deptName);
    }

    private void executeDeptClassify(Long organDeptId, List<Long> classifyIds) {
        this.classifyDeptRelativeMapper.deleteDeptClassify(organDeptId);
        for (Long classifyId : classifyIds) {
            ClassifyDeptRelative classifyDeptRelative = new ClassifyDeptRelative();
            classifyDeptRelative.setClassifyId(classifyId);
            classifyDeptRelative.setDeptId(organDeptId);
            this.classifyDeptRelativeMapper.insertSelective(classifyDeptRelative);
        }
    }

    @Transactional
    public BaseResponse saveOrganDepartment(OrganDeptSaveReqVo organDeptReq) {
        QueryDeptIdDTO queryParam = new QueryDeptIdDTO();
        queryParam.setOrganId(String.valueOf(organDeptReq.getOrganId()));
        queryParam.setDeptName(organDeptReq.getOrganDeptName());
        String organDeptId = this.departmentMapper.queryIdByNameAndOrganId(queryParam);
        DepartmentEntity department = new DepartmentEntity();
        if (Objects.isNull(organDeptId)) {
            department.initInsert();
            department.setDeptCode(organDeptReq.getDeptCode());
            department.setDeptName(organDeptReq.getOrganDeptName());
            department.setEnglishName(organDeptReq.getEnglishName());
            department.setOrganId(String.valueOf(organDeptReq.getOrganId()));
            department.setStdFirstDeptId(Integer.valueOf(Math.toIntExact(organDeptReq.getFirstStdDeptId())));
            department.setStdSecondDeptId(Integer.valueOf(Math.toIntExact(organDeptReq.getSecondStdDeptId())));
            this.departmentMapper.save(department);
            this.executeDeptClassify(Long.valueOf(department.getxId()), organDeptReq.getClassifyIds());
            return BaseResponse.success();
        }
        if (Long.valueOf(organDeptId).equals(organDeptReq.getOrganDeptId())) {
            department.setDeptCode(organDeptReq.getDeptCode());
            department.setDeptName(organDeptReq.getOrganDeptName());
            department.setEnglishName(organDeptReq.getEnglishName());
            department.setxId(String.valueOf(organDeptReq.getOrganDeptId()));
            this.departmentMapper.save(department);
            this.executeDeptClassify(Long.valueOf(department.getxId()), organDeptReq.getClassifyIds());
            return BaseResponse.success();
        }
        return BaseResponse.error((IError)EHErrorEnum.DEPARTMENT_HAVE_EXIST);
    }

    public BaseResponse<List<FetchAdvisoryDeptRes>> getByClassifyCode(String classifyCode, Long organId) {
        DeptClassifyParam deptClassify = new DeptClassifyParam();
        deptClassify.setClassifyCode(classifyCode);
        deptClassify.setOrganId(String.valueOf(organId));
        deptClassify.setStatus(Integer.valueOf(1));
        List deptList = this.departmentMapper.getOrganDeptByClassifyCode(deptClassify);
        List responseList = deptList.stream().map(item -> {
            FetchAdvisoryDeptRes deptRes = new FetchAdvisoryDeptRes();
            deptRes.setDeptCode(item.getDeptCode());
            deptRes.setDeptId(item.getxId());
            deptRes.setDeptName(item.getDeptName());
            deptRes.setEnglishName(item.getEnglishName());
            return deptRes;
        }).collect(Collectors.toList());
        return BaseResponse.success(responseList);
    }

    public BaseResponse<List<StandardDeptResVO>> getOrganDeptByClassifyCode(String classifyCode, String deptName, Long organId) {
        ArrayList<StandardDeptResVO> resultList = new ArrayList<StandardDeptResVO>();
        DeptClassifyParam deptClassify = new DeptClassifyParam();
        deptClassify.setClassifyCode(classifyCode);
        deptClassify.setOrganId(String.valueOf(organId));
        deptClassify.setStatus(Integer.valueOf(1));
        deptClassify.setDeptName(deptName);
        List deptList = this.departmentMapper.getOrganDeptByClassifyCode(deptClassify);
        List departmentList = this.convertDepartmentModel(deptList);
        List stdFirstDeptIds = deptList.stream().map(DepartmentEntity::getStdFirstDeptId).collect(Collectors.toList());
        if (stdFirstDeptIds.isEmpty()) {
            return BaseResponse.success(resultList);
        }
        List stdDeptList = this.departmentStandardMapper.selectByIds(stdFirstDeptIds);
        Map<Integer, List<DepartmentVO>> deptMap = departmentList.stream().collect(Collectors.groupingBy(DepartmentVO::getFirstDeptId));
        for (StandardDepartmentEntity stdDeptInfo : stdDeptList) {
            StandardDeptResVO organDeptInfoVO = new StandardDeptResVO();
            organDeptInfoVO.setDisplayName(stdDeptInfo.getDisplayName());
            organDeptInfoVO.setEnglishName(stdDeptInfo.getEnglishName());
            organDeptInfoVO.setStandDeptId(Integer.valueOf(stdDeptInfo.getxId()).intValue());
            List<DepartmentVO> departmentVOS = deptMap.get(Integer.valueOf(stdDeptInfo.getxId()));
            organDeptInfoVO.setDeptList(departmentVOS);
            resultList.add(organDeptInfoVO);
        }
        return BaseResponse.success(resultList);
    }

    public BaseResponse<List<DepartmentRespVO>> getOrganDeptByOrganIdAndDeptName(String organId, String deptName) {
        List departmentRespVOList = this.departmentMapper.findByOrganIdAndDeptName(organId, deptName);
        return BaseResponse.success((Object)departmentRespVOList);
    }

    public BaseResponse<StandardDepartmentEntity> getByOrganIdAndHosDeptId(GetStandDeptVo getStandDeptVo) {
        StandardDepartmentEntity standardDepartmentEntity = this.departmentStandardMapper.selectByOrganIdAndHosDeptId(getStandDeptVo);
        if (Objects.isNull(standardDepartmentEntity)) {
            return BaseResponse.error((String)"\u8981\u67e5\u8be2\u7684\u79d1\u5ba4\u4e0d\u5b58\u5728");
        }
        return BaseResponse.success((Object)standardDepartmentEntity);
    }

    private List<DepartmentVO> convertDepartmentModel(List<DepartmentEntity> deptList) {
        return deptList.stream().map(dept -> {
            DepartmentVO departmentVO = new DepartmentVO();
            departmentVO.setDeptCode(dept.getDeptCode());
            departmentVO.setDeptId(Integer.valueOf(dept.getxId()).intValue());
            departmentVO.setDeptName(dept.getDeptName());
            departmentVO.setDescription(dept.getDescription());
            departmentVO.setEnglishName(dept.getEnglishName());
            departmentVO.setFirstDeptId(dept.getStdFirstDeptId().intValue());
            departmentVO.setSecondDeptId(dept.getStdSecondDeptId().intValue());
            departmentVO.setIsInhos(dept.getIsInhos());
            departmentVO.setIsPopular(dept.getIsPopular());
            departmentVO.setStatus(dept.getStatus());
            departmentVO.setOrganId(Integer.valueOf(dept.getOrganId()).intValue());
            return departmentVO;
        }).collect(Collectors.toList());
    }
}

