/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.doctor.basedata.api.dto.DoctorInfoCheckDTO;
import com.doctor.basedata.api.dto.ZRDocInfoCheckDTO;
import com.doctor.basedata.api.utils.ValidPropertyUtil;
import com.doctor.basedata.api.utils.ValidateResult;
import com.doctor.basedata.api.vo.BaseDoctorInfoRespVO;
import com.doctor.basedata.api.vo.DictionaryResp;
import com.doctor.basedata.api.vo.DoctorInfoHomeVo;
import com.doctor.basedata.api.vo.DoctorPostRepVO;
import com.doctor.basedata.api.vo.GetBusinessDoctorListVo;
import com.doctor.basedata.api.vo.OrganSupervisionVo;
import com.doctor.basedata.api.vo.RetBusinessDoctorListVo;
import com.doctoruser.api.pojo.base.entity.DepartmentEntity;
import com.doctoruser.api.pojo.base.entity.DoctorWorkingServiceDo;
import com.doctoruser.api.pojo.base.entity.OrganWorkingServiceEntity;
import com.doctoruser.api.pojo.base.query.BusinessDoctorListQuery;
import com.doctoruser.api.pojo.base.query.DoctorInfoQuery;
import com.doctoruser.api.pojo.base.vo.BaseDoctorInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorBasicInfoVo;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.doctor.AreaInfoDTO;
import com.doctoruser.api.pojo.dto.doctor.DoctorNetworkClinicDTO;
import com.doctoruser.api.pojo.dto.doctor.DoctorSearchDTO;
import com.doctoruser.api.pojo.dto.doctor.FuzzyQueryDoctorDTO;
import com.doctoruser.api.pojo.dto.doctor.ListDoctorDTO;
import com.doctoruser.api.pojo.dto.doctor.ListFamousDoctorDTO;
import com.doctoruser.api.pojo.dto.doctor.QueryDoctorDTO;
import com.doctoruser.api.pojo.dto.doctor.QueryPiontServiceDTO;
import com.doctoruser.api.pojo.dto.doctor.SaveDoctorInfoDTO;
import com.doctoruser.api.pojo.dto.doctor.UpdateBalanceDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.AreaInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorConsultationServiceInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorDetailVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorDetailsInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorRegisterInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorServiceInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorServicesRes;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorTeamDetailVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorUserInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.InDoServiceStatus;
import com.doctoruser.api.pojo.vo.basedata.doctor.ListAreaVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.ListCityVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.ListDoctReq;
import com.doctoruser.api.pojo.vo.basedata.doctor.ListDoctorVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.ListProvinceVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.ManagerDoctorListVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.PointDoctorServiceInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.UserDoctorVo;
import com.doctoruser.doctor.enums.ConsultationServiceEnum;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.mapper.DepartmentMapper;
import com.doctoruser.doctor.mapper.DictionaryMapper;
import com.doctoruser.doctor.mapper.DocDoctorServiceAccessMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkingServiceMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesInfoMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesMapper;
import com.doctoruser.doctor.mapper.DoctorConsultationServiceInfoEntityMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.DoctorTeamInfoMapper;
import com.doctoruser.doctor.mapper.OrganWorkingServiceMapper;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.pojo.entity.DictionaryEntity;
import com.doctoruser.doctor.pojo.entity.DocBalanceLogEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkingServiceEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesInfo;
import com.doctoruser.doctor.pojo.entity.DoctorConsultationServiceInfoEntity;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.entity.OrganizationEntity;
import com.doctoruser.doctor.pojo.vo.DoctorInfoVO;
import com.doctoruser.doctor.pojo.vo.SortOrganDoctorVo;
import com.doctoruser.doctor.service.IDoctorService;
import com.doctoruser.doctor.service.IUserEvaluationService;
import com.doctoruser.doctor.service.feign.ByhUserRelationShipClient;
import com.doctoruser.doctor.service.impl.DictionaryServiceImpl;
import com.doctoruser.doctor.utils.JsonUtil;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DoctorServiceImpl
implements IDoctorService {
    private static final Logger log = LoggerFactory.getLogger(DoctorServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(DoctorServiceImpl.class);
    @Value(value="${doctorServiceUrl}")
    private String doctorServiceUrl;
    @Value(value="${organServiceUrl}")
    private String organServiceUrl;
    @Value(value="${syscServiceUrl}")
    private String syscServiceUrl;
    @Resource
    private DoctorMapper doctorMapper;
    @Autowired
    private DepartmentMapper departmentMapper;
    @Resource
    private DocDoctorWorkplacesMapper docDoctorWorkplacesMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Autowired
    private IUserEvaluationService UserEvaluationService;
    @Resource
    private ByhUserRelationShipClient byhUserRelationShipClient;
    @Resource
    private DoctorConsultationServiceInfoEntityMapper doctorConsultationServiceInfoEntityMapper;
    @Resource
    private DocDoctorWorkingServiceMapper docDoctorWorkingServiceMapper;
    @Resource
    private DoctorTeamInfoMapper doctorTeamInfoMapper;
    @Autowired
    private OrganWorkingServiceMapper organWorkingServiceMapper;
    @Autowired
    private DictionaryMapper dictionaryMapper;
    @Autowired
    private DocDoctorWorkplacesInfoMapper doctorWorkplacesInfoMapper;
    @Autowired
    private DictionaryServiceImpl dictionaryService;
    @Autowired
    private DocDoctorServiceAccessMapper docDoctorServiceAccessMapper;
    private static final String IMAGE = "52110";
    private static final String VIDEO = "52120";

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public BaseResponse<Integer> saveDoctorInfo(SaveDoctorInfoDTO dto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DoctorInfoEntity::getName, (Object)dto.getName());
        queryWrapper.lambda().eq(DoctorInfoEntity::getRegisterMobile, (Object)dto.getRegisterMobile());
        queryWrapper.lambda().eq(DoctorInfoEntity::getStatus, (Object)1);
        DoctorInfoEntity entity = (DoctorInfoEntity)this.doctorMapper.selectOne((Wrapper)queryWrapper);
        if (null == dto.getId()) {
            if (null == entity) {
                entity = new DoctorInfoEntity();
                BeanUtils.copyProperties((Object)dto, (Object)entity);
                this.logger.info("==\u4fdd\u5b58\u7684\u533b\u751f\u4fe1\u606f=={}", (Object)entity);
                this.doctorMapper.saveDoctorInfo(entity);
            } else {
                this.logger.info("==\u5ba1\u6838\u7684\u533b\u751f\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u590d\u7528\u8be5\u6570\u636e==");
            }
        } else {
            entity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)dto.getId());
            BigDecimal balance = entity.getBalance();
            BeanUtils.copyProperties((Object)dto, (Object)entity);
            entity.setBalance(balance);
            this.logger.info("==\u66f4\u65b0\u7684\u533b\u751f\u4fe1\u606f=={}", (Object)entity);
            this.doctorMapper.updateById((Object)entity);
        }
        this.executeWorkPlacesUpdate(entity);
        return BaseResponse.success((Object)entity.getId().intValue());
    }

    public BaseResponse<PageResult<ListDoctorVO>> listDoctorInfo(ListDoctorDTO dto) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setSize((long)dto.getPageSize().intValue());
        page.setCurrent((long)dto.getPageNum().intValue());
        IPage detailsInfoVOS = null;
        if (dto.getSourceType() == 1) {
            detailsInfoVOS = this.doctorMapper.listAppAllianceDoctorInfo(page, dto);
        } else if (dto.getSourceType() == 2) {
            detailsInfoVOS = this.doctorMapper.listWebAllianceDoctorInfo(page, dto);
        } else if (dto.getSourceType() == 3) {
            detailsInfoVOS = this.doctorMapper.listAppSxzzDoctorInfo(page, dto);
        } else if (dto.getSourceType() == 4) {
            detailsInfoVOS = this.doctorMapper.listWebYcyxDoctorInfo(page, dto);
        }
        if (null == detailsInfoVOS || detailsInfoVOS.getRecords().isEmpty()) {
            return BaseResponse.success((Object)new PageResult());
        }
        PageResult result = new PageResult();
        result.setContent(detailsInfoVOS.getRecords());
        result.setPageNum((int)detailsInfoVOS.getCurrent());
        result.setPageSize((int)detailsInfoVOS.getSize());
        result.setTotal((int)detailsInfoVOS.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<PageResult<ListDoctorVO>> listClcDoctorInfo(ListDoctorDTO dto) {
        if (null == dto.getDoctorId()) {
            return BaseResponse.error((IError)EHErrorEnum.DOCTOR_ID_MUST);
        }
        ListDoctorVO listDoctorVO = this.doctorMapper.RemoteClcDoctorInfo(dto);
        if (null == listDoctorVO) {
            return BaseResponse.error((IError)EHErrorEnum.NOT_OPENED_YCMZ);
        }
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setSize((long)dto.getPageSize().intValue());
        page.setCurrent((long)dto.getPageNum().intValue());
        IPage detailsInfoVOS = null;
        if (dto.getSourceType() == 1) {
            detailsInfoVOS = this.doctorMapper.listAppRemoteClcDoctorInfo(page, dto);
        } else if (dto.getSourceType() == 2) {
            detailsInfoVOS = this.doctorMapper.listWebRemoteClcDoctorInfo(page, dto);
        }
        if (null == detailsInfoVOS || detailsInfoVOS.getRecords().isEmpty()) {
            return BaseResponse.success((Object)new PageResult());
        }
        PageResult result = new PageResult();
        result.setContent(detailsInfoVOS.getRecords());
        result.setPageNum((int)detailsInfoVOS.getCurrent());
        result.setPageSize((int)detailsInfoVOS.getSize());
        result.setTotal((int)detailsInfoVOS.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<List<ManagerDoctorListVO>> queryOrganDoctorList(Integer organId) {
        List data = this.doctorMapper.queryOrganDoctorList(organId);
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<List<ListDoctorVO>> fuzzyQueryDoctorList(FuzzyQueryDoctorDTO dto) {
        this.logger.info("=================\u6a21\u7cca\u67e5\u8be2\u533b\u751f\u5217\u8868\uff0cparam = {} ==================");
        List doctorVOS = this.doctorMapper.fuzzyQueryDoctorList(dto);
        if (null == dto.getDoctorId() || 0 == dto.getDoctorId()) {
            this.logger.info("========================\u8d85\u7ba1\u7aef\u67e5\u8be2\u533b\u751f\u5217\u8868\uff0c\u8df3\u8fc7\u597d\u53cb\u5173\u7cfb\u5bf9\u6bd4=============================");
            return BaseResponse.success((Object)doctorVOS);
        }
        if (null == doctorVOS || doctorVOS.isEmpty()) {
            return BaseResponse.success(null);
        }
        try {
            for (ListDoctorVO vo : doctorVOS) {
                BaseResponse relation = this.byhUserRelationShipClient.isFreind(Long.valueOf(dto.getDoctorId().longValue()), Long.valueOf(vo.getDoctorId().longValue()));
                if (null == relation.getData()) {
                    vo.setIsFriend(Integer.valueOf(0));
                    continue;
                }
                vo.setIsFriend(Integer.valueOf(1));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return BaseResponse.error((IError)IError.FEIGN_FAIL);
        }
        return BaseResponse.success((Object)doctorVOS);
    }

    public BaseResponse<PageResult<ListDoctorVO>> listFamousDoctorInfo(ListFamousDoctorDTO dto) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setSize((long)dto.getPageSize().intValue());
        page.setCurrent((long)dto.getPageNum().intValue());
        if (StringUtils.isNotBlank((String)dto.getCity()) && "00".equals(dto.getCity().substring(4, 6))) {
            dto.setCity(dto.getCity().substring(0, 4));
            log.info("\u67e5\u8be2\u57ce\u5e02 code: {}", (Object)dto.getCity().substring(0, 4));
        }
        IPage detailsInfoVOS = null;
        if (dto.getSourceType() == 1) {
            if (null == dto.getServiceCode() || "".equals(dto.getServiceCode())) {
                detailsInfoVOS = this.doctorMapper.listAppAllFamousDoctorInfo(page, dto);
            } else {
                detailsInfoVOS = this.doctorMapper.listWebAllFamousDoctorInfo(page, dto);
                for (ListDoctorVO vo : detailsInfoVOS.getRecords()) {
                    if (IMAGE.equals(dto.getServiceCode())) {
                        vo.setGraphicStatus(Integer.valueOf(1));
                        Integer vedioStatus = this.doctorMapper.queryDoctorServiceStatusByCode(VIDEO, vo.getDoctorId());
                        vo.setVideoStatus(vedioStatus);
                    }
                    if (!VIDEO.equals(dto.getServiceCode())) continue;
                    vo.setVideoStatus(Integer.valueOf(1));
                    Integer graphicStatus = this.doctorMapper.queryDoctorServiceStatusByCode(IMAGE, vo.getDoctorId());
                    vo.setGraphicStatus(graphicStatus);
                }
            }
        } else if (dto.getSourceType() == 2) {
            detailsInfoVOS = this.doctorMapper.listWebAllFamousDoctorInfo(page, dto);
        }
        if (null == detailsInfoVOS || detailsInfoVOS.getRecords().isEmpty()) {
            return BaseResponse.success((Object)new PageResult());
        }
        PageResult result = new PageResult();
        result.setContent(detailsInfoVOS.getRecords());
        result.setPageNum((int)detailsInfoVOS.getCurrent());
        result.setPageSize((int)detailsInfoVOS.getSize());
        result.setTotal((int)detailsInfoVOS.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<PageResult<ListDoctorVO>> listSurgeryDoctor(DoctorNetworkClinicDTO dto) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)dto.getPageNum().intValue());
        page.setSize((long)dto.getPageSize().intValue());
        IPage data = this.doctorMapper.listSurgeryDoctorInfo(page, dto);
        if (null == data || data.getRecords().isEmpty()) {
            return BaseResponse.success((Object)new PageResult());
        }
        PageResult result = new PageResult();
        result.setContent(data.getRecords());
        result.setPageNum((int)data.getCurrent());
        result.setPageSize((int)data.getSize());
        result.setTotal((int)data.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<List<ListDoctorVO>> listDoctorByConsultationType(BaseDTO dto) {
        List result = new ArrayList();
        switch (dto.getCode()) {
            case "Video": {
                result = this.doctorMapper.queryVideoConsultationDoctorList(dto.getId());
                break;
            }
            case "Graphic": {
                result = this.doctorMapper.queryGraphicConsultationDoctorList(dto.getId());
                break;
            }
        }
        return BaseResponse.success(result);
    }

    public BaseResponse<DoctorDetailVO> queryDoctorDetails(QueryDoctorDTO dto) {
        DoctorDetailVO result = new DoctorDetailVO();
        DoctorDetailsInfoVO detailsInfoVO = this.doctorMapper.queryDoctorDetailsInfo(dto.getDoctorId());
        if (null == detailsInfoVO) {
            return BaseResponse.success(null);
        }
        DoctorTeamDetailVO doctorTeamDetailVO = this.doctorTeamInfoMapper.selectDoctorTeamDetail(Long.valueOf(dto.getDoctorId().longValue()));
        result.setDoctorTeamDetailVO(doctorTeamDetailVO);
        List hospitalMessageVOS = this.doctorMapper.queryDoctorHospitalMessage(dto.getDoctorId());
        List shcoolMessageVOS = this.doctorMapper.queryDoctorSchoolMessage(dto.getDoctorId());
        detailsInfoVO.setSchoolMessageVOS(shcoolMessageVOS);
        detailsInfoVO.setHospitalMessageVOs(hospitalMessageVOS);
        DoctorConsultationServiceInfoVO serviceInfoVO = new DoctorConsultationServiceInfoVO();
        if (detailsInfoVO.getDoctorType() == 1) {
            serviceInfoVO = this.doctorMapper.listDoctorServiceInfo(dto.getDoctorId());
        } else if (detailsInfoVO.getDoctorType() == 2) {
            serviceInfoVO = this.doctorMapper.listFamousDoctorServiceInfo(dto.getDoctorId());
        }
        DoctorRegisterInfoVO registerInfoVO = new DoctorRegisterInfoVO();
        if (null != dto.getUserDoctorId()) {
            BaseResponse relation = this.byhUserRelationShipClient.isFreind(Long.valueOf(dto.getUserDoctorId().longValue()), Long.valueOf(dto.getDoctorId().longValue()));
            if (null == relation.getData()) {
                result.setIsFriend(Integer.valueOf(0));
            } else {
                result.setIsFriend(Integer.valueOf(1));
            }
        }
        result.setDetailsInfoVO(detailsInfoVO);
        result.setServiceInfoVO(serviceInfoVO);
        result.setRegisterInfoVO(registerInfoVO);
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<DoctorUserInfoVO> queryDoctorUserInfo(Integer doctorId) {
        DoctorInfoEntity entity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)doctorId);
        if (null == entity) {
            return BaseResponse.success(null);
        }
        OrganizationEntity organ = this.doctorMapper.queryHospitalNameById(entity.getOrganId());
        DoctorUserInfoVO vo = new DoctorUserInfoVO();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        vo.setHospitalId(entity.getOrganId());
        vo.setHospitalName(organ.getOrganName());
        vo.setHospitalCode(organ.getOrganCode());
        return BaseResponse.success((Object)vo);
    }

    public BaseResponse<DoctorDetailsInfoVO> queryDoctorDetailsInfo(Integer doctorId) {
        DoctorDetailsInfoVO detailsInfoVO = this.doctorMapper.queryDoctorDetailsInfo(doctorId);
        if (null == detailsInfoVO) {
            return BaseResponse.success(null);
        }
        return BaseResponse.success((Object)detailsInfoVO);
    }

    public BaseResponse<DoctorEntityInfoVO> queryDoctorAllInfo(Integer doctorId) {
        DoctorInfoEntity entity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)doctorId);
        if (null == entity) {
            return BaseResponse.success(null);
        }
        DoctorEntityInfoVO vo = new DoctorEntityInfoVO();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        return BaseResponse.success((Object)vo);
    }

    public BaseResponse<List<Integer>> searchDoctorIds(DoctorSearchDTO dto) {
        List doctorIds = new ArrayList();
        if (dto.getType() == 1) {
            doctorIds = this.doctorMapper.searchDoctorIdsByAreaCode(dto.getSearchParam());
            return BaseResponse.success(doctorIds);
        }
        doctorIds = this.doctorMapper.searchDoctorIdsByParam(dto.getSearchParam());
        return BaseResponse.success(doctorIds);
    }

    public BaseResponse<List<ListProvinceVO>> queryRegionInfo() {
        List list = this.doctorMapper.listPrivenceInfo();
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<List<ListCityVO>> queryCityInfoByProvince(String privinceCode) {
        if ("900".equals(privinceCode)) {
            List cityVOS = this.doctorMapper.listHotCityInfo();
            return BaseResponse.success((Object)cityVOS);
        }
        List list = this.doctorMapper.listCityInfo(privinceCode);
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<List<ListAreaVO>> queryAreaListInfo() {
        ArrayList<ListAreaVO> result = new ArrayList<ListAreaVO>();
        List provinceVOS = this.doctorMapper.listPrivenceInfo();
        for (ListProvinceVO provinceVO : provinceVOS) {
            ListAreaVO areaVO = new ListAreaVO();
            BeanUtils.copyProperties((Object)provinceVO, (Object)areaVO);
            List cityVOS = this.doctorMapper.listCityInfo(provinceVO.getProvinceCode());
            areaVO.setCityVOS(cityVOS);
            result.add(areaVO);
        }
        return BaseResponse.success(result);
    }

    public BaseResponse<List<ListAreaVO>> queryDistrictInfo() {
        ArrayList<ListAreaVO> result = new ArrayList<ListAreaVO>();
        List provinceVOS = this.doctorMapper.listPrivenceInfo();
        for (ListProvinceVO provinceVO : provinceVOS) {
            ListAreaVO areaVO = new ListAreaVO();
            BeanUtils.copyProperties((Object)provinceVO, (Object)areaVO);
            List cityVOS = this.doctorMapper.listCityInfo(provinceVO.getProvinceCode());
            for (ListCityVO cityVO : cityVOS) {
                List districtVOS = this.doctorMapper.listDistrictInfo(cityVO.getCityCode());
                cityVO.setDistrictVOS(districtVOS);
            }
            areaVO.setCityVOS(cityVOS);
            result.add(areaVO);
        }
        return BaseResponse.success(result);
    }

    public BaseResponse<AreaInfoVO> queryAreaByDistrictCode(AreaInfoDTO dto) {
        AreaInfoVO vo = new AreaInfoVO();
        if (null != dto.getDistrictCode() && !"".equals(dto.getDistrictCode())) {
            vo = this.doctorMapper.queryAreaInfoByDistrictCode(dto);
        } else if (null != dto.getCityCode() && !"".equals(dto.getCityCode())) {
            vo = this.doctorMapper.queryAreaInfoByCityCode(dto);
        }
        return BaseResponse.success((Object)vo);
    }

    public BaseResponse<List<DoctorServiceInfoVO>> queryDoctorServiceInfo(Integer doctorId) {
        List doctorServiceInfoVOS = this.doctorMapper.queryDoctorServiceInfo(doctorId);
        for (DoctorServiceInfoVO vo : doctorServiceInfoVOS) {
            List servicePriceVOS = this.doctorMapper.queryServicePriceByDoctorId(doctorId, vo.getServiceCode());
            vo.setServicePriceVOS(servicePriceVOS);
        }
        return BaseResponse.success((Object)doctorServiceInfoVOS);
    }

    public BaseResponse<List<PointDoctorServiceInfoVO>> queryDoctorServInfoByServCode(List<QueryPiontServiceDTO> list) {
        ArrayList<PointDoctorServiceInfoVO> data = new ArrayList<PointDoctorServiceInfoVO>();
        for (QueryPiontServiceDTO dto : list) {
            PointDoctorServiceInfoVO vo = this.doctorMapper.queryDoctorServInfoByServCode(dto);
            data.add(vo);
        }
        return BaseResponse.success(data);
    }

    public BaseResponse<String> updateDoctorBalanceInfo(UpdateBalanceDTO dto) {
        if (dto.getDoctorId() == null || dto.getBalance() == null) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        DoctorInfoEntity entity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)dto.getDoctorId());
        DocBalanceLogEntity docBalanceLogEntity = new DocBalanceLogEntity();
        docBalanceLogEntity.setDoctorId(entity.getId());
        docBalanceLogEntity.setBalance(entity.getBalance());
        log.info("{}\u533b\u751f\u8bbe\u7f6e\u4f59\u989d,\u8bbe\u7f6e\u524d:{}", (Object)entity.getId(), (Object)entity.getBalance());
        entity.setBalance(dto.getBalance());
        this.doctorMapper.updateById((Object)entity);
        docBalanceLogEntity.setModifyBalance(dto.getBalance());
        docBalanceLogEntity.setBusinessCode(ServiceCodeEnum.YLTSPHZ.getServiceCode());
        this.saveDocBalanceLog(docBalanceLogEntity);
        log.info("{}\u533b\u751f\u8bbe\u7f6e\u4f59\u989d,\u8bbe\u7f6e\u540e:{}", (Object)entity.getId(), (Object)entity.getBalance());
        return BaseResponse.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    public BaseResponse<List<DoctorServicesRes>> queryDictionaryByParentCode(Long doctorId, String parentCode) {
        ArrayList<DoctorServicesRes> list = new ArrayList<DoctorServicesRes>();
        List dictionaryEntities = this.doctorMapper.queryByParentCode(parentCode);
        if (null != dictionaryEntities && dictionaryEntities.size() > 0) {
            for (DictionaryEntity dictionaryEntity : dictionaryEntities) {
                DoctorServicesRes doctorServicesRes = new DoctorServicesRes();
                BeanUtils.copyProperties((Object)dictionaryEntity, (Object)doctorServicesRes);
                DoctorConsultationServiceInfoEntity doctorConsultationServiceInfoEntity = this.doctorConsultationServiceInfoEntityMapper.selectByDoctorId(doctorId, dictionaryEntity.getDicCode());
                if (null != doctorConsultationServiceInfoEntity && null != doctorConsultationServiceInfoEntity.getAmount()) {
                    doctorServicesRes.setAmount(doctorConsultationServiceInfoEntity.getAmount());
                }
                list.add(doctorServicesRes);
            }
        }
        return BaseResponse.success(list);
    }

    @Transactional
    public BaseResponse<Boolean> doctorServiceSynchro(InDoServiceStatus inDoServiceStatus) {
        log.info("\u8c03\u7528\u5b57\u5178\u8868\u83b7\u53d6\u670d\u52a1\u540d\u79f0");
        String groupName = "";
        DictionaryEntity dictionaryEntity = this.doctorMapper.queryByDicCode(inDoServiceStatus.getGroupCode());
        if (null != dictionaryEntity) {
            groupName = dictionaryEntity.getDicName();
        }
        log.info("\u63d2\u5165\u6216\u8005\u66f4\u65b0\u4f1a\u8bca\u670d\u52a1");
        if (null != inDoServiceStatus.getList() && inDoServiceStatus.getList().size() > 0) {
            DoctorConsultationServiceInfoEntity doctorConsultationServiceInfoEntity = new DoctorConsultationServiceInfoEntity();
            doctorConsultationServiceInfoEntity.setDoctorId(inDoServiceStatus.getDoctorId());
            doctorConsultationServiceInfoEntity.setGroupCode(Long.valueOf(inDoServiceStatus.getGroupCode()));
            doctorConsultationServiceInfoEntity.setGroupName(groupName);
            List serviceCodeAndAmounts = inDoServiceStatus.getList();
            serviceCodeAndAmounts.forEach(e -> {
                DoctorConsultationServiceInfoEntity dcsie = this.doctorConsultationServiceInfoEntityMapper.selectByDoctorId(inDoServiceStatus.getDoctorId(), e.getServiceCode());
                doctorConsultationServiceInfoEntity.setAmount(e.getAmount());
                doctorConsultationServiceInfoEntity.setServiceCode(Long.valueOf(e.getServiceCode()));
                DictionaryEntity de = this.doctorMapper.queryByDicCode(e.getServiceCode());
                if (null != de) {
                    doctorConsultationServiceInfoEntity.setServiceName(de.getDicName());
                }
                if (null == dcsie) {
                    this.doctorConsultationServiceInfoEntityMapper.insertSelective(doctorConsultationServiceInfoEntity);
                } else {
                    this.doctorConsultationServiceInfoEntityMapper.updateByDoctorId(doctorConsultationServiceInfoEntity);
                }
            });
        }
        return BaseResponse.success();
    }

    public BaseResponse<DoctorServiceInfoVO> queryAllServiceInfo(QueryPiontServiceDTO dto) {
        DoctorServiceInfoVO doctorServiceInfoVO;
        if ("111".equals(dto.getServiceCode()) || "101".equals(dto.getServiceCode())) {
            dto.setServiceCode("51110");
        }
        if ("113".equals(dto.getServiceCode()) || "103".equals(dto.getServiceCode())) {
            dto.setServiceCode("51120");
        }
        if ("107".equals(dto.getServiceCode())) {
            dto.setServiceCode(VIDEO);
        }
        if ("105".equals(dto.getServiceCode())) {
            dto.setServiceCode(IMAGE);
        }
        if ("121".equals(dto.getServiceCode()) || "123".equals(dto.getServiceCode())) {
            dto.setServiceCode("51130");
        }
        if (Objects.isNull(doctorServiceInfoVO = this.docDoctorWorkingServiceMapper.selectByDoctorId(dto.getDoctorId() + "", dto.getServiceCode()))) {
            doctorServiceInfoVO = new DoctorServiceInfoVO();
            doctorServiceInfoVO.setServiceCode(dto.getServiceCode());
            doctorServiceInfoVO.setServiceName("");
            doctorServiceInfoVO.setStatus(Integer.valueOf(0));
        }
        return BaseResponse.success((Object)doctorServiceInfoVO);
    }

    public BaseResponse<PageResult<UserDoctorVo>> getListDoctorInfoByNameAndCode(ListDoctReq req) {
        req.setStatus(ListDoctReq.STATUS_VALID);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)req.getPageNum().intValue());
        page.setSize((long)req.getPageSize().intValue());
        IPage data = this.doctorMapper.getListDoctorInfoByNameAndCode(page, req);
        if (null == data || data.getRecords().isEmpty()) {
            return BaseResponse.success((Object)new PageResult());
        }
        PageResult result = new PageResult();
        result.setContent(data.getRecords());
        result.setPageNum((int)data.getCurrent());
        result.setPageSize((int)data.getSize());
        result.setTotal((int)data.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<PageResult<UserDoctorVo>> getListDoctorByNameAndCode(ListDoctReq req) {
        req.setStatus(ListDoctReq.STATUS_VALID);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)req.getPageNum().intValue());
        page.setSize((long)req.getPageSize().intValue());
        IPage data = this.doctorMapper.getListDoctorByNameAndCode(page, req);
        if (null == data || data.getRecords().isEmpty()) {
            return BaseResponse.success((Object)new PageResult());
        }
        PageResult result = new PageResult();
        result.setContent(data.getRecords());
        result.setPageNum((int)data.getCurrent());
        result.setPageSize((int)data.getSize());
        result.setTotal((int)data.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<PageResult<UserDoctorVo>> getListDoctorByNameAndCodeHy(ListDoctReq req) {
        req.setStatus(ListDoctReq.STATUS_VALID);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)req.getPageNum().intValue());
        page.setSize((long)req.getPageSize().intValue());
        IPage data = this.doctorMapper.getListDoctorByNameAndCodeHy(page, req);
        if (null == data || data.getRecords().isEmpty()) {
            return BaseResponse.success((Object)new PageResult());
        }
        PageResult result = new PageResult();
        result.setContent(data.getRecords());
        result.setPageNum((int)data.getCurrent());
        result.setPageSize((int)data.getSize());
        result.setTotal((int)data.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<PageResult<ListDoctorVO>> listSurgeryDoctorHy(DoctorNetworkClinicDTO dto) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)dto.getPageNum().intValue());
        page.setSize((long)dto.getPageSize().intValue());
        IPage data = this.doctorMapper.listSurgeryDoctorInfoHy(page, dto);
        if (null == data || data.getRecords().isEmpty()) {
            return BaseResponse.success((Object)new PageResult());
        }
        PageResult result = new PageResult();
        result.setContent(data.getRecords());
        result.setPageNum((int)data.getCurrent());
        result.setPageSize((int)data.getSize());
        result.setTotal((int)data.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<PageResult<UserDoctorVo>> getListDoctorByNameAndCodeNy(ListDoctReq req) {
        req.setStatus(ListDoctReq.STATUS_VALID);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)req.getPageNum().intValue());
        page.setSize((long)req.getPageSize().intValue());
        IPage data = this.doctorMapper.getListDoctorByNameAndCodeNy(page, req);
        if (null == data || data.getRecords().isEmpty()) {
            return BaseResponse.success((Object)new PageResult());
        }
        PageResult result = new PageResult();
        result.setContent(data.getRecords());
        result.setPageNum((int)data.getCurrent());
        result.setPageSize((int)data.getSize());
        result.setTotal((int)data.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<PageResult<UserDoctorVo>> getListDoctorByNameAndCodeZryh(ListDoctReq req) {
        req.setStatus(ListDoctReq.STATUS_VALID);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setCurrent((long)req.getPageNum().intValue());
        page.setSize((long)req.getPageSize().intValue());
        IPage data = this.doctorMapper.getListDoctorByNameAndCodeZryh(page, req);
        if (null == data || data.getRecords().isEmpty()) {
            return BaseResponse.success((Object)new PageResult());
        }
        PageResult result = new PageResult();
        result.setContent(data.getRecords());
        result.setPageNum((int)data.getCurrent());
        result.setPageSize((int)data.getSize());
        result.setTotal((int)data.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<PageResult<BaseDoctorInfoVo>> getOrganDoctorList(DoctorInfoQuery doctorInfoQuery) {
        PageHelper.startPage((int)doctorInfoQuery.getPageNum(), (int)doctorInfoQuery.getPageSize());
        doctorInfoQuery.setStatus(1);
        Page page = this.doctorMapper.getOrganDoctorList(doctorInfoQuery);
        PageResult pageResult = new PageResult();
        pageResult.setPageNum(doctorInfoQuery.getPageNum());
        pageResult.setPageSize(doctorInfoQuery.getPageSize());
        pageResult.setContent(page.getResult());
        pageResult.setTotal((int)page.getTotal());
        pageResult.setTotalPages(page.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<List<BaseDoctorInfoVo>> getDoctorListByParams(DoctorInfoQuery doctorInfoQuery) {
        doctorInfoQuery.setStatus(1);
        return BaseResponse.success((Object)this.doctorMapper.getOrganDoctorList(doctorInfoQuery));
    }

    public BaseResponse<List<DoctorBasicInfoVo>> getBusinessDoctorList(BusinessDoctorListQuery businessDoctorListQuery) {
        businessDoctorListQuery.setStatus(1);
        List doctorInfoList = this.doctorMapper.getBusinessDoctorList(businessDoctorListQuery);
        List organIds = doctorInfoList.stream().map(DoctorInfoEntity::getOrganId).map(Long::valueOf).collect(Collectors.toList());
        Map organsMap = new HashMap();
        if (!organIds.isEmpty()) {
            organsMap = this.organizationMapper.getOrgansByIds(organIds);
        }
        ArrayList<DoctorBasicInfoVo> resultList = new ArrayList<DoctorBasicInfoVo>();
        for (DoctorInfoEntity record : doctorInfoList) {
            DoctorBasicInfoVo doctorBasicInfoVo = new DoctorBasicInfoVo();
            OrganizationEntity organizationEntity = (OrganizationEntity)organsMap.get(record.getOrganId());
            doctorBasicInfoVo.setOrganName(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganName());
            this.convertDoctorEntity2DoctorBase(record, doctorBasicInfoVo);
            resultList.add(doctorBasicInfoVo);
        }
        return BaseResponse.success(resultList);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public BaseResponse sortOrganDoctor(SortOrganDoctorVo sortOrganDoctorVo) {
        String serviceCode;
        Long organId = sortOrganDoctorVo.getOrganId();
        OrganWorkingServiceEntity organService = this.organWorkingServiceMapper.getServiceByOrganId(organId, serviceCode = sortOrganDoctorVo.getServiceCode(), "1,-1");
        if (Objects.isNull(organService) || 1 != organService.getStatus()) {
            return BaseResponse.error((IError)EHErrorEnum.DOC_SERVICE_NOT_OPEN);
        }
        int init = this.docDoctorWorkingServiceMapper.initDoctorServiceSeq(organService.getxId(), 0);
        log.info("\u533b\u751f\u670d\u52a1\u521d\u59cb\u5316\u6392\u5e8f\u6267\u884c\u6570\u91cf:{}", (Object)init);
        List doctorIds = sortOrganDoctorVo.getDoctorIds();
        for (int i = 0; i < doctorIds.size(); ++i) {
            List doctorServiceList = this.docDoctorWorkingServiceMapper.getDocServiceByDocIdAndServId((Long)doctorIds.get(i), organService.getxId(), 1);
            for (DocDoctorWorkingServiceEntity doctorWorkingService : doctorServiceList) {
                DoctorWorkingServiceDo doctorWorkingServiceDo = new DoctorWorkingServiceDo();
                doctorWorkingServiceDo.setxId(doctorWorkingService.getxId());
                doctorWorkingServiceDo.setSeq(Integer.valueOf((doctorIds.size() - i) * 10));
                this.docDoctorWorkingServiceMapper.updateByPrimaryKeySelective(doctorWorkingServiceDo);
            }
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<DoctorBasicInfoVo>> getSortedOrganDoctor(Long organId, String serviceCode) {
        OrganWorkingServiceEntity organService = this.organWorkingServiceMapper.getServiceByOrganId(organId, serviceCode, String.valueOf(1));
        if (Objects.isNull(organService)) {
            return BaseResponse.error((IError)EHErrorEnum.DOC_SERVICE_NOT_OPEN);
        }
        ArrayList<DoctorBasicInfoVo> resultList = new ArrayList<DoctorBasicInfoVo>();
        List doctorIds = this.docDoctorWorkplacesMapper.getSortedOrganDoctor(organId, organService.getxId(), 1);
        if (!doctorIds.isEmpty()) {
            List doctorInfoList = this.doctorMapper.getDoctorListByIds(doctorIds);
            Map doctorMap = doctorInfoList.stream().filter(doctorInfoEntity -> 1 == doctorInfoEntity.getStatus()).collect(Collectors.toMap(DoctorInfoEntity::getId, Function.identity()));
            for (Long doctorId : doctorIds) {
                DoctorInfoEntity doctorInfoEntity2 = (DoctorInfoEntity)doctorMap.get(doctorId);
                if (!Objects.nonNull(doctorInfoEntity2)) continue;
                DoctorBasicInfoVo doctorBasicInfoVo = new DoctorBasicInfoVo();
                this.convertDoctorEntity2DoctorBase(doctorInfoEntity2, doctorBasicInfoVo);
                resultList.add(doctorBasicInfoVo);
            }
        }
        return BaseResponse.success(resultList);
    }

    private void convertDoctorEntity2DoctorBase(DoctorInfoEntity doctorInfoEntity, DoctorBasicInfoVo doctorBasicInfoVo) {
        doctorBasicInfoVo.setCountry("0");
        doctorBasicInfoVo.setDeptId(Long.valueOf(doctorInfoEntity.getHospitalDeptId().intValue()));
        doctorBasicInfoVo.setDeptName(doctorInfoEntity.getHospitalDeptName());
        doctorBasicInfoVo.setDoctorName(doctorInfoEntity.getName());
        doctorBasicInfoVo.setDoctorCode(String.valueOf(doctorInfoEntity.getId()));
        doctorBasicInfoVo.setEmail(doctorInfoEntity.getEmail());
        doctorBasicInfoVo.setGender(doctorInfoEntity.getGender());
        doctorBasicInfoVo.setIntroduction(doctorInfoEntity.getProfile());
        doctorBasicInfoVo.setOrganId(Long.valueOf(doctorInfoEntity.getOrganId().intValue()));
        doctorBasicInfoVo.setStandardTitle(doctorInfoEntity.getProfession());
        doctorBasicInfoVo.setPortrait(doctorInfoEntity.getHeadPortrait());
        doctorBasicInfoVo.setProfession(doctorInfoEntity.getSpeciality());
        doctorBasicInfoVo.setTelephone(doctorInfoEntity.getRegisterMobile());
        doctorBasicInfoVo.setXId(doctorInfoEntity.getId());
        doctorBasicInfoVo.setStdFirstDeptName(doctorInfoEntity.getStdFirstDeptName());
    }

    private void executeWorkPlacesUpdate(DoctorInfoEntity entity) {
        List doctorWorkplaces = this.docDoctorWorkplacesMapper.getDoctorWorkplaces(entity.getId());
        List existDoctorWorkplace = doctorWorkplaces.stream().filter(item -> item.getOrganId().intValue() == entity.getOrganId().intValue()).collect(Collectors.toList());
        this.docDoctorWorkplacesMapper.updateDoctorWorkplaces(entity.getId(), -1);
        if (existDoctorWorkplace.isEmpty()) {
            DocDoctorWorkplacesEntity doctorWorkplacesEntity = new DocDoctorWorkplacesEntity();
            doctorWorkplacesEntity.setDoctorId(entity.getId());
            doctorWorkplacesEntity.setOrganId(Long.valueOf(entity.getOrganId().longValue()));
            doctorWorkplacesEntity.setStatus(Byte.valueOf((byte)1));
            doctorWorkplacesEntity.setxCreateTime(new Date());
            doctorWorkplacesEntity.setxUpdateTime(new Date());
            doctorWorkplacesEntity.setxVersion(Long.valueOf(1L));
            doctorWorkplacesEntity.setxRemark("");
            this.docDoctorWorkplacesMapper.insertSelective(doctorWorkplacesEntity);
            this.executeWorkplacesInfo(doctorWorkplacesEntity.getxId(), entity);
        } else {
            for (DocDoctorWorkplacesEntity workplacesEntity : existDoctorWorkplace) {
                workplacesEntity.setStatus(Byte.valueOf((byte)1));
                this.docDoctorWorkplacesMapper.updateByPrimaryKeySelective(workplacesEntity);
                this.executeWorkplacesInfo(workplacesEntity.getxId(), entity);
            }
        }
    }

    private void executeWorkplacesInfo(Long workPlacesId, DoctorInfoEntity entity) {
        DocDoctorWorkplacesInfo workPlacesDeptInfo;
        Long deptId = (long)entity.getHospitalDeptId();
        DocDoctorWorkplacesInfo doctorWorkplacesInfo = this.doctorWorkplacesInfoMapper.getByWorkInfoIdAndDefault(workPlacesId, 1);
        if (Objects.nonNull(doctorWorkplacesInfo) && doctorWorkplacesInfo.getDeptId().intValue() == entity.getHospitalDeptId().intValue()) {
            return;
        }
        if (Objects.nonNull(doctorWorkplacesInfo)) {
            this.doctorWorkplacesInfoMapper.deleteByPrimaryKey(doctorWorkplacesInfo.getXId());
        }
        if (Objects.nonNull(workPlacesDeptInfo = this.doctorWorkplacesInfoMapper.getByWorkPlacesIdAndDeptId(workPlacesId, deptId))) {
            workPlacesDeptInfo.setIsDefault(Integer.valueOf(1));
            this.doctorWorkplacesInfoMapper.updateByPrimaryKeySelective(workPlacesDeptInfo);
        } else {
            doctorWorkplacesInfo = new DocDoctorWorkplacesInfo();
            doctorWorkplacesInfo.setDeptId(deptId);
            doctorWorkplacesInfo.setDeptName(entity.getHospitalDeptName());
            doctorWorkplacesInfo.setDoctorCode(entity.getEmplCode());
            doctorWorkplacesInfo.setDoctorWorkplaces(workPlacesId);
            doctorWorkplacesInfo.setIntroduction(entity.getPersonalizedSignature());
            doctorWorkplacesInfo.setIsDefault(Integer.valueOf(1));
            doctorWorkplacesInfo.setProfession(entity.getProfession());
            doctorWorkplacesInfo.setProfessionCode(entity.getProfessionCode());
            doctorWorkplacesInfo.setShareCode("");
            doctorWorkplacesInfo.setXCreateTime(new Date());
            doctorWorkplacesInfo.setXUpdateTime(new Date());
            doctorWorkplacesInfo.setXVersion(Long.valueOf(1L));
            doctorWorkplacesInfo.setXRemark("");
            this.doctorWorkplacesInfoMapper.insertSelective(doctorWorkplacesInfo);
        }
        this.docDoctorServiceAccessMapper.batchUpdateStatusByDoctorWorkId(workPlacesId, -1);
        this.docDoctorWorkingServiceMapper.updateStatusByDoctorWorkId(workPlacesId, -1);
    }

    public BaseResponse<DoctorInfoHomeVo> getDoctorInfoHome(Long doctorId) {
        DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)doctorId);
        DoctorInfoHomeVo doctorInfoHome = null;
        if (Objects.nonNull(doctorInfoEntity)) {
            DictionaryEntity profession;
            BaseResponse doctorAverageScore;
            OrganizationEntity organizationEntity;
            doctorInfoHome = new DoctorInfoHomeVo();
            doctorInfoHome.setDoctorId(doctorInfoEntity.getId());
            doctorInfoHome.setDoctorName(doctorInfoEntity.getName());
            doctorInfoHome.setProfession(doctorInfoEntity.getProfession());
            doctorInfoHome.setSpeciality(doctorInfoEntity.getSpeciality());
            doctorInfoHome.setStdFirstDeptId(Long.valueOf(doctorInfoEntity.getStdFirstDeptId().intValue()));
            doctorInfoHome.setStdFirstDeptName(doctorInfoEntity.getStdFirstDeptName());
            doctorInfoHome.setStdSecondDeptId(Long.valueOf(doctorInfoEntity.getStdSecondDeptId().intValue()));
            doctorInfoHome.setStdSecondDeptName(doctorInfoEntity.getStdSecondDeptName());
            doctorInfoHome.setSynopsis(doctorInfoEntity.getProfile());
            doctorInfoHome.setBadgeImage(doctorInfoEntity.getBadgeImage());
            doctorInfoHome.setDepartment(doctorInfoEntity.getHospitalDeptName());
            doctorInfoHome.setPortrait(doctorInfoEntity.getHeadPortrait());
            doctorInfoHome.setHospitalDeptId(Long.valueOf(doctorInfoEntity.getHospitalDeptId().intValue()));
            doctorInfoHome.setHospitalDeptName(doctorInfoEntity.getHospitalDeptName());
            doctorInfoHome.setEmplCode(doctorInfoEntity.getEmplCode());
            Integer doctorType = doctorInfoEntity.getDoctorType();
            doctorInfoHome.setExpertMark(Integer.valueOf(Objects.isNull(doctorType) ? 1 : doctorType));
            DepartmentEntity departmentEntity = this.departmentMapper.selectById(Long.valueOf(doctorInfoEntity.getHospitalDeptId().intValue()));
            if (Objects.nonNull(departmentEntity)) {
                doctorInfoHome.setDepartmentId(Long.valueOf(departmentEntity.getxId()));
                doctorInfoHome.setDeptLabel(departmentEntity.getLabel());
                doctorInfoHome.setDepartmentEnglish(departmentEntity.getEnglishName());
            }
            if (Objects.nonNull(organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorInfoEntity.getOrganId()))) {
                doctorInfoHome.setOrganId(Long.valueOf(organizationEntity.getId().intValue()));
                doctorInfoHome.setOrganName(organizationEntity.getOrganName());
            }
            if ((doctorAverageScore = this.UserEvaluationService.getDoctorAverageScore(String.valueOf(doctorId))).isSuccess()) {
                doctorInfoHome.setAverageScore((String)doctorAverageScore.getData());
            }
            if (Objects.nonNull(profession = this.dictionaryMapper.findByDicCodeAndTypeCode(doctorInfoEntity.getProfessionCode(), "100"))) {
                doctorInfoHome.setProfession(profession.getDicName());
                doctorInfoHome.setProfessionEnglish(profession.getRemark());
            }
            return BaseResponse.success((Object)doctorInfoHome);
        }
        return BaseResponse.success(doctorInfoHome);
    }

    public BaseResponse<DoctorInfoEntity> checkHealthDocService() {
        DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)Integer.valueOf(0));
        return BaseResponse.success((Object)doctorInfoEntity);
    }

    public BaseResponse<List<BaseDoctorInfoRespVO>> getDoctorByOccupation(Long organId, String occupationCode) {
        List doctorTitle = this.dictionaryMapper.getDictionaryByParentCode(occupationCode);
        if (doctorTitle.isEmpty()) {
            return BaseResponse.error((IError)IError.DATA_ERROR);
        }
        String titleCodes = doctorTitle.stream().map(DictionaryEntity::getDicCode).collect(Collectors.joining(","));
        List result = this.doctorMapper.getDoctorByOccupation(organId, titleCodes);
        return BaseResponse.success((Object)result);
    }

    public BaseResponse doctorOffline(Long id) {
        this.doctorMapper.updateStatusById(id, Integer.valueOf(-1));
        return BaseResponse.success();
    }

    public BaseResponse<Integer> updateInfoMsg(SaveDoctorInfoDTO dto) {
        log.info("\u66f4\u65b0info\u8868\u6570\u636e\u5165\u53c2:{}", (Object)JsonUtil.convertObject((Object)dto));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DoctorInfoEntity::getRegisterMobile, (Object)dto.getRegisterMobile());
        queryWrapper.lambda().eq(DoctorInfoEntity::getStatus, (Object)1);
        DoctorInfoEntity entity = (DoctorInfoEntity)this.doctorMapper.selectOne((Wrapper)queryWrapper);
        if (null != entity) {
            this.buildUpdateInfo(dto, entity);
            int i = this.doctorMapper.updateById((Object)entity);
            log.info("\u66f4\u65b0info\u8868\u6570\u636e\u8fd4\u53c2:{}", (Object)i);
            return BaseResponse.success((Object)i);
        }
        return BaseResponse.success();
    }

    public BaseResponse<Boolean> doctorAddInfoCheck(Long doctorId, Long organId) {
        OrganSupervisionVo organSupervisionVo = this.organizationMapper.selectOrganSupervVisionById(organId);
        if (Objects.nonNull(organSupervisionVo) && organSupervisionVo.getRegulatoryStatus() == 1) {
            if ("ZRYH".equals(organSupervisionVo.getAppCode())) {
                return this.ZrDoctorAddInfoCheck(doctorId, organId);
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(DoctorInfoEntity::getId, (Object)doctorId);
            queryWrapper.lambda().eq(DoctorInfoEntity::getOrganId, (Object)organId);
            DoctorInfoEntity entity = (DoctorInfoEntity)this.doctorMapper.selectOne((Wrapper)queryWrapper);
            if (Objects.isNull(entity)) {
                return BaseResponse.success((Object)Boolean.TRUE);
            }
            DoctorInfoCheckDTO checkDTO = new DoctorInfoCheckDTO();
            checkDTO.setCredNo(entity.getCredNo());
            checkDTO.setHeadPortrait(entity.getHeadPortrait());
            checkDTO.setDoctorworkDate(entity.getDoctorworkDate());
            checkDTO.setBadgeUrl(entity.getBadgeUrl());
            ValidateResult validate = ValidPropertyUtil.validate((Object)checkDTO);
            BaseResponse professionByTitle = this.dictionaryService.getProfessionByTitle(entity.getProfessionCode());
            DictionaryResp profession = (DictionaryResp)professionByTitle.getData();
            if (Objects.nonNull(profession)) {
                if ("100".equals(profession.getDicCode())) {
                    return BaseResponse.success((Object)(!validate.isSuccess() || !StringUtils.isNotBlank((String)entity.getDoctorWorkCode()) || !StringUtils.isNotBlank((String)entity.getDoctorCertCode()) ? 1 : 0));
                }
                if ("110".equals(profession.getDicCode())) {
                    return BaseResponse.success((Object)(!validate.isSuccess() || !StringUtils.isNotBlank((String)entity.getDoctorWorkCode()) ? 1 : 0));
                }
                if ("140".equals(profession.getDicCode())) {
                    return BaseResponse.success((Object)(!validate.isSuccess() || !StringUtils.isNotBlank((String)entity.getDoctorCertCode()) ? 1 : 0));
                }
            }
        }
        return BaseResponse.success((Object)Boolean.FALSE);
    }

    public BaseResponse<Boolean> ZrDoctorAddInfoCheck(Long doctorId, Long organId) {
        OrganSupervisionVo organSupervisionVo = this.organizationMapper.selectOrganSupervVisionById(organId);
        if (Objects.nonNull(organSupervisionVo) && organSupervisionVo.getRegulatoryStatus() == 1) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(DoctorInfoEntity::getId, (Object)doctorId);
            queryWrapper.lambda().eq(DoctorInfoEntity::getOrganId, (Object)organId);
            DoctorInfoEntity entity = (DoctorInfoEntity)this.doctorMapper.selectOne((Wrapper)queryWrapper);
            if (Objects.isNull(entity)) {
                return BaseResponse.error((IError)IError.DATA_ERROR);
            }
            ZRDocInfoCheckDTO checkDTO = new ZRDocInfoCheckDTO();
            checkDTO.setCredNo(entity.getCredNo());
            checkDTO.setBadgeUrl(entity.getBadgeUrl());
            checkDTO.setHeadPortrait(entity.getHeadPortrait());
            ValidateResult validate = ValidPropertyUtil.validate((Object)checkDTO);
            BaseResponse professionByTitle = this.dictionaryService.getProfessionByTitle(entity.getProfessionCode());
            DictionaryResp profession = (DictionaryResp)professionByTitle.getData();
            if (Objects.nonNull(profession)) {
                if ("100".equals(profession.getDicCode())) {
                    return BaseResponse.success((Object)(!validate.isSuccess() || !StringUtils.isNotBlank((String)entity.getDoctorWorkCode()) ? 1 : 0));
                }
                return BaseResponse.success((Object)(!validate.isSuccess() ? 1 : 0));
            }
        }
        return BaseResponse.success((Object)Boolean.FALSE);
    }

    public BaseResponse doctorOnline(Long id) {
        this.doctorMapper.updateStatusById(id, Integer.valueOf(1));
        return BaseResponse.success();
    }

    @Async
    public void saveDocBalanceLog(DocBalanceLogEntity docBalanceLogEntity) {
        log.info("\u6dfb\u52a0\u4f59\u989d\u64cd\u4f5c\u8bb0\u5f55,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)docBalanceLogEntity));
        this.doctorMapper.insertDocBalanceLog(docBalanceLogEntity);
    }

    private void buildUpdateInfo(SaveDoctorInfoDTO doctorInfoBo, DoctorInfoEntity doctorInfoEntity) {
        if (StringUtil.isNotEmpty((String)doctorInfoBo.getEmplCode())) {
            doctorInfoEntity.setEmplCode(doctorInfoBo.getEmplCode());
        }
        if (StringUtil.isNotEmpty((String)doctorInfoBo.getProfessionCode())) {
            doctorInfoEntity.setProfessionCode(doctorInfoBo.getProfessionCode());
        }
        if (StringUtil.isNotEmpty((String)doctorInfoBo.getProfession())) {
            doctorInfoEntity.setProfession(doctorInfoBo.getProfession());
        }
        if (StringUtil.isNotEmpty((String)doctorInfoBo.getSpeciality())) {
            doctorInfoEntity.setSpeciality(doctorInfoBo.getSpeciality());
        }
        if (StringUtil.isNotEmpty((String)doctorInfoBo.getProfile())) {
            doctorInfoEntity.setProfile(doctorInfoBo.getProfile());
        }
        if (StringUtil.isNotEmpty((String)doctorInfoBo.getDoctorCertCode())) {
            doctorInfoEntity.setDoctorCertCode(doctorInfoBo.getDoctorCertCode());
        }
        if (StringUtil.isNotEmpty((String)doctorInfoBo.getDoctorWorkCode())) {
            doctorInfoEntity.setDoctorWorkCode(doctorInfoBo.getDoctorWorkCode());
        }
        if (null != doctorInfoBo.getDoctorworkDate()) {
            doctorInfoEntity.setDoctorworkDate(doctorInfoBo.getDoctorworkDate());
        }
        if (StringUtil.isNotEmpty((String)doctorInfoBo.getCredNo())) {
            doctorInfoEntity.setCredNo(doctorInfoBo.getCredNo());
        }
        if (StringUtil.isNotEmpty((String)doctorInfoBo.getCredType())) {
            doctorInfoEntity.setCredType(doctorInfoBo.getCredType());
        }
    }

    public BaseResponse<BaseDoctorInfoRespVO> getDoctorInfoByCode(String doctorCode, Long organId) {
        BaseDoctorInfoRespVO baseDoctorInfoRespVO = this.doctorMapper.getDoctorInfoByCode(doctorCode, organId);
        return BaseResponse.success((Object)baseDoctorInfoRespVO);
    }

    public BaseResponse<String> getDoctorPhone(Long doctorId) {
        DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)doctorId);
        return BaseResponse.success((Object)doctorInfoEntity.getRegisterMobile());
    }

    public List<DoctorPostRepVO> getDoctorPostAndCreditCardByDoctorIds(List<String> doctorIds) {
        return this.doctorMapper.selectDoctorPostAndCreditCardByIds(doctorIds);
    }

    public BaseResponse updateDoctorPostAndCreditCardById(String post, String creditCard, String doctorId) {
        this.doctorMapper.updatePostAndCreditCardById(post, creditCard, doctorId);
        return BaseResponse.success();
    }

    public BaseResponse<PageResult<RetBusinessDoctorListVo>> getMedicalDoctorList(GetBusinessDoctorListVo getBusinessDoctorListVo) {
        PageHelper.startPage((int)getBusinessDoctorListVo.getPageNum(), (int)getBusinessDoctorListVo.getPageSize());
        Page retBusinessDoctorListVoList = (Page)this.doctorMapper.selectMedicalDoctorList(getBusinessDoctorListVo);
        if (!retBusinessDoctorListVoList.isEmpty() && null != getBusinessDoctorListVo.getServiceCode()) {
            ConsultationServiceEnum byServiceCode = ConsultationServiceEnum.getByServiceCode((String)getBusinessDoctorListVo.getServiceCode());
            this.getPriceAndOrganConfig(retBusinessDoctorListVoList.getResult(), String.valueOf(byServiceCode.getConsultationServiceCode()), getBusinessDoctorListVo.getServiceCode());
        }
        PageResult pageResult = new PageResult();
        pageResult.setContent(retBusinessDoctorListVoList.getResult());
        pageResult.setPageNum(retBusinessDoctorListVoList.getPageNum());
        pageResult.setPageSize(retBusinessDoctorListVoList.getPageSize());
        pageResult.setTotal((int)retBusinessDoctorListVoList.getTotal());
        pageResult.setTotalPages(retBusinessDoctorListVoList.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<PageResult<RetBusinessDoctorListVo>> getExpertsDoctorList(GetBusinessDoctorListVo getBusinessDoctorListVo) {
        getBusinessDoctorListVo.setDoctorType(Integer.valueOf(2));
        PageHelper.startPage((int)getBusinessDoctorListVo.getPageNum(), (int)getBusinessDoctorListVo.getPageSize());
        Page retBusinessDoctorListVoList = (Page)this.doctorMapper.selectMedicalDoctorList(getBusinessDoctorListVo);
        if (!retBusinessDoctorListVoList.isEmpty() && null != getBusinessDoctorListVo.getServiceCode()) {
            ConsultationServiceEnum byServiceCode = ConsultationServiceEnum.getByServiceCode((String)getBusinessDoctorListVo.getServiceCode());
            this.getPriceAndOrganConfig(retBusinessDoctorListVoList.getResult(), String.valueOf(byServiceCode.getConsultationServiceCode()), getBusinessDoctorListVo.getServiceCode());
        }
        PageResult pageResult = new PageResult();
        pageResult.setContent(retBusinessDoctorListVoList.getResult());
        pageResult.setPageNum(retBusinessDoctorListVoList.getPageNum());
        pageResult.setPageSize(retBusinessDoctorListVoList.getPageSize());
        pageResult.setTotal((int)retBusinessDoctorListVoList.getTotal());
        pageResult.setTotalPages(retBusinessDoctorListVoList.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public List<DoctorInfoVO> getByHospitalDeptId(Long hospitalDeptId, Long organId, String search) {
        return this.doctorMapper.selectByHospitalDeptId(hospitalDeptId, organId, search);
    }

    public List<DoctorPostRepVO> getDoctorPostAndCreditCardByDoctorIdsIM(List<String> doctorIds) {
        return this.doctorMapper.selectDoctorPostAndCreditCardByIdsIM(doctorIds);
    }

    public List<RetBusinessDoctorListVo> getPriceAndOrganConfig(List<RetBusinessDoctorListVo> retBusinessDoctorListVos, String serviceCode, String groupCode) {
        for (RetBusinessDoctorListVo retBusinessDoctorListVo : retBusinessDoctorListVos) {
            DoctorConsultationServiceInfoEntity doctorConsultationServiceInfoEntity = this.doctorConsultationServiceInfoEntityMapper.selectByDoctorIdAndServiceCodeAndGroupCode(Long.valueOf(retBusinessDoctorListVo.getDoctorId().longValue()), serviceCode, groupCode);
            OrganWorkingServiceEntity serviceByOrganId = this.organWorkingServiceMapper.getServiceByOrganId(Long.valueOf(retBusinessDoctorListVo.getOrganId().intValue()), groupCode, String.valueOf(1));
            if (Objects.nonNull(doctorConsultationServiceInfoEntity)) {
                retBusinessDoctorListVo.setPrice(doctorConsultationServiceInfoEntity.getAmount());
            } else {
                retBusinessDoctorListVo.setPrice(new BigDecimal(0));
            }
            retBusinessDoctorListVo.setConfig(serviceByOrganId.getConfig());
        }
        return retBusinessDoctorListVos;
    }
}

