/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.doctoruser.doctor.pojo.vo.DocPatientRelationRepVo;
import com.doctoruser.doctor.pojo.vo.MedicalRecordsVO;
import com.doctoruser.doctor.pojo.vo.PatientDetailInfoVO;
import com.doctoruser.doctor.pojo.vo.PatientDetailReqVO;
import com.doctoruser.doctor.pojo.vo.PatientFollowupPlanVO;
import com.doctoruser.doctor.remote.NodeRemoteService;
import com.doctoruser.doctor.service.DocPatientRelationService;
import com.doctoruser.doctor.service.PatientInfoService;
import com.ebaiyihui.framework.response.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PatientInfoServiceImpl
implements PatientInfoService {
    private static final Logger log = LoggerFactory.getLogger(PatientInfoServiceImpl.class);
    @Autowired
    private DocPatientRelationService docPatientRelationService;
    @Autowired
    private NodeRemoteService nodeRemoteService;

    public BaseResponse<PatientDetailInfoVO> getPatientDetail(PatientDetailReqVO reqVO) {
        PatientDetailInfoVO result = new PatientDetailInfoVO();
        BaseResponse patientResponse = this.docPatientRelationService.getPatientByPatientIdAndDoctorId(Long.valueOf(Long.parseLong(reqVO.getDoctorId())), Long.valueOf(Long.parseLong(reqVO.getPatientId())));
        DocPatientRelationRepVo patient = null;
        if (patientResponse.isSuccess()) {
            patient = (DocPatientRelationRepVo)patientResponse.getData();
        }
        result.setPatientInfo(patient);
        MedicalRecordsVO recordsVO = this.nodeRemoteService.getDoctorMedicalRecords(reqVO);
        result.setMedicalRecord(recordsVO);
        PatientFollowupPlanVO planOrder = this.nodeRemoteService.getPatientFollowPlanOrder(reqVO);
        result.setFollowUpVO(planOrder);
        return BaseResponse.success((Object)result);
    }
}

