/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.listener;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.vo.UserLastLoginDeviceRespVo;
import com.doctoruser.doctor.enums.ChannelEnum;
import com.doctoruser.doctor.listener.EventManager;
import com.doctoruser.doctor.listener.event.PatientEvent;
import com.doctoruser.doctor.listener.event.SmsPatientEvent;
import com.doctoruser.doctor.mapper.NewCommonMapper;
import com.doctoruser.doctor.pojo.dto.DoctorInfoDTO;
import com.doctoruser.doctor.push.PushService;
import com.doctoruser.doctor.push.vo.AliSmsSendAuthCodeReqPhoneVo;
import com.doctoruser.doctor.push.vo.GetPushConfigurationResVo;
import com.doctoruser.doctor.push.vo.UmPushMsgIOSReqVo;
import com.doctoruser.doctor.push.vo.UmPushMsgWithUserIdReqVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ChronicDataListener
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ChronicDataListener.class);
    @Autowired
    private EventManager eventManager;
    @Autowired
    private PushService pushService;
    @Autowired
    private NewCommonMapper newCommonMapper;

    @Subscribe
    public void pushMsg(PatientEvent event) {
        String userId = this.getDoctorUserId(event.getDoctorId());
        UserLastLoginDeviceRespVo loginDevice = this.pushService.getDeviceNumber(userId, event.getAppCode());
        List configList = this.pushService.getClientCode(event.getAppCode(), "youmengPush");
        if (ChannelEnum.DOCTOR_ANDROID.getValue().equals(loginDevice.getDeviceType())) {
            String clientCode = configList.stream().filter(s -> "doctor".equals(s.getUserType()) && "Android".equals(s.getDeviceType())).map(GetPushConfigurationResVo::getClientCode).findFirst().orElse("");
            UmPushMsgWithUserIdReqVo android = this.getAndroidMsg(loginDevice.getDeviceNumber(), clientCode, userId);
            this.pushService.pushAndroidMsg(android);
        } else if (ChannelEnum.DOCTOR_IOS.getValue().equals(loginDevice.getDeviceType())) {
            String clientCode = configList.stream().filter(s -> "doctor".equals(s.getUserType()) && "IOS".equals(s.getDeviceType())).map(GetPushConfigurationResVo::getClientCode).findFirst().orElse("");
            UmPushMsgIOSReqVo iosMsg = this.getIOSMsg(loginDevice.getDeviceNumber(), clientCode, userId);
            this.pushService.pushIOSMsg(iosMsg);
        }
    }

    @Subscribe
    public void smsSend(SmsPatientEvent event) {
        AliSmsSendAuthCodeReqPhoneVo aliSmsSendAuthCodeReqPhoneVO = new AliSmsSendAuthCodeReqPhoneVo();
        aliSmsSendAuthCodeReqPhoneVO.setTemplateCode(event.getTemplateCode());
        GetPushConfigurationResVo pushConfiguration = this.pushService.getSingleClientCode(event.getAppCode(), "sms");
        aliSmsSendAuthCodeReqPhoneVO.setSmsAppCode(pushConfiguration.getClientCode());
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("doctorName", event.getDoctorName());
        aliSmsSendAuthCodeReqPhoneVO.setParams(params);
        aliSmsSendAuthCodeReqPhoneVO.setPhone(event.getPhone());
        aliSmsSendAuthCodeReqPhoneVO.setSignCode(pushConfiguration.getPatientCode());
        log.info("\u60a3\u8005\u62a5\u9053\u901a\u8fc7\u77ed\u4fe1aliSmsSendAuthCodeReqPhoneVO:{}" + JSON.toJSONString((Object)aliSmsSendAuthCodeReqPhoneVO));
        BaseResponse smsSendPatient = this.pushService.sendAuthCodeWithPhone(aliSmsSendAuthCodeReqPhoneVO);
        log.info("smsSendPatient :{}" + JSON.toJSONString((Object)smsSendPatient));
        if (!smsSendPatient.isSuccess()) {
            log.info("=====\u5df2\u5ba1\u6838\u901a\u8fc7\u60a3\u8005\u77ed\u4fe1\u63a8\u9001\u5931\u8d25:" + JSON.toJSONString((Object)smsSendPatient));
        }
    }

    private String getDoctorUserId(Long doctorId) {
        List doctorInfoList = this.newCommonMapper.listUserId(Arrays.asList(doctorId));
        if (CollectionUtils.isEmpty((Collection)doctorInfoList)) {
            log.error("\u5f53\u524d\u533b\u751fdoctorId{}\u65e0userId ", (Object)doctorId);
            return "";
        }
        return String.valueOf(((DoctorInfoDTO)doctorInfoList.get(0)).getUserId());
    }

    private UmPushMsgWithUserIdReqVo getAndroidMsg(String deviceNumber, String clientCode, String userId) {
        UmPushMsgWithUserIdReqVo umPushMsgWithUserIdReqVo = new UmPushMsgWithUserIdReqVo();
        umPushMsgWithUserIdReqVo.setBusiCode("health_manage_hzbd");
        umPushMsgWithUserIdReqVo.setClientCode(clientCode);
        umPushMsgWithUserIdReqVo.setDeviceTokens(deviceNumber);
        umPushMsgWithUserIdReqVo.setUserId(userId);
        umPushMsgWithUserIdReqVo.setText("\u6709\u65b0\u7684\u60a3\u8005\u5173\u6ce8\u4e86\u60a8,\u60a8\u53ef\u524d\u5f80\u5de5\u4f5c\u53f0-\u6211\u7684\u60a3\u8005\u4e2d\u67e5\u770b");
        umPushMsgWithUserIdReqVo.setTitle("\u60a3\u8005\u5173\u6ce8\u63d0\u9192");
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("actionCode", "hzbd");
        map.put("pushCode", "HZBD");
        map.put("businessCode", "hzbd");
        umPushMsgWithUserIdReqVo.setExtra(map);
        return umPushMsgWithUserIdReqVo;
    }

    private UmPushMsgIOSReqVo getIOSMsg(String deviceNumber, String clientCode, String userId) {
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode("health_manage_hzbd");
        umPushMsgIOSReqVo.setClientCode(clientCode);
        umPushMsgIOSReqVo.setDeviceTokens(deviceNumber);
        umPushMsgIOSReqVo.setUserId(userId);
        umPushMsgIOSReqVo.setBody("\u6709\u65b0\u7684\u60a3\u8005\u5173\u6ce8\u4e86\u60a8,\u60a8\u53ef\u524d\u5f80\u5de5\u4f5c\u53f0-\u6211\u7684\u60a3\u8005\u4e2d\u67e5\u770b");
        umPushMsgIOSReqVo.setTitle("\u60a3\u8005\u5173\u6ce8\u63d0\u9192");
        umPushMsgIOSReqVo.setSubTitle("\u60a3\u8005\u5173\u6ce8\u63d0\u9192");
        umPushMsgIOSReqVo.setDescription("\u6709\u65b0\u7684\u60a3\u8005\u5173\u6ce8\u4e86\u60a8,\u60a8\u53ef\u524d\u5f80\u5de5\u4f5c\u53f0-\u6211\u7684\u60a3\u8005\u4e2d\u67e5\u770b");
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("pushCode", "HZBD");
        map.put("businessCode", "JKGL");
        umPushMsgIOSReqVo.setExtra(map);
        return umPushMsgIOSReqVo;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventManager.register((Object)this);
    }
}

