/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.push.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UserLastLoginDeviceReqVo;
import com.doctoruser.api.pojo.vo.UserLastLoginDeviceRespVo;
import com.doctoruser.api.pojo.vo.pushcenter.SmsSendAuthCodeRsp;
import com.doctoruser.doctor.push.PushService;
import com.doctoruser.doctor.push.vo.AliSmsSendAuthCodeReqPhoneVo;
import com.doctoruser.doctor.push.vo.GetPushConfigurationResVo;
import com.doctoruser.doctor.push.vo.UmPushMsgIOSReqVo;
import com.doctoruser.doctor.push.vo.UmPushMsgWithUserIdReqVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PushServiceImpl
implements PushService {
    private static final Logger log = LoggerFactory.getLogger(PushServiceImpl.class);
    @Value(value="${domainName}")
    private String domainName;
    private static final String GET_PUSH_CONFIG_URL = "/cloud/doctoruser/configuration/getdetail";
    private static final String GET_UM_IOS_P_ULL_CALL = "/cloud/push/umapi/pushiosunicast";
    private static final String GET_UM_ANDROID_P_ULL_CALL = "/cloud/push/umapi/pushandroidunicast";
    public static final short DOCTOR = 1;
    private static final String GET_USER_LOGIN_CALL = "/cloud/doctoruser/cloudaccount/getLastLoginDevice";
    private static final String GET_SMS_CALL = "/cloud/push/alismsapi/sendAuthCodeWithPhone";

    public UserLastLoginDeviceRespVo getDeviceNumber(String userId, String appCode) {
        if (StringUtils.isEmpty((Object)userId)) {
            log.error("\u67e5\u8be2\u533b\u751f\u8bbe\u5907\u53c2\u6570\u975e\u6cd5==============");
            return null;
        }
        UserLastLoginDeviceReqVo reqVo = new UserLastLoginDeviceReqVo();
        reqVo.setUserId(userId);
        reqVo.setUserType(Short.valueOf((short)1));
        try {
            log.info("\u83b7\u53d6\u7528\u6237\u767b\u5f55\u8bbe\u5907\u4fe1\u606f\u5165\u53c2: {}", (Object)reqVo);
            String body = HttpKit.jsonPost((String)(this.domainName + GET_USER_LOGIN_CALL), (String)JSON.toJSONString((Object)reqVo));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            log.info("\u83b7\u53d6\u7528\u6237\u767b\u5f55\u8bbe\u5907\u4fe1\u606f\u8fd4\u56de\u503c:{}", (Object)baseResponse);
            UserLastLoginDeviceRespVo respVo = (UserLastLoginDeviceRespVo)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), UserLastLoginDeviceRespVo.class);
            return respVo;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u767b\u5f55\u8bbe\u5907\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
            return null;
        }
    }

    public List<GetPushConfigurationResVo> getClientCode(String appCode, String businessType) {
        String clientCodeString = this.getPushConfiguration(appCode, businessType);
        log.info("\u53cb\u76df\u63a8\u9001\u914d\u7f6e\u8fd4\u56de\u503c: {}", (Object)clientCodeString);
        List clientCodeList = JSONObject.parseArray((String)clientCodeString, GetPushConfigurationResVo.class);
        return clientCodeList;
    }

    public void pushIOSMsg(UmPushMsgIOSReqVo iosMsg) {
        try {
            log.info("IOS\u6d88\u606f\u63a8\u9001\u5165\u53c2: {}", (Object)iosMsg);
            String body = HttpKit.jsonPost((String)(this.domainName + GET_UM_IOS_P_ULL_CALL), (String)JSON.toJSONString((Object)iosMsg));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("IOS\u6d88\u606f\u63a8\u9001pushPatientApp\u8fd4\u56de\u503c:{}", (Object)baseResponse);
        }
        catch (Exception e) {
            log.error("IOS\u6d88\u606f\u63a8\u9001\u5931\u8d25{}", (Throwable)e);
        }
    }

    public void pushAndroidMsg(UmPushMsgWithUserIdReqVo androidMsg) {
        try {
            log.info("Android\u6d88\u606f\u63a8\u9001\u5165\u53c2: {}", (Object)androidMsg);
            String body = HttpKit.jsonPost((String)(this.domainName + GET_UM_ANDROID_P_ULL_CALL), (String)JSON.toJSONString((Object)androidMsg));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
        }
        catch (Exception e) {
            log.error("\u5b89\u5353\u6d88\u606f\u63a8\u9001\u5931\u8d25{}", (Throwable)e);
        }
    }

    public GetPushConfigurationResVo getSingleClientCode(String appCode, String type) {
        String clientCodeString = this.getPushConfiguration(appCode, type);
        if (StringUtils.isEmpty((Object)clientCodeString)) {
            return new GetPushConfigurationResVo();
        }
        log.info("\u77ed\u4fe1\u63a8\u9001\u914d\u7f6e\u8fd4\u56de\u503c:{}" + clientCodeString);
        GetPushConfigurationResVo getPushConfigurationResVo = new GetPushConfigurationResVo();
        GetPushConfigurationResVo clientCodeObject = (GetPushConfigurationResVo)JSONObject.parseObject((String)clientCodeString, GetPushConfigurationResVo.class);
        log.info("\u4ece\u63a8\u9001\u914d\u7f6e\u4e2d\u83b7\u53d6\u77ed\u4fe1\u7684clientCode:{}" + JSON.toJSONString((Object)clientCodeObject));
        getPushConfigurationResVo.setDoctorCode(clientCodeObject.getSignCode().getDoctorCode());
        getPushConfigurationResVo.setPatientCode(clientCodeObject.getSignCode().getPatientCode());
        getPushConfigurationResVo.setClientCode(clientCodeObject.getClientCode());
        log.info("\u83b7\u53d6\u5230\u7684ClientCode-doctorCode-patientCode:{}" + JSON.toJSONString((Object)getPushConfigurationResVo));
        return getPushConfigurationResVo;
    }

    public BaseResponse<SmsSendAuthCodeRsp> sendAuthCodeWithPhone(AliSmsSendAuthCodeReqPhoneVo aliSmsSendAuthCodeReqPhoneVO) {
        try {
            String smsPush = this.domainName + GET_SMS_CALL;
            String body = HttpKit.jsonPost((String)smsPush, (String)JSON.toJSONString((Object)aliSmsSendAuthCodeReqPhoneVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse:{} " + JSON.toJSONString((Object)baseResponse));
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u9a8c\u8bc1\u7801\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    private String getPushConfiguration(String appCode, String type) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("appCode", appCode);
        map.put("type", type);
        log.info("\u83b7\u53d6\u63a8\u9001code\u5165\u53c2map:", (Object)JSON.toJSONString(map));
        String url = this.domainName + GET_PUSH_CONFIG_URL;
        String clientCodeData = null;
        try {
            String body = HttpKit.jsonPost((String)url, (String)JSON.toJSONString(map));
            GetPushConfigurationResVo getPushConfigurationResVo = (GetPushConfigurationResVo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), GetPushConfigurationResVo.class);
            if (null == getPushConfigurationResVo || null == getPushConfigurationResVo.getData()) {
                return "";
            }
            log.info("\u83b7\u53d6\u63a8\u9001\u914d\u7f6e\u8fd4\u56de\u503c: {}", (Object)getPushConfigurationResVo.getData());
            clientCodeData = getPushConfigurationResVo.getData().getClientCode();
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38{} ", (Throwable)e);
        }
        return clientCodeData;
    }
}

