/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.doctor.basedata.api.vo.HospitalModel;
import com.doctor.basedata.api.vo.OrganDistanceLocationReqVO;
import com.doctor.basedata.api.vo.OrganInfoReqVO;
import com.doctor.basedata.api.vo.OrganManageDetailVo;
import com.doctor.basedata.api.vo.OrganSupervisionVo;
import com.doctor.basedata.api.vo.QueryHisDeptScheduleVo;
import com.doctoruser.api.common.enums.OrganizationStatusEnum;
import com.doctoruser.api.pojo.base.entity.OrganWorkingServiceEntity;
import com.doctoruser.api.pojo.base.entity.OrganizationConfigEntity;
import com.doctoruser.api.pojo.base.entity.StandardDepartmentEntity;
import com.doctoruser.api.pojo.base.vo.basedata.GuideBaseResponse;
import com.doctoruser.api.pojo.base.vo.doctor.StandardDeptResVO;
import com.doctoruser.api.pojo.base.vo.organization.DepartmentVO;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.OrganInfoListDTO;
import com.doctoruser.api.pojo.dto.OrganInfoReq;
import com.doctoruser.api.pojo.dto.OrganizationReq;
import com.doctoruser.api.pojo.dto.organization.DeptByParamDTO;
import com.doctoruser.api.pojo.dto.organization.ListOrganByAppCodeDTO;
import com.doctoruser.api.pojo.dto.organization.ListOrganDTO;
import com.doctoruser.api.pojo.dto.organization.ManagerDeptDTO;
import com.doctoruser.api.pojo.dto.organization.OrganizationByParamDTO;
import com.doctoruser.api.pojo.dto.organization.OrganizationStatusDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganNameDTO;
import com.doctoruser.api.pojo.dto.organization.SaveOrganInCloudDTO;
import com.doctoruser.api.pojo.dto.organization.UpdateOrganDTO;
import com.doctoruser.api.pojo.vo.BeanRespVO;
import com.doctoruser.api.pojo.vo.GuideDeptListVo;
import com.doctoruser.api.pojo.vo.GuideHospitaDetailVo;
import com.doctoruser.api.pojo.vo.GuideHospitalnfo;
import com.doctoruser.api.pojo.vo.OrganBasicInfoReqVO;
import com.doctoruser.api.pojo.vo.OrganBasicInfoRespVO;
import com.doctoruser.api.pojo.vo.OrganDetailAllRespVO;
import com.doctoruser.api.pojo.vo.OrganDistanceListRespVO;
import com.doctoruser.api.pojo.vo.OrganHomePageReqVO;
import com.doctoruser.api.pojo.vo.OrganInfoAndHospitalVO;
import com.doctoruser.api.pojo.vo.OrganInfoRespVO;
import com.doctoruser.api.pojo.vo.SevrCodeGetDeptReqVO;
import com.doctoruser.api.pojo.vo.basedata.organization.DoctorNumberVO;
import com.doctoruser.api.pojo.vo.basedata.organization.ListOrganVO;
import com.doctoruser.api.pojo.vo.basedata.organization.ListStdDeptVO;
import com.doctoruser.api.pojo.vo.basedata.organization.OrganCodeInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.OrganNodeInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganNameVO;
import com.doctoruser.api.pojo.vo.basedata.organization.StdSecondDeptVO;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.mapper.DepartmentStandardMapper;
import com.doctoruser.doctor.mapper.DictionaryMapper;
import com.doctoruser.doctor.mapper.DocDepartmentMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesInfoMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.OrganWorkingServiceMapper;
import com.doctoruser.doctor.mapper.OrganizationConfigMapper;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.pojo.entity.DictionaryEntity;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.entity.OrganizationEntity;
import com.doctoruser.doctor.pojo.vo.OpenHomeVO;
import com.doctoruser.doctor.pojo.vo.OrganRelVO;
import com.doctoruser.doctor.service.IOrganizationService;
import com.doctoruser.doctor.service.feign.ByhCloudAccountClient;
import com.doctoruser.doctor.service.feign.ByhDoctorDetailInfoClient;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.LocationUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OrganizationServiceImpl
implements IOrganizationService {
    private static final Logger log = LoggerFactory.getLogger(OrganizationServiceImpl.class);
    @Resource
    private OrganizationMapper organizationMapper;
    @Autowired
    private OrganWorkingServiceMapper organWorkingServiceMapper;
    @Autowired
    private DocDepartmentMapper docDepartmentMapper;
    @Autowired
    private ByhDoctorDetailInfoClient detailInfoClient;
    @Resource
    private DoctorMapper doctorMapper;
    @Autowired
    private DictionaryMapper dictionaryMapper;
    @Autowired
    private ByhCloudAccountClient byhCloudAccountClient;
    @Autowired
    private DepartmentStandardMapper departmentStandardMapper;
    @Autowired
    private OrganizationConfigMapper organizationConfigMapper;
    @Autowired
    private DocDoctorWorkplacesInfoMapper docDoctorWorkplacesInfoMapper;
    @Value(value="${domainName}")
    private String domainName;
    @Value(value="${stdDeptServiceUrl}")
    private String stdDeptServiceUrl;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SUCCESS = "success";
    private static final String INTO_ARGS = "\u5165\u53c2:{}";
    private static final String OUT_ARGS = "\u51fa\u53c2:{}";
    private static final String DATA_NOT_EXIS = "\u6570\u636e\u4e0d\u5b58\u5728";

    public BaseResponse<PageResult<ListOrganVO>> listOrganInfo(ListOrganDTO dto) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setSize((long)dto.getPageSize().intValue());
        page.setCurrent((long)dto.getPageNum().intValue());
        if (!dto.getHospitalId().isEmpty()) {
            String organIds = dto.getHospitalId().stream().map(String::valueOf).collect(Collectors.joining(","));
            IPage data = this.organizationMapper.listAllianceOgranInfo(page, dto, organIds);
            if (null == data || data.getRecords().isEmpty()) {
                return BaseResponse.success();
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getServiceCode())) {
                String[] split = dto.getServiceCode().split(",");
                List<String> serviceCodeList = Arrays.asList(split);
                dto.setServiceCode("");
                if (!serviceCodeList.isEmpty()) {
                    String serviceCodes = serviceCodeList.stream().collect(Collectors.joining("','", "'", "'"));
                    dto.setServiceCode(serviceCodes);
                }
            }
            for (ListOrganVO organVO : data.getRecords()) {
                int doctorCount = this.docDoctorWorkplacesInfoMapper.getBusinessDoctorCount(organVO.getHospitalId().toString(), dto.getServiceCode(), Integer.valueOf(1));
                organVO.setExpertNum(Integer.valueOf(doctorCount));
            }
            PageResult result = new PageResult();
            result.setContent(data.getRecords());
            result.setPageNum((int)data.getCurrent());
            result.setPageSize((int)data.getSize());
            result.setTotal((int)data.getTotal());
            return BaseResponse.success((Object)result);
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<ListOrganVO>> managerQueryAllOrganList(BaseDTO dto) {
        List list = new ArrayList();
        if (null != dto.getCode()) {
            Integer id = this.organizationMapper.queryOrganIdByCode(dto);
            dto.setId(id);
        }
        list = this.organizationMapper.managerQueryAllOrganInfo(dto);
        return BaseResponse.success(list);
    }

    public BaseResponse<List<ListOrganVO>> listAllOrganInfo(ListOrganDTO dto) {
        List data = this.organizationMapper.queryAllianceOgranInfo(dto);
        for (ListOrganVO vo : data) {
            DoctorNumberVO num = this.organizationMapper.queryDoctorAndFamousNum(vo.getHospitalId());
            if (num == null) {
                vo.setDoctorNum(Integer.valueOf(0));
                vo.setExpertNum(Integer.valueOf(0));
                continue;
            }
            vo.setDoctorNum(num.getDoctorNum());
            vo.setExpertNum(num.getFamousDoctorNum());
        }
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<PageResult<ListOrganVO>> listAreaOrganInfo(ListOrganDTO dto) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setSize((long)dto.getPageSize().intValue());
        page.setCurrent((long)dto.getPageNum().intValue());
        IPage data = this.organizationMapper.listAreaOgranInfo(page, dto);
        if (null == data || data.getRecords().isEmpty()) {
            return BaseResponse.success(null);
        }
        PageResult result = new PageResult();
        result.setContent(data.getRecords());
        result.setPageNum((int)data.getCurrent());
        result.setPageSize((int)data.getSize());
        result.setTotal((int)data.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<List<ListStdDeptVO>> listStdDeptInfo() {
        List stdDeptVOS = this.organizationMapper.listFirstStdDeptInfo();
        if (stdDeptVOS.isEmpty()) {
            return BaseResponse.success(null);
        }
        for (ListStdDeptVO vo : stdDeptVOS) {
            List secondDeptVOS = this.organizationMapper.listSecondStdDeptInfo(vo.getStdFirstDeptId());
            vo.setStdSecondDeptVOS(secondDeptVOS);
        }
        return BaseResponse.success((Object)stdDeptVOS);
    }

    public BaseResponse<QueryOrganDetailVO> queryOrganDetailsInfo(Integer organId) {
        QueryOrganDetailVO organDetailVO = this.organizationMapper.queryOrganDetailnfo(organId);
        return BaseResponse.success((Object)organDetailVO);
    }

    public BaseResponse<DoctorNumberVO> queryOrganDoctorAndFamousDoctorNum(Integer organId) {
        DoctorNumberVO vo = this.organizationMapper.queryDoctorAndFamousNum(organId);
        return BaseResponse.success((Object)vo);
    }

    public BaseResponse<List<ListOrganVO>> listAllhospital() {
        List data = this.organizationMapper.listAllHospitalInfo();
        return BaseResponse.success((Object)data);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public BaseResponse<String> saveStdDeptInfo(ManagerDeptDTO dto) {
        this.logger.info("========\u4fdd\u5b58\u6807\u51c6\u79d1\u5ba4\u4fe1\u606f=======param: {}", (Object)dto);
        if (null == dto.getType()) {
            return BaseResponse.error((IError)EHErrorEnum.TYPE_NOT_NULL);
        }
        if (dto.getType() == 1) {
            if (dto.getIconUrl() == null || dto.getStatus() == null || dto.getStdDeptName() == null) {
                return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
            }
            this.organizationMapper.saveStdDeptInfo(dto);
        } else if (dto.getType() == 2) {
            if (dto.getRelDeptId() == null || dto.getStatus() == null || dto.getStdDeptName() == null) {
                return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
            }
            this.organizationMapper.saveStdDeptInfo(dto);
        }
        return BaseResponse.success((Object)SUCCESS);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public BaseResponse<String> updtaeStdDeptInfo(ManagerDeptDTO dto) {
        this.logger.info("========\u4fee\u6539\u6807\u51c6\u79d1\u5ba4\u4fe1\u606f=======param: {}", (Object)dto);
        this.organizationMapper.updateStdDeptInfo(dto);
        return BaseResponse.success((Object)SUCCESS);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public BaseResponse<String> deleteStdDeptInfo(ManagerDeptDTO dto) {
        this.logger.info("========\u5220\u9664\u6807\u51c6\u79d1\u5ba4\u4fe1\u606f=======param: {}", (Object)dto);
        Integer num = this.organizationMapper.countOrganDept(dto.getStdDeptId(), dto.getType());
        if (num > 0) {
            return BaseResponse.error((IError)EHErrorEnum.DELETE_FAIL);
        }
        if (dto.getType() == 2) {
            this.organizationMapper.deleteStdDeptInfo(dto.getStdDeptId());
        }
        if (dto.getType() == 1) {
            List stdDeptVOS = this.organizationMapper.listSecondStdDeptInfo(dto.getStdDeptId());
            this.organizationMapper.deleteStdDeptInfo(dto.getStdDeptId());
            for (StdSecondDeptVO vo : stdDeptVOS) {
                this.organizationMapper.deleteStdDeptInfo(vo.getStdSecondDeptId());
            }
        }
        return BaseResponse.success((Object)SUCCESS);
    }

    public BaseResponse<String> queryAppCodeByHospitalId(Integer hospitalId) {
        OrganizationEntity entity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)hospitalId);
        if (null == entity) {
            return BaseResponse.success(null);
        }
        return BaseResponse.success((Object)entity.getAppCode());
    }

    public BaseResponse<String> queryNodeOrganCode(Integer hospitalId) {
        OrganizationEntity entityHospital = (OrganizationEntity)this.organizationMapper.selectById((Serializable)hospitalId);
        OrganizationEntity entityNode = (OrganizationEntity)this.organizationMapper.selectById((Serializable)entityHospital.getRelOrganId());
        if (null == entityNode) {
            return BaseResponse.success((Object)"");
        }
        return BaseResponse.success((Object)entityNode.getOrganCode());
    }

    public BaseResponse<OrganCodeInfoVO> queryCodeByHospitalId(Integer doctorId) {
        this.logger.info("=============\u6839\u636edoctorId\u67e5\u8be2code\u4fe1\u606f\uff0cdoctorId = {} ===============", (Object)doctorId);
        OrganCodeInfoVO vo = this.organizationMapper.queryOrganCodeInfoByDoctorId(doctorId);
        this.logger.info("============code \u8fd4\u56de\u53c2\u6570\uff0cparam = {} ==============", (Object)vo);
        return BaseResponse.success((Object)vo);
    }

    public BaseResponse<List<OrganNodeInfoVO>> queryNodeInfo() {
        List info = this.organizationMapper.getOrganNodeInfo(Integer.valueOf(2), Integer.valueOf(1));
        return BaseResponse.success((Object)info);
    }

    public BaseResponse<List<Integer>> queryDoctorIdsInOrgan(List<Integer> list) {
        List ids = this.organizationMapper.listDoctorIdsInOrgan(list);
        return BaseResponse.success((Object)ids);
    }

    public BaseResponse<String> saveOrganInCloud(SaveOrganInCloudDTO organ) {
        OrganizationEntity organs = new OrganizationEntity();
        BeanUtils.copyProperties((Object)organ, (Object)organs);
        organs.setOrganAddress(organ.getAddress());
        organs.setTelphone(organ.getTelephone());
        organs.setOrganCategory(organ.getThirdCategory());
        organs.setCategoryName(organ.getThirdCategoryName());
        organs.setCreateTime(new Date());
        organs.setUpdateTime(new Date());
        organs.setOrganCode("12345678");
        organs.setRelOrganId(this.organizationMapper.selectRelOrganIdByCode(organ.getAppCode()));
        this.organizationMapper.insert((Object)organs);
        String organId = this.organizationMapper.selectOrganByOrganCode(organs.getOrganCode());
        this.organizationMapper.updateOrganCodeById(organId);
        return BaseResponse.success((Object)organId);
    }

    public BaseResponse<String> updateOrganInCloud(UpdateOrganDTO organ) {
        this.organizationMapper.updateOrgan(organ, new Date());
        return BaseResponse.success((Object)"\u4e91\u7aef\u4fee\u6539\u6210\u529f\uff01");
    }

    public void deleteOrgan(OrganizationStatusDTO organ) {
        this.organizationMapper.deleteOrgan(organ, OrganizationStatusEnum.IS_DELETE.getValue());
    }

    public void updateOrganStatus(OrganizationStatusDTO organ) {
        this.organizationMapper.updateOrganStatus(organ);
    }

    public void delOrganByOrganCode(String organCode) {
        this.organizationMapper.delByOrganCode(organCode);
    }

    public BaseResponse<ArrayList<OrganRelVO>> selRelOrgan() {
        return BaseResponse.success((Object)this.organizationMapper.selRelOrgan());
    }

    public BaseResponse<List<ListOrganVO>> listByAppCode(ListOrganByAppCodeDTO dto) {
        return BaseResponse.success((Object)this.organizationMapper.listByAppCode(dto.getAppCode()));
    }

    public BaseResponse<List<ListOrganVO>> managerQueryAllOrganListHy(BaseDTO dto) {
        List list = new ArrayList();
        if (null != dto.getCode()) {
            Integer id = this.organizationMapper.queryOrganIdByCode(dto);
            dto.setId(id);
        }
        list = this.organizationMapper.managerQueryAllOrganInfoHy(dto);
        return BaseResponse.success(list);
    }

    public BaseResponse<QueryOrganNameVO> queryOrganName(QueryOrganNameDTO dto) {
        QueryOrganNameVO byOrganCode = this.organizationMapper.getOrganNameByOrganCode(dto.getOrganCode());
        return BaseResponse.success((Object)byOrganCode);
    }

    public BaseResponse<PageResult<OrganInfoRespVO>> getOrganInfoListByAppCode(OrganInfoReq organInfoReq) {
        log.info(INTO_ARGS, (Object)organInfoReq);
        OrganizationByParamDTO dto = new OrganizationByParamDTO();
        dto.setAppCode(organInfoReq.getAppCode());
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
        page.setSize((long)organInfoReq.getPageSize().intValue());
        page.setCurrent((long)organInfoReq.getPageNum().intValue());
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(1);
        statusList.add(2);
        IPage organInfoRespVOIPage = this.organizationMapper.selectByOrganTypeAndOrganCode(page, dto, statusList);
        ArrayList<OrganInfoRespVO> list = new ArrayList<OrganInfoRespVO>();
        for (OrganInfoRespVO organizationVo : organInfoRespVOIPage.getRecords()) {
            List workingServiceEntities = this.organWorkingServiceMapper.queryOrganServiceByOrganId(organizationVo.getOrganId(), String.valueOf(1));
            DeptByParamDTO dept = new DeptByParamDTO();
            dept.setOrganId(organizationVo.getOrganId());
            List departmentVOS = this.docDepartmentMapper.queryDeptByParam(dept);
            DoctorNumberVO vo = this.organizationMapper.queryDoctorAndFamousNum(Integer.valueOf(organizationVo.getOrganId()));
            int doctorAllNum = vo.getDoctorNum() + vo.getFamousDoctorNum();
            OrganInfoRespVO organInfoRespVO = new OrganInfoRespVO();
            BeanUtils.copyProperties((Object)organizationVo, (Object)organInfoRespVO);
            organInfoRespVO.setServiceNumber(Integer.valueOf(workingServiceEntities.size()));
            organInfoRespVO.setDoctorNumber(Integer.valueOf(doctorAllNum));
            organInfoRespVO.setDeptNumber(Integer.valueOf(departmentVOS.size()));
            list.add(organInfoRespVO);
        }
        PageResult result = new PageResult();
        result.setContent(list);
        result.setPageNum((int)organInfoRespVOIPage.getCurrent());
        result.setPageSize((int)organInfoRespVOIPage.getSize());
        result.setTotal((int)organInfoRespVOIPage.getTotal());
        log.info(OUT_ARGS, (Object)result);
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<BeanRespVO> getOrganInfoList(OrganInfoListDTO listDTO) {
        log.info(INTO_ARGS, (Object)listDTO);
        if (listDTO.getStatusArr().size() == 0 || listDTO.getStatusArr().isEmpty()) {
            log.info("\u72b6\u6001\u4e3a\u7a7a,\u4e0d\u67e5\u8be2");
            BeanRespVO beanRespVO = new BeanRespVO();
            return BaseResponse.success((Object)beanRespVO);
        }
        PageHelper.startPage((int)listDTO.getPageNum(), (int)listDTO.getPageSize());
        Page organInfoAndHospitalVOS = (Page)this.organizationMapper.selectOrganInfoList(listDTO);
        for (OrganInfoAndHospitalVO organizationVo : organInfoAndHospitalVOS.getResult()) {
            List workingServiceEntities = this.organWorkingServiceMapper.queryOrganServiceByOrganId(organizationVo.getOrganId(), String.valueOf(1));
            DeptByParamDTO dept = new DeptByParamDTO();
            dept.setOrganId(organizationVo.getOrganId());
            List departmentVOS = this.docDepartmentMapper.queryDeptByParam(dept);
            DoctorNumberVO vo = this.organizationMapper.queryDoctorAndFamousNum(Integer.valueOf(organizationVo.getOrganId()));
            int doctorAllNum = vo.getDoctorNum() + vo.getFamousDoctorNum();
            organizationVo.setDeptNumber(Integer.valueOf(departmentVOS.size()));
            organizationVo.setDoctorNumber(Integer.valueOf(doctorAllNum));
            organizationVo.setServiceNumber(Integer.valueOf(workingServiceEntities.size()));
        }
        PageResult result = new PageResult();
        result.setContent(organInfoAndHospitalVOS.getResult());
        result.setPageNum(organInfoAndHospitalVOS.getPageNum());
        result.setPageSize(organInfoAndHospitalVOS.getPageSize());
        result.setTotal((int)organInfoAndHospitalVOS.getTotal());
        List infoAndHospitalVOS = this.organizationMapper.selectOrganInfoList(listDTO);
        List lowerCollect = infoAndHospitalVOS.stream().filter(s -> s.getStatus() == 2).collect(Collectors.toList());
        List upCollect = infoAndHospitalVOS.stream().filter(s -> s.getStatus() == 1).collect(Collectors.toList());
        BeanRespVO hospitalRespVO = new BeanRespVO();
        hospitalRespVO.setHospitalPage(result);
        hospitalRespVO.setLowerLineNumber(Integer.valueOf(lowerCollect.size()));
        hospitalRespVO.setUpLineNumber(Integer.valueOf(upCollect.size()));
        log.info(OUT_ARGS, (Object)hospitalRespVO);
        return BaseResponse.success((Object)hospitalRespVO);
    }

    public BaseResponse<OrganManageDetailVo> getOrganManageDetail(Integer organId) {
        log.info(INTO_ARGS, (Object)organId);
        OrganManageDetailVo organDetailById = this.organizationMapper.getOrganDetailById(organId);
        if (organDetailById == null) {
            return BaseResponse.success();
        }
        List serviceEntities = this.organWorkingServiceMapper.queryOrganServiceByOrganId(String.valueOf(organId), String.valueOf(1));
        DoctorNumberVO vo = this.organizationMapper.queryDoctorAndFamousNum(organId);
        int doctorAllNum = vo.getDoctorNum() + vo.getFamousDoctorNum();
        BaseResponse secondAuditDoctors = this.detailInfoClient.getSecondAuditDoctors(String.valueOf(organId));
        log.info("\u67e5\u8be2\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u4e8c\u6b21\u5ba1\u6838\u533b\u751f\u6570\u636e{}", (Object)JSON.toJSONString((Object)secondAuditDoctors));
        List secondAuditDoctorData = (List)secondAuditDoctors.getData();
        organDetailById.setUnauditedDoctorNumber(Integer.valueOf(Objects.isNull(secondAuditDoctorData) ? 0 : secondAuditDoctorData.size()));
        organDetailById.setDoctorNumber(Integer.valueOf(doctorAllNum - organDetailById.getUnauditedDoctorNumber()));
        organDetailById.setOpeningServiceNumber(Integer.valueOf(serviceEntities.size()));
        log.info(OUT_ARGS, (Object)organDetailById);
        return BaseResponse.success((Object)organDetailById);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> updateOrganInfoById(OrganizationReq organizationReq) {
        log.info(INTO_ARGS, (Object)organizationReq);
        OrganizationEntity entity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)organizationReq.getId());
        if (entity == null) {
            log.error(DATA_NOT_EXIS);
            return BaseResponse.error((IError)EHErrorEnum.DATA_NOT_EXIST);
        }
        String statusArr = "1,2";
        List entityList = this.organizationMapper.selectOrganizationByName(organizationReq.getOrganName(), statusArr);
        for (OrganizationEntity organizationEntity : entityList) {
            if (organizationEntity.getId().equals(organizationReq.getId()) || !organizationEntity.getOrganName().equals(organizationReq.getOrganName())) continue;
            log.error("\u533b\u9662\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            return BaseResponse.error((IError)EHErrorEnum.ORGAN_NAME_EXISTS);
        }
        OrganizationEntity organizationEntity = new OrganizationEntity();
        BeanUtils.copyProperties((Object)organizationReq, (Object)organizationEntity);
        organizationEntity.setOrganAddress(organizationReq.getAddress());
        this.organizationMapper.updateByPrimaryKeySelective(organizationEntity);
        if (!entity.getAppCode().equals(organizationReq.getAppCode())) {
            log.info("core\u670d\u52a1\u540c\u6b65\u6570\u636e");
            List doctorList = this.doctorMapper.queryDoctorIdByOrganId(organizationReq.getId(), statusArr);
            List doctorIds = doctorList.stream().map(String::valueOf).collect(Collectors.toList());
            if (doctorIds.isEmpty() || doctorIds.size() == 0) {
                log.info("\u533b\u9662\u4e0b\u6ca1\u6709\u533b\u751f,\u4e0d\u9700\u8981\u540c\u6b65");
            } else {
                BaseResponse baseResponse = this.byhCloudAccountClient.updateAccountAppCode(organizationReq.getAppCode(), doctorIds);
                if (!baseResponse.isSuccess()) {
                    log.error("\u8c03\u7528core\u670d\u52a1,\u540c\u6b65\u6570\u636e\u5931\u8d25");
                    throw new RuntimeException();
                }
            }
        }
        log.info("\u7f16\u8f91\u533b\u9662\u4fe1\u606f\u6210\u529f");
        return BaseResponse.success();
    }

    public BaseResponse<String> updateOrganStatusById(int organId, int status) {
        log.info("\u5165\u53c2:{hospitalId=" + organId + ",status=" + status + "}");
        OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)Integer.valueOf(organId));
        if (organizationEntity == null) {
            log.error(DATA_NOT_EXIS);
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST);
        }
        OrganizationEntity entity = new OrganizationEntity();
        entity.setId(Integer.valueOf(organId));
        entity.setStatus(Integer.valueOf(status));
        int updateNumber = this.organizationMapper.updateByPrimaryKeySelective(entity);
        if (updateNumber == 1) {
            log.info("\u72b6\u6001\u4fee\u6539\u6210\u529f");
            return BaseResponse.success();
        }
        log.error("\u672a\u77e5\u9519\u8bef");
        return BaseResponse.error((IError)IError.SYSYTEM_UNKNOW);
    }

    public BaseResponse<OrganDetailAllRespVO> getOrganDetailAllById(int organId) {
        OrganDetailAllRespVO organInfoAll = this.organizationMapper.getOrganInfoAllById(Integer.valueOf(organId));
        return BaseResponse.success((Object)organInfoAll);
    }

    public BaseResponse<List<OrganDistanceListRespVO>> getOrganDistanceByAppCode(OrganDistanceLocationReqVO distanceReqVO) {
        log.info(INTO_ARGS, (Object)distanceReqVO);
        List collect = null;
        List distanceByAppCode = this.organizationMapper.getOrganDistanceByAppCode(distanceReqVO);
        if (distanceByAppCode.isEmpty()) {
            log.info("\u67e5\u8be2\u4e3a\u7a7a");
            return BaseResponse.success((Object)distanceByAppCode);
        }
        if (StringUtils.isNotBlank((CharSequence)distanceReqVO.getServiceCode())) {
            List organIdList = distanceByAppCode.stream().map(s -> Long.valueOf(s.getOrganId())).collect(Collectors.toList());
            List organWorkingServiceEntityList = this.organWorkingServiceMapper.selectByServiceCodeAndOrganIdList(organIdList, distanceReqVO.getServiceCode(), 1);
            List organIdListFilter = organWorkingServiceEntityList.stream().map(OrganWorkingServiceEntity::getOrganId).collect(Collectors.toList());
            distanceByAppCode = distanceByAppCode.stream().filter(s -> organIdListFilter.contains(s.getOrganId())).collect(Collectors.toList());
        }
        if (distanceByAppCode.isEmpty()) {
            log.info("\u67e5\u8be2\u4e3a\u7a7a");
            return BaseResponse.success((Object)distanceByAppCode);
        }
        List listRespVOS = distanceByAppCode.stream().filter(s -> s.getLongitude() != 0.0 && s.getLatitude() != 0.0).collect(Collectors.toList());
        if (distanceReqVO.getLat() != null && distanceReqVO.getLng() != null) {
            for (OrganDistanceListRespVO respVO : listRespVOS) {
                double distance = LocationUtils.getDistance((double)distanceReqVO.getLat(), (double)distanceReqVO.getLng(), (double)respVO.getLatitude(), (double)respVO.getLongitude());
                respVO.setDistance(distance);
            }
            collect = listRespVOS.stream().sorted(Comparator.comparing(OrganDistanceListRespVO::getOrganOnOff).thenComparing(OrganDistanceListRespVO::getDistance)).collect(Collectors.toList());
            log.info("\u6839\u636e\u7ecf\u7eac\u5ea6\u8fd4\u56de\u51fa\u53c2:{}", collect);
            return BaseResponse.success(collect);
        }
        log.info("\u65e0\u7ecf\u7eac\u5ea6\u8fd4\u56de\u51fa\u53c2:{}", listRespVOS);
        return BaseResponse.success(listRespVOS);
    }

    public BaseResponse<List<OrganWorkingServiceEntity>> getOrganServiceByOrganId(String organId) {
        String status = "1,-1";
        List serviceEntities = this.organWorkingServiceMapper.queryOrganServiceByOrganId(organId, status);
        return BaseResponse.success((Object)serviceEntities);
    }

    public BaseResponse<List<StandardDeptResVO>> getDeptAllByServCode(SevrCodeGetDeptReqVO sevrCodeVo) {
        log.info(INTO_ARGS, (Object)sevrCodeVo);
        List deptIdList = this.docDepartmentMapper.getDeptIdBySevrCodeAndOrganId(sevrCodeVo.getOrganId(), sevrCodeVo.getSevrCode());
        ArrayList deptResVOList = new ArrayList();
        List integers = deptIdList.stream().distinct().collect(Collectors.toList());
        if (integers.isEmpty()) {
            log.info("\u67e5\u8be2\u4e3a\u7a7a");
            return BaseResponse.success(deptResVOList);
        }
        sevrCodeVo.setDeptIds(integers);
        List departmentVOS = this.docDepartmentMapper.getDeptInfoByDeptIds(sevrCodeVo);
        if (departmentVOS.isEmpty()) {
            log.info("\u67e5\u8be2\u4e3a\u7a7a");
            return BaseResponse.success(deptResVOList);
        }
        Map<Integer, List<DepartmentVO>> listMap = departmentVOS.stream().collect(Collectors.groupingBy(DepartmentVO::getFirstDeptId));
        ArrayList<StandardDeptResVO> resVOList = new ArrayList<StandardDeptResVO>();
        for (Integer key : listMap.keySet()) {
            StandardDeptResVO deptlist = this.docDepartmentMapper.queryFirstOrSecondDeptById(key);
            deptlist.setDeptList(listMap.get(key));
            resVOList.add(deptlist);
        }
        log.info(OUT_ARGS, resVOList);
        return BaseResponse.success(resVOList);
    }

    public BaseResponse<List<StandardDeptResVO>> getOrganDeptInStdDept(int organId, String standName) {
        List departmentVOS = this.docDepartmentMapper.queryDeptByOrganId(organId, standName, null);
        ArrayList<StandardDeptResVO> deptResVOList = new ArrayList<StandardDeptResVO>();
        if (departmentVOS.isEmpty()) {
            return BaseResponse.success(deptResVOList);
        }
        Map<Integer, List<DepartmentVO>> listMap = departmentVOS.stream().collect(Collectors.groupingBy(DepartmentVO::getFirstDeptId));
        ArrayList<Integer> stdDeptIds = new ArrayList<Integer>(listMap.keySet());
        List stdDeptList = this.departmentStandardMapper.selectOrderByOrganSeq(stdDeptIds, Long.valueOf(organId));
        for (StandardDepartmentEntity standardDepartmentEntity : stdDeptList) {
            StandardDeptResVO standardDeptResVOS = new StandardDeptResVO();
            standardDeptResVOS.setDisplayName(standardDepartmentEntity.getDisplayName());
            standardDeptResVOS.setIconUrl(standardDepartmentEntity.getIconUrl());
            standardDeptResVOS.setShortName(standardDepartmentEntity.getShortName());
            int stdDeptId = Integer.valueOf(standardDepartmentEntity.getxId());
            standardDeptResVOS.setStandDeptId(stdDeptId);
            standardDeptResVOS.setStatus(standardDepartmentEntity.getStatus());
            List<DepartmentVO> departmentVOList = listMap.get(stdDeptId);
            for (DepartmentVO departmentVO : departmentVOList) {
                StandardDeptResVO deptResVO = this.docDepartmentMapper.queryFirstDeptById(departmentVO.getSecondDeptId());
                departmentVO.setSecondDeptName(deptResVO.getDisplayName());
                departmentVO.setFirstDeptName(standardDeptResVOS.getDisplayName());
            }
            standardDeptResVOS.setDeptList(departmentVOList);
            deptResVOList.add(standardDeptResVOS);
        }
        return BaseResponse.success(deptResVOList);
    }

    public BaseResponse<List<ListStdDeptVO>> getStdDeptListByHospitalIdAndAppCodeAndServiceCodes(String hospitalId, String appCode, String serviceCodes) {
        List stdDeptVOS = this.organizationMapper.listFirstStdDeptInfo();
        if (stdDeptVOS.isEmpty()) {
            return BaseResponse.success();
        }
        ArrayList<String> serviceCodeList = new ArrayList<String>(Arrays.asList(serviceCodes.split(",")));
        List doctorInfoEntityList = this.doctorMapper.getDoctorInfoByHospitalIdAndAppCodeAndServiceCodes(hospitalId, appCode, serviceCodes = serviceCodeList.stream().collect(Collectors.joining("','", "'", "'")));
        List stdFirstDeptIdList = doctorInfoEntityList.stream().map(DoctorInfoEntity::getStdFirstDeptId).distinct().collect(Collectors.toList());
        if (stdFirstDeptIdList.isEmpty()) {
            return BaseResponse.success();
        }
        stdDeptVOS = stdDeptVOS.stream().filter(stdDept -> stdFirstDeptIdList.contains(stdDept.getStdFirstDeptId())).collect(Collectors.toList());
        List stdSecondDeptIdList = doctorInfoEntityList.stream().map(DoctorInfoEntity::getStdSecondDeptId).collect(Collectors.toList());
        for (ListStdDeptVO vo : stdDeptVOS) {
            List secondDeptVOS = this.organizationMapper.listSecondStdDeptInfo(vo.getStdFirstDeptId());
            secondDeptVOS = secondDeptVOS.stream().filter(secondDept -> stdSecondDeptIdList.contains(secondDept.getStdSecondDeptId())).collect(Collectors.toList());
            vo.setStdSecondDeptVOS(secondDeptVOS);
        }
        return BaseResponse.success(stdDeptVOS);
    }

    public BaseResponse<List<OrganBasicInfoRespVO>> queryOrganBasicInfo(OrganBasicInfoReqVO reqVO) {
        List infoRespVOS = this.organizationMapper.queryOrganBasicInfoList(reqVO);
        return BaseResponse.success((Object)infoRespVOS);
    }

    public GuideBaseResponse<List<GuideHospitalnfo>> getAllHospInfoByServiceCode(String partnerId) {
        if (StringUtils.isBlank((CharSequence)partnerId)) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        OrganizationByParamDTO dto = new OrganizationByParamDTO();
        dto.setServCode("51140");
        this.organizationMapper.selectOpenServiceOrgan(dto);
        List organizationVoList = this.organizationMapper.selectOpenServiceOrgan(dto);
        if (CollectionUtils.isEmpty((Collection)organizationVoList)) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        List organizationConfigEntityList = this.organizationConfigMapper.selectByPartnerId(partnerId);
        if (CollectionUtils.isEmpty((Collection)organizationConfigEntityList)) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        List hospitalIdList = organizationConfigEntityList.stream().map(organizationConfigEntity -> organizationConfigEntity.getHospitalId().toString()).collect(Collectors.toList());
        List guideHospitalnfoList = organizationVoList.stream().filter(organizationVo -> hospitalIdList.contains(organizationVo.getOrganId())).map(organizationVo -> {
            GuideHospitalnfo guideHospitalnfo = new GuideHospitalnfo();
            guideHospitalnfo.setHosId(organizationVo.getOrganId());
            guideHospitalnfo.setHosName(organizationVo.getOrganName());
            return guideHospitalnfo;
        }).collect(Collectors.toList());
        log.info("guideHospitalnfoList->{}", (Object)guideHospitalnfoList.toString());
        return GuideBaseResponse.success(guideHospitalnfoList, (String)MessageFormat.format("\u67e5\u8be2\u6210\u529f\uff0c\u5171\u67e5\u8be2{0}\u6761\u6570\u636e", guideHospitalnfoList.size()));
    }

    public GuideBaseResponse<List<GuideHospitaDetailVo>> getHospDetail(String hosId, String partnerId) {
        if (StringUtils.isBlank((CharSequence)partnerId)) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)Integer.valueOf(hosId));
        if (organizationEntity == null) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        List organizationConfigEntityList = this.organizationConfigMapper.selectByPartnerId(partnerId);
        if (CollectionUtils.isEmpty((Collection)organizationConfigEntityList)) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        List hospitalIdList = organizationConfigEntityList.stream().map(organizationConfigEntity -> organizationConfigEntity.getHospitalId().toString()).collect(Collectors.toList());
        if (!hospitalIdList.contains(organizationEntity.getId().toString())) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        GuideHospitaDetailVo guideHospitaDetailVo = new GuideHospitaDetailVo();
        guideHospitaDetailVo.setHosId(organizationEntity.getId().toString());
        guideHospitaDetailVo.setBranchId("");
        guideHospitaDetailVo.setHosName(organizationEntity.getOrganName());
        if (StringUtils.isNotBlank((CharSequence)organizationEntity.getIntroduction())) {
            guideHospitaDetailVo.setHosIntro(organizationEntity.getIntroduction().trim());
        } else {
            guideHospitaDetailVo.setHosIntro("");
        }
        guideHospitaDetailVo.setIsHTML(Boolean.valueOf(false));
        guideHospitaDetailVo.setHosLevel(organizationEntity.getLevelName() == null ? "" : organizationEntity.getLevelName());
        guideHospitaDetailVo.setHosAddress(organizationEntity.getAddress() == null ? "" : organizationEntity.getAddress());
        guideHospitaDetailVo.setHosTelephone(organizationEntity.getTelphone() == null ? "" : organizationEntity.getTelphone());
        guideHospitaDetailVo.setHosUrl(organizationEntity.getWebsite() == null ? "" : organizationEntity.getWebsite());
        guideHospitaDetailVo.setHosImage(organizationEntity.getLogo() == null ? "" : organizationEntity.getLogo());
        if (organizationEntity.getLongitude() != null && organizationEntity.getLatitude() != null) {
            guideHospitaDetailVo.setLocation(organizationEntity.getLongitude() + "," + organizationEntity.getLatitude());
        } else {
            guideHospitaDetailVo.setLocation("");
        }
        OrganizationConfigEntity organizationConfigEntity2 = this.organizationConfigMapper.selectByHosId(organizationEntity.getId().toString());
        if (organizationConfigEntity2 != null) {
            guideHospitaDetailVo.setMiniAppId(organizationConfigEntity2.getMiniAppId() == null ? "" : organizationConfigEntity2.getMiniAppId());
            guideHospitaDetailVo.setAppId(organizationConfigEntity2.getAppId() == null ? "" : organizationConfigEntity2.getAppId());
        } else {
            guideHospitaDetailVo.setMiniAppId("");
            guideHospitaDetailVo.setAppId("");
        }
        ArrayList<GuideHospitaDetailVo> guideHospitaDetailVoList = new ArrayList<GuideHospitaDetailVo>();
        guideHospitaDetailVoList.add(guideHospitaDetailVo);
        return GuideBaseResponse.success(guideHospitaDetailVoList, (String)MessageFormat.format("\u67e5\u8be2\u6210\u529f\uff0c\u5171\u67e5\u8be2{0}\u6761\u6570\u636e", guideHospitaDetailVoList.size()));
    }

    public GuideBaseResponse<List<GuideDeptListVo>> getDeptList(String hosId, String branchId) {
        List departmentVOS = this.docDepartmentMapper.queryHisDeptByOrganId(Integer.valueOf(hosId), "");
        if (departmentVOS.isEmpty()) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        List stdFirstDeptIdList = departmentVOS.stream().map(DepartmentVO::getFirstDeptId).distinct().collect(Collectors.toList());
        List stdDeptVOS = this.organizationMapper.listFirstStdDeptInfo();
        List guideDeptListVoList = stdDeptVOS.stream().filter(listStdDeptVO -> stdFirstDeptIdList.contains(listStdDeptVO.getStdFirstDeptId())).map(listStdDeptVO -> {
            GuideDeptListVo guideDeptListVo = new GuideDeptListVo();
            guideDeptListVo.setDeptId(listStdDeptVO.getStdFirstDeptId().toString());
            guideDeptListVo.setDeptIntro("");
            guideDeptListVo.setTreatrange("");
            guideDeptListVo.setParentDeptId("");
            guideDeptListVo.setDeptAddr("");
            guideDeptListVo.setFeatureFlag(0);
            guideDeptListVo.setDeptName(listStdDeptVO.getStdFirstDeptName());
            guideDeptListVo.setLevel(1);
            guideDeptListVo.setIsHTML(Boolean.valueOf(false));
            guideDeptListVo.setDeptUrl("");
            return guideDeptListVo;
        }).collect(Collectors.toList());
        if (guideDeptListVoList.isEmpty()) {
            return GuideBaseResponse.success(new ArrayList(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        List guideSecondDeptVoList = departmentVOS.stream().filter(departmentVO -> departmentVO.getDeptCode() != null).map(departmentVO -> {
            GuideDeptListVo guideDeptListVo = new GuideDeptListVo();
            guideDeptListVo.setDeptId(String.valueOf(departmentVO.getDeptCode()));
            int isPopular = departmentVO.getIsPopular() == null ? 0 : departmentVO.getIsPopular();
            guideDeptListVo.setFeatureFlag(isPopular);
            guideDeptListVo.setDeptName(departmentVO.getDeptName());
            guideDeptListVo.setLevel(2);
            guideDeptListVo.setParentDeptId(String.valueOf(departmentVO.getFirstDeptId()));
            String deptUrl = "/wisdomTreatment/pages/register/index?dept=";
            QueryHisDeptScheduleVo queryHisDeptScheduleVo = new QueryHisDeptScheduleVo();
            queryHisDeptScheduleVo.setStdseconddeptid(String.valueOf(departmentVO.getDeptCode()));
            queryHisDeptScheduleVo.setStdseconddeptname(departmentVO.getDeptName());
            try {
                deptUrl = deptUrl + URLEncoder.encode(JSON.toJSONString((Object)queryHisDeptScheduleVo), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("deptUrl\u7f16\u7801\u5f02\u5e38", (Throwable)e);
            }
            guideDeptListVo.setDeptUrl(deptUrl);
            guideDeptListVo.setIsHTML(Boolean.valueOf(false));
            guideDeptListVo.setDeptIntro(departmentVO.getDescription() == null ? "" : departmentVO.getDescription().trim());
            guideDeptListVo.setTreatrange("");
            guideDeptListVo.setDeptAddr("");
            return guideDeptListVo;
        }).collect(Collectors.toList());
        guideDeptListVoList.addAll(guideSecondDeptVoList);
        return GuideBaseResponse.success(guideDeptListVoList, (String)MessageFormat.format("\u67e5\u8be2\u6210\u529f\uff0c\u5171\u67e5\u8be2{0}\u6761\u6570\u636e", guideDeptListVoList.size()));
    }

    public BaseResponse<PageResult<OrganBasicInfoRespVO>> queryOrganBasicInfoPage(OrganBasicInfoReqVO reqVO) {
        PageHelper.startPage((int)reqVO.getPageNum(), (int)reqVO.getPageSize());
        Page infoRespVOS = (Page)this.organizationMapper.queryOrganBasicInfoList(reqVO);
        List records = infoRespVOS.getResult();
        PageResult result = new PageResult();
        result.setContent(records);
        result.setPageNum(reqVO.getPageNum().intValue());
        result.setPageSize(reqVO.getPageSize().intValue());
        result.setPageNum(infoRespVOS.getPageNum());
        result.setPageSize(infoRespVOS.getPageSize());
        result.setTotal((int)infoRespVOS.getTotal());
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<OrganBasicInfoRespVO> queryOrganInfoByIdOrOrganCode(BaseDTO dto) {
        OrganBasicInfoRespVO respVO = this.organizationMapper.queryOrganInfoByIdOrOrganCode(dto);
        if (Objects.nonNull(respVO)) {
            DictionaryEntity province = this.dictionaryMapper.findByDicCodeAndTypeCode(respVO.getProvince(), "province");
            DictionaryEntity city = this.dictionaryMapper.findByDicCodeAndTypeCode(respVO.getCity(), "city");
            DictionaryEntity district = this.dictionaryMapper.findByDicCodeAndTypeCode(respVO.getDistrict(), "district");
            respVO.setProvinceName(Objects.isNull(province) ? "" : province.getDicName());
            respVO.setCityName(Objects.isNull(city) ? "" : respVO.getProvinceName());
            respVO.setDistrictName(Objects.isNull(district) ? "" : respVO.getProvinceName());
        }
        return BaseResponse.success((Object)respVO);
    }

    public BaseResponse<String> organOpenHomePageById(OrganHomePageReqVO reqVO) {
        log.info(INTO_ARGS, (Object)reqVO);
        OrganizationEntity entity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)reqVO.getId());
        if (entity == null) {
            log.error(DATA_NOT_EXIS);
            return BaseResponse.error((IError)EHErrorEnum.DATA_NOT_EXIST);
        }
        OrganizationEntity organizationEntity = new OrganizationEntity();
        BeanUtils.copyProperties((Object)reqVO, (Object)organizationEntity);
        this.organizationMapper.updateByPrimaryKeySelective(organizationEntity);
        log.info("\u7f16\u8f91\u533b\u9662\u4fe1\u606f\u6210\u529f");
        return BaseResponse.success();
    }

    public BaseResponse supervisionPlatformDocking(OrganSupervisionVo organSupervisionVo) {
        this.organizationMapper.updateSupervisionById(organSupervisionVo);
        return BaseResponse.success();
    }

    public BaseResponse getOrganSuperVisionById(Long id) {
        OrganSupervisionVo organSupervisionVo = this.organizationMapper.selectOrganSupervVisionById(id);
        return BaseResponse.success((Object)organSupervisionVo);
    }

    public OrganizationEntity getOrganByOrganName(String organName) {
        OrganizationEntity organizationEntity = this.organizationMapper.getOrganByName(organName, Integer.toString(1));
        if (null == organizationEntity) {
            return new OrganizationEntity();
        }
        return organizationEntity;
    }

    public List<OrganizationEntity> getOrganIntroductionByAppCode(String appCode) {
        return this.organizationMapper.selectByAppCodeAndOrganOnOff(appCode, Integer.valueOf(1));
    }

    public List<ListStdDeptVO> getListFirstStdDeptInfo() {
        return this.organizationMapper.listFirstStdDeptInfo();
    }

    public List<StdSecondDeptVO> getListSecondStdDeptInfoByRelDeptId(Integer relDeptId) {
        return this.organizationMapper.listSecondStdDeptInfo(relDeptId);
    }

    public List<StdSecondDeptVO> getListSecondStdDeptInfo(String search) {
        return this.organizationMapper.listSecondStdDeptInfoAll(search);
    }

    public BaseResponse<String> syncHomePage(HospitalModel reqVO) {
        log.info("\u540c\u6b65\u533b\u9662\u4fe1\u606f\u5165\u53c2:{}", (Object)reqVO);
        OrganizationEntity entity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)reqVO.getOran_id());
        if (entity == null) {
            log.error("\u540c\u6b65\u533b\u9662\u6570\u636e\u4e0d\u5b58\u5728");
            return BaseResponse.error((IError)EHErrorEnum.DATA_NOT_EXIST);
        }
        OrganizationEntity newEntity = new OrganizationEntity();
        newEntity.setId(reqVO.getOran_id());
        newEntity.setLogo(reqVO.getLogo_link());
        newEntity.setCalligraphyName(reqVO.getName_link());
        newEntity.setOrganBackground(reqVO.getBgPicture_link());
        newEntity.setOrganLabel(reqVO.getTagList());
        this.organizationMapper.updateByPrimaryKeySelective(newEntity);
        log.info("\u540c\u6b65\u533b\u9662\u4fe1\u606f\u6210\u529f");
        return BaseResponse.success();
    }

    @Transactional
    public BaseResponse<String> openHomePageById(OpenHomeVO reqVO) {
        if (reqVO.getId() == null) {
            return BaseResponse.error((String)"\u975e\u6cd5\u53c2\u6570");
        }
        OrganizationEntity entity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)reqVO.getId());
        if (entity == null) {
            log.error("\u540c\u6b65\u533b\u9662\u6570\u636e\u4e0d\u5b58\u5728");
            return BaseResponse.error((IError)EHErrorEnum.DATA_NOT_EXIST);
        }
        OrganizationEntity newEntity = new OrganizationEntity();
        newEntity.setId(reqVO.getId());
        newEntity.setOrganOnOff(reqVO.getOrganOnOff());
        this.organizationMapper.updateByPrimaryKeySelective(newEntity);
        return BaseResponse.success();
    }

    public BaseResponse<List<OrganInfoReqVO>> getOpenOrgan(OrganInfoReqVO reqVO) {
        List organList = this.organizationMapper.getOpenOrgan(reqVO);
        return BaseResponse.success((Object)organList);
    }

    public BaseResponse<List<OrganInfoReqVO>> selectOrganList(ListOrganDTO dto) {
        List organList = this.organizationMapper.selectOrganList(dto);
        return BaseResponse.success((Object)organList);
    }
}

