/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.doctor.basedata.api.dto.PatientEvaluationDTO;
import com.doctor.basedata.api.vo.UcUserEvaluationVO;
import com.doctoruser.doctor.mapper.UcUserEvaluationMapper;
import com.doctoruser.doctor.pojo.vo.EvaluationRspVO;
import com.doctoruser.doctor.pojo.vo.GraphDataVO;
import com.doctoruser.doctor.service.PatientEvaluationService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PatientEvaluationServiceImpl
implements PatientEvaluationService {
    private static final Logger log = LoggerFactory.getLogger(PatientEvaluationServiceImpl.class);
    @Autowired
    private UcUserEvaluationMapper ucUserEvaluationMapper;
    private final Byte disPlayStatus = 1;
    private final Byte noDisPlayStatus = 0;
    private static final String GOOD = "\u597d\u8bc4\u7387";
    private static final String MIDDLE = "\u4e2d\u8bc4\u7387";
    private static final String BAD = "\u5dee\u8bc4\u7387";

    public BaseResponse<EvaluationRspVO> listEvaluation(PatientEvaluationDTO dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        Page pageResult = this.ucUserEvaluationMapper.listEvaluation(dto);
        Long totalNum = pageResult.getTotal();
        List statisticsList = this.ucUserEvaluationMapper.countEvaluation(dto);
        Long displayNum = 0L;
        Long unDisplayNum = 0L;
        Long goodNum = 0L;
        Long middleNum = 0L;
        Long badNum = 0L;
        if (!CollectionUtils.isEmpty((Collection)statisticsList)) {
            displayNum = statisticsList.stream().filter(x -> x.getDisplay().equals(this.disPlayStatus)).count();
            unDisplayNum = statisticsList.stream().filter(x -> x.getDisplay().equals(this.noDisPlayStatus)).count();
            goodNum = statisticsList.stream().filter(x -> x.getDoctorScore().intValue() >= 4 && x.getDoctorScore().intValue() <= 5).count();
            middleNum = statisticsList.stream().filter(x -> x.getDoctorScore().intValue() == 3).count();
            badNum = statisticsList.stream().filter(x -> x.getDoctorScore().intValue() >= 1 && x.getDoctorScore().intValue() <= 2).count();
        }
        ArrayList tagList = new ArrayList();
        statisticsList.stream().map(UcUserEvaluationVO::getTagsName).forEach(tags -> {
            if (Objects.nonNull(tags)) {
                tagList.addAll(Stream.of(tags.split(",")).collect(Collectors.toList()));
            }
        });
        Map<String, List<String>> labelMap = tagList.stream().filter(x -> !x.equals("")).collect(Collectors.groupingBy(x -> x));
        ArrayList<GraphDataVO> labelGraph = new ArrayList<GraphDataVO>(labelMap.size());
        for (Map.Entry<String, List<String>> entry : labelMap.entrySet()) {
            GraphDataVO graphDataVO = new GraphDataVO(entry.getKey(), Long.valueOf(entry.getValue().size()));
            labelGraph.add(graphDataVO);
        }
        List<GraphDataVO> gradeGraph = Arrays.asList(new GraphDataVO(GOOD, goodNum), new GraphDataVO(MIDDLE, middleNum), new GraphDataVO(BAD, badNum));
        List totalStatisticsList = this.ucUserEvaluationMapper.countTotalEvaluation(dto);
        Long totalGoodNum = 0L;
        Long totalMiddleNum = 0L;
        Long totalBadNum = 0L;
        if (!CollectionUtils.isEmpty((Collection)totalStatisticsList)) {
            totalGoodNum = totalStatisticsList.stream().filter(x -> x.getDoctorScore().intValue() >= 4 && x.getDoctorScore().intValue() <= 5).count();
            totalMiddleNum = totalStatisticsList.stream().filter(x -> x.getDoctorScore().intValue() == 3).count();
            totalBadNum = totalStatisticsList.stream().filter(x -> x.getDoctorScore().intValue() >= 1 && x.getDoctorScore().intValue() <= 2).count();
        }
        EvaluationRspVO evaluationRspVO = EvaluationRspVO.builder().evaluationList(pageResult).totalNum(totalNum).displayNum(displayNum).unDisplayNum(unDisplayNum).goodNum(totalGoodNum).middleNum(totalMiddleNum).badNum(totalBadNum).labelGraph(labelGraph).gradeGraph(gradeGraph).build();
        return BaseResponse.success((Object)evaluationRspVO);
    }
}

