/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctor.basedata.api.DictionaryBaseApi;
import com.doctor.basedata.api.vo.DictionaryResp;
import com.doctoruser.api.DictionaryApi;
import com.doctoruser.api.pojo.vo.dictionary.DictionaryAndChildrenRes;
import com.doctoruser.api.pojo.vo.dictionary.DictionaryParentReqVO;
import com.doctoruser.api.pojo.vo.dictionary.DictionaryRespVO;
import com.doctoruser.api.pojo.vo.dictionary.DictionaryTypeReqVO;
import com.doctoruser.doctor.pojo.entity.DictionaryEntity;
import com.doctoruser.doctor.pojo.entity.DictionaryTypeEntity;
import com.doctoruser.doctor.service.IDictionaryService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5b57\u5178\u670d\u52a1"})
public class DictionaryController
implements DictionaryApi,
DictionaryBaseApi {
    @Resource
    private IDictionaryService dictionaryService;

    public BaseResponse<DictionaryRespVO> queryByType(@RequestBody DictionaryTypeReqVO reqVO) {
        return this.dictionaryService.findByType(reqVO.getType(), reqVO.getCode());
    }

    public BaseResponse<Map<String, DictionaryRespVO>> queryListByType(@RequestBody DictionaryTypeReqVO reqVO) {
        return this.dictionaryService.findByType(reqVO.getType());
    }

    public BaseResponse<DictionaryRespVO> queryByParent(@RequestBody DictionaryParentReqVO reqVO) {
        return this.dictionaryService.findByParent(reqVO.getParentCode(), reqVO.getCode());
    }

    public BaseResponse<Map<String, DictionaryRespVO>> queryListByParent(@RequestBody DictionaryParentReqVO reqVO) {
        return this.dictionaryService.findByParent(reqVO.getParentCode());
    }

    public BaseResponse<List<DictionaryAndChildrenRes>> findDictionaryAndChildrenByType(@RequestBody DictionaryTypeReqVO reqVO) {
        return this.dictionaryService.findDictionaryAndChildrenByType(reqVO.getType());
    }

    @ApiOperation(value="\u8d85\u7ba1\u7aef-\u56fd\u6807\u4e09\u7ea7\u8054\u52a8", notes="\u8d85\u7ba1\u7aef-\u56fd\u6807\u4e09\u7ea7\u8054\u52a8")
    @RequestMapping(value={"/dictionary_gb_List"}, method={RequestMethod.GET})
    public BaseResponse<List<DictionaryAndChildrenRes>> getDictionaryList() {
        return this.dictionaryService.getDictionaryList();
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u804c\u4e1a\u7c7b\u578b\u96c6\u5408")
    @GetMapping(value={"/getDocProfession"})
    public BaseResponse<List<DictionaryTypeEntity>> getDocProfession() {
        return this.dictionaryService.getDocProfession();
    }

    @ApiOperation(value="\u67e5\u8be2\u804c\u4e1a\u804c\u79f0\u4fe1\u606f\u96c6\u5408")
    @GetMapping(value={"/getProfessionTitle"})
    public BaseResponse<List<DictionaryEntity>> getProfessionTitle() {
        return this.dictionaryService.getProfessionTitle();
    }

    @ApiOperation(value="\u6839\u636e\u7236\u5b57\u5178code\u67e5\u8be2\u5b50\u5b57\u5178")
    @GetMapping(value={"/getDictionaryByParentCode"})
    public BaseResponse<List<DictionaryEntity>> getDictionaryByParentCode(@RequestParam(value="parentCode") String parentCode) {
        return this.dictionaryService.getDictionaryByParentCode(parentCode);
    }

    public BaseResponse<DictionaryResp> getProfessionByTitle(@RequestParam(value="professionCode") String professionCode) {
        return this.dictionaryService.getProfessionByTitle(professionCode);
    }
}

