/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.factory;

import com.doctoruser.doctor.handler.DocServiceHandler;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DocServiceFactory.class);
    @Autowired
    private Map<String, DocServiceHandler> doctorServerMap = new ConcurrentHashMap(14);

    public DocServiceHandler getDocServiceHandler(String serviceCode) {
        DocServiceHandler docServiceHandler = (DocServiceHandler)this.doctorServerMap.get(serviceCode);
        if (Objects.isNull(docServiceHandler)) {
            log.info("null factory: {}", (Object)serviceCode);
            return (DocServiceHandler)this.doctorServerMap.get("common");
        }
        return docServiceHandler;
    }
}

