/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorDetailsInfoVO;
import com.doctoruser.doctor.exception.BusinessException;
import com.doctoruser.doctor.mapper.NewCommonMapper;
import com.doctoruser.doctor.mapper.UcHospitalInfoMapper;
import com.doctoruser.doctor.pojo.entity.UcHospitalInfoEntity;
import com.doctoruser.doctor.service.NewCommonService;
import com.doctoruser.doctor.token.TokenBody;
import com.doctoruser.doctor.token.TokenJson;
import com.doctoruser.doctor.token.exception.TokenParseException;
import com.doctoruser.doctor.utils.Tokenutil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common"})
public class NewCommonController {
    private static final Logger log = LoggerFactory.getLogger(NewCommonController.class);
    @Autowired
    private NewCommonService newCommonService;
    @Autowired
    private UcHospitalInfoMapper ucHospitalInfoMapper;
    @Autowired
    private NewCommonMapper newCommonMapper;

    @GetMapping(value={"/accessPersonalInfo"})
    public BaseResponse<DoctorDetailsInfoVO> accessPersonalInfo(@RequestParam(value="loginDoctorId") Integer loginDoctorId, HttpServletRequest servletRequest) {
        String token = servletRequest.getHeader("token");
        if (token == null) {
            throw new BusinessException("\u8bf7\u6c42\u5934\u4e2dtoken\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String appCode = servletRequest.getHeader("appCode");
        if (appCode == null) {
            throw new BusinessException("\u8bf7\u6c42\u5934\u4e2dappCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UcHospitalInfoEntity ucHospitalInfoEntity = this.ucHospitalInfoMapper.queryHospitalInfo(appCode);
        if (ucHospitalInfoEntity == null) {
            throw new BusinessException("\u8bf7\u6c42\u5934\u4e2dappCode\u4f20\u53c2\u9519\u8bef");
        }
        String tokenKey = ucHospitalInfoEntity.getTokenKey();
        try {
            TokenBody tokenBody = Tokenutil.parse((String)token, (String)tokenKey);
            TokenJson tokenJson = tokenBody.getTokenJson();
            String userId = tokenJson.getUserId();
            List userIdList = this.newCommonMapper.findUserIdList(loginDoctorId.toString());
            if (!userIdList.contains(userId)) {
                throw new BusinessException("\u4e0d\u53ef\u4ee5\u67e5\u770b\u5176\u5b83\u7528\u6237\u7684\u4fe1\u606f");
            }
        }
        catch (TokenParseException e) {
            log.error("token\u89e3\u6790\u9519\u8bef{}", (Throwable)e);
            throw new BusinessException("token\u89e3\u6790\u9519\u8bef");
        }
        DoctorDetailsInfoVO doctorDetailsInfoVO = this.newCommonService.accessPersonalInfo(loginDoctorId);
        if (doctorDetailsInfoVO == null) {
            return BaseResponse.success(null);
        }
        return BaseResponse.success((Object)doctorDetailsInfoVO);
    }
}

