/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctor.basedata.api.vo.GetOrganByParamDto;
import com.doctoruser.api.OrganInfoApi;
import com.doctoruser.api.pojo.base.bo.OrganWorkServiceBo;
import com.doctoruser.api.pojo.base.dto.organ.OrganIdVo;
import com.doctoruser.api.pojo.base.dto.organ.OrganInfoByIdReq;
import com.doctoruser.api.pojo.base.dto.organ.OrganInfoByOrganCodeReq;
import com.doctoruser.api.pojo.base.dto.organ.OrganInfoByOrganCodeRes;
import com.doctoruser.api.pojo.base.dto.orgnazition.ListDeptDoctorDTO;
import com.doctoruser.api.pojo.base.entity.OrganWorkingServiceEntity;
import com.doctoruser.api.pojo.base.vo.OrganInfoByCodeReq;
import com.doctoruser.api.pojo.base.vo.OrganServiceInfoVo;
import com.doctoruser.api.pojo.base.vo.OrganizationEntity;
import com.doctoruser.api.pojo.base.vo.OrganizationVo;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorDetailsVO;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorListInfoVO;
import com.doctoruser.api.pojo.base.vo.doctor.ListDoctorParamVO;
import com.doctoruser.api.pojo.base.vo.doctor.OrganIdReqVO;
import com.doctoruser.api.pojo.base.vo.doctor.StandDeptIdVO;
import com.doctoruser.api.pojo.base.vo.doctor.StandDeptInfoVO;
import com.doctoruser.api.pojo.base.vo.doctor.StandDeptReqVO;
import com.doctoruser.api.pojo.base.vo.doctor.StandardDeptResVO;
import com.doctoruser.api.pojo.base.vo.organization.DepartmentVO;
import com.doctoruser.api.pojo.base.vo.organization.DeptCountVO;
import com.doctoruser.api.pojo.base.vo.organization.ListDeptParamVO;
import com.doctoruser.api.pojo.base.vo.organization.ListOrganParamVO;
import com.doctoruser.api.pojo.base.vo.organization.OrganServiceInfoVO;
import com.doctoruser.api.pojo.base.vo.organization.OrganizationVO;
import com.doctoruser.api.pojo.base.vo.organization.QueryDeptParamVO;
import com.doctoruser.api.pojo.base.vo.organization.QueryOrganParamVO;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.organization.DeptByParamDTO;
import com.doctoruser.api.pojo.dto.organization.DoctorByParamDTO;
import com.doctoruser.api.pojo.dto.organization.OrganizationByParamDTO;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.pojo.vo.OrganizationInfoVo;
import com.doctoruser.doctor.pojo.vo.PlatformOrganizationVo;
import com.doctoruser.doctor.pojo.vo.QueryDoctorInfoReqVo;
import com.doctoruser.doctor.service.IOrganInfoService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8282\u70b9\u8fc1\u79fb\u533b\u9662\u63a5\u53e3"})
public class OrganInfoController
implements OrganInfoApi {
    @Resource
    private IOrganInfoService organService;

    public BaseResponse<List<OrganizationVo>> queryOrganizations(@RequestParam(value="appCode") String appCode) {
        OrganizationByParamDTO dto = new OrganizationByParamDTO();
        dto.setOrganType(Integer.valueOf(1));
        dto.setAppCode(appCode);
        return BaseResponse.success((Object)this.organService.queryOrganization(dto));
    }

    public BaseResponse<List<OrganWorkingServiceEntity>> queryOrganServiceByOrganId(@RequestBody OrganIdVo req) {
        return BaseResponse.success((Object)this.organService.queryOrganServiceByOrganId(req.getOrganId()));
    }

    public BaseResponse<List<Integer>> queryOgranServTypeByOrganId(@RequestBody OrganIdVo param) {
        List listBaseResponse = this.organService.queryOrganServiceByOrganId(param.getOrganId());
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (OrganWorkingServiceEntity organWorkingServiceEntity : listBaseResponse) {
            if (null == organWorkingServiceEntity.getServType()) continue;
            list.add(organWorkingServiceEntity.getServType());
        }
        return BaseResponse.success(list);
    }

    public BaseResponse<OrganInfoByOrganCodeRes> getOrganInfoByUrHospitalIdReq(@RequestBody OrganInfoByOrganCodeReq req) {
        return null;
    }

    public BaseResponse<OrganizationVo> getOrganInfoById(@RequestBody OrganInfoByIdReq req) {
        OrganizationByParamDTO dto = new OrganizationByParamDTO();
        dto.setOrganId(req.getOrganId());
        List list = this.organService.queryOrganization(dto);
        if (null != list && list.size() > 0) {
            return BaseResponse.success(list.get(0));
        }
        return BaseResponse.success();
    }

    public BaseResponse<OrganizationVo> getOrganInfoByCode(@RequestBody OrganInfoByCodeReq req) {
        OrganizationByParamDTO dto = new OrganizationByParamDTO();
        dto.setOrganCode(req.getOrganCode());
        List list = this.organService.queryOrganization(dto);
        if (null != list && list.size() > 0) {
            return BaseResponse.success(list.get(0));
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<OrganServiceInfoVo>> listOrganServInfoByServCode(@RequestBody OrganWorkServiceBo organWSBo) {
        return null;
    }

    public BaseResponse<List<OrganizationVO>> fuzzyQueryOrganizations(@RequestBody ListOrganParamVO param) {
        ArrayList organizationVOS = new ArrayList();
        OrganizationByParamDTO dto = new OrganizationByParamDTO();
        dto.setServCode(param.getServCode());
        dto.setOrganName(param.getOrganName());
        dto.setAppCode(param.getAppCode());
        dto.setOrganType(Integer.valueOf(1));
        List list = this.organService.queryOrganization(dto);
        if (null != list && list.size() > 0) {
            list.forEach(e -> {
                OrganizationVO organizationVO = new OrganizationVO();
                BeanUtils.copyProperties((Object)e, (Object)organizationVO);
                organizationVOS.add(organizationVO);
            });
        }
        return BaseResponse.success(organizationVOS);
    }

    public BaseResponse<PageResult<OrganizationVO>> fuzzyQueryOrganizationsPage(@RequestBody ListOrganParamVO param) {
        if (param.getPageNum() < 0) {
            return BaseResponse.error((IError)EHErrorEnum.PARAM_CHECK_FAILD);
        }
        return this.organService.fuzzyQueryOrganizationsPage(param);
    }

    public BaseResponse<OrganizationVO> queryOrganByOrganId(@RequestBody QueryOrganParamVO param) {
        OrganizationVO organizationVo = new OrganizationVO();
        OrganizationByParamDTO dto = new OrganizationByParamDTO();
        dto.setOrganId(param.getOrganId());
        List list = this.organService.queryOrganization(dto);
        if (null != list && list.size() > 0) {
            BeanUtils.copyProperties(list.get(0), (Object)organizationVo);
        }
        return BaseResponse.success((Object)organizationVo);
    }

    public BaseResponse<List<DepartmentVO>> fuzzyListDeptByOrganId(@RequestBody ListDeptParamVO param) {
        DeptByParamDTO dto = new DeptByParamDTO();
        dto.setOrganId(param.getOrganId() + "");
        dto.setDeptName(param.getDeptName());
        return BaseResponse.success((Object)this.organService.queryDeptByParam(dto));
    }

    public BaseResponse<List<DepartmentVO>> fuzzyListDeptByOrganIdAndName(@RequestBody ListDeptParamVO param) {
        DeptByParamDTO dto = new DeptByParamDTO();
        dto.setOrganId(param.getOrganId() + "");
        dto.setDeptName(param.getDeptName());
        return BaseResponse.success((Object)this.organService.queryDeptByParam(dto));
    }

    public BaseResponse<DepartmentVO> getDeptInfoById(@RequestBody QueryDeptParamVO param) {
        DeptByParamDTO dto = new DeptByParamDTO();
        dto.setDeptId(param.getDeptId() + "");
        List success = this.organService.queryDeptByParam(dto);
        if (null != success && success.size() > 0) {
            return BaseResponse.success(success.get(0));
        }
        return BaseResponse.success(null);
    }

    public BaseResponse<List<DoctorListInfoVO>> listDeptBaseData(@RequestBody ListDoctorParamVO param) {
        return this.organService.queryDoctorInfoByDeptId(Integer.valueOf(param.getDeptId()).intValue(), param.getDoctorName());
    }

    public BaseResponse<List<StandardDeptResVO>> queryStandDeptByOrganId(@RequestBody StandDeptReqVO param) {
        return BaseResponse.success((Object)this.organService.queryStandDeptByOrganId(param.getOrganId(), param.getStandName()));
    }

    public BaseResponse<DeptCountVO> queryDeptCountByOrganId(@RequestBody OrganIdReqVO param) {
        DeptByParamDTO dto = new DeptByParamDTO();
        dto.setOrganId(param.getOrganId() + "");
        List listBaseResponse = this.organService.queryDeptByParam(dto);
        DeptCountVO deptCountVO = new DeptCountVO();
        if (null != listBaseResponse) {
            deptCountVO.setCount(Integer.valueOf(listBaseResponse.size()));
        }
        return BaseResponse.success((Object)deptCountVO);
    }

    public BaseResponse<StandDeptInfoVO> queryStandDeptInfoById(@RequestBody StandDeptIdVO param) {
        return BaseResponse.success((Object)this.organService.queryStandDeptInfoById(param.getStandDeptId()));
    }

    public BaseResponse<List<OrganServiceInfoVO>> queryOrganServiceInfo(@RequestBody BaseDTO dto) {
        List organWorkingServiceEntities = this.organService.queryOrganServiceByOrganId(dto.getId() + "");
        ArrayList list = new ArrayList();
        organWorkingServiceEntities.forEach(e -> {
            OrganServiceInfoVO organServiceInfoVO = new OrganServiceInfoVO();
            BeanUtils.copyProperties((Object)e, (Object)organServiceInfoVO);
            organServiceInfoVO.setOrganId(e.getOrganId());
            list.add(organServiceInfoVO);
        });
        return BaseResponse.success(list);
    }

    public BaseResponse<List<DepartmentVO>> listNetworkClinicDepartment(@RequestBody BaseDTO dto) {
        return BaseResponse.success((Object)this.organService.listNetworkClinicDepartment(dto.getId() + ""));
    }

    public BaseResponse<List<DoctorDetailsVO>> listDoctorInfo(@RequestBody BaseDTO dto) {
        DoctorByParamDTO doctorByParamDTO = new DoctorByParamDTO();
        doctorByParamDTO.setHospitalDeptId(dto.getId() + "");
        doctorByParamDTO.setServCode(dto.getCode());
        return BaseResponse.success((Object)this.organService.listDeptDoctorInfo(doctorByParamDTO));
    }

    public BaseResponse<PageResult<DoctorDetailsVO>> listDeptDoctorInfo(@RequestBody ListDeptDoctorDTO dto) {
        return this.organService.pageListDeptDoctorInfo(dto);
    }

    public BaseResponse<List<DoctorDetailsVO>> fuzzyListDoctor(@RequestBody BaseDTO dto) {
        DoctorByParamDTO doctorByParamDTO = new DoctorByParamDTO();
        doctorByParamDTO.setSearchParam(dto.getCode());
        doctorByParamDTO.setServCode("wlmz");
        return BaseResponse.success((Object)this.organService.listDeptDoctorInfo(doctorByParamDTO));
    }

    public BaseResponse<List<OrganizationVo>> getAreaOrganization(@RequestParam(value="cityCode", required=false) String cityCode, @RequestParam(value="serviceCode", required=false) String serviceCode, @RequestParam(value="appCode", required=false) String appCode) {
        if (StringUtils.isNotBlank((String)serviceCode)) {
            String[] split = serviceCode.split(",");
            serviceCode = Arrays.stream(split).collect(Collectors.joining("','", "'", "'"));
        }
        OrganizationByParamDTO dto = new OrganizationByParamDTO();
        dto.setCityCode(cityCode);
        dto.setServCode(serviceCode);
        dto.setAppCode(appCode);
        return BaseResponse.success((Object)this.organService.queryOrganizationList(dto));
    }

    public BaseResponse<OrganizationEntity> getOrganInfoById(@RequestParam(value="organId") Long organId) {
        return this.organService.getOrganInfoById(organId);
    }

    @ApiOperation(value="\u6839\u636eid\u4fe1\u606f\u67e5\u8be2\u5e73\u53f0\u533b\u9662")
    @GetMapping(value={"/getOrganInfoByIds"})
    public BaseResponse<List<OrganizationVo>> getOrganInfoByIds(@RequestParam(value="appCode", required=false) String appCode, @RequestParam(value="organIds") String organIds) {
        List<Object> organIdList = new ArrayList();
        if (StringUtils.isNotBlank((String)organIds)) {
            organIdList = Arrays.asList(organIds.split(","));
        }
        return this.organService.getOrganInfoByIds(appCode, organIdList);
    }

    @ApiOperation(value="\u5e73\u53f0\u533b\u9662\u5165\u9a7b\u63a5\u53e3")
    @PostMapping(value={"/savePlatformOrganization"})
    public BaseResponse savePlatformOrganization(@RequestBody PlatformOrganizationVo platformOrganizationVo) {
        return this.organService.savePlatformOrganization(platformOrganizationVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5730\u533a\u533b\u9662\u5217\u8868(V2-\u591a\u5b66\u79d1\u4f1a\u8bca\u652f\u6301\u63a5\u53e3)", notes="\u6839\u636e\u5e02\u7ea7\u5730\u533a\u67e5\u8be2\u533b\u9662(V2-\u591a\u5b66\u79d1\u4f1a\u8bca\u652f\u6301\u63a5\u53e3)")
    @GetMapping(value={"/getAreaOrganizationIteration"})
    public BaseResponse<List<OrganizationInfoVo>> getAreaOrganizationIteration(@RequestParam(value="cityCode", required=false) String cityCode, @RequestParam(value="serviceCode", required=false) String serviceCode, @RequestParam(value="appCode", required=false) String appCode, @RequestParam(value="level", required=false) String level, @RequestParam(value="search", required=false) String search, @RequestParam(value="hospitalId", required=false) String hospitalId) {
        if (StringUtils.isNotBlank((String)serviceCode)) {
            String[] split = serviceCode.split(",");
            serviceCode = Arrays.stream(split).collect(Collectors.joining("','", "'", "'"));
        }
        GetOrganByParamDto dto = new GetOrganByParamDto();
        dto.setCityCode(cityCode);
        dto.setServCode(serviceCode);
        dto.setAppCode(appCode);
        dto.setLevel(level);
        dto.setSearch(search);
        if (StringUtils.isNotBlank((String)hospitalId)) {
            dto.setHospitalId(Integer.valueOf(Integer.parseInt(hospitalId)));
        }
        return BaseResponse.success((Object)this.organService.queryOrganizationListIteration(dto));
    }

    @ApiOperation(value="\u6839\u636e\u533b\u751f\u540d\u79f0\u6a21\u7cca\u4fe1\u606f\u67e5\u8be2\u5e73\u53f0\u533b\u9662")
    @PostMapping(value={"/getOrganInfoByName"})
    public BaseResponse<List<DoctorDetailsVO>> getOrganInfoByName(@RequestBody QueryDoctorInfoReqVo reqVo) {
        DoctorByParamDTO doctorByParamDTO = new DoctorByParamDTO();
        doctorByParamDTO.setOrganId(reqVo.getOrganId());
        doctorByParamDTO.setServCode(reqVo.getServCode());
        doctorByParamDTO.setSearchParam(reqVo.getDoctorName());
        return BaseResponse.success((Object)this.organService.listDeptDoctorInfo(doctorByParamDTO));
    }
}

