/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.controller;

import com.doctor.basedata.api.vo.HospitalModel;
import com.doctor.basedata.api.vo.OrganDistanceLocationReqVO;
import com.doctor.basedata.api.vo.OrganInfoReqVO;
import com.doctor.basedata.api.vo.OrganManageDetailVo;
import com.doctor.basedata.api.vo.OrganSupervisionVo;
import com.doctoruser.api.OrganizationApi;
import com.doctoruser.api.pojo.base.dto.organ.OrganIdVo;
import com.doctoruser.api.pojo.base.entity.OrganWorkingServiceEntity;
import com.doctoruser.api.pojo.base.vo.basedata.GuideBaseResponse;
import com.doctoruser.api.pojo.base.vo.doctor.StandDeptReqVO;
import com.doctoruser.api.pojo.base.vo.doctor.StandardDeptResVO;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.OrganInfoListDTO;
import com.doctoruser.api.pojo.dto.OrganInfoReq;
import com.doctoruser.api.pojo.dto.OrganizationReq;
import com.doctoruser.api.pojo.dto.organization.ListOrganByAppCodeDTO;
import com.doctoruser.api.pojo.dto.organization.ListOrganDTO;
import com.doctoruser.api.pojo.dto.organization.ManagerDeptDTO;
import com.doctoruser.api.pojo.dto.organization.OrganizationStatusDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganDetailDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganNameDTO;
import com.doctoruser.api.pojo.dto.organization.SaveOrganInCloudDTO;
import com.doctoruser.api.pojo.dto.organization.UpdateOrganDTO;
import com.doctoruser.api.pojo.vo.BeanRespVO;
import com.doctoruser.api.pojo.vo.GuideDeptListVo;
import com.doctoruser.api.pojo.vo.GuideHospitaDetailVo;
import com.doctoruser.api.pojo.vo.GuideHospitalnfo;
import com.doctoruser.api.pojo.vo.OrganBasicInfoReqVO;
import com.doctoruser.api.pojo.vo.OrganBasicInfoRespVO;
import com.doctoruser.api.pojo.vo.OrganDetailAllRespVO;
import com.doctoruser.api.pojo.vo.OrganDistanceListRespVO;
import com.doctoruser.api.pojo.vo.OrganHomePageReqVO;
import com.doctoruser.api.pojo.vo.OrganInfoRespVO;
import com.doctoruser.api.pojo.vo.SevrCodeGetDeptReqVO;
import com.doctoruser.api.pojo.vo.basedata.organization.DoctorNumberVO;
import com.doctoruser.api.pojo.vo.basedata.organization.ListOrganVO;
import com.doctoruser.api.pojo.vo.basedata.organization.ListStdDeptVO;
import com.doctoruser.api.pojo.vo.basedata.organization.OrganCodeInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.OrganNodeInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganNameVO;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.pojo.vo.OpenHomeVO;
import com.doctoruser.doctor.pojo.vo.OrganRelVO;
import com.doctoruser.doctor.service.IOrganizationService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e91\u4e0a\u533b\u9662\u76f8\u5173\u63a5\u53e3"})
public class OrganizationController
implements OrganizationApi {
    @Autowired
    private IOrganizationService organizationService;

    public BaseResponse<PageResult<ListOrganVO>> queryOrganList(@RequestBody ListOrganDTO dto) {
        if (null == dto || null == dto.getHospitalId()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.listOrganInfo(dto);
    }

    public BaseResponse<List<ListOrganVO>> managerQueryAllOrganList(@RequestBody BaseDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.managerQueryAllOrganList(dto);
    }

    public BaseResponse<List<ListOrganVO>> queryAllOrganList(@RequestBody ListOrganDTO dto) {
        if (null == dto || null == dto.getHospitalId()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.listAllOrganInfo(dto);
    }

    public BaseResponse<PageResult<ListOrganVO>> queryAreaOrganList(@RequestBody ListOrganDTO dto) {
        return this.organizationService.listAreaOrganInfo(dto);
    }

    public BaseResponse<List<ListStdDeptVO>> queryDeptList() {
        return this.organizationService.listStdDeptInfo();
    }

    public BaseResponse<QueryOrganDetailVO> queryOrganDetail(@RequestBody QueryOrganDetailDTO dto) {
        if (null == dto || null == dto.getOrganId()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.queryOrganDetailsInfo(dto.getOrganId());
    }

    public BaseResponse<DoctorNumberVO> queryDoctorNum(@RequestBody QueryOrganDetailDTO dto) {
        if (null == dto || null == dto.getOrganId()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.queryOrganDoctorAndFamousDoctorNum(dto.getOrganId());
    }

    public BaseResponse<List<ListOrganVO>> queryAllHospital() {
        return this.organizationService.listAllhospital();
    }

    public BaseResponse<String> saveStdDept(@RequestBody ManagerDeptDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.saveStdDeptInfo(dto);
    }

    public BaseResponse<String> updateStdDept(@RequestBody ManagerDeptDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.updtaeStdDeptInfo(dto);
    }

    public BaseResponse<String> deleteStdDept(@RequestBody ManagerDeptDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.deleteStdDeptInfo(dto);
    }

    public BaseResponse<String> queryAppCodeByHospitalId(@RequestBody BaseDTO dto) {
        if (null == dto || dto.getId() == null) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.queryAppCodeByHospitalId(dto.getId());
    }

    public BaseResponse<String> queryNodeOrganCode(@RequestBody BaseDTO dto) {
        if (null == dto || dto.getId() == null) {
            return BaseResponse.error((IError)EHErrorEnum.PARAM_CHECK_FAILD);
        }
        return this.organizationService.queryNodeOrganCode(dto.getId());
    }

    public BaseResponse<OrganCodeInfoVO> queryDoctorCodeInOrgan(@RequestBody BaseDTO dto) {
        if (null == dto || dto.getId() == null) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.queryCodeByHospitalId(dto.getId());
    }

    public BaseResponse<List<OrganNodeInfoVO>> queryOrganNodeInfo() {
        return this.organizationService.queryNodeInfo();
    }

    public BaseResponse<List<Integer>> listDoctorInOrgan(@RequestBody List<Integer> list) {
        if (null == list || list.size() == 0) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.queryDoctorIdsInOrgan(list);
    }

    public BaseResponse<List<ListOrganVO>> listByAppCode(ListOrganByAppCodeDTO dto) {
        return this.organizationService.listByAppCode(dto);
    }

    @ApiOperation(value="\u65b0\u589e\u673a\u6784\u8fd4\u56de\u673a\u6784id", notes="\u65b0\u589e\u673a\u6784\u8fd4\u56de\u673a\u6784id")
    @RequestMapping(value={"/saveOrgan"}, method={RequestMethod.POST})
    public BaseResponse<String> saveOrganInCloud(@RequestBody @Validated SaveOrganInCloudDTO saveOrganInCloudDTO) {
        return this.organizationService.saveOrganInCloud(saveOrganInCloudDTO);
    }

    @ApiOperation(value="\u4fee\u6539\u673a\u6784", notes="\u4fee\u6539\u673a\u6784\u540c\u6b65")
    @RequestMapping(value={"/updateOrgan"}, method={RequestMethod.POST})
    public BaseResponse<String> updateOrganInCloud(@RequestBody @Validated UpdateOrganDTO updateOrganDTO) {
        return this.organizationService.updateOrganInCloud(updateOrganDTO);
    }

    @ApiOperation(value="\u5220\u9664\u673a\u6784", notes="\u4f20\u5165\u4e00\u4e2a\u673a\u6784\u5bf9\u8c61")
    @RequestMapping(value={"/deleteOrgan"}, method={RequestMethod.POST})
    public BaseResponse<String> deleteOrgan(@RequestBody OrganizationStatusDTO organizationDelVO) {
        this.organizationService.deleteOrgan(organizationDelVO);
        return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u673a\u6784\u72b6\u6001\u7801", notes="\u4fee\u6539\u5bf9\u8c61\u4fee\u6539\u673a\u6784\u4e0a\u4e0b\u7ebf\u72b6\u6001\u4fe1\u606f")
    @RequestMapping(value={"/updateOrganStatus"}, method={RequestMethod.POST})
    public BaseResponse<String> updateOrganStatus(@RequestBody OrganizationStatusDTO organ) {
        this.organizationService.updateOrganStatus(organ);
        return BaseResponse.success((Object)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664\u673a\u6784", notes="\u6839\u636e\u673a\u6784code\u5220\u9664\u673a\u6784\uff0c\u5185\u90e8\u8c03\u7528")
    @RequestMapping(value={"/delOrganByOrganCode"}, method={RequestMethod.POST})
    public BaseResponse<String> delOrganByOrganCode(@RequestBody String organCode) {
        this.organizationService.delOrganByOrganCode(organCode);
        return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u8282\u70b9\u533b\u9662", notes="\u67e5\u8be2\u8282\u70b9\u533b\u9662")
    @RequestMapping(value={"/selRelOrgan"}, method={RequestMethod.POST})
    public BaseResponse<ArrayList<OrganRelVO>> delOrganByOrganCode() {
        return this.organizationService.selRelOrgan();
    }

    public BaseResponse<List<ListOrganVO>> managerQueryAllOrganListHy(@RequestBody BaseDTO dto) {
        if (null == dto) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.managerQueryAllOrganListHy(dto);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u9662\u8be6\u60c5", notes="\u67e5\u8be2\u533b\u9662\u8be6\u60c5")
    @RequestMapping(value={"/organName"}, method={RequestMethod.POST})
    BaseResponse<QueryOrganNameVO> queryOrganName(@RequestBody QueryOrganNameDTO dto) {
        if (null == dto || null == dto.getOrganCode()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return null;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8282\u70b9\u4e0b\u6240\u6709\u533b\u9662\u8be6\u7ec6\u4fe1\u606f-\u8d85\u7ba1\u7aef", notes="\u5206\u9875\u67e5\u8be2\u8282\u70b9\u4e0b\u6240\u6709\u533b\u9662\u8be6\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"/organ_info"}, method={RequestMethod.POST})
    public BaseResponse<PageResult<OrganInfoRespVO>> getOrganInfoListByAppCode(@RequestBody OrganInfoReq organInfoReq) {
        if (null == organInfoReq || null == organInfoReq.getAppCode()) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.getOrganInfoListByAppCode(organInfoReq);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8282\u70b9\u4e0b\u6240\u6709\u533b\u9662\u8be6\u7ec6\u4fe1\u606f-\u7efc\u5408\u7ba1\u7406\u5e73\u53f0", notes="\u5206\u9875\u67e5\u8be2\u8282\u70b9\u4e0b\u6240\u6709\u533b\u9662\u8be6\u7ec6\u4fe1\u606f-\u7efc\u5408\u7ba1\u7406\u5e73\u53f0")
    @RequestMapping(value={"/manage/organ_list"}, method={RequestMethod.POST})
    public BaseResponse<BeanRespVO> getOrganInfoList(@RequestBody OrganInfoListDTO listDTO) {
        return this.organizationService.getOrganInfoList(listDTO);
    }

    @ApiOperation(value="\u533b\u9662\u4fe1\u606f\u53ca\u6240\u5c5e\u5e73\u53f0-\u7efc\u5408\u7ba1\u7406\u5e73\u53f0", notes="\u5206\u9875\u67e5\u8be2\u8282\u70b9\u4e0b\u6240\u6709\u533b\u9662\u8be6\u7ec6\u4fe1\u606f-\u7efc\u5408\u7ba1\u7406\u5e73\u53f0")
    @RequestMapping(value={"/manage/organ_detail"}, method={RequestMethod.GET})
    public BaseResponse<OrganManageDetailVo> getOrganManageDetail(@RequestParam(value="organId") Integer organId) {
        return this.organizationService.getOrganManageDetail(organId);
    }

    @ApiOperation(value="\u7f16\u8f91\u533b\u9662\u4fe1\u606f-\u7efc\u5408\u7ba1\u7406\u5e73\u53f0", notes="\u7f16\u8f91\u533b\u9662\u4fe1\u606f-\u7efc\u5408\u7ba1\u7406\u5e73\u53f0")
    @RequestMapping(value={"/manage/update_organ"}, method={RequestMethod.POST})
    public BaseResponse<String> updateOrganInfoById(@RequestBody OrganizationReq organizationReq) {
        return this.organizationService.updateOrganInfoById(organizationReq);
    }

    @GetMapping(value={"/manage/update_status"})
    @ApiOperation(value="\u5220\u9664\u533b\u9662,\u6216\u4e0a\u4e0b\u7ebf\u533b\u9662", notes="1:\u4e0a\u7ebf,2:\u4e0b\u7ebf,-1:\u5220\u9664")
    public BaseResponse<String> updateOrganStatusById(@RequestParam(value="organId") int organId, @RequestParam(value="status") int status) {
        return this.organizationService.updateOrganStatusById(organId, status);
    }

    @GetMapping(value={"/organ_detail_all"})
    @ApiOperation(value="\u533b\u9662\u8be6\u60c5", notes="\u5c0f\u7a0b\u5e8f\u4e2d\u533b\u9662\u8be6\u60c5")
    public BaseResponse<OrganDetailAllRespVO> getOrganDetailAllById(@RequestParam(value="organId") int organId) {
        return this.organizationService.getOrganDetailAllById(organId);
    }

    @PostMapping(value={"/organ_distance"})
    @ApiOperation(value="\u641c\u7d22\u9644\u8fd1\u533b\u9662", notes="\u6839\u636e\u7ecf\u7eac\u5ea6\u67e5\u770b\u9644\u8fd1\u533b\u9662\u8ddd\u79bb")
    public BaseResponse<List<OrganDistanceListRespVO>> getOrganDistanceByAppCode(@RequestBody OrganDistanceLocationReqVO distanceReqVO) {
        return this.organizationService.getOrganDistanceByAppCode(distanceReqVO);
    }

    public BaseResponse<List<OrganWorkingServiceEntity>> getOrganServiceByOrganId(@RequestBody OrganIdVo req) {
        return this.organizationService.getOrganServiceByOrganId(req.getOrganId());
    }

    public BaseResponse<List<StandardDeptResVO>> getDeptAllByServCode(@RequestBody SevrCodeGetDeptReqVO sevrCodeGetDeptReqVO) {
        return this.organizationService.getDeptAllByServCode(sevrCodeGetDeptReqVO);
    }

    @Deprecated
    @ApiOperation(value="\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u53ca\u4e00\u7ea7\u6807\u79d1\u7ec4\u5408")
    @PostMapping(value={"/getOrganDeptInStdDept"})
    public BaseResponse<List<StandardDeptResVO>> getOrganDeptInStdDept(@RequestBody StandDeptReqVO param) {
        return this.organizationService.getOrganDeptInStdDept(param.getOrganId(), param.getStandName());
    }

    public BaseResponse<List<ListStdDeptVO>> getStdDeptListByHospitalIdAndAppCodeAndServiceCodes(String hospitalId, String appCode, String serviceCodes) {
        return this.organizationService.getStdDeptListByHospitalIdAndAppCodeAndServiceCodes(hospitalId, appCode, serviceCodes);
    }

    public BaseResponse<List<OrganBasicInfoRespVO>> queryOrganBasicInfo(@RequestBody OrganBasicInfoReqVO reqVO) {
        return this.organizationService.queryOrganBasicInfo(reqVO);
    }

    public BaseResponse<PageResult<OrganBasicInfoRespVO>> queryOrganBasicInfoPage(@RequestBody OrganBasicInfoReqVO reqVO) {
        return this.organizationService.queryOrganBasicInfoPage(reqVO);
    }

    public BaseResponse<OrganBasicInfoRespVO> queryOrganInfoByIdOrOrganCode(@RequestBody BaseDTO dto) {
        return this.organizationService.queryOrganInfoByIdOrOrganCode(dto);
    }

    @ApiOperation(value="\u5f00\u901a\u533b\u9662\u9996\u9875-\u7efc\u5408\u7ba1\u7406\u5e73\u53f0", notes="\u5f00\u901a\u533b\u9662\u9996\u9875-\u7efc\u5408\u7ba1\u7406\u5e73\u53f0")
    @RequestMapping(value={"/manage/open_home_page"}, method={RequestMethod.POST})
    public BaseResponse<String> organOpenHomePageById(@RequestBody OrganHomePageReqVO reqVO) {
        return this.organizationService.organOpenHomePageById(reqVO);
    }

    public GuideBaseResponse<List<GuideHospitalnfo>> getAllHospInfoByServiceCode(HttpServletRequest request) {
        String partnerId = request.getHeader("god-portal-partner-id");
        return this.organizationService.getAllHospInfoByServiceCode(partnerId);
    }

    public GuideBaseResponse<List<GuideHospitaDetailVo>> getHospDetail(String hosId, HttpServletRequest request) {
        String partnerId = request.getHeader("god-portal-partner-id");
        return this.organizationService.getHospDetail(hosId, partnerId);
    }

    public GuideBaseResponse<List<GuideDeptListVo>> getDeptList(String hosId, String branchId) {
        return this.organizationService.getDeptList(hosId, branchId);
    }

    @ApiOperation(value="\u76d1\u7ba1\u5e73\u53f0\u5bf9\u63a5")
    @PostMapping(value={"/supervision_platform_docking"})
    public BaseResponse supervisionPlatformDocking(@RequestBody OrganSupervisionVo organSupervisionVo) {
        return this.organizationService.supervisionPlatformDocking(organSupervisionVo);
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u9662\u7684\u76d1\u7ba1\u5e73\u53f0\u4fe1\u606f")
    @GetMapping(value={"/getOrganSuperVisionById"})
    public BaseResponse getOrganSuperVisionById(@RequestParam(value="id", required=true) Long id) {
        return this.organizationService.getOrganSuperVisionById(id);
    }

    @ApiOperation(value="\u6839\u636e\u533b\u9662\u540d\u79f0\u83b7\u53d6\u533b\u9662\u4fe1\u606f")
    @PostMapping(value={"/getOrganByOrganName"})
    public BaseResponse getOrganByOrganName(@RequestParam(value="organName") String organName) {
        return BaseResponse.success((Object)this.organizationService.getOrganByOrganName(organName));
    }

    @ApiOperation(value="\u6839\u636e\u5e73\u53f0\u83b7\u53d6\u5e73\u53f0\u5c0f\u5f00\u901a\u9996\u9875\u7684\u533b\u9662\u4fe1\u606f")
    @GetMapping(value={"/getOrganIntroductionByAppCode"})
    public BaseResponse getOrganIntroductionByAppCode(@RequestParam(value="appCode") String appCode) {
        return BaseResponse.success((Object)this.organizationService.getOrganIntroductionByAppCode(appCode));
    }

    @ApiOperation(value="\u540c\u6b65\u533b\u9662\u9996\u9875\u914d\u7f6e", notes="\u540c\u6b65\u533b\u9662\u9996\u9875\u914d\u7f6e")
    @RequestMapping(value={"/manage/syncHomePage"}, method={RequestMethod.POST})
    public BaseResponse<String> syncHomePage(@RequestBody HospitalModel reqVO) {
        return this.organizationService.syncHomePage(reqVO);
    }

    @ApiOperation(value="\u5f00\u901a-\u662f\u5426\u72ec\u7acb\u9996\u9875", notes="\u5f00\u901a-\u662f\u5426\u72ec\u7acb\u9996\u9875")
    @RequestMapping(value={"/independent/homePage"}, method={RequestMethod.POST})
    public BaseResponse<String> openHomePageById(@RequestBody OpenHomeVO reqVO) {
        return this.organizationService.openHomePageById(reqVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u5f00\u901a\u72ec\u7acb\u9996\u9875\u7684\u533b\u9662\u5217\u8868", notes="\u67e5\u8be2\u5df2\u5f00\u901a\u72ec\u7acb\u9996\u9875\u7684\u533b\u9662\u5217\u8868")
    @RequestMapping(value={"/manage/getOpenOrgan"}, method={RequestMethod.POST})
    public BaseResponse<List<OrganInfoReqVO>> getOpenOrgan(@RequestBody OrganInfoReqVO reqVO) {
        return this.organizationService.getOpenOrgan(reqVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u9662\u5217\u8868", notes="\u67e5\u8be2\u533b\u9662\u5217\u8868")
    @RequestMapping(value={"/selectOrganList"}, method={RequestMethod.POST})
    public BaseResponse<List<OrganInfoReqVO>> selectOrganList(@RequestBody ListOrganDTO dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getHospitalId())) {
            return BaseResponse.error((IError)EHErrorEnum.REQUISITE_PARAMETER_DEFICIENCY);
        }
        return this.organizationService.selectOrganList(dto);
    }
}

