/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.doctor.basedata.api.vo.DictionaryResp;
import com.doctoruser.api.pojo.vo.dictionary.DictionaryAndChildrenRes;
import com.doctoruser.api.pojo.vo.dictionary.DictionaryRespVO;
import com.doctoruser.doctor.mapper.DictionaryMapper;
import com.doctoruser.doctor.pojo.entity.DictionaryEntity;
import com.doctoruser.doctor.pojo.entity.DictionaryTypeEntity;
import com.doctoruser.doctor.service.IDictionaryService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DictionaryServiceImpl
implements IDictionaryService {
    private static final Logger log = LoggerFactory.getLogger(DictionaryServiceImpl.class);
    private static final String NO_RESULTS_FOUND = "NO_RESULTS_FOUND";
    @Resource
    private DictionaryMapper dictionaryMapper;

    public BaseResponse<DictionaryRespVO> findByType(String type, String key) {
        DictionaryEntity dictionaryEntity = this.dictionaryMapper.findByTypeAndCode(type, key);
        if (dictionaryEntity == null) {
            return BaseResponse.error((String)NO_RESULTS_FOUND);
        }
        return this.responseToVO(dictionaryEntity);
    }

    public BaseResponse<Map<String, DictionaryRespVO>> findByType(String type) {
        List list = this.dictionaryMapper.findByTypeCode(type);
        if (list == null || list.size() == 0) {
            return BaseResponse.error((String)NO_RESULTS_FOUND);
        }
        return this.responseToMap(list);
    }

    public BaseResponse<DictionaryRespVO> findByParent(String parent, String key) {
        DictionaryEntity dictionaryEntity = (DictionaryEntity)this.dictionaryMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictionaryEntity::getParentCode, (Object)parent)).eq(DictionaryEntity::getDicCode, (Object)key));
        if (dictionaryEntity == null) {
            return BaseResponse.error((String)NO_RESULTS_FOUND);
        }
        return this.responseToVO(dictionaryEntity);
    }

    public BaseResponse<Map<String, DictionaryRespVO>> findByParent(String parent) {
        List list = this.dictionaryMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(DictionaryEntity::getParentCode, (Object)parent));
        if (list == null || list.size() == 0) {
            return BaseResponse.error((String)NO_RESULTS_FOUND);
        }
        return this.responseToMap(list);
    }

    private BaseResponse<DictionaryRespVO> responseToVO(DictionaryEntity dictionaryEntity) {
        DictionaryRespVO respVO = new DictionaryRespVO(dictionaryEntity.getDicName(), dictionaryEntity.getIconUrl(), dictionaryEntity.getParentCode());
        return BaseResponse.success((Object)respVO);
    }

    private BaseResponse<Map<String, DictionaryRespVO>> responseToMap(List<DictionaryEntity> list) {
        HashMap<String, DictionaryRespVO> map = new HashMap<String, DictionaryRespVO>(list.size());
        for (DictionaryEntity dictionaryEntity : list) {
            DictionaryRespVO respVO = new DictionaryRespVO(dictionaryEntity.getDicName(), dictionaryEntity.getIconUrl(), dictionaryEntity.getParentCode());
            map.put(dictionaryEntity.getDicCode(), respVO);
        }
        return BaseResponse.success(map);
    }

    public BaseResponse<List<DictionaryAndChildrenRes>> findDictionaryAndChildrenByType(String type) {
        List list = this.dictionaryMapper.findByTypeCode(type);
        ArrayList<DictionaryAndChildrenRes> listRes = new ArrayList<DictionaryAndChildrenRes>();
        if (list.isEmpty()) {
            return BaseResponse.success(listRes);
        }
        for (DictionaryEntity dic : list) {
            DictionaryAndChildrenRes resVo = new DictionaryAndChildrenRes();
            BeanUtils.copyProperties((Object)dic, (Object)resVo);
            List listChildren = this.dictionaryMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(DictionaryEntity::getParentCode, (Object)dic.getDicCode()));
            ArrayList<DictionaryAndChildrenRes> listRes1 = new ArrayList<DictionaryAndChildrenRes>();
            for (DictionaryEntity dic1 : listChildren) {
                DictionaryAndChildrenRes resVo1 = new DictionaryAndChildrenRes();
                BeanUtils.copyProperties((Object)dic1, (Object)resVo1);
                listRes1.add(resVo1);
            }
            listRes.add(resVo);
        }
        return BaseResponse.success(listRes);
    }

    public BaseResponse<List<DictionaryAndChildrenRes>> getDictionaryList() {
        List<DictionaryAndChildrenRes> levelList;
        String dicCode;
        String gb_one_level = "24";
        String gb_two_level = "25";
        String gb_three_level = "26";
        String dicTypeArr = "24,25,26";
        List dictionaryList = this.dictionaryMapper.getDictionaryList(dicTypeArr);
        Map<String, List<DictionaryAndChildrenRes>> listMap = dictionaryList.stream().collect(Collectors.groupingBy(DictionaryAndChildrenRes::getDicType));
        List<DictionaryAndChildrenRes> oneLevelList = listMap.get(gb_one_level);
        List<DictionaryAndChildrenRes> twoLevelList = listMap.get(gb_two_level);
        List<DictionaryAndChildrenRes> threeLevelList = listMap.get(gb_three_level);
        Map<String, List<DictionaryAndChildrenRes>> twoLevelMap = twoLevelList.stream().collect(Collectors.groupingBy(DictionaryAndChildrenRes::getParentCode));
        Map<String, List<DictionaryAndChildrenRes>> threeLevelMap = threeLevelList.stream().collect(Collectors.groupingBy(DictionaryAndChildrenRes::getParentCode));
        for (DictionaryAndChildrenRes dictionaryAndChildrenRes : twoLevelList) {
            dicCode = dictionaryAndChildrenRes.getDicCode();
            levelList = threeLevelMap.get(dicCode);
            dictionaryAndChildrenRes.setChildrenRes(levelList);
        }
        for (DictionaryAndChildrenRes dictionaryAndChildrenRes : oneLevelList) {
            dicCode = dictionaryAndChildrenRes.getDicCode();
            levelList = twoLevelMap.get(dicCode);
            dictionaryAndChildrenRes.setChildrenRes(levelList);
        }
        return BaseResponse.success(oneLevelList);
    }

    public BaseResponse<List<DictionaryTypeEntity>> getDocProfession() {
        List list = this.dictionaryMapper.findByTypeCode("5000");
        List resultList = list.stream().map(item -> {
            DictionaryTypeEntity dictionaryType = new DictionaryTypeEntity();
            dictionaryType.setId(item.getId());
            dictionaryType.setTypeCode(item.getDicCode());
            dictionaryType.setTypeName(item.getDicName());
            dictionaryType.setCreateTime(item.getCreateTime());
            dictionaryType.setUpdateTime(item.getUpdateTime());
            return dictionaryType;
        }).collect(Collectors.toList());
        return BaseResponse.success(resultList);
    }

    public BaseResponse<List<DictionaryEntity>> getDictionaryByParentCode(String parentCode) {
        List list = this.dictionaryMapper.getDictionaryByParentCode(parentCode);
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<List<DictionaryEntity>> getProfessionTitle() {
        List list = this.dictionaryMapper.findByTypeCode("100");
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<DictionaryResp> getProfessionByTitle(String professionCode) {
        DictionaryEntity titleInfo = this.dictionaryMapper.findByDicCodeAndTypeCode(professionCode, "100");
        DictionaryEntity profession = this.dictionaryMapper.findByDicCodeAndTypeCode(titleInfo.getParentCode(), "5000");
        if (Objects.nonNull(profession)) {
            DictionaryResp dictionaryResp = new DictionaryResp();
            BeanUtils.copyProperties((Object)profession, (Object)dictionaryResp);
            return BaseResponse.success((Object)dictionaryResp);
        }
        return BaseResponse.success();
    }
}

