/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.doctoruser.api.pojo.base.vo.organization.DepartmentVO;
import com.doctoruser.doctor.mapper.DepartmentMapper;
import com.doctoruser.doctor.mapper.DepartmentStandardMapper;
import com.doctoruser.doctor.mapper.DocFamousDoctorMapper;
import com.doctoruser.doctor.mapper.DocFamousDoctorSwitchMapper;
import com.doctoruser.doctor.pojo.entity.DocFamousDoctorEntity;
import com.doctoruser.doctor.pojo.entity.DocFamousDoctorSwitchEntity;
import com.doctoruser.doctor.pojo.vo.DocFamousDoctorHosDeptRespVo;
import com.doctoruser.doctor.pojo.vo.DocFamousDoctorReqVo;
import com.doctoruser.doctor.pojo.vo.DocFamousDoctorRespVo;
import com.doctoruser.doctor.pojo.vo.DocFamousDoctorStandDeptRespVo;
import com.doctoruser.doctor.pojo.vo.DoctorInfoVO;
import com.doctoruser.doctor.pojo.vo.GetFamousDoctorReqVo;
import com.doctoruser.doctor.pojo.vo.SaveFamousDoctorOperationReqVo;
import com.doctoruser.doctor.service.DocFamousDoctorService;
import com.doctoruser.doctor.service.DocFamousDoctorSwitchService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DocFamousDoctorServiceImpl
implements DocFamousDoctorService {
    @Autowired
    private DocFamousDoctorMapper docFamousDoctorMapper;
    @Autowired
    private DepartmentStandardMapper departmentStandardMapper;
    @Autowired
    private DepartmentMapper departmentMapper;
    @Autowired
    private DocFamousDoctorSwitchMapper docFamousDoctorSwitchMapper;
    @Autowired
    private DocFamousDoctorSwitchService docFamousDoctorSwitchService;

    public DocFamousDoctorRespVo getFamousDoctorByOrganIdToWeb(Long organId) {
        List docFamousDoctorStandDeptRespVoList = this.departmentStandardMapper.selectAllStandFirstDept();
        for (DocFamousDoctorStandDeptRespVo docFamousDoctorStandDeptRespVo : docFamousDoctorStandDeptRespVoList) {
            int addDeptCount = 0;
            ArrayList<DocFamousDoctorHosDeptRespVo> docFamousDoctorHosDeptRespVoList = new ArrayList<DocFamousDoctorHosDeptRespVo>();
            List departmentVOList = this.departmentMapper.queryDeptByFirstDepId(docFamousDoctorStandDeptRespVo.getDeptId().intValue(), organId.intValue());
            for (DepartmentVO departmentVO : departmentVOList) {
                DocFamousDoctorHosDeptRespVo docFamousDoctorHosDeptRespVo = new DocFamousDoctorHosDeptRespVo();
                BeanUtils.copyProperties((Object)departmentVO, (Object)docFamousDoctorHosDeptRespVo);
                List doctorInfoVOList = this.docFamousDoctorMapper.selectDoctorByHosDeptIdAndOrganId(Long.valueOf(docFamousDoctorHosDeptRespVo.getDeptId()), organId);
                docFamousDoctorHosDeptRespVo.setDoctorInfoVOList(doctorInfoVOList);
                if (null != doctorInfoVOList && doctorInfoVOList.size() > 0) {
                    ++addDeptCount;
                }
                docFamousDoctorHosDeptRespVoList.add(docFamousDoctorHosDeptRespVo);
            }
            docFamousDoctorStandDeptRespVo.setAddDeptCount(addDeptCount);
            docFamousDoctorStandDeptRespVo.setDocFamousDoctorHosDeptRespVoList(docFamousDoctorHosDeptRespVoList);
        }
        DocFamousDoctorSwitchEntity byOrganId = this.docFamousDoctorSwitchService.getByOrganId(organId);
        DocFamousDoctorRespVo docFamousDoctorRespVo = new DocFamousDoctorRespVo();
        docFamousDoctorRespVo.setDocFamousDoctorStandDeptRespVoList(docFamousDoctorStandDeptRespVoList);
        docFamousDoctorRespVo.setFamousDoctorSwitch(byOrganId.getIsShow());
        return docFamousDoctorRespVo;
    }

    public List<DoctorInfoVO> getFamousDoctorByOrganId(GetFamousDoctorReqVo getFamousDoctorReqVo) {
        PageHelper.startPage((int)getFamousDoctorReqVo.getPageNum(), (int)getFamousDoctorReqVo.getPageSize());
        List doctorInfoVOList = this.docFamousDoctorMapper.selectDoctorByHosDeptIdAndOrganId(getFamousDoctorReqVo.getHospitalDeptId(), getFamousDoctorReqVo.getOrganId());
        return doctorInfoVOList;
    }

    public List<DocFamousDoctorHosDeptRespVo> getFamousDoctorDeptByOrganId(Long organId) {
        DocFamousDoctorSwitchEntity docFamousDoctorSwitchEntity = this.docFamousDoctorSwitchService.getByOrganId(organId);
        if (docFamousDoctorSwitchEntity.getIsShow() == -1) {
            return new ArrayList<DocFamousDoctorHosDeptRespVo>();
        }
        List docFamousDoctorHosDeptRespVoList = this.docFamousDoctorMapper.selectHosDeptByOrganId(organId);
        if (CollectionUtils.isEmpty((Collection)docFamousDoctorHosDeptRespVoList)) {
            return new ArrayList<DocFamousDoctorHosDeptRespVo>();
        }
        return docFamousDoctorHosDeptRespVoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public DocFamousDoctorRespVo saveFamousDoctorOperation(SaveFamousDoctorOperationReqVo saveFamousDoctorOperationReqVo) {
        DocFamousDoctorSwitchEntity docFamousDoctorSwitchEntity = this.docFamousDoctorSwitchService.getByOrganId(saveFamousDoctorOperationReqVo.getOrganId());
        if (1 != docFamousDoctorSwitchEntity.getIsShow()) {
            this.docFamousDoctorSwitchMapper.updateIsShowByOrganId(saveFamousDoctorOperationReqVo.getOrganId(), 1);
        }
        if (!CollectionUtils.isEmpty((Collection)saveFamousDoctorOperationReqVo.getSaveDocFamousDoctorReqVoList())) {
            for (DocFamousDoctorReqVo docFamousDoctorReqVo : saveFamousDoctorOperationReqVo.getSaveDocFamousDoctorReqVoList()) {
                DocFamousDoctorEntity docFamousDoctorEntity = new DocFamousDoctorEntity();
                BeanUtils.copyProperties((Object)docFamousDoctorReqVo, (Object)docFamousDoctorEntity);
                docFamousDoctorEntity.setStatus(Integer.valueOf(1));
                DocFamousDoctorEntity docFamousDoctor = this.docFamousDoctorMapper.selectByPrimaryKey(docFamousDoctorReqVo.getFamousId());
                if (Objects.isNull(docFamousDoctor)) {
                    this.docFamousDoctorMapper.insertSelective(docFamousDoctorEntity);
                    continue;
                }
                docFamousDoctorEntity.setId(docFamousDoctorReqVo.getFamousId());
                this.docFamousDoctorMapper.updateByPrimaryKeySelective(docFamousDoctorEntity);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)saveFamousDoctorOperationReqVo.getDeleteDocFamousDoctorIdList())) {
            for (Long id : saveFamousDoctorOperationReqVo.getDeleteDocFamousDoctorIdList()) {
                this.docFamousDoctorMapper.updateStatusById(Integer.valueOf(-1), id);
            }
        }
        return this.getFamousDoctorByOrganIdToWeb(saveFamousDoctorOperationReqVo.getOrganId());
    }
}

