/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.doctoruser.api.pojo.vo.basedata.doctor.UserDoctorRelationVo;
import com.doctoruser.doctor.listener.EventManager;
import com.doctoruser.doctor.listener.event.PatientEvent;
import com.doctoruser.doctor.listener.event.SmsPatientEvent;
import com.doctoruser.doctor.mapper.DocPatientRelationMapper;
import com.doctoruser.doctor.mapper.DocPatientReportLogMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.NewCommonMapper;
import com.doctoruser.doctor.pojo.entity.DocPatientRelationEntity;
import com.doctoruser.doctor.pojo.entity.DocPatientReportLogEntity;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.vo.ChronicDoctorRsqVO;
import com.doctoruser.doctor.pojo.vo.DocPatientReportLogRepVo;
import com.doctoruser.doctor.pojo.vo.DoctorArdeeReporeReqVo;
import com.doctoruser.doctor.pojo.vo.GetPatientInfoVo;
import com.doctoruser.doctor.pojo.vo.GetPatientReqVo;
import com.doctoruser.doctor.pojo.vo.QueryDoctorParam;
import com.doctoruser.doctor.pojo.vo.SaveDoctorRelationReqVo;
import com.doctoruser.doctor.pojo.vo.SavePatientReportLogVo;
import com.doctoruser.doctor.service.DocPatientRelationService;
import com.doctoruser.doctor.service.DocPatientReportLogService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DataUtils;
import com.ebaiyihui.framework.utils.GenderUtils;
import com.ebaiyihui.framework.utils.HttpClientUtil;
import com.ebaiyihui.framework.utils.IdCardUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DocPatientReportLogServiceImpl
implements DocPatientReportLogService {
    private static final Logger log = LoggerFactory.getLogger(DocPatientReportLogServiceImpl.class);
    @Autowired
    private DocPatientReportLogMapper docPatientReportLogMapper;
    @Autowired
    private DocPatientRelationService docPatientRelationService;
    @Autowired
    private EventManager eventManager;
    @Value(value="${domainName}")
    private String domainName;
    public static final String GET_PATIENT_INFO_FOR_CARD_SERVICE = "/cardservice/getpatientinfobyid";
    @Autowired
    private DocPatientRelationMapper docPatientRelationMapper;
    @Autowired
    private NewCommonMapper newCommonMapper;
    @Autowired
    private DoctorMapper doctorMapper;
    private static final String ZERO_TIME = " 00:00:00";
    private static final String BEFORE_ZERO_TIME = " 23:59:59";

    public BaseResponse savePatientReportLog(SavePatientReportLogVo savePatientReportLogVo) {
        GetPatientInfoVo patientInfo = this.getPatientInfo(savePatientReportLogVo.getPatientId(), savePatientReportLogVo.getAppCode());
        savePatientReportLogVo.setCardNo(patientInfo.getCredNo());
        savePatientReportLogVo.setPhone(patientInfo.getContactMobile());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String endData = sdf.format(new Date());
        String startData = DataUtils.getWeek((String)endData);
        String startTime = startData + ZERO_TIME;
        String endTime = endData + BEFORE_ZERO_TIME;
        List byAppCodeAndPatientIdAndDoctorIdAndStatusSeven = this.docPatientReportLogMapper.getByAppCodeAndPatientIdAndDoctorIdAndStatus(savePatientReportLogVo.getAppCode(), Long.valueOf(savePatientReportLogVo.getPatientId()), Long.valueOf(savePatientReportLogVo.getDoctorId()), Integer.valueOf(1), startTime, endTime);
        if (!CollectionUtils.isEmpty((Collection)byAppCodeAndPatientIdAndDoctorIdAndStatusSeven)) {
            return BaseResponse.success((Object)"\u60a3\u8005\u5df2\u5411\u533b\u751f\u53d1\u8d77\u8fc7\u60a3\u8005\u62a5\u5230\u7533\u8bf7,\u533b\u751f\u6b63\u5728\u5ba1\u6838\u4e2d,\u8bf7\u8010\u5fc3\u7b49\u5f85");
        }
        String startTimeThreeData = DataUtils.getLastThreeMonthDay((String)endData);
        String startTimeThree = startTimeThreeData + ZERO_TIME;
        List appCodeAndPatientIdAndDoctorIdAndStatusRefused = this.docPatientReportLogMapper.getByAppCodeAndPatientIdAndDoctorIdAndStatus(savePatientReportLogVo.getAppCode(), Long.valueOf(savePatientReportLogVo.getPatientId()), Long.valueOf(savePatientReportLogVo.getDoctorId()), Integer.valueOf(-1), startTimeThree, endTime);
        if (!CollectionUtils.isEmpty((Collection)appCodeAndPatientIdAndDoctorIdAndStatusRefused) && appCodeAndPatientIdAndDoctorIdAndStatusRefused.size() >= 3) {
            return BaseResponse.success((Object)"\u533b\u751f\u5df2\u7ecf\u591a\u6b21\u62d2\u7edd\u8fc7\u8be5\u60a3\u8005\u7684\u62a5\u5230\u7533\u8bf7,\u4e0d\u53ef\u518d\u5411\u8be5\u533b\u751f\u62a5\u5230");
        }
        List byAppCodeAndDoctorIdAndTime = this.docPatientReportLogMapper.getByAppCodeAndPatientIdAndDoctorIdAndStatus(savePatientReportLogVo.getAppCode(), Long.valueOf(savePatientReportLogVo.getPatientId()), Long.valueOf(savePatientReportLogVo.getDoctorId()), Integer.valueOf(2), null, null);
        if (!CollectionUtils.isEmpty((Collection)byAppCodeAndDoctorIdAndTime)) {
            return BaseResponse.success((Object)"\u533b\u751f\u5df2\u7ecf\u901a\u8fc7\u60a8\u7684\u62a5\u5230\u7533\u8bf7.");
        }
        DocPatientReportLogEntity docPatientReportLogEntity = new DocPatientReportLogEntity();
        this.patientInfoToDocPatientReportLogEntity(docPatientReportLogEntity, savePatientReportLogVo);
        docPatientReportLogEntity.setStatus(Byte.valueOf((byte)1));
        this.docPatientReportLogMapper.insert(docPatientReportLogEntity);
        PatientEvent event = new PatientEvent();
        event.setDoctorId(docPatientReportLogEntity.getDoctorId());
        event.setAppCode(docPatientReportLogEntity.getAppCode());
        this.eventManager.post((Object)event);
        return BaseResponse.success((Object)"\u60a3\u8005\u5df2\u6210\u529f\u5411\u533b\u751f\u53d1\u8d77\u62a5\u5230\u7533\u8bf7,\u8bf7\u8010\u5fc3\u7b49\u5f85\u533b\u751f\u5ba1\u6838");
    }

    public BaseResponse selectPatientReportLogByDoctorId(Long doctorId, String appCode) {
        String lastEndTime;
        String lastStartData;
        String lastStartTime;
        List byAppCodeAndDoctorIdAndTimeLast;
        String endTimeOne;
        ArrayList<DocPatientReportLogRepVo> docPatientReportLogRepVoList = new ArrayList<DocPatientReportLogRepVo>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String endData = sdf.format(new Date());
        String startTimeOne = endData + ZERO_TIME;
        List byAppCodeAndDoctorIdAndTimeOne = this.docPatientReportLogMapper.getByAppCodeAndDoctorIdAndTime(appCode, doctorId, startTimeOne, endTimeOne = endData + BEFORE_ZERO_TIME);
        if (!CollectionUtils.isEmpty((Collection)byAppCodeAndDoctorIdAndTimeOne)) {
            DocPatientReportLogRepVo docPatientReportLogRepVo = new DocPatientReportLogRepVo();
            docPatientReportLogRepVo.setTitle("\u4eca\u5929");
            docPatientReportLogRepVo.setDocPatientReportLogEntityList(byAppCodeAndDoctorIdAndTimeOne);
            docPatientReportLogRepVoList.add(docPatientReportLogRepVo);
        }
        if (!CollectionUtils.isEmpty((Collection)(byAppCodeAndDoctorIdAndTimeLast = this.docPatientReportLogMapper.getByAppCodeAndDoctorIdAndTime(appCode, doctorId, lastStartTime = (lastStartData = DataUtils.getLastDay((String)endData)) + ZERO_TIME, lastEndTime = lastStartData + BEFORE_ZERO_TIME)))) {
            DocPatientReportLogRepVo docPatientReportLogRepVo = new DocPatientReportLogRepVo();
            docPatientReportLogRepVo.setTitle("\u6628\u5929");
            docPatientReportLogRepVo.setDocPatientReportLogEntityList(byAppCodeAndDoctorIdAndTimeLast);
            docPatientReportLogRepVoList.add(docPatientReportLogRepVo);
        }
        String lastThreeStratData = DataUtils.getLastSevenDay((String)endData);
        String lastThreeStartTime = lastThreeStratData + ZERO_TIME;
        String lastThreeEndData = DataUtils.getLastThreeDay((String)endData);
        String lastThreeEndTime = lastThreeEndData + BEFORE_ZERO_TIME;
        List byAppCodeAndDoctorIdAndTimeLastThree = this.docPatientReportLogMapper.getByAppCodeAndDoctorIdAndTime(appCode, doctorId, lastThreeStartTime, lastThreeEndTime);
        List byAppCodeAndDoctorIdAndTimeSeven = this.docPatientReportLogMapper.getByAppCodeAndDoctorIdAndTime(appCode, doctorId, null, lastThreeStartTime);
        for (DocPatientReportLogEntity docPatientReportLogEntity : byAppCodeAndDoctorIdAndTimeSeven) {
            docPatientReportLogEntity.setStatus(Byte.valueOf((byte)-2));
            byAppCodeAndDoctorIdAndTimeLastThree.add(docPatientReportLogEntity);
        }
        if (!CollectionUtils.isEmpty((Collection)byAppCodeAndDoctorIdAndTimeLastThree)) {
            DocPatientReportLogRepVo docPatientReportLogRepVo = new DocPatientReportLogRepVo();
            docPatientReportLogRepVo.setTitle("\u4e09\u5929\u524d");
            docPatientReportLogRepVo.setDocPatientReportLogEntityList(byAppCodeAndDoctorIdAndTimeLastThree);
            docPatientReportLogRepVoList.add(docPatientReportLogRepVo);
        }
        return BaseResponse.success(docPatientReportLogRepVoList);
    }

    public BaseResponse doctorRefusedReport(Long patientReportLogId) {
        DocPatientReportLogEntity docPatientReportLogEntity = this.docPatientReportLogMapper.selectByPrimaryKey(patientReportLogId);
        if (Objects.isNull(docPatientReportLogEntity)) {
            return BaseResponse.error((String)"\u8981\u62d2\u7edd\u7684\u60a3\u8005\u62a5\u5230\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        this.docPatientReportLogMapper.updateStatusById(patientReportLogId, Integer.valueOf(-1));
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse doctorAgreeReport(DoctorArdeeReporeReqVo doctorArdeeReporeReqVo) {
        String code = "0";
        DocPatientReportLogEntity docPatientReportLogEntity = this.docPatientReportLogMapper.selectByPrimaryKey(doctorArdeeReporeReqVo.getPatientReportLogId());
        if (!StringUtils.isEmpty((Object)doctorArdeeReporeReqVo.getPhone())) {
            docPatientReportLogEntity.setPhone(doctorArdeeReporeReqVo.getPhone());
        }
        if (Objects.isNull(docPatientReportLogEntity)) {
            return BaseResponse.error((String)"\u8981\u540c\u610f\u7684\u60a3\u8005\u62a5\u5230\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        SaveDoctorRelationReqVo saveDoctorRelationReqVo = new SaveDoctorRelationReqVo();
        saveDoctorRelationReqVo.setPatientId(docPatientReportLogEntity.getPatientId().toString());
        saveDoctorRelationReqVo.setPatientName(docPatientReportLogEntity.getPatientName());
        saveDoctorRelationReqVo.setAppCode(docPatientReportLogEntity.getAppCode());
        saveDoctorRelationReqVo.setCardNo(docPatientReportLogEntity.getCardNo());
        saveDoctorRelationReqVo.setDoctorId(docPatientReportLogEntity.getDoctorId().toString());
        saveDoctorRelationReqVo.setGroupId(doctorArdeeReporeReqVo.getGroupId().toString());
        saveDoctorRelationReqVo.setLabel(doctorArdeeReporeReqVo.getLabel());
        saveDoctorRelationReqVo.setPhone(docPatientReportLogEntity.getPhone());
        saveDoctorRelationReqVo.setUserId(docPatientReportLogEntity.getUserId().toString());
        this.docPatientReportLogMapper.updateStatusById(doctorArdeeReporeReqVo.getPatientReportLogId(), Integer.valueOf(2));
        BaseResponse savePatientDoctorRelation = this.docPatientRelationService.savePatientDoctorRelation(saveDoctorRelationReqVo);
        if (!savePatientDoctorRelation.isSuccess()) {
            return BaseResponse.success((Object)savePatientDoctorRelation.getMsg());
        }
        UserDoctorRelationVo userDoctorRelationVo = new UserDoctorRelationVo();
        userDoctorRelationVo.setStatus(Byte.valueOf((byte)1));
        userDoctorRelationVo.setAppCode(docPatientReportLogEntity.getAppCode());
        userDoctorRelationVo.setDoctorId(docPatientReportLogEntity.getDoctorId());
        userDoctorRelationVo.setUserId(docPatientReportLogEntity.getUserId().toString());
        String phone = docPatientReportLogEntity.getPhone();
        log.info("\u60a3\u8005\u624b\u673a\u53f7\u4e3a\uff1a{}", (Object)phone);
        if (!StringUtils.isEmpty((Object)phone)) {
            QueryDoctorParam param = new QueryDoctorParam();
            param.setDoctorId(userDoctorRelationVo.getDoctorId());
            DoctorInfoEntity doctorInfo = this.doctorMapper.querySingleDoctor(param);
            SmsPatientEvent event = new SmsPatientEvent(doctorInfo.getName(), userDoctorRelationVo.getAppCode(), phone, "hzbd");
            log.info("\u60a3\u8005\u62a5\u9053\u5ba1\u6838\u901a\u8fc7-\u77ed\u4fe1\u901a\u77e5\u5165\u53c2: {}", (Object)event);
            this.eventManager.post((Object)event);
        }
        return this.docPatientRelationService.saveUserDoctorRelation(userDoctorRelationVo);
    }

    public BaseResponse getUntreatedLogCountByDoctorId(Long doctorId, String appCode) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String endData = sdf.format(new Date());
        String startData = DataUtils.getLastSevenDay((String)endData);
        String startTime = startData + ZERO_TIME;
        List docPatientReportLogEntityList = this.docPatientReportLogMapper.selectByDoctorIdAndTime(appCode, doctorId, startTime, null, Integer.valueOf(1));
        return BaseResponse.success((Object)docPatientReportLogEntityList.size());
    }

    public BaseResponse<List<DocPatientReportLogEntity>> selectDoctorByPatientId(Long patientId, String appCode) {
        ArrayList docPatientList = new ArrayList();
        List relationList = this.docPatientRelationMapper.getByPatientId(patientId, appCode);
        log.info("\u67e5\u8be2\u60a3\u8005{},\u5bf9\u5e94\u7684\u533b\u751f\u4fe1\u606f{}", (Object)patientId, (Object)relationList);
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            docPatientList = new ArrayList();
        }
        ArrayList finalDocPatientList = docPatientList;
        relationList.stream().forEach(entity -> {
            String doctorId = String.valueOf(entity.getDoctorId());
            DocPatientReportLogEntity logEntity = new DocPatientReportLogEntity();
            String userId = this.newCommonMapper.findUserId(doctorId);
            logEntity.setUserId(Long.valueOf(userId));
            finalDocPatientList.add(logEntity);
        });
        return BaseResponse.success(docPatientList);
    }

    public BaseResponse<List<ChronicDoctorRsqVO>> selectPatientByDoctorId(Long doctorId, String patientName, String appCode) {
        if (Objects.isNull(doctorId) || StringUtils.isEmpty((Object)appCode)) {
            return BaseResponse.error((String)"\u975e\u6cd5\u53c2\u6570");
        }
        ArrayList<ChronicDoctorRsqVO> chronicDoctorRsqVOList = new ArrayList<ChronicDoctorRsqVO>();
        log.info("\u533b\u751f\u67e5\u8be2\u5bf9\u5e94\u7684\u60a3\u8005\u53c2\u6570doctorId={},appCode={}", (Object)doctorId, (Object)appCode);
        List relationList = this.docPatientRelationMapper.getLabelByDoctorIdAndPatientId(doctorId, appCode);
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            return BaseResponse.success(chronicDoctorRsqVOList);
        }
        for (DocPatientRelationEntity entity : relationList) {
            ChronicDoctorRsqVO rsqVO = new ChronicDoctorRsqVO();
            if (StringUtils.isEmpty((Object)entity.getCardNo())) continue;
            BeanUtils.copyProperties((Object)entity, (Object)rsqVO);
            String gender = IdCardUtil.getGenderByIdCard((String)entity.getCardNo());
            rsqVO.setPatientAge(Byte.valueOf((byte)IdCardUtil.getAgeByIdCard((String)entity.getCardNo())));
            rsqVO.setPatientSexCode(Byte.valueOf(GenderUtils.getSexCode((String)gender)));
            rsqVO.setPatientSexName(GenderUtils.getSexName((String)gender));
            chronicDoctorRsqVOList.add(rsqVO);
        }
        return BaseResponse.success(chronicDoctorRsqVOList);
    }

    public BaseResponse push_patient_msg(SavePatientReportLogVo savePatientReportLogVo) {
        PatientEvent event = new PatientEvent();
        event.setDoctorId(Long.valueOf(savePatientReportLogVo.getDoctorId()));
        event.setAppCode(savePatientReportLogVo.getAppCode());
        this.eventManager.post((Object)event);
        return BaseResponse.success();
    }

    private void patientInfoToDocPatientReportLogEntity(DocPatientReportLogEntity docPatientReportLogEntity, SavePatientReportLogVo savePatientReportLogVo) {
        String gender = IdCardUtil.getGenderByIdCard((String)savePatientReportLogVo.getCardNo());
        docPatientReportLogEntity.setAppCode(savePatientReportLogVo.getAppCode());
        docPatientReportLogEntity.setDoctorId(Long.valueOf(savePatientReportLogVo.getDoctorId()));
        docPatientReportLogEntity.setUserId(Long.valueOf(savePatientReportLogVo.getUserId()));
        docPatientReportLogEntity.setPatientId(Long.valueOf(savePatientReportLogVo.getPatientId()));
        docPatientReportLogEntity.setPatientName(savePatientReportLogVo.getPatientName());
        docPatientReportLogEntity.setPatientAge(Byte.valueOf((byte)IdCardUtil.getAgeByIdCard((String)savePatientReportLogVo.getCardNo())));
        docPatientReportLogEntity.setPatientId(Long.valueOf(savePatientReportLogVo.getPatientId()));
        docPatientReportLogEntity.setPatientSexCode(Byte.valueOf(GenderUtils.getSexCode((String)gender)));
        docPatientReportLogEntity.setPatientSexName(GenderUtils.getSexName((String)gender));
        docPatientReportLogEntity.setPatientHeadPortrait("");
        docPatientReportLogEntity.setPhone(savePatientReportLogVo.getPhone());
        docPatientReportLogEntity.setCardNo(savePatientReportLogVo.getCardNo());
    }

    private GetPatientInfoVo getPatientInfo(String patientId, String appCode) {
        GetPatientReqVo getPatientReqVo = new GetPatientReqVo();
        getPatientReqVo.setPatientId(patientId);
        getPatientReqVo.setAppCode(appCode);
        getPatientReqVo.setChannelCode("PATIENT_IOS");
        log.info("\u6839\u636e\u60a3\u8005ID\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u8c03\u7528\u5361\u670d\u52a1\u53c2\u6570\u4e3a:{}", (Object)getPatientReqVo);
        BaseResponse baseResponse = HttpClientUtil.doJsonPost((Object)getPatientReqVo, (String)(this.domainName + appCode + GET_PATIENT_INFO_FOR_CARD_SERVICE));
        String json = JSON.toJSONString((Object)baseResponse.getData());
        GetPatientInfoVo getPatientInfoVo = (GetPatientInfoVo)JSONArray.parseObject((String)json, GetPatientInfoVo.class);
        return getPatientInfoVo;
    }
}

