/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.doctoruser.api.pojo.base.dto.DocServiceInfoDTO;
import com.doctoruser.api.pojo.base.dto.DocWorkServiceInfoDTO;
import com.doctoruser.api.pojo.base.entity.OrganWorkingServiceEntity;
import com.doctoruser.api.pojo.base.vo.WorkInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.DoctorPositionInfoVo;
import com.doctoruser.api.pojo.base.vo.doctor.WorkServiceInfoVo;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.mapper.DocDoctorWorkingServiceMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.DoctorWorkplacesMapper;
import com.doctoruser.doctor.mapper.OrganWorkingServiceMapper;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesEntity;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.entity.DoctorWorkEntity;
import com.doctoruser.doctor.pojo.entity.OrganizationEntity;
import com.doctoruser.doctor.service.DoctorWorkService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorWorkServiceImpl
implements DoctorWorkService {
    private static final Logger log = LoggerFactory.getLogger(DoctorWorkServiceImpl.class);
    @Resource
    private DocDoctorWorkplacesMapper doctorWorkMapper;
    @Resource
    private DoctorMapper doctorMapper;
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private OrganWorkingServiceMapper organWorkingServiceMapper;
    @Resource
    private DocDoctorWorkingServiceMapper docDoctorWorkingServiceMapper;
    @Autowired
    private DoctorWorkplacesMapper doctorWorkplacesMapper;

    public BaseResponse<DoctorPositionInfoVo> getDoctorPositionInfo(Long doctorId) {
        DoctorPositionInfoVo doctorPositionInfoVo = this.doctorWorkMapper.getDoctorBaseInfo(doctorId);
        if (doctorPositionInfoVo != null && doctorPositionInfoVo.getWorkPlaceId() != null) {
            List openServiceIdList = this.doctorWorkMapper.getWorkService(doctorPositionInfoVo.getWorkPlaceId(), Integer.valueOf(1));
            List workServices = this.organWorkingServiceMapper.getWorkPlaceService(doctorPositionInfoVo.getWorkOrganId(), 1);
            workServices.stream().filter(item -> openServiceIdList.contains(item.getServiceCode())).forEach(item -> item.setStatus(Integer.valueOf(1)));
            doctorPositionInfoVo.setWorkServiceInfoList(workServices);
        }
        return BaseResponse.success((Object)doctorPositionInfoVo);
    }

    public BaseResponse<WorkInfoVo> getDoctorAuthInfo(Long doctorId) {
        DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)doctorId);
        if (doctorInfoEntity != null) {
            OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationMapper.selectById((Serializable)doctorInfoEntity.getOrganId());
            WorkInfoVo workInfoVo = new WorkInfoVo();
            workInfoVo.setWorkplacesId(null);
            workInfoVo.setStandardTitle(doctorInfoEntity.getProfession());
            workInfoVo.setHospitalTitle(doctorInfoEntity.getProfession());
            workInfoVo.setProfession(doctorInfoEntity.getSpeciality());
            workInfoVo.setIntroduction(doctorInfoEntity.getProfile());
            workInfoVo.setShareCode(null);
            workInfoVo.setDeptId(String.valueOf(doctorInfoEntity.getHospitalDeptId()));
            workInfoVo.setOrganCode(Objects.isNull(organizationEntity) ? "" : organizationEntity.getOrganCode());
            return BaseResponse.success((Object)workInfoVo);
        }
        return BaseResponse.success();
    }

    public BaseResponse<WorkServiceInfoVo> checkDoctorService(Long doctorId, String serviceType) {
        WorkServiceInfoVo workServiceInfoVo = this.doctorWorkMapper.checkDoctorService(doctorId, serviceType, Integer.valueOf(1));
        return BaseResponse.success((Object)workServiceInfoVo);
    }

    public BaseResponse<WorkServiceInfoVo> checkDoctorServiceByCode(Long doctorId, String serviceCode) {
        WorkServiceInfoVo workServiceInfoVo = this.doctorWorkMapper.checkDoctorServiceByCode(doctorId, serviceCode, Integer.valueOf(1));
        return BaseResponse.success((Object)workServiceInfoVo);
    }

    public BaseResponse<DocServiceInfoDTO> getDocServiceInfo(Long organId, Long doctorId, String serviceCode) {
        ServiceCodeEnum docService = ServiceCodeEnum.getByServiceCode((String)serviceCode);
        if (Objects.isNull(docService)) {
            return BaseResponse.error((IError)EHErrorEnum.SERVICE_CODE_PARAMETER_ERROR);
        }
        DocDoctorWorkplacesEntity docWorkplaceInfo = this.doctorWorkMapper.getByDoctorIdAndOrganId(organId, doctorId, Integer.valueOf(1));
        if (Objects.isNull(docWorkplaceInfo)) {
            log.error("\u533b\u751f\u804c\u4e1a\u4fe1\u606f\u6709\u8bef,\u67e5\u8be2\u5165\u53c2,\u533b\u9662id:{},\u533b\u751fid:{}", (Object)organId, (Object)doctorId);
            return BaseResponse.error((IError)EHErrorEnum.PROFESSION_INFORMATION_ERROR);
        }
        OrganWorkingServiceEntity organServiceInfo = this.organWorkingServiceMapper.getServiceByOrganId(organId, serviceCode, "1,-1");
        if (Objects.isNull(organServiceInfo)) {
            log.error("\u533b\u9662\u670d\u52a1\u4fe1\u606f\u6709\u8bef,\u67e5\u8be2\u5165\u53c2serviceCode:{}", (Object)serviceCode);
            return BaseResponse.error((IError)EHErrorEnum.SERVICE_INFORMATION_ERROR);
        }
        DocWorkServiceInfoDTO docWorkServiceInfo = this.docDoctorWorkingServiceMapper.getDocWorkService(Long.valueOf(organServiceInfo.getxId()), docWorkplaceInfo.getxId());
        if (Objects.isNull(docWorkServiceInfo) || StringUtils.isEmpty((String)docWorkServiceInfo.getConfig())) {
            log.error("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u4fe1\u606f\u53ca\u914d\u7f6e\u6709\u8bef,\u533b\u9662\u670d\u52a1id\u5165\u53c2:{},\u533b\u751f\u804c\u4e1aid\u5165\u53c2:{}", (Object)organServiceInfo.getxId(), (Object)docWorkplaceInfo.getxId());
            return BaseResponse.error((IError)EHErrorEnum.QUERY_SERVICE_ERROR);
        }
        DocServiceInfoDTO docServiceInfoDTO = new DocServiceInfoDTO();
        docServiceInfoDTO.setDoctorId(doctorId);
        docServiceInfoDTO.setOrganId(organId);
        docServiceInfoDTO.setServiceCode(serviceCode);
        docServiceInfoDTO.setServiceId(organServiceInfo.getxId());
        docServiceInfoDTO.setServiceName(organServiceInfo.getServName());
        return BaseResponse.success((Object)docServiceInfoDTO);
    }

    public DoctorWorkEntity getDoctorWork(Long organId, Long doctorId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DoctorWorkEntity::getOrganId, (Object)organId);
        queryWrapper.eq(DoctorWorkEntity::getDoctorId, (Object)doctorId);
        queryWrapper.eq(DoctorWorkEntity::getStatus, (Object)1);
        return (DoctorWorkEntity)this.doctorWorkplacesMapper.selectOne((Wrapper)queryWrapper);
    }
}

