/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.common.enums.ConfigTypeEnum;
import com.doctoruser.api.pojo.base.bo.DoctorWorkingServiceReq;
import com.doctoruser.api.pojo.base.entity.DoctorWorkingServiceDo;
import com.doctoruser.api.pojo.base.entity.OrganWorkingServiceEntity;
import com.doctoruser.api.pojo.base.vo.WorkServiceVo;
import com.doctoruser.api.pojo.base.vo.doctor.WorkServiceInfoVo;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.enums.ServiceCodeEnum;
import com.doctoruser.doctor.factory.DocServiceFactory;
import com.doctoruser.doctor.handler.DocServiceHandler;
import com.doctoruser.doctor.mapper.DocDepartmentMapper;
import com.doctoruser.doctor.mapper.DocDoctorServiceAccessMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkingServiceMapper;
import com.doctoruser.doctor.mapper.DocDoctorWorkplacesMapper;
import com.doctoruser.doctor.mapper.DocServiceConfigMapper;
import com.doctoruser.doctor.mapper.DoctorMapper;
import com.doctoruser.doctor.mapper.OrganWorkingServiceMapper;
import com.doctoruser.doctor.pojo.entity.DocDepartmentEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorServiceAccessEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkingServiceEntity;
import com.doctoruser.doctor.pojo.entity.DocDoctorWorkplacesEntity;
import com.doctoruser.doctor.pojo.entity.DocServiceConfigEntity;
import com.doctoruser.doctor.pojo.entity.DoctorInfoEntity;
import com.doctoruser.doctor.pojo.vo.BatchSetDocServiceReq;
import com.doctoruser.doctor.pojo.vo.ChildServiceInfo;
import com.doctoruser.doctor.pojo.vo.DocNodeServiceVo;
import com.doctoruser.doctor.pojo.vo.DocServiceSetParam;
import com.doctoruser.doctor.pojo.vo.DocWorkServiceVo;
import com.doctoruser.doctor.service.ServiceDoctorWorkService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceDoctorWorkServiceImpl
implements ServiceDoctorWorkService {
    private static final Logger log = LoggerFactory.getLogger(ServiceDoctorWorkServiceImpl.class);
    @Autowired
    private DocDoctorWorkingServiceMapper doctorWorkingServiceMapper;
    @Autowired
    private DocDoctorWorkplacesMapper doctorWorkMapper;
    @Autowired
    private OrganWorkingServiceMapper organWorkingServiceMapper;
    @Autowired
    private DocDoctorServiceAccessMapper doctorServiceAccessMapper;
    @Autowired
    private DocServiceConfigMapper docServiceConfigMapper;
    @Autowired
    private DocDepartmentMapper docDepartmentMapper;
    @Autowired
    private DocServiceFactory docServiceFactory;
    @Autowired
    private DoctorMapper doctorMapper;

    @Transactional(rollbackFor={RuntimeException.class})
    public BaseResponse saveDoctorWorkService(DoctorWorkingServiceReq doctorWorkingService) {
        DocDoctorServiceAccessEntity serviceAccess;
        DocDoctorWorkplacesEntity doctorWorkPlace = this.doctorWorkMapper.getDoctorWorkInfo(doctorWorkingService.getDoctorId(), doctorWorkingService.getOrganId(), 1);
        if (Objects.isNull(doctorWorkPlace)) {
            log.error("======\u533b\u751f:{}\u6267\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728======", (Object)doctorWorkingService.getDoctorId());
            return BaseResponse.error((IError)IError.DATA_ERROR);
        }
        OrganWorkingServiceEntity organWorkingServiceEntity = this.organWorkingServiceMapper.getServiceByOrganId(doctorWorkPlace.getOrganId(), doctorWorkingService.getServiceCode(), String.valueOf(1));
        if (Objects.isNull(organWorkingServiceEntity)) {
            log.error("======\u804c\u4e1a\u70b9:{},\u670d\u52a1:{}\u4fe1\u606f\u4e0d\u5b58\u5728======", (Object)doctorWorkPlace.getxId(), (Object)doctorWorkingService.getServiceCode());
            return BaseResponse.error((IError)IError.DATA_ERROR);
        }
        if (doctorWorkingService.getStatus() == 1 && ((serviceAccess = this.doctorServiceAccessMapper.getByWorkIdAndServiceId(doctorWorkPlace.getxId() + "", organWorkingServiceEntity.getxId())) == null || serviceAccess.getStatus() == 0)) {
            log.info("======\u533b\u751f\u5f00\u901a\u670d\u52a1\u6743\u9650\u5173\u95ed,\u786e\u8ba4\u6570\u636e\u662f\u5426\u77db\u76fe======");
            return BaseResponse.error((String)com.doctoruser.api.common.enums.EHErrorEnum.OPEN_POWER_CLOSED.getMsg());
        }
        this.updateDoctorServiceInfo(doctorWorkingService, organWorkingServiceEntity.getxId() + "", doctorWorkPlace.getxId() + "");
        return BaseResponse.success();
    }

    public BaseResponse<List<WorkServiceVo>> getWorkServiceList(Long doctorId, Long organId) {
        DocDoctorWorkplacesEntity doctorWorkPlace = this.doctorWorkMapper.getDoctorWorkInfo(doctorId, organId, 1);
        if (Objects.isNull(doctorWorkPlace)) {
            log.error("======\u533b\u751f:{}\u6267\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728======", (Object)doctorId);
            return BaseResponse.error((IError)IError.DATA_ERROR);
        }
        List workPlaceService = this.organWorkingServiceMapper.getWorkPlaceService(doctorWorkPlace.getOrganId(), 1);
        workPlaceService.sort(Comparator.comparingInt(item -> Integer.valueOf(item.getParentCode())));
        Map doctorServiceMap = this.doctorWorkingServiceMapper.getWorkingServiceDetail(doctorWorkPlace.getxId() + "", ConfigTypeEnum.DOCTOR_CONFIG.getValue(), 1);
        LinkedHashMap<String, WorkServiceVo> workServiceMap = new LinkedHashMap<String, WorkServiceVo>();
        for (WorkServiceInfoVo workServiceInfo : workPlaceService) {
            WorkServiceVo workService = (WorkServiceVo)doctorServiceMap.get(workServiceInfo.getServiceCode());
            ServiceCodeEnum serviceEnum = ServiceCodeEnum.getByServiceCode((String)workServiceInfo.getServiceCode());
            if (workService == null) {
                workService = new WorkServiceVo();
                workService.initService();
                workService.setServiceName(workServiceInfo.getServiceName());
                workService.setServiceCode(workServiceInfo.getServiceCode());
                workService.setParentCode(workServiceInfo.getParentCode());
                OrganWorkingServiceEntity organWorkingService = this.organWorkingServiceMapper.getServiceByOrganId(organId, workServiceInfo.getServiceCode(), "1,-1");
                if (Objects.nonNull(organWorkingService) && StringUtils.isNotBlank((CharSequence)organWorkingService.getServiceConfig())) {
                    workService.setServiceInfo(organWorkingService.getServiceConfig());
                } else if (Objects.nonNull(serviceEnum)) {
                    workService.setServiceInfo(serviceEnum.getServiceConfig());
                }
            }
            if (Objects.isNull(workService.getStatus())) {
                workService.setStatus(Integer.valueOf(0));
            }
            if (Objects.isNull(workService.getAuthStatus())) {
                workService.setAuthStatus(workService.getStatus());
            }
            if (StringUtils.isBlank((CharSequence)workService.getServiceInfo())) {
                if (Objects.nonNull(serviceEnum)) {
                    workService.setServiceInfo(serviceEnum.getServiceConfig());
                } else {
                    workService.setServiceInfo("");
                }
            }
            if (StringUtils.isBlank((CharSequence)workService.getProperty())) {
                workService.setProperty("");
            } else {
                DocDepartmentEntity docDepartmentEntity = this.docDepartmentMapper.selectByPrimaryKey(Long.valueOf(workService.getProperty()));
                if (Objects.nonNull(docDepartmentEntity)) {
                    workService.setPropertyName(docDepartmentEntity.getDeptName());
                }
            }
            if ("0".equals(workServiceInfo.getParentCode())) {
                workServiceMap.put(workServiceInfo.getServiceCode(), workService);
                continue;
            }
            WorkServiceVo workServiceVo = (WorkServiceVo)workServiceMap.get(workServiceInfo.getParentCode());
            if (!Objects.nonNull(workServiceVo)) continue;
            List childService = workServiceVo.getChildService();
            childService.add(workService);
            childService.sort(Comparator.comparingInt(service -> Integer.valueOf(service.getServiceCode())));
        }
        ArrayList workServiceVos = new ArrayList(workServiceMap.values());
        return BaseResponse.success(workServiceVos);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public BaseResponse saveDoctorServiceAccess(DoctorWorkingServiceReq doctorWorkingService) {
        DocDoctorWorkplacesEntity doctorWorkPlace = this.doctorWorkMapper.getDoctorWorkInfo(doctorWorkingService.getDoctorId(), doctorWorkingService.getOrganId(), 1);
        if (Objects.isNull(doctorWorkPlace)) {
            log.error("\u533b\u751f:[{}]\u6267\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)doctorWorkingService.getDoctorId());
            return BaseResponse.error((IError)IError.DATA_ERROR);
        }
        log.info("\u533b\u751f\u804c\u4e1a\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)doctorWorkPlace));
        OrganWorkingServiceEntity organWorkingServiceEntity = this.organWorkingServiceMapper.getServiceByOrganId(doctorWorkPlace.getOrganId(), doctorWorkingService.getServiceCode(), String.valueOf(1));
        if (Objects.isNull(organWorkingServiceEntity)) {
            log.error("\u804c\u4e1a\u70b9:[{}],\u670d\u52a1:[{}]\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)doctorWorkPlace.getxId(), (Object)doctorWorkingService.getServiceCode());
            return BaseResponse.error((IError)IError.DATA_ERROR);
        }
        log.info("\u533b\u751f\u804c\u4e1a\u70b9\u670d\u52a1\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)organWorkingServiceEntity));
        DocDoctorServiceAccessEntity serviceAccess = this.doctorServiceAccessMapper.getByWorkIdAndServiceId(doctorWorkPlace.getxId() + "", organWorkingServiceEntity.getxId() + "");
        if (null == serviceAccess) {
            DocDoctorServiceAccessEntity doctorServiceAccessEntity = new DocDoctorServiceAccessEntity();
            doctorServiceAccessEntity.setDoctorWorkId(doctorWorkPlace.getxId());
            doctorServiceAccessEntity.setWorkingService(Long.valueOf(organWorkingServiceEntity.getxId()));
            doctorServiceAccessEntity.setxCreateTime(new Date());
            doctorServiceAccessEntity.setxUpdateTime(new Date());
            doctorServiceAccessEntity.setStatus(Integer.valueOf(doctorWorkingService.getStatus()));
            this.doctorServiceAccessMapper.insertSelective(doctorServiceAccessEntity);
        } else {
            serviceAccess.setStatus(Integer.valueOf(doctorWorkingService.getStatus()));
            serviceAccess.setxUpdateTime(new Date());
            this.doctorServiceAccessMapper.updateByPrimaryKeySelective(serviceAccess);
        }
        this.updateDoctorServiceInfo(doctorWorkingService, organWorkingServiceEntity.getxId() + "", doctorWorkPlace.getxId() + "");
        return BaseResponse.success();
    }

    private void updateDoctorServiceInfo(DoctorWorkingServiceReq doctorWorkingService, String organWorkingServiceId, String doctorWorkPlaceId) {
        log.info("\u8bbe\u7f6e\u533b\u751f\u670d\u52a1\u4fe1\u606f\u5165\u53c2:{},\u533b\u9662\u670d\u52a1id:{},\u533b\u751f\u804c\u4e1a\u4fe1\u606fid:{}", new Object[]{JSON.toJSONString((Object)doctorWorkingService), organWorkingServiceId, doctorWorkPlaceId});
        DoctorWorkingServiceDo doctorWorkingServiceDo = this.doctorWorkingServiceMapper.getWorkingService(organWorkingServiceId, doctorWorkPlaceId);
        if (Objects.isNull(doctorWorkingServiceDo)) {
            log.info("========\u533b\u751f\u670d\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728,\u521b\u5efa\u65b0\u7684\u670d\u52a1\u4fe1\u606f========");
            DocServiceConfigEntity docServiceConfig = new DocServiceConfigEntity();
            docServiceConfig.setxCreateTime(new Date());
            docServiceConfig.setxUpdateTime(new Date());
            docServiceConfig.setxRemark("");
            docServiceConfig.setxVersion(Long.valueOf(1L));
            docServiceConfig.setServCode(organWorkingServiceId);
            docServiceConfig.setContent(doctorWorkingService.getServiceInfo());
            docServiceConfig.setSourceId(Long.valueOf(doctorWorkPlaceId));
            docServiceConfig.setType(Integer.valueOf(ConfigTypeEnum.DOCTOR_CONFIG.getValue()));
            log.info("\u6dfb\u52a0\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)docServiceConfig));
            this.docServiceConfigMapper.insertSelective(docServiceConfig);
            if (docServiceConfig.getxId() == null) {
                log.error("======\u533b\u751f:{},\u914d\u7f6e\u670d\u52a1:{},\u5931\u8d25======", (Object)doctorWorkingService.getDoctorId(), (Object)doctorWorkingService.getServiceCode());
                throw new RuntimeException("\u6dfb\u52a0\u670d\u52a1\u914d\u7f6e\u5931\u8d25");
            }
            log.info("\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u6dfb\u52a0\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)docServiceConfig));
            doctorWorkingServiceDo = new DoctorWorkingServiceDo();
            doctorWorkingServiceDo.setConfigId(docServiceConfig.getxId());
            doctorWorkingServiceDo.setDoctorWorkId(Long.valueOf(doctorWorkPlaceId));
            doctorWorkingServiceDo.setWorkingService(Long.valueOf(organWorkingServiceId));
            doctorWorkingServiceDo.setxRemark(doctorWorkingService.getRemark());
            doctorWorkingServiceDo.setStatus(Integer.valueOf(doctorWorkingService.getStatus()));
            log.info("\u6dfb\u52a0\u533b\u751f\u670d\u52a1\u4fe1\u606f\u5165\u53c2:{},", (Object)JSON.toJSONString((Object)doctorWorkingServiceDo));
            int insertService = this.doctorWorkingServiceMapper.insertSelective(doctorWorkingServiceDo);
            if (insertService == 0) {
                log.error("======\u533b\u751f:{},\u6dfb\u52a0\u670d\u52a1:{},\u5931\u8d25======", (Object)doctorWorkingService.getDoctorId(), (Object)doctorWorkingService.getServiceCode());
                throw new RuntimeException("\u6dfb\u52a0\u533b\u751f\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            DocServiceConfigEntity serviceConfig = this.docServiceConfigMapper.getById(doctorWorkingServiceDo.getConfigId());
            if (Objects.isNull(serviceConfig)) {
                log.info("======\u533b\u751f\u670d\u52a1\u914d\u7f6e\u4e0d\u5b58\u5728,\u521b\u5efa\u670d\u52a1\u914d\u7f6e======");
                DocServiceConfigEntity docServiceConfig = new DocServiceConfigEntity();
                docServiceConfig.setxCreateTime(new Date());
                docServiceConfig.setxUpdateTime(new Date());
                docServiceConfig.setxRemark("");
                docServiceConfig.setxVersion(Long.valueOf(1L));
                docServiceConfig.setServCode(organWorkingServiceId);
                docServiceConfig.setContent(doctorWorkingService.getServiceInfo());
                docServiceConfig.setSourceId(Long.valueOf(doctorWorkPlaceId));
                docServiceConfig.setType(Integer.valueOf(ConfigTypeEnum.DOCTOR_CONFIG.getValue()));
                this.docServiceConfigMapper.insertSelective(docServiceConfig);
                if (docServiceConfig.getxId() == null) {
                    log.error("======\u533b\u751f:{},\u6dfb\u52a0\u914d\u7f6e\u670d\u52a1:{},\u5931\u8d25======", (Object)doctorWorkingService.getDoctorId(), (Object)doctorWorkingService.getServiceCode());
                    throw new RuntimeException("\u6dfb\u52a0\u670d\u52a1\u914d\u7f6e\u5931\u8d25");
                }
                doctorWorkingServiceDo.setConfigId(docServiceConfig.getxId());
            } else {
                serviceConfig.setServCode(organWorkingServiceId);
                serviceConfig.setContent(doctorWorkingService.getServiceInfo());
                log.info("\u66f4\u65b0\u533b\u751f\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)serviceConfig));
                Integer updateConfig = this.docServiceConfigMapper.updateById(serviceConfig);
                if (updateConfig == 0) {
                    log.error("======\u533b\u751f:{},\u66f4\u65b0\u914d\u7f6e\u670d\u52a1:{},\u5931\u8d25======", (Object)doctorWorkingService.getDoctorId(), (Object)doctorWorkingService.getServiceCode());
                    throw new RuntimeException("\u66f4\u65b0\u670d\u52a1\u914d\u7f6e\u5931\u8d25");
                }
            }
            doctorWorkingServiceDo.setStatus(Integer.valueOf(doctorWorkingService.getStatus()));
            doctorWorkingServiceDo.setxRemark(doctorWorkingService.getRemark());
            log.info("\u66f4\u65b0\u533b\u751f\u670d\u52a1\u5f00\u5173\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)doctorWorkingServiceDo));
            int updateService = this.doctorWorkingServiceMapper.updateByPrimaryKeySelective(doctorWorkingServiceDo);
            if (updateService == 0) {
                log.error("======\u533b\u751f:{},\u66f4\u65b0\u670d\u52a1:{},\u5931\u8d25======", (Object)doctorWorkingService.getDoctorId(), (Object)doctorWorkingService.getServiceCode());
                throw new RuntimeException("\u66f4\u65b0\u533b\u751f\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
            }
        }
    }

    public BaseResponse<List<DocWorkServiceVo>> getBatchDocService(List<Long> doctorIds, String serviceCode) {
        List list = new ArrayList();
        if (doctorIds.isEmpty()) {
            return BaseResponse.success(list);
        }
        list = this.doctorWorkingServiceMapper.getBatchDocService(doctorIds, serviceCode, 1);
        return BaseResponse.success(list);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public synchronized BaseResponse batchSetDocService(BatchSetDocServiceReq batchSetDocServiceReq) {
        if (batchSetDocServiceReq.getDoctorWorkIds().isEmpty()) {
            return BaseResponse.error((IError)EHErrorEnum.DATA_NOT_EXIST);
        }
        DocServiceHandler docServiceHandler = this.docServiceFactory.getDocServiceHandler(batchSetDocServiceReq.getServiceCode());
        List serviceSetParamList = this.convertServiceSetParam(batchSetDocServiceReq);
        for (DocServiceSetParam docServiceSetParam : serviceSetParamList) {
            log.info("\u6279\u91cf\u8bbe\u7f6e\u7684\u670d\u52a1\u9879:{}", (Object)JSON.toJSONString((Object)docServiceSetParam));
            List doctorWorkServiceList = this.doctorWorkingServiceMapper.getByDoctorWorkIdAndServiceCode(batchSetDocServiceReq.getDoctorWorkIds(), docServiceSetParam.getServiceCode(), "1,-1");
            List doctorWorkIds = doctorWorkServiceList.stream().map(DocDoctorWorkingServiceEntity::getDoctorWorkId).collect(Collectors.toList());
            log.info("\u9700\u8981\u66f4\u65b0\u8bb0\u5f55\u7684\u533b\u751f\u804c\u4e1aid\u96c6\u5408:{}", (Object)JSON.toJSONString(doctorWorkIds));
            List insertServiceWorkIds = batchSetDocServiceReq.getDoctorWorkIds().stream().filter(workId -> !doctorWorkIds.contains(workId)).collect(Collectors.toList());
            log.info("\u9700\u8981\u65b0\u589e\u8bb0\u5f55\u7684\u533b\u751f\u804c\u4e1aid\u96c6\u5408:{}", (Object)JSON.toJSONString(insertServiceWorkIds));
            if (!insertServiceWorkIds.isEmpty()) {
                this.doctorServiceAccessMapper.batchInsertSelective(insertServiceWorkIds, docServiceSetParam);
                List insertDoctorWork = this.doctorWorkMapper.selectByIds(insertServiceWorkIds);
                List insertDataDoctorId = insertDoctorWork.stream().map(DocDoctorWorkplacesEntity::getDoctorId).collect(Collectors.toList());
                log.info("\u9700\u8981\u65b0\u589e\u8bb0\u5f55\u7684\u533b\u751fid\u96c6\u5408:{}", (Object)JSON.toJSONString(insertDataDoctorId));
                docServiceHandler.synchroniseInsert(docServiceSetParam, insertDataDoctorId);
            }
            for (Long doctorWorkId : insertServiceWorkIds) {
                DocServiceConfigEntity docServiceConfig = new DocServiceConfigEntity();
                docServiceConfig.setxCreateTime(new Date());
                docServiceConfig.setxUpdateTime(new Date());
                docServiceConfig.setxRemark("");
                docServiceConfig.setxVersion(Long.valueOf(1L));
                docServiceConfig.setServCode(String.valueOf(docServiceSetParam.getOrganServiceId()));
                docServiceConfig.setContent(docServiceSetParam.getServiceInfo());
                docServiceConfig.setSourceId(doctorWorkId);
                docServiceConfig.setType(Integer.valueOf(ConfigTypeEnum.DOCTOR_CONFIG.getValue()));
                this.docServiceConfigMapper.insertSelective(docServiceConfig);
                DoctorWorkingServiceDo doctorWorkingServiceDo = new DoctorWorkingServiceDo();
                doctorWorkingServiceDo.setConfigId(docServiceConfig.getxId());
                doctorWorkingServiceDo.setDoctorWorkId(doctorWorkId);
                doctorWorkingServiceDo.setServiceCode(docServiceSetParam.getServiceCode());
                doctorWorkingServiceDo.setStatus(docServiceSetParam.getStatus());
                doctorWorkingServiceDo.setWorkingService(docServiceSetParam.getOrganServiceId());
                doctorWorkingServiceDo.setxCreateTime(new Date());
                doctorWorkingServiceDo.setxRemark(docServiceSetParam.getRemark());
                doctorWorkingServiceDo.setxUpdateTime(new Date());
                int insertService = this.doctorWorkingServiceMapper.insertSelective(doctorWorkingServiceDo);
                if (insertService != 0) continue;
                log.error("======\u533b\u751f\u6267\u4e1aid:{},\u6dfb\u52a0\u670d\u52a1:{},\u5931\u8d25======", (Object)doctorWorkId, (Object)docServiceSetParam.getServiceCode());
                throw new RuntimeException("\u6dfb\u52a0\u533b\u751f\u670d\u52a1\u4fe1\u606f\u5931\u8d25");
            }
            if (!doctorWorkIds.isEmpty()) {
                List existDoctorWork = this.doctorWorkMapper.selectByIds(doctorWorkIds);
                List existDataDoctorId = existDoctorWork.stream().map(DocDoctorWorkplacesEntity::getDoctorId).collect(Collectors.toList());
                log.info("\u9700\u8981\u66f4\u65b0\u8bb0\u5f55\u7684\u533b\u751fid\u96c6\u5408:{}", (Object)JSON.toJSONString((Object)existDataDoctorId));
                docServiceHandler.synchroniseUpdate(docServiceSetParam, existDataDoctorId);
                this.doctorWorkingServiceMapper.batchUpdateSelective(doctorWorkIds, docServiceSetParam);
                this.doctorServiceAccessMapper.batchUpdateSelective(doctorWorkIds, docServiceSetParam);
            }
            List insertConfigService = doctorWorkServiceList.stream().filter(item -> Objects.isNull(item.getConfigId())).collect(Collectors.toList());
            for (DocDoctorWorkingServiceEntity docDoctorWorkingServiceEntity : insertConfigService) {
                DocServiceConfigEntity docServiceConfig = new DocServiceConfigEntity();
                docServiceConfig.setxCreateTime(new Date());
                docServiceConfig.setxUpdateTime(new Date());
                docServiceConfig.setxRemark("");
                docServiceConfig.setxVersion(Long.valueOf(1L));
                docServiceConfig.setServCode(String.valueOf(docServiceSetParam.getOrganServiceId()));
                docServiceConfig.setContent(docServiceSetParam.getServiceInfo());
                docServiceConfig.setSourceId(docDoctorWorkingServiceEntity.getDoctorWorkId());
                docServiceConfig.setType(Integer.valueOf(ConfigTypeEnum.DOCTOR_CONFIG.getValue()));
                this.docServiceConfigMapper.insertSelective(docServiceConfig);
                DoctorWorkingServiceDo doctorWorkingServiceDo = new DoctorWorkingServiceDo();
                doctorWorkingServiceDo.setxId(docDoctorWorkingServiceEntity.getxId());
                doctorWorkingServiceDo.setConfigId(docServiceConfig.getxId());
                int updateService = this.doctorWorkingServiceMapper.updateByPrimaryKeySelective(doctorWorkingServiceDo);
                if (updateService != 0) continue;
                log.error("======\u533b\u751f\u6267\u4e1aid:{},\u66f4\u65b0\u670d\u52a1:{},\u5931\u8d25======", (Object)docDoctorWorkingServiceEntity.getDoctorWorkId(), (Object)docServiceSetParam.getServiceCode());
                throw new RuntimeException("\u66f4\u65b0\u533b\u751f\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
            }
            List updateConfigService = doctorWorkServiceList.stream().filter(item -> Objects.nonNull(item.getConfigId())).collect(Collectors.toList());
            List serviceConfigIds = updateConfigService.stream().map(DocDoctorWorkingServiceEntity::getConfigId).collect(Collectors.toList());
            if (serviceConfigIds.isEmpty()) continue;
            log.info("======\u533b\u751f\u6267\u4e1aid:{},\u66f4\u65b0\u670d\u52a1:{}======", (Object)serviceConfigIds.toString(), (Object)docServiceSetParam.getServiceCode());
            this.docServiceConfigMapper.updateContentByIds(serviceConfigIds, docServiceSetParam.getServiceInfo());
        }
        return BaseResponse.success();
    }

    private List<DocServiceSetParam> convertServiceSetParam(BatchSetDocServiceReq batchSetDocServiceReq) {
        ArrayList<DocServiceSetParam> serviceSetList = new ArrayList<DocServiceSetParam>();
        DocServiceSetParam docServiceSetParam = new DocServiceSetParam();
        docServiceSetParam.setStatus(Integer.valueOf(batchSetDocServiceReq.getStatus()));
        docServiceSetParam.setRemark(batchSetDocServiceReq.getProperty());
        docServiceSetParam.setServiceCode(batchSetDocServiceReq.getServiceCode());
        docServiceSetParam.setServiceInfo(batchSetDocServiceReq.getServiceConfig());
        docServiceSetParam.setAppCode(batchSetDocServiceReq.getAppCode());
        docServiceSetParam.setOrganId(batchSetDocServiceReq.getOrganId());
        OrganWorkingServiceEntity organWorkingServiceEntity = this.organWorkingServiceMapper.getServiceByOrganId(batchSetDocServiceReq.getOrganId(), batchSetDocServiceReq.getServiceCode(), "1,-1");
        if (Objects.isNull(organWorkingServiceEntity)) {
            throw new RuntimeException("\u533b\u9662\u670d\u52a1\u6709\u8bef,\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c");
        }
        docServiceSetParam.setOrganServiceId(Long.valueOf(organWorkingServiceEntity.getxId()));
        serviceSetList.add(docServiceSetParam);
        for (ChildServiceInfo childServiceInfo : batchSetDocServiceReq.getChildService()) {
            DocServiceSetParam serviceSetParam = new DocServiceSetParam();
            serviceSetParam.setServiceInfo(childServiceInfo.getServiceConfig());
            serviceSetParam.setServiceCode(childServiceInfo.getServiceCode());
            serviceSetParam.setRemark(childServiceInfo.getProperty());
            serviceSetParam.setStatus(Integer.valueOf(childServiceInfo.getStatus()));
            serviceSetParam.setAppCode(batchSetDocServiceReq.getAppCode());
            serviceSetParam.setOrganId(batchSetDocServiceReq.getOrganId());
            OrganWorkingServiceEntity organWorkingService = this.organWorkingServiceMapper.getServiceByOrganId(batchSetDocServiceReq.getOrganId(), childServiceInfo.getServiceCode(), "1,-1");
            if (Objects.isNull(organWorkingService)) {
                throw new RuntimeException("\u533b\u9662\u670d\u52a1\u6709\u8bef,\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c");
            }
            serviceSetParam.setOrganServiceId(Long.valueOf(organWorkingService.getxId()));
            serviceSetList.add(serviceSetParam);
        }
        log.info("\u8f6c\u6362\u670d\u52a1\u8bbe\u7f6e\u96c6\u5408,\u8f6c\u6362\u540e\u7ed3\u679c:{}", (Object)JSON.toJSONString(serviceSetList));
        return serviceSetList;
    }

    public List<DocNodeServiceVo> getDocNodeServiceList(Long organId, Long doctorId, String serviceCode) {
        ArrayList<DocNodeServiceVo> resultList = new ArrayList<DocNodeServiceVo>();
        DoctorInfoEntity doctorInfoEntity = (DoctorInfoEntity)this.doctorMapper.selectById((Serializable)doctorId);
        if (Objects.isNull(doctorInfoEntity)) {
            throw new RuntimeException("\u533b\u751f\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        List organServiceList = this.organWorkingServiceMapper.getChildServiceByParentCode(organId, serviceCode, 1);
        if (organServiceList.isEmpty()) {
            return resultList;
        }
        for (OrganWorkingServiceEntity organWorkingService : organServiceList) {
            List docServiceList = this.doctorWorkingServiceMapper.getDocServiceByDocIdAndServId(doctorId, organWorkingService.getxId(), 1);
            for (DocDoctorWorkingServiceEntity doctorService : docServiceList) {
                DocNodeServiceVo docNodeServiceVo = new DocNodeServiceVo();
                docNodeServiceVo.setDeptId(doctorInfoEntity.getHospitalDeptId());
                docNodeServiceVo.setDeptName(doctorInfoEntity.getHospitalDeptName());
                docNodeServiceVo.setDoctorId(doctorId);
                docNodeServiceVo.setDoctorName(doctorInfoEntity.getName());
                docNodeServiceVo.setServCode(organWorkingService.getServCode());
                docNodeServiceVo.setServName(organWorkingService.getServName());
                docNodeServiceVo.setStdFirstDeptId(doctorInfoEntity.getStdFirstDeptId());
                docNodeServiceVo.setStdFirstDeptName(doctorInfoEntity.getStdFirstDeptName());
                resultList.add(docNodeServiceVo);
            }
        }
        return resultList;
    }
}

