/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctor.basedata.api.vo.UcAppCodeHospitalInfoVO;
import com.doctoruser.api.pojo.dto.GetHospitalInfoDTO;
import com.doctoruser.api.pojo.dto.UcHospitalInfoDTO;
import com.doctoruser.api.pojo.dto.UcHospitalInfoReq;
import com.doctoruser.api.pojo.dto.UpdateHospitalInfoReq;
import com.doctoruser.api.pojo.dto.organization.OrganizationByParamDTO;
import com.doctoruser.api.pojo.vo.BeanRespVO;
import com.doctoruser.api.pojo.vo.UcHospitalInfoVO;
import com.doctoruser.api.pojo.vo.pushcenter.OrganNumberVO;
import com.doctoruser.doctor.enums.EHErrorEnum;
import com.doctoruser.doctor.exception.BusinessException;
import com.doctoruser.doctor.mapper.OrganizationMapper;
import com.doctoruser.doctor.mapper.UcHospitalInfoMapper;
import com.doctoruser.doctor.pojo.dto.RemoteCallBack;
import com.doctoruser.doctor.pojo.entity.UcHospitalInfoEntity;
import com.doctoruser.doctor.pojo.vo.PlatformActiveReq;
import com.doctoruser.doctor.service.UcHospitalInfoService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.HttpClientUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UcHospitalInfoServiceImpl
implements UcHospitalInfoService {
    private static final Logger log = LoggerFactory.getLogger(UcHospitalInfoServiceImpl.class);
    public static final String PREFIX_USER_ID = "8888";
    public static final String TONKEN_KEY = "hxgy-ehospital";
    public static final String APP_URL = "https://sytwx.chinachdu.com/consulationdetail/";
    public static final String REQ_URL = "https://ihos.chinachdu.com";
    private static final String INTO_ARGS = "\u5165\u53c2:{}";
    @Autowired
    private UcHospitalInfoMapper ucHospitalInfoMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private Environment environment;

    @Transactional(rollbackFor={RuntimeException.class})
    public BaseResponse<String> saveHospitalInfo(UcHospitalInfoReq ucHospitalInfoReq) {
        int insertSelective;
        log.info(INTO_ARGS, (Object)ucHospitalInfoReq);
        UcHospitalInfoEntity ucHospitalInfoEntity = new UcHospitalInfoEntity();
        BeanUtils.copyProperties((Object)ucHospitalInfoReq, (Object)ucHospitalInfoEntity);
        ucHospitalInfoEntity.setAppCode(ucHospitalInfoReq.getHospitalCode());
        ucHospitalInfoEntity.setStatus(Byte.valueOf((byte)8));
        ucHospitalInfoEntity.setType(Byte.valueOf((byte)1));
        ucHospitalInfoEntity.setPrefixUserid(PREFIX_USER_ID);
        ucHospitalInfoEntity.setTokenKey(TONKEN_KEY);
        ucHospitalInfoEntity.setAppUrl(APP_URL);
        ucHospitalInfoEntity.setReqUrl(REQ_URL);
        GetHospitalInfoDTO getHospitalInfoDTO = new GetHospitalInfoDTO();
        BeanUtils.copyProperties((Object)ucHospitalInfoReq, (Object)getHospitalInfoDTO);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        getHospitalInfoDTO.setStatusArr(list);
        UcHospitalInfoEntity ucHospitalInfo = this.ucHospitalInfoMapper.selectByNameOrCode(getHospitalInfoDTO);
        if (ucHospitalInfo != null) {
            if (ucHospitalInfo.getHospitalCode().equals(ucHospitalInfoReq.getHospitalCode())) {
                log.error("\u5e73\u53f0code\u5df2\u5b58\u5728!");
                return BaseResponse.error((IError)EHErrorEnum.APP_CODE_EXISTS);
            }
            if (ucHospitalInfo.getHospitalName().equals(ucHospitalInfoReq.getHospitalName())) {
                log.error("\u5e73\u53f0\u540d\u79f0\u5df2\u5b58\u5728!");
                return BaseResponse.error((IError)EHErrorEnum.APP_NAME_EXISTS);
            }
        }
        if ((insertSelective = this.ucHospitalInfoMapper.insertSelective(ucHospitalInfoEntity)) == 0) {
            log.error("\u672a\u77e5\u9519\u8bef");
            return BaseResponse.error((IError)IError.SYSYTEM_UNKNOW);
        }
        log.info("\u6dfb\u52a0\u6210\u529f");
        return BaseResponse.success();
    }

    private void RemoteCallPermission(UcHospitalInfoEntity ucHospitalInfoEntity) {
        String initAuthDataUrl = this.createInitAuthDataUrl(ucHospitalInfoEntity.getAppCode());
        String initRoleDataUrl = this.createInitRoleDataUrl(ucHospitalInfoEntity.getAppCode());
        String authResponseStr = HttpClientUtil.get((String)initAuthDataUrl);
        String roleResponseStr = HttpClientUtil.get((String)initRoleDataUrl);
        BaseResponse initAuthResponse = (BaseResponse)JSON.parseObject((String)authResponseStr, BaseResponse.class);
        BaseResponse initRoleResponse = (BaseResponse)JSON.parseObject((String)roleResponseStr, BaseResponse.class);
        if (!"1".equals(initAuthResponse.getCode()) || !"1".equals(initRoleResponse.getCode())) {
            log.info("\u8c03\u7528\u6743\u9650\u521d\u59cb\u5316\u5e73\u53f0\u6743\u9650\u5931\u8d25---initAuthDataUrl:[{}],initRoleDataUrl:[{}]", (Object)initAuthDataUrl, (Object)roleResponseStr);
            RemoteCallBack authCallException = (RemoteCallBack)JSON.parseObject((String)authResponseStr, RemoteCallBack.class);
            RemoteCallBack roleCallException = (RemoteCallBack)JSON.parseObject((String)roleResponseStr, RemoteCallBack.class);
            if (Objects.nonNull(authCallException) && Objects.nonNull(roleCallException) && (404 == authCallException.getStatus() || 404 == roleCallException.getStatus())) {
                throw new BusinessException("\u672a\u914d\u7f6eurl\u6620\u5c04");
            }
            log.error("\u6743\u9650\u521d\u59cb\u5316\u8fd4\u56de:{},\u89d2\u8272\u521d\u59cb\u5316\u8fd4\u56de:{}", (Object)authResponseStr, (Object)initRoleDataUrl);
            throw new RuntimeException("\u521d\u59cb\u5316\u5e73\u53f0\u6743\u9650\u5931\u8d25");
        }
    }

    private String createInitAuthDataUrl(String appCode) {
        String nodeDomainName = this.environment.getProperty("domainName");
        return nodeDomainName + "/" + appCode + "/permissions/initialization/initializationAuth?appCode=" + appCode;
    }

    private String createInitRoleDataUrl(String appCode) {
        String nodeDomainName = this.environment.getProperty("domainName");
        return nodeDomainName + "/" + appCode + "/permissions/initialization/initializationRole?appCode=" + appCode;
    }

    public BaseResponse<String> updateHospitalInfoStatus(int hospitalId, int status) {
        log.info("\u5165\u53c2:{hospitalId=" + hospitalId + ",status=" + status + "}");
        UcHospitalInfoEntity infoEntity = this.ucHospitalInfoMapper.selectByPrimaryKey(Integer.valueOf(hospitalId));
        if (infoEntity == null) {
            log.error("\u6570\u636e\u4e0d\u5b58\u5728");
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST);
        }
        UcHospitalInfoEntity ucHospitalInfoEntity = new UcHospitalInfoEntity();
        ucHospitalInfoEntity.setStatus(Byte.valueOf((byte)status));
        ucHospitalInfoEntity.setId(Integer.valueOf(hospitalId));
        int updateNumber = this.ucHospitalInfoMapper.updateByPrimaryKeySelective(ucHospitalInfoEntity);
        if (updateNumber == 1) {
            log.info("\u72b6\u6001\u4fee\u6539\u6210\u529f");
            return BaseResponse.success();
        }
        log.error("\u672a\u77e5\u9519\u8bef");
        return BaseResponse.error((IError)IError.SYSYTEM_UNKNOW);
    }

    public BaseResponse<BeanRespVO> selectHospitalList(UcHospitalInfoDTO dto) {
        log.info(INTO_ARGS, (Object)dto);
        if (dto.getStatusArr().size() == 0 || dto.getStatusArr().isEmpty()) {
            BeanRespVO hospitalRespVO = new BeanRespVO();
            return BaseResponse.success((Object)hospitalRespVO);
        }
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        Page hospitalList = (Page)this.ucHospitalInfoMapper.selectHospitalList(dto);
        List records = hospitalList.getResult();
        ArrayList<UcHospitalInfoVO> hospitalInfoList = new ArrayList<UcHospitalInfoVO>();
        for (UcHospitalInfoVO record : records) {
            OrganizationByParamDTO organDto = new OrganizationByParamDTO();
            organDto.setAppCode(record.getHospitalCode());
            String statusArr = "1,2";
            List organInfoRespVOS = this.organizationMapper.selectOrganInfoByAppCode(organDto, statusArr);
            record.setOrganNumber(Integer.valueOf(organInfoRespVOS.size()));
            hospitalInfoList.add(record);
        }
        PageResult result = new PageResult();
        result.setContent(hospitalInfoList);
        result.setPageNum(dto.getPageNum().intValue());
        result.setPageSize(dto.getPageSize().intValue());
        result.setPageNum(hospitalList.getPageNum());
        result.setPageSize(hospitalList.getPageSize());
        result.setTotal((int)hospitalList.getTotal());
        List hospitalInfoVOS = this.ucHospitalInfoMapper.selectHospitalList(dto);
        List lowerCollect = hospitalInfoVOS.stream().filter(s -> s.getStatus() == 2).collect(Collectors.toList());
        List upCollect = hospitalInfoVOS.stream().filter(s -> s.getStatus() == 1).collect(Collectors.toList());
        BeanRespVO hospitalRespVO = new BeanRespVO();
        hospitalRespVO.setHospitalPage(result);
        hospitalRespVO.setLowerLineNumber(Integer.valueOf(lowerCollect.size()));
        hospitalRespVO.setUpLineNumber(Integer.valueOf(upCollect.size()));
        log.info("\u51fa\u53c2:{}", (Object)hospitalRespVO);
        return BaseResponse.success((Object)hospitalRespVO);
    }

    public BaseResponse<OrganNumberVO> getTotalByAppCode(Integer hospitalId) {
        log.info("\u5165\u53c2:{hospitalId=" + hospitalId + "}");
        UcHospitalInfoEntity hospitalInfoEntity = this.ucHospitalInfoMapper.selectByPrimaryKey(hospitalId);
        OrganizationByParamDTO organDto = new OrganizationByParamDTO();
        organDto.setAppCode(hospitalInfoEntity.getHospitalCode());
        String statusArr = "1,2";
        List infoRespVO = this.organizationMapper.selectOrganInfoByAppCode(organDto, statusArr);
        List collect = infoRespVO.stream().filter(s -> s.getStatus() == 2).collect(Collectors.toList());
        OrganNumberVO organNumberVO = new OrganNumberVO();
        BeanUtils.copyProperties((Object)hospitalInfoEntity, (Object)organNumberVO);
        organNumberVO.setTotal(Integer.valueOf(infoRespVO.size()));
        organNumberVO.setOfflineNumber(Integer.valueOf(collect.size()));
        organNumberVO.setOrganNumber(Integer.valueOf(infoRespVO.size()));
        log.info("\u51fa\u53c2:{}", (Object)organNumberVO);
        return BaseResponse.success((Object)organNumberVO);
    }

    public BaseResponse<String> updateHospitalById(UpdateHospitalInfoReq hospitalInfoReq) {
        log.info(INTO_ARGS, (Object)hospitalInfoReq);
        UcHospitalInfoEntity infoEntity = this.ucHospitalInfoMapper.selectByPrimaryKey(hospitalInfoReq.getHospitalId());
        if (infoEntity == null) {
            log.error("\u6570\u636e\u4e0d\u5b58\u5728");
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST);
        }
        String statusArr = "1,2";
        List entity = this.ucHospitalInfoMapper.selectHospitalByName(hospitalInfoReq.getHospitalName(), statusArr);
        for (UcHospitalInfoEntity ucHospitalInfoEntity : entity) {
            if (ucHospitalInfoEntity.getId().equals(hospitalInfoReq.getHospitalId()) || !infoEntity.getHospitalName().equals(hospitalInfoReq.getHospitalName())) continue;
            log.error("\u5e73\u53f0\u540d\u79f0\u5df2\u5b58\u5728!");
            return BaseResponse.error((IError)EHErrorEnum.APP_NAME_EXISTS);
        }
        UcHospitalInfoEntity ucHospitalInfoEntity = new UcHospitalInfoEntity();
        ucHospitalInfoEntity.setId(hospitalInfoReq.getHospitalId());
        ucHospitalInfoEntity.setHospitalName(hospitalInfoReq.getHospitalName());
        ucHospitalInfoEntity.setHospitalLogo(hospitalInfoReq.getHospitalLogo());
        int updateNumber = this.ucHospitalInfoMapper.updateByPrimaryKeySelective(ucHospitalInfoEntity);
        if (updateNumber == 1) {
            log.info("\u7f16\u8f91\u5e73\u53f0\u4fe1\u606f\u6210\u529f");
            return BaseResponse.success();
        }
        log.error("\u672a\u77e5\u9519\u8bef");
        return BaseResponse.error((IError)IError.SYSYTEM_UNKNOW);
    }

    public BaseResponse<List<UcHospitalInfoVO>> queryHospitalList() {
        List hospitalInfoVOS = this.ucHospitalInfoMapper.queryHospitalList();
        return BaseResponse.success((Object)hospitalInfoVOS);
    }

    public BaseResponse<UcHospitalInfoEntity> queryHospitalInfo(String appCode) {
        UcHospitalInfoEntity infoEntity = this.ucHospitalInfoMapper.queryHospitalInfo(appCode);
        return BaseResponse.success((Object)infoEntity);
    }

    public BaseResponse<List<UcAppCodeHospitalInfoVO>> queryAppCodeHospitalList(OrganizationByParamDTO dto) {
        List hospitalInfoVOS = this.ucHospitalInfoMapper.queryHospitalList();
        ArrayList<UcAppCodeHospitalInfoVO> ucAppCodeHospitalInfoVOList = new ArrayList<UcAppCodeHospitalInfoVO>();
        for (UcHospitalInfoVO hospitalInfoVO : hospitalInfoVOS) {
            UcAppCodeHospitalInfoVO ucAppCodeHospitalInfoVO = new UcAppCodeHospitalInfoVO();
            BeanUtils.copyProperties((Object)hospitalInfoVO, (Object)ucAppCodeHospitalInfoVO);
            dto.setAppCode(hospitalInfoVO.getHospitalCode());
            List listOrganVOS = this.organizationMapper.selectOpenServiceOrgan(dto);
            ucAppCodeHospitalInfoVO.setListOrganVOList(listOrganVOS);
            ucAppCodeHospitalInfoVOList.add(ucAppCodeHospitalInfoVO);
        }
        return BaseResponse.success(ucAppCodeHospitalInfoVOList);
    }

    public BaseResponse activationPlatform(PlatformActiveReq platformActiveReq) {
        UcHospitalInfoEntity ucHospitalInfo = this.ucHospitalInfoMapper.selectByPrimaryKey(platformActiveReq.getId());
        if (Objects.nonNull(ucHospitalInfo)) {
            if (8 != ucHospitalInfo.getStatus().intValue()) {
                return BaseResponse.error((IError)EHErrorEnum.PLATFORM_STATUS_ERROR);
            }
            try {
                this.RemoteCallPermission(ucHospitalInfo);
            }
            catch (BusinessException e) {
                log.error("\u8c03\u7528\u6743\u9650\u521d\u59cb\u5316\u6743\u9650\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                return BaseResponse.error((String)"\u6fc0\u6d3b\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u6620\u5c04");
            }
            catch (RuntimeException e) {
                return BaseResponse.error((String)e.getMessage());
            }
            ucHospitalInfo.setStatus(Byte.valueOf((byte)1));
            this.ucHospitalInfoMapper.updateByPrimaryKeySelective(ucHospitalInfo);
            return BaseResponse.success();
        }
        return BaseResponse.error((IError)IError.DATA_NOT_EXIST);
    }
}

