/*
 * Decompiled with CFR 0.152.
 */
package com.doctoruser.doctor.utils;

import com.doctoruser.doctor.token.TokenBody;
import com.doctoruser.doctor.token.TokenJson;
import com.doctoruser.doctor.token.UserCenterTokenParseUtil;
import com.doctoruser.doctor.token.exception.TokenParseException;
import com.ebaiyihui.framework.utils.JwtUtil;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Tokenutil {
    private static final Logger log = LoggerFactory.getLogger(Tokenutil.class);
    private static String SPACE_MARK = "***";
    private static String DEFAULT_SECRYKEY = "cloud-ehospital";

    public static TokenBody parse(String token, String secryKey) throws TokenParseException {
        int i = token.indexOf(SPACE_MARK);
        if (i > 0) {
            token = token.substring(0, i);
        }
        return UserCenterTokenParseUtil.parse((String)token, (String)secryKey);
    }

    public static String gen(TokenJson tokenJson, String secryKey) {
        Objects.requireNonNull(tokenJson, "\u751f\u6210token\u53c2\u6570tokenJson\u4e0d\u80fd\u4e3anull");
        String id = tokenJson.getUserId() + tokenJson.getDevicenumber();
        long timeTolive = 30L;
        String genJwt = JwtUtil.genJwt((String)id, (Object)tokenJson, (long)timeTolive, (TimeUnit)TimeUnit.DAYS, (String)secryKey);
        return genJwt + SPACE_MARK + tokenJson.getAppCode();
    }

    public static boolean validateToken(String accesstoken, String secryKey) {
        try {
            TokenBody tokenBody = Tokenutil.parse((String)accesstoken, (String)secryKey);
            return tokenBody.expire();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String genTokenKey(String accountId, String appCode, String deviceType) {
        return accountId + "_CLOUNDAPP_" + deviceType;
    }

    public static String gen(TokenJson tokenJson) {
        return Tokenutil.gen((TokenJson)tokenJson, (String)DEFAULT_SECRYKEY);
    }

    public static String getTokenAppCode(String token) {
        return token.substring(token.indexOf(SPACE_MARK) + 3);
    }
}

